/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2.model;

import com.jpexs.decompiler.flash.IdentifiersDeobfuscation;
import com.jpexs.decompiler.flash.SourceGeneratorLocalData;
import com.jpexs.decompiler.flash.abc.avm2.instructions.AVM2Instruction;
import com.jpexs.decompiler.flash.abc.avm2.model.AVM2Item;
import com.jpexs.decompiler.flash.ecma.ObjectType;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.CompilationException;
import com.jpexs.decompiler.graph.DottedChain;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.SourceGenerator;
import com.jpexs.decompiler.graph.TypeItem;
import com.jpexs.decompiler.graph.model.LocalData;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class ThisAVM2Item
extends AVM2Item {
    public DottedChain className;
    public boolean basicObject;
    public boolean showClassName;

    public ThisAVM2Item(GraphSourceItem instruction, GraphSourceItem lineStartIns, DottedChain className, boolean basicObject, boolean showClassName) {
        super(instruction, lineStartIns, 0);
        this.className = className;
        this.basicObject = basicObject;
        this.showClassName = showClassName;
        this.getSrcData().localName = "this";
    }

    public boolean isBasicObject() {
        return this.basicObject;
    }

    @Override
    public boolean isConvertedCompileTime(Set<GraphTargetItem> dependencies) {
        return this.isBasicObject();
    }

    @Override
    public Object getResult() {
        if (this.basicObject) {
            return new ObjectType(new HashMap()){

                @Override
                public String toString() {
                    return "[object " + ThisAVM2Item.this.className.getLast() + "]";
                }
            };
        }
        return null;
    }

    @Override
    public Boolean getResultAsBoolean() {
        return true;
    }

    @Override
    public String toString() {
        return "this";
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) {
        if (this.showClassName && this.className != null) {
            if (localData.fullyQualifiedNames != null && localData.fullyQualifiedNames.contains(this.className)) {
                return writer.append(this.className.toPrintableString(true)).append(".this");
            }
            return writer.append(IdentifiersDeobfuscation.printIdentifier(true, this.className.getLast(), new String[0])).append(".this");
        }
        return writer.append("this");
    }

    @Override
    public List<GraphSourceItem> toSource(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
        return ThisAVM2Item.toSourceMerge(localData, generator, new AVM2Instruction(0L, 208, null));
    }

    @Override
    public GraphTargetItem returnType() {
        return new TypeItem(this.className);
    }

    @Override
    public boolean hasReturnValue() {
        return true;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    public int hashCode() {
        int hash = 3;
        return hash;
    }
}

