/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2.model;

import com.jpexs.decompiler.flash.SourceGeneratorLocalData;
import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.avm2.AVM2ConstantPool;
import com.jpexs.decompiler.flash.abc.avm2.model.AVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.StringAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.parser.script.AVM2SourceGenerator;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.ecma.ArrayType;
import com.jpexs.decompiler.flash.ecma.EcmaScript;
import com.jpexs.decompiler.flash.ecma.Null;
import com.jpexs.decompiler.flash.ecma.Undefined;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.CompilationException;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.SourceGenerator;
import com.jpexs.decompiler.graph.TypeItem;
import com.jpexs.decompiler.graph.model.Callable;
import com.jpexs.decompiler.graph.model.LocalData;
import com.jpexs.helpers.Helper;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegExpAvm2Item
extends AVM2Item
implements Callable {
    public String pattern;
    public String modifier;

    public RegExpAvm2Item(String pattern, String modifier, GraphSourceItem instruction, GraphSourceItem lineStartIns) {
        super(instruction, lineStartIns, 0);
        this.pattern = pattern;
        this.modifier = modifier;
    }

    @Override
    public boolean isCompileTime() {
        return true;
    }

    public static String escapeRegExpString(String s) {
        StringBuilder ret = new StringBuilder(s.length());
        boolean escape = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '/') {
                if (!escape) {
                    return null;
                }
                ret.append("/");
            } else {
                if (c == '\\') {
                    ret.append("\\");
                    escape = true;
                    continue;
                }
                if (c == '\n') {
                    ret.append("\\n");
                } else if (c == '\r') {
                    ret.append("\\r");
                } else if (c == '\t') {
                    ret.append("\\t");
                } else if (c == '\b') {
                    ret.append("\\b");
                } else if (c == '\f') {
                    ret.append("\\f");
                } else if (c < ' ') {
                    ret.append("\\x").append(Helper.byteToHex((byte)c));
                } else {
                    ret.append(c);
                }
            }
            escape = false;
        }
        return ret.toString();
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        String escaped;
        if (Configuration.useRegExprLiteral.get().booleanValue() && (escaped = RegExpAvm2Item.escapeRegExpString(this.pattern)) != null) {
            writer.append("/");
            writer.append(escaped);
            writer.append("/");
            writer.append(this.modifier);
            return writer;
        }
        writer.append("new RegExp(");
        writer.append("\"" + Helper.escapeActionScriptString(this.pattern) + "\"");
        if (this.modifier != null && !this.modifier.isEmpty()) {
            writer.append(",");
            writer.append("\"" + this.modifier + "\"");
        }
        writer.append(")");
        return writer;
    }

    @Override
    public boolean hasReturnValue() {
        return true;
    }

    @Override
    public GraphTargetItem returnType() {
        return new TypeItem("RegExp");
    }

    @Override
    public List<GraphSourceItem> toSource(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
        AVM2SourceGenerator g = (AVM2SourceGenerator)generator;
        ABC abc = g.abcIndex.getSelectedAbc();
        AVM2ConstantPool constants = abc.constants;
        boolean hasModifier = this.modifier != null && !this.modifier.isEmpty();
        return RegExpAvm2Item.toSourceMerge(localData, generator, RegExpAvm2Item.ins(96, constants.getQnameId("RegExp", 22, "", true)), new StringAVM2Item(null, null, this.pattern), hasModifier ? new StringAVM2Item(null, null, this.modifier) : null, RegExpAvm2Item.ins(66, hasModifier ? 2 : 1));
    }

    @Override
    public Object call(String methodName, List<Object> args) {
        int flags = 0;
        block15: for (char c : this.modifier.toCharArray()) {
            switch (c) {
                case 'g': {
                    continue block15;
                }
                case 'i': {
                    flags |= 2;
                    continue block15;
                }
                case 's': {
                    flags |= 0x20;
                    continue block15;
                }
                case 'm': {
                    flags |= 8;
                    continue block15;
                }
                case 'x': {
                    flags |= 4;
                    continue block15;
                }
            }
        }
        Pattern p = Pattern.compile(this.pattern, flags);
        switch (methodName) {
            case "exec": {
                String estr = EcmaScript.toString(args.get(0));
                Matcher m = p.matcher(estr);
                if (m.find()) {
                    ArrayList<Object> avals = new ArrayList<Object>();
                    for (int i = 0; i <= m.groupCount(); ++i) {
                        avals.add(m.group(i));
                    }
                    ArrayType a = new ArrayType(avals);
                    a.setAttribute("input", estr);
                    a.setAttribute("index", m.start());
                    return a;
                }
                return Null.INSTANCE;
            }
            case "test": {
                String tstr = EcmaScript.toString(args.get(0));
                return p.matcher(tstr).find();
            }
        }
        return Undefined.INSTANCE;
    }

    @Override
    public Object call(List<Object> args) {
        return this.call("exec", args);
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + Objects.hashCode(this.pattern);
        hash = 89 * hash + Objects.hashCode(this.modifier);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RegExpAvm2Item other = (RegExpAvm2Item)obj;
        if (!Objects.equals(this.pattern, other.pattern)) {
            return false;
        }
        return Objects.equals(this.modifier, other.modifier);
    }
}

