/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2.model;

import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.avm2.model.AVM2Item;
import com.jpexs.decompiler.flash.abc.types.ConvertData;
import com.jpexs.decompiler.flash.abc.types.MethodBody;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.exporters.modes.ScriptExportMode;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.flash.helpers.NulWriter;
import com.jpexs.decompiler.graph.DottedChain;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.ScopeStack;
import com.jpexs.decompiler.graph.TypeItem;
import com.jpexs.decompiler.graph.model.LocalData;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;

public class NewFunctionAVM2Item
extends AVM2Item {
    public String functionName;
    public String path;
    public boolean isStatic;
    public int scriptIndex;
    public int classIndex;
    public ABC abc;
    public int methodIndex;
    public ScopeStack scopeStack;

    public NewFunctionAVM2Item(GraphSourceItem instruction, GraphSourceItem lineStartIns, String functionName, String path, boolean isStatic, int scriptIndex, int classIndex, ABC abc, int methodIndex, ScopeStack scopeStack) {
        super(instruction, lineStartIns, 0);
        this.functionName = functionName;
        this.path = path;
        this.isStatic = isStatic;
        this.scriptIndex = scriptIndex;
        this.classIndex = classIndex;
        this.abc = abc;
        this.methodIndex = methodIndex;
        this.scopeStack = scopeStack;
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        if (localData.seenMethods.contains(this.methodIndex)) {
            return writer.append("\u00a7\u00a7method(").append(this.methodIndex).append(")");
        }
        MethodBody body = this.abc.findBody(this.methodIndex);
        writer.append("function");
        writer.startMethod(this.methodIndex);
        writer.append(!this.functionName.isEmpty() ? " " + this.functionName : "");
        writer.appendNoHilight("(");
        this.abc.method_info.get(this.methodIndex).getParamStr(writer, this.abc.constants, body, this.abc, localData.fullyQualifiedNames);
        writer.appendNoHilight("):");
        if (Configuration.showMethodBodyId.get().booleanValue()) {
            writer.appendNoHilight("// method body index: ");
            writer.appendNoHilight(this.abc.findBodyIndex(this.methodIndex));
            writer.appendNoHilight(" method index: ");
            writer.appendNoHilight(this.methodIndex);
            writer.newLine();
        }
        this.abc.method_info.get(this.methodIndex).getReturnTypeStr(writer, this.abc.constants, localData.fullyQualifiedNames);
        writer.startBlock();
        if (body != null) {
            ArrayList<MethodBody> callStack = new ArrayList<MethodBody>(localData.callStack);
            callStack.add(body);
            body.convert(callStack, localData.abcIndex, new ConvertData(), this.path + "/inner", ScriptExportMode.AS, this.isStatic, this.methodIndex, this.scriptIndex, this.classIndex, this.abc, null, this.scopeStack, 0, new NulWriter(), localData.fullyQualifiedNames, null, false, new HashSet<Integer>(localData.seenMethods));
            body.toString(callStack, localData.abcIndex, this.path + "/inner", ScriptExportMode.AS, this.abc, null, writer, localData.fullyQualifiedNames, new HashSet<Integer>(localData.seenMethods));
        }
        writer.endBlock();
        writer.endMethod();
        return writer;
    }

    @Override
    public GraphTargetItem returnType() {
        return new TypeItem(DottedChain.FUNCTION);
    }

    @Override
    public boolean hasReturnValue() {
        return true;
    }

    public int hashCode() {
        int hash = 3;
        hash = 37 * hash + Objects.hashCode(this.functionName);
        hash = 37 * hash + this.methodIndex;
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NewFunctionAVM2Item other = (NewFunctionAVM2Item)obj;
        if (this.methodIndex != other.methodIndex) {
            return false;
        }
        return Objects.equals(this.functionName, other.functionName);
    }
}

