/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2.model;

import com.jpexs.decompiler.flash.abc.avm2.model.AVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.ConvertAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.NumberValueAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.StringAVM2Item;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.GraphTargetVisitorInterface;
import com.jpexs.decompiler.graph.TypeItem;
import com.jpexs.decompiler.graph.model.LocalData;
import com.jpexs.decompiler.graph.model.TernarOpItem;
import java.util.Objects;

public class NameValuePair
extends AVM2Item {
    public GraphTargetItem name;

    public NameValuePair(GraphTargetItem name, GraphTargetItem value) {
        super(name.getSrc(), name.getLineStartItem(), 16, value);
        this.name = name;
    }

    @Override
    public void visit(GraphTargetVisitorInterface visitor) {
        visitor.visit(this.name);
        if (this.value != null) {
            visitor.visit(this.value);
        }
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        boolean needsParents;
        boolean bl = needsParents = !(this.name.getNotCoerced() instanceof NumberValueAVM2Item) && !(this.name.getNotCoerced() instanceof StringAVM2Item);
        if (needsParents) {
            writer.append("(");
        }
        if (this.name instanceof ConvertAVM2Item && ((ConvertAVM2Item)this.name).type.equals(TypeItem.STRING)) {
            this.name = this.name.value;
        }
        this.name.toString(writer, localData);
        if (needsParents) {
            writer.append(")");
        }
        writer.append(":");
        if (this.value instanceof TernarOpItem) {
            writer.append("(");
            this.value.toString(writer, localData);
            writer.append(")");
        } else {
            this.value.toString(writer, localData);
        }
        return writer;
    }

    @Override
    public GraphTargetItem returnType() {
        return TypeItem.UNBOUNDED;
    }

    @Override
    public boolean hasReturnValue() {
        return true;
    }

    public int hashCode() {
        int hash = 7;
        hash = 73 * hash + Objects.hashCode(this.name);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NameValuePair other = (NameValuePair)obj;
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        return Objects.equals(this.value, other.value);
    }

    @Override
    public boolean hasSideEffect() {
        return this.name.hasSideEffect() || this.value.hasSideEffect();
    }
}

