/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2.model;

import com.jpexs.decompiler.flash.SourceGeneratorLocalData;
import com.jpexs.decompiler.flash.abc.avm2.instructions.AVM2Instruction;
import com.jpexs.decompiler.flash.abc.avm2.model.NumberValueAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.parser.script.AVM2SourceGenerator;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.ecma.EcmaScript;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.CompilationException;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.SourceGenerator;
import com.jpexs.decompiler.graph.TypeItem;
import com.jpexs.decompiler.graph.model.IntegerValueTypeItem;
import com.jpexs.decompiler.graph.model.LocalData;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class IntegerValueAVM2Item
extends NumberValueAVM2Item
implements IntegerValueTypeItem {
    public Integer value;

    public IntegerValueAVM2Item(GraphSourceItem instruction, GraphSourceItem lineStartIns, Integer value) {
        super(instruction, lineStartIns);
        this.value = value;
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) {
        if (Configuration.smartNumberFormatting.get().booleanValue()) {
            long value2;
            if (this.value >= 256 && (long)this.value.intValue() <= 0xFFFFFFFFL) {
                int intVal = (int)(this.value & 0xFFFFFF);
                int r = intVal >> 16 & 0xFF;
                int g = intVal >> 8 & 0xFF;
                int b = intVal & 0xFF;
                if (r == b && b == g || ((intVal & 0xF0000) == 0 || (intVal & 0xF0000) == 983040) && ((intVal & 0xF00) == 0 || (intVal & 0xF00) == 3840) && ((intVal & 0xF) == 0 || (intVal & 0xF) == 15) || (intVal & 0xF00000) >> 20 == (intVal & 0xF0000) >> 16 && (intVal & 0xF000) >> 12 == (intVal & 0xF00) >> 8 && (intVal & 0xF0) >> 4 == (intVal & 0xF)) {
                    return writer.append("0x").append(Long.toHexString(this.value.intValue()));
                }
            }
            if ((value2 = (long)this.value.intValue()) > 0L && value2 % 60L == 0L) {
                int thousandCount = 0;
                boolean isHour = false;
                boolean isDay = false;
                if ((value2 /= 60L) % 60L == 0L) {
                    isHour = true;
                    if ((value2 /= 60L) % 24L == 0L) {
                        value2 /= 24L;
                        isDay = true;
                    }
                }
                while (thousandCount < 3 && value2 % 1000L == 0L) {
                    ++thousandCount;
                    value2 /= 1000L;
                }
                if (value2 < 1000L) {
                    int i;
                    ArrayList<Integer> factors = new ArrayList<Integer>();
                    if (value2 > 1L) {
                        factors.add((int)value2);
                    }
                    if (isDay) {
                        factors.add(24);
                    }
                    if (isHour) {
                        factors.add(60);
                    }
                    factors.add(60);
                    for (i = 0; i < thousandCount; ++i) {
                        factors.add(1000);
                    }
                    for (i = 0; i < factors.size(); ++i) {
                        if (i != 0) {
                            writer.append(" * ");
                        }
                        writer.append((Integer)factors.get(i));
                    }
                    return writer;
                }
            }
        }
        return writer.append(EcmaScript.toString(this.value));
    }

    @Override
    public Object getResult() {
        return this.value;
    }

    @Override
    public boolean isCompileTime(Set<GraphTargetItem> dependencies) {
        return true;
    }

    @Override
    public List<GraphSourceItem> toSource(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
        AVM2Instruction ins = this.value >= -128 && this.value <= 127 ? new AVM2Instruction(0L, 36, new int[]{(int)((long)this.value.intValue())}) : (this.value >= Short.MIN_VALUE && this.value <= Short.MAX_VALUE ? new AVM2Instruction(0L, 37, new int[]{(int)((long)this.value.intValue())}) : new AVM2Instruction(0L, 45, new int[]{((AVM2SourceGenerator)generator).abcIndex.getSelectedAbc().constants.getIntId(this.value, true)}));
        return IntegerValueAVM2Item.toSourceMerge(localData, generator, ins);
    }

    @Override
    public GraphTargetItem returnType() {
        return TypeItem.INT;
    }

    @Override
    public boolean hasReturnValue() {
        return true;
    }

    @Override
    public int intValue() {
        return (int)((long)this.value.intValue());
    }

    public int hashCode() {
        int hash = 3;
        hash = 79 * hash + Objects.hashCode(this.value);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IntegerValueAVM2Item other = (IntegerValueAVM2Item)obj;
        return Objects.equals(this.value, other.value);
    }
}

