/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2.model;

import com.jpexs.decompiler.flash.abc.avm2.model.AVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.FullMultinameAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.GetPropertyAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.SetTypeAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.clauses.AssignmentAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.clauses.DeclarationAVM2Item;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.GraphTargetVisitorInterface;
import com.jpexs.decompiler.graph.TypeItem;
import com.jpexs.decompiler.graph.model.LocalData;
import java.util.Objects;

public class InitPropertyAVM2Item
extends AVM2Item
implements SetTypeAVM2Item,
AssignmentAVM2Item {
    public GraphTargetItem object;
    public FullMultinameAVM2Item propertyName;
    public DeclarationAVM2Item declaration;
    public GraphTargetItem compoundValue;
    public String compoundOperator;
    public GraphTargetItem type;
    public GraphTargetItem callType;
    public boolean isStatic;

    @Override
    public void visit(GraphTargetVisitorInterface visitor) {
        visitor.visit(this.object);
        visitor.visit(this.propertyName);
        visitor.visit(this.value);
    }

    @Override
    public DeclarationAVM2Item getDeclaration() {
        return this.declaration;
    }

    @Override
    public void setDeclaration(DeclarationAVM2Item declaration) {
        this.declaration = declaration;
    }

    public InitPropertyAVM2Item(GraphSourceItem instruction, GraphSourceItem lineStartIns, GraphTargetItem object, FullMultinameAVM2Item propertyName, GraphTargetItem value, GraphTargetItem type, GraphTargetItem callType, boolean isStatic) {
        super(instruction, lineStartIns, 14, value);
        this.object = object;
        this.propertyName = propertyName;
        this.type = type;
        this.callType = callType;
        this.isStatic = isStatic;
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        this.formatProperty(writer, this.object, this.propertyName, localData, this.isStatic);
        if (this.compoundOperator != null) {
            writer.append(" ");
            writer.append(this.compoundOperator);
            writer.append("= ");
            return this.compoundValue.toString(writer, localData);
        }
        writer.append(" = ");
        return this.value.toString(writer, localData);
    }

    @Override
    public GraphTargetItem getObject() {
        return new GetPropertyAVM2Item(this.getInstruction(), this.getLineStartIns(), this.object, this.propertyName, this.type, this.callType, this.isStatic);
    }

    @Override
    public GraphTargetItem getValue() {
        return this.value;
    }

    @Override
    public GraphTargetItem returnType() {
        return TypeItem.UNBOUNDED;
    }

    @Override
    public boolean hasReturnValue() {
        return false;
    }

    public int hashCode() {
        int hash = 3;
        hash = 17 * hash + Objects.hashCode(this.object);
        hash = 17 * hash + Objects.hashCode(this.propertyName);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InitPropertyAVM2Item other = (InitPropertyAVM2Item)obj;
        if (!Objects.equals(this.object, other.object)) {
            return false;
        }
        return Objects.equals(this.propertyName, other.propertyName);
    }

    @Override
    public GraphTargetItem getCompoundValue() {
        return this.compoundValue;
    }

    @Override
    public void setCompoundValue(GraphTargetItem value) {
        this.compoundValue = value;
    }

    @Override
    public void setCompoundOperator(String operator) {
        this.compoundOperator = operator;
    }

    @Override
    public String getCompoundOperator() {
        return this.compoundOperator;
    }
}

