/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2.model;

import com.jpexs.decompiler.flash.abc.avm2.model.AVM2Item;
import com.jpexs.decompiler.flash.abc.types.Multiname;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.GraphTargetVisitorInterface;
import com.jpexs.decompiler.graph.model.LocalData;
import java.util.Objects;

public class GetSlotAVM2Item
extends AVM2Item {
    public Multiname slotName;
    public GraphTargetItem scope;
    public GraphTargetItem slotObject;
    public int slotIndex;
    public GraphTargetItem slotType;

    public GetSlotAVM2Item(GraphSourceItem instruction, GraphSourceItem lineStartIns, GraphTargetItem scope, GraphTargetItem slotObject, int slotIndex, Multiname slotName, GraphTargetItem slotType) {
        super(instruction, lineStartIns, 0);
        this.slotName = slotName;
        this.scope = scope;
        this.slotObject = slotObject;
        this.slotIndex = slotIndex;
        this.slotType = slotType;
    }

    @Override
    public void visit(GraphTargetVisitorInterface visitor) {
        visitor.visit(this.scope);
        visitor.visit(this.slotObject);
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        String name;
        this.getSrcData().localName = name = this.getNameAsStr(localData);
        return writer.append(name);
    }

    public String getNameAsStr(LocalData localData) throws InterruptedException {
        if (this.slotName == null) {
            return this.slotObject.toString(localData) + ".\u00a7\u00a7slot[" + this.slotIndex + "]";
        }
        return this.slotName.getName(localData.constantsAvm2, localData.fullyQualifiedNames, false, true);
    }

    public GraphTextWriter getName(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        return writer.append(this.getNameAsStr(localData));
    }

    @Override
    public GraphTargetItem returnType() {
        return this.slotType;
    }

    @Override
    public boolean hasReturnValue() {
        return true;
    }

    public int hashCode() {
        int hash = 3;
        hash = 67 * hash + Objects.hashCode(this.scope);
        hash = 67 * hash + this.slotIndex;
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GetSlotAVM2Item other = (GetSlotAVM2Item)obj;
        if (this.slotIndex != other.slotIndex) {
            return false;
        }
        return Objects.equals(this.scope, other.scope);
    }
}

