/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2.model;

import com.jpexs.decompiler.flash.SourceGeneratorLocalData;
import com.jpexs.decompiler.flash.abc.avm2.model.AVM2Item;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.CompilationException;
import com.jpexs.decompiler.graph.DottedChain;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.SourceGenerator;
import com.jpexs.decompiler.graph.TypeItem;
import com.jpexs.decompiler.graph.model.LocalData;
import java.util.List;
import java.util.Objects;

public class AlchemySignExtendAVM2Item
extends AVM2Item {
    private final int size;

    public AlchemySignExtendAVM2Item(GraphSourceItem instruction, GraphSourceItem lineStartIns, GraphTargetItem value, int size) {
        super(instruction, lineStartIns, 0, value);
        this.size = size;
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        writer.append("si").append(this.size).append("(");
        this.value.toString(writer, localData);
        return writer.append(")");
    }

    @Override
    public GraphTargetItem returnType() {
        return new TypeItem(DottedChain.INT);
    }

    @Override
    public boolean hasReturnValue() {
        return true;
    }

    @Override
    public List<GraphSourceItem> toSource(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
        int code = 0;
        switch (this.size) {
            case 1: {
                code = 80;
                break;
            }
            case 8: {
                code = 81;
                break;
            }
            case 16: {
                code = 82;
            }
        }
        return AlchemySignExtendAVM2Item.toSourceMerge(localData, generator, this.value, AlchemySignExtendAVM2Item.ins(code, new Integer[0]));
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + this.size;
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AlchemySignExtendAVM2Item other = (AlchemySignExtendAVM2Item)obj;
        if (this.size != other.size) {
            return false;
        }
        return Objects.equals(this.value, other.value);
    }
}

