/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2.instructions.other;

import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.AVM2LocalData;
import com.jpexs.decompiler.flash.abc.avm2.AVM2ConstantPool;
import com.jpexs.decompiler.flash.abc.avm2.LocalDataArea;
import com.jpexs.decompiler.flash.abc.avm2.exceptions.AVM2ExecutionException;
import com.jpexs.decompiler.flash.abc.avm2.instructions.AVM2Instruction;
import com.jpexs.decompiler.flash.abc.avm2.instructions.AVM2InstructionFlag;
import com.jpexs.decompiler.flash.abc.avm2.instructions.InstructionDefinition;
import com.jpexs.decompiler.flash.abc.avm2.model.ApplyTypeAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.FindPropertyAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.FullMultinameAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.GetLexAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.GetPropertyAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.LocalRegAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.SetLocalAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.parser.script.AbcIndexing;
import com.jpexs.decompiler.flash.abc.types.MethodBody;
import com.jpexs.decompiler.flash.abc.types.Namespace;
import com.jpexs.decompiler.flash.abc.types.traits.Trait;
import com.jpexs.decompiler.flash.abc.types.traits.TraitSlotConst;
import com.jpexs.decompiler.flash.ecma.ArrayType;
import com.jpexs.decompiler.flash.ecma.EcmaScript;
import com.jpexs.decompiler.flash.ecma.ObjectType;
import com.jpexs.decompiler.flash.ecma.Undefined;
import com.jpexs.decompiler.graph.DottedChain;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.TranslateStack;
import com.jpexs.decompiler.graph.TypeItem;
import com.jpexs.decompiler.graph.model.DuplicateItem;
import com.jpexs.helpers.Reference;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class GetPropertyIns
extends InstructionDefinition {
    public GetPropertyIns() {
        super(102, "getproperty", new int[]{257}, true, new AVM2InstructionFlag[0]);
    }

    @Override
    public boolean execute(LocalDataArea lda, AVM2ConstantPool constants, AVM2Instruction ins) throws AVM2ExecutionException {
        if (constants.getMultiname((int)ins.operands[0]).kind == 27) {
            String name = EcmaScript.toString(lda.operandStack.pop());
            Object obj = lda.operandStack.pop();
            if (obj == ArrayType.EMPTY_ARRAY) {
                if ("length".equals(name)) {
                    lda.operandStack.push(0L);
                } else {
                    lda.operandStack.push(Undefined.INSTANCE);
                }
                return true;
            }
            if (obj == ObjectType.EMPTY_OBJECT) {
                lda.operandStack.push(Undefined.INSTANCE);
                return true;
            }
            return true;
        }
        return false;
    }

    @Override
    public void translate(AVM2LocalData localData, TranslateStack stack, AVM2Instruction ins, List<GraphTargetItem> output, String path) {
        int multinameIndex = ins.operands[0];
        FullMultinameAVM2Item multiname = this.resolveMultiname(localData, true, stack, localData.getConstants(), multinameIndex, ins);
        GraphTargetItem obj = stack.pop();
        if (obj instanceof FindPropertyAVM2Item) {
            FindPropertyAVM2Item findProp = (FindPropertyAVM2Item)obj;
            if (findProp.propertyName instanceof FullMultinameAVM2Item) {
                FullMultinameAVM2Item findPropName = (FullMultinameAVM2Item)findProp.propertyName;
                if (findPropName.name instanceof LocalRegAVM2Item && multiname.name instanceof LocalRegAVM2Item) {
                    LocalRegAVM2Item getLocal1 = (LocalRegAVM2Item)findPropName.name;
                    LocalRegAVM2Item getLocal2 = (LocalRegAVM2Item)multiname.name;
                    if (!output.isEmpty() && output.get(output.size() - 1) instanceof SetLocalAVM2Item) {
                        Set<Integer> usage;
                        SetLocalAVM2Item setLocal = (SetLocalAVM2Item)output.get(output.size() - 1);
                        if (setLocal.regIndex == getLocal1.regIndex && setLocal.regIndex == getLocal2.regIndex && (usage = localData.getSetLocalUsages(localData.code.adr2pos(setLocal.getSrc().getAddress()))).size() == 2) {
                            findPropName.name = setLocal.value;
                            output.remove(output.size() - 1);
                        }
                    }
                }
                if (findPropName.name instanceof DuplicateItem && findPropName.name.value == multiname.name) {
                    findPropName.name = findPropName.name.value;
                }
                if (findPropName.namespace instanceof SetLocalAVM2Item) {
                    SetLocalAVM2Item setLocal = (SetLocalAVM2Item)findPropName.namespace;
                    if (multiname.namespace instanceof LocalRegAVM2Item) {
                        Set<Integer> usage;
                        LocalRegAVM2Item getLocal = (LocalRegAVM2Item)multiname.namespace;
                        if (setLocal.regIndex == getLocal.regIndex && (usage = localData.getSetLocalUsages(localData.code.adr2pos(setLocal.getSrc().getAddress()))).size() == 1) {
                            findPropName.namespace = findPropName.namespace.value;
                        }
                    }
                }
                if (findPropName.namespace instanceof DuplicateItem && findPropName.namespace.value == multiname.namespace) {
                    findPropName.namespace = findPropName.namespace.value;
                }
            }
        }
        Reference<Boolean> isStatic = new Reference<Boolean>(false);
        Reference<Object> type = new Reference<Object>(null);
        Reference<Object> callType = new Reference<Object>(null);
        GetPropertyIns.resolvePropertyType(localData, obj, multiname, isStatic, type, callType);
        stack.push(new GetPropertyAVM2Item(ins, localData.lineStartInstruction, obj, multiname, type.getVal(), callType.getVal(), isStatic.getVal()));
    }

    public static void resolvePropertyType(AVM2LocalData localData, GraphTargetItem obj, FullMultinameAVM2Item multiname, Reference<Boolean> isStatic, Reference<GraphTargetItem> type, Reference<GraphTargetItem> callType) {
        GraphTargetItem receiverType;
        type.setVal(TypeItem.UNKNOWN);
        callType.setVal(TypeItem.UNKNOWN);
        String multinameStr = localData.abc.constants.getMultiname(multiname.multinameIndex).getName(localData.abc.constants, new ArrayList<DottedChain>(), true, true);
        if (obj instanceof FindPropertyAVM2Item) {
            FindPropertyAVM2Item fprop = (FindPropertyAVM2Item)obj;
            if (fprop.propertyName.equals(multiname)) {
                for (int b = localData.callStack.size() - 1; b >= 0; --b) {
                    MethodBody body = localData.callStack.get(b);
                    for (Trait t : body.traits.traits) {
                        TraitSlotConst tsc;
                        if (!(t instanceof TraitSlotConst) || !Objects.equals((tsc = (TraitSlotConst)t).getName(localData.abc).getName(localData.abc.constants, new ArrayList<DottedChain>(), true, true), multinameStr)) continue;
                        GraphTargetItem ty = AbcIndexing.multinameToType(tsc.type_index, localData.abc.constants);
                        type.setVal(ty);
                        callType.setVal(ty);
                        return;
                    }
                }
                if (type.getVal().equals(TypeItem.UNKNOWN) && localData.abcIndex != null) {
                    String currentClassName;
                    String string = currentClassName = localData.classIndex == -1 ? null : localData.abc.instance_info.get(localData.classIndex).getName(localData.abc.constants).getNameWithNamespace(localData.abc.constants, true).toRawString();
                    if (currentClassName != null) {
                        localData.abcIndex.findPropertyTypeOrCallType(localData.abc, new TypeItem(currentClassName), multinameStr, localData.abc.constants.getMultiname((int)multiname.multinameIndex).namespace_index, true, true, true, type, callType);
                    }
                    if (type.getVal().equals(TypeItem.UNKNOWN)) {
                        String rawNs;
                        AbcIndexing.TraitIndex traitIndex;
                        GraphTargetItem ti = AbcIndexing.multinameToType(multiname.multinameIndex, localData.abc.constants);
                        if (localData.abcIndex.findClass(ti, localData.abc, localData.scriptIndex) != null) {
                            type.setVal(ti);
                            callType.setVal(ti);
                            isStatic.setVal(true);
                            return;
                        }
                        Namespace ns = localData.abc.constants.getMultiname(multiname.multinameIndex).getNamespace(localData.abc.constants);
                        if (ns != null && (traitIndex = localData.abcIndex.findScriptProperty(multinameStr, DottedChain.parseWithSuffix(rawNs = ns.getRawName(localData.abc.constants)))) != null) {
                            type.setVal(traitIndex.returnType);
                            callType.setVal(traitIndex.callReturnType);
                            isStatic.setVal(true);
                            return;
                        }
                    }
                }
            }
        } else if (localData.abcIndex != null && !(receiverType = obj.returnType()).equals(TypeItem.UNBOUNDED) && !receiverType.equals(TypeItem.UNKNOWN)) {
            boolean parentStatic = false;
            if (obj instanceof GetLexAVM2Item && ((GetLexAVM2Item)obj).isStatic) {
                parentStatic = true;
            }
            if (obj instanceof GetPropertyAVM2Item && ((GetPropertyAVM2Item)obj).isStatic) {
                parentStatic = true;
            }
            if (receiverType instanceof ApplyTypeAVM2Item) {
                ApplyTypeAVM2Item ati = (ApplyTypeAVM2Item)receiverType;
                if (localData.abc.constants.getMultiname(multiname.multinameIndex).needsName()) {
                    callType.setVal(TypeItem.UNBOUNDED);
                    type.setVal(ati.params.get(0));
                    return;
                }
                receiverType = ati.object;
                if (receiverType.equals(new TypeItem("__AS3__.vec.Vector"))) {
                    String paramStr;
                    switch (paramStr = ati.params.get(0).toString()) {
                        case "double": 
                        case "int": 
                        case "uint": {
                            receiverType = new TypeItem("__AS3__.vec.Vector$" + paramStr);
                            break;
                        }
                        default: {
                            receiverType = new TypeItem("__AS3__.vec.Vector$object");
                        }
                    }
                }
            }
            if (localData.abc.constants.getMultiname(multiname.multinameIndex).isAttribute()) {
                type.setVal(new TypeItem("XMLList"));
                return;
            }
            if (receiverType.equals(new TypeItem("XMLList")) && multiname.name != null && multiname.name.returnType().equals(TypeItem.INT)) {
                type.setVal(new TypeItem("XML"));
                return;
            }
            localData.abcIndex.findPropertyTypeOrCallType(localData.abc, receiverType, multiname.resolvedMultinameName, localData.abc.constants.getMultiname((int)multiname.multinameIndex).namespace_index, parentStatic, !parentStatic, false, type, callType);
            if (receiverType.equals(new TypeItem("XML")) && !type.getVal().equals(new TypeItem("Function"))) {
                type.setVal(new TypeItem("XMLList"));
            }
        }
    }

    @Override
    public int getStackPopCount(AVM2Instruction ins, ABC abc) {
        int multinameIndex = ins.operands[0];
        return 1 + this.getMultinameRequiredStackSize(abc.constants, multinameIndex);
    }

    @Override
    public int getStackPushCount(AVM2Instruction ins, ABC abc) {
        return 1;
    }
}

