/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2.instructions.localregs;

import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.AVM2LocalData;
import com.jpexs.decompiler.flash.abc.avm2.AVM2ConstantPool;
import com.jpexs.decompiler.flash.abc.avm2.LocalDataArea;
import com.jpexs.decompiler.flash.abc.avm2.instructions.AVM2Instruction;
import com.jpexs.decompiler.flash.abc.avm2.instructions.AVM2InstructionFlag;
import com.jpexs.decompiler.flash.abc.avm2.instructions.InstructionDefinition;
import com.jpexs.decompiler.flash.abc.avm2.model.AVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.ClassAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.CoerceAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.ConvertAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.DecrementAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.FullMultinameAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.GetPropertyAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.IncrementAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.LocalRegAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.PostDecrementAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.PostIncrementAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.SetLocalAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.SetPropertyAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.SetTypeAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.ThisAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.operations.PreDecrementAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.operations.PreIncrementAVM2Item;
import com.jpexs.decompiler.flash.abc.types.Multiname;
import com.jpexs.decompiler.flash.abc.types.traits.Trait;
import com.jpexs.decompiler.flash.ecma.Undefined;
import com.jpexs.decompiler.graph.DottedChain;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.TranslateStack;
import com.jpexs.decompiler.graph.TypeItem;
import com.jpexs.decompiler.graph.model.DuplicateItem;
import java.util.List;

public abstract class GetLocalTypeIns
extends InstructionDefinition {
    public GetLocalTypeIns(int instructionCode, String instructionName, int[] operands, boolean canThrow) {
        super(instructionCode, instructionName, operands, canThrow, new AVM2InstructionFlag[0]);
    }

    @Override
    public boolean execute(LocalDataArea lda, AVM2ConstantPool constants, AVM2Instruction ins) {
        Object value = lda.localRegisters.get(this.getRegisterId(ins));
        lda.operandStack.push(value == null ? Undefined.INSTANCE : value);
        return true;
    }

    @Override
    public void translate(AVM2LocalData localData, TranslateStack stack, AVM2Instruction ins, List<GraphTargetItem> output, String path) {
        int regId = this.getRegisterId(ins);
        if (regId == 0) {
            if (localData.classIndex == -1) {
                stack.push(new ThisAVM2Item(ins, localData.lineStartInstruction, DottedChain.parseNoSuffix("global"), false, false));
                return;
            }
            if (localData.classIndex >= localData.getInstanceInfo().size()) {
                stack.push(new ThisAVM2Item(ins, localData.lineStartInstruction, DottedChain.OBJECT, false, false));
                return;
            }
            if (localData.isStatic.booleanValue()) {
                stack.push(new ClassAVM2Item(localData.getInstanceInfo().get(localData.classIndex).getName(localData.getConstants())));
            } else {
                List<Trait> ts = localData.getInstanceInfo().get((int)localData.classIndex.intValue()).instance_traits.traits;
                boolean isBasicObject = localData.thisHasDefaultToPrimitive;
                Multiname m = localData.getInstanceInfo().get(localData.classIndex).getName(localData.getConstants());
                stack.push(new ThisAVM2Item(ins, localData.lineStartInstruction, m.getNameWithNamespace(localData.getConstants(), true), isBasicObject, false));
            }
            return;
        }
        GraphTargetItem computedValue = localData.localRegs.get(regId);
        int assignCount = 0;
        if (localData.localRegAssignmentIps.containsKey(regId)) {
            assignCount = localData.localRegAssignmentIps.get(regId);
        }
        if (assignCount > 5) {
            // empty if block
        }
        if (!output.isEmpty() && output.get(output.size() - 1) instanceof SetTypeAVM2Item) {
            GraphTargetItem setItem = output.get(output.size() - 1);
            if (setItem instanceof SetPropertyAVM2Item && (setItem.value.getNotCoerced() instanceof DecrementAVM2Item || setItem.value.getNotCoerced() instanceof IncrementAVM2Item)) {
                boolean isIncrement = setItem.value.getNotCoerced() instanceof IncrementAVM2Item;
                GraphTargetItem val = setItem.value.getNotCoerced();
                if (val.value instanceof SetLocalAVM2Item) {
                    SetLocalAVM2Item setLocal = (SetLocalAVM2Item)val.value;
                    if (setLocal.regIndex == regId && setLocal.value.getNotCoerced() instanceof GetPropertyAVM2Item) {
                        SetPropertyAVM2Item setProp = (SetPropertyAVM2Item)setItem;
                        GetPropertyAVM2Item getProp = (GetPropertyAVM2Item)setLocal.value.getNotCoerced();
                        if (getProp.object.getThroughDuplicate() == setProp.object && ((FullMultinameAVM2Item)setProp.propertyName).compareSame((FullMultinameAVM2Item)getProp.propertyName)) {
                            if (getProp.object instanceof DuplicateItem) {
                                getProp.object = getProp.object.value;
                            }
                            AVM2Item result = isIncrement ? new PostIncrementAVM2Item(setProp.getSrc(), localData.lineStartInstruction, getProp) : new PostDecrementAVM2Item(setProp.getSrc(), localData.lineStartInstruction, getProp);
                            output.remove(output.size() - 1);
                            stack.add(result);
                            return;
                        }
                    }
                }
            } else if (setItem.value.getNotCoerced() instanceof SetLocalAVM2Item) {
                int setLocalIp;
                SetLocalAVM2Item setLocal = (SetLocalAVM2Item)setItem.value.getNotCoerced();
                if (setLocal.regIndex == regId && localData.getSetLocalUsages(setLocalIp = localData.code.adr2pos(setLocal.getSrc().getAddress())).size() == 1) {
                    if (setItem.value instanceof CoerceAVM2Item || setItem.value instanceof ConvertAVM2Item) {
                        setItem.value.value = setLocal.value;
                    } else {
                        setItem.value = setLocal.value;
                    }
                    output.remove(output.size() - 1);
                    if (setItem instanceof SetPropertyAVM2Item && (setItem.value instanceof IncrementAVM2Item || setItem.value instanceof DecrementAVM2Item)) {
                        boolean isIncrement = setItem.value instanceof IncrementAVM2Item;
                        if (setItem.value.value instanceof GetPropertyAVM2Item) {
                            SetPropertyAVM2Item setProp = (SetPropertyAVM2Item)setItem;
                            GetPropertyAVM2Item getProp = (GetPropertyAVM2Item)setItem.value.value;
                            if (getProp.object.getThroughDuplicate() == setProp.object && ((FullMultinameAVM2Item)setProp.propertyName).compareSame((FullMultinameAVM2Item)getProp.propertyName)) {
                                if (getProp.object instanceof DuplicateItem) {
                                    getProp.object = getProp.object.value;
                                }
                                setItem = isIncrement ? new PreIncrementAVM2Item(setProp.getSrc(), localData.lineStartInstruction, getProp) : new PreDecrementAVM2Item(setProp.getSrc(), localData.lineStartInstruction, getProp);
                            }
                        }
                    }
                    stack.add(setItem);
                    return;
                }
            }
        }
        GraphTargetItem type = TypeItem.UNBOUNDED;
        if (localData.localRegTypes.containsKey(regId)) {
            type = localData.localRegTypes.get(regId);
        } else if (computedValue != null) {
            type = computedValue.returnType();
        }
        stack.push(new LocalRegAVM2Item(ins, localData.lineStartInstruction, regId, computedValue, type));
    }

    @Override
    public int getStackPushCount(AVM2Instruction ins, ABC abc) {
        return 1;
    }

    public abstract int getRegisterId(AVM2Instruction var1);
}

