/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2.instructions.executing;

import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.AVM2LocalData;
import com.jpexs.decompiler.flash.abc.avm2.AVM2ConstantPool;
import com.jpexs.decompiler.flash.abc.avm2.LocalDataArea;
import com.jpexs.decompiler.flash.abc.avm2.instructions.AVM2Instruction;
import com.jpexs.decompiler.flash.abc.avm2.instructions.AVM2InstructionFlag;
import com.jpexs.decompiler.flash.abc.avm2.instructions.InstructionDefinition;
import com.jpexs.decompiler.flash.abc.avm2.model.CallAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.GetPropertyAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.LocalRegAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.SetLocalAVM2Item;
import com.jpexs.decompiler.flash.ecma.NotCompileTime;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.TranslateStack;
import com.jpexs.decompiler.graph.model.DuplicateItem;
import java.util.ArrayList;
import java.util.List;

public class CallIns
extends InstructionDefinition {
    public CallIns() {
        super(65, "call", new int[]{258}, true, new AVM2InstructionFlag[0]);
    }

    @Override
    public boolean isNotCompileTimeSupported() {
        return true;
    }

    @Override
    public boolean execute(LocalDataArea lda, AVM2ConstantPool constants, AVM2Instruction ins) {
        int argCount = ins.getParamAsLong(constants, 0).intValue();
        for (int i = 0; i < argCount; ++i) {
            lda.operandStack.pop();
        }
        Object receiver = lda.operandStack.pop();
        Object function = lda.operandStack.pop();
        lda.operandStack.push(NotCompileTime.INSTANCE);
        return true;
    }

    @Override
    public void translate(AVM2LocalData localData, TranslateStack stack, AVM2Instruction ins, List<GraphTargetItem> output, String path) {
        int argCount = ins.operands[0];
        ArrayList<GraphTargetItem> args = new ArrayList<GraphTargetItem>();
        for (int a = 0; a < argCount; ++a) {
            args.add(0, stack.pop());
        }
        GraphTargetItem receiver = stack.pop();
        GraphTargetItem function = stack.pop();
        if (function instanceof GetPropertyAVM2Item) {
            GetPropertyAVM2Item getProperty = (GetPropertyAVM2Item)function;
            if (getProperty.object instanceof DuplicateItem) {
                if (getProperty.object.value == receiver) {
                    getProperty.object = receiver;
                }
            } else if (getProperty.object instanceof SetLocalAVM2Item) {
                SetLocalAVM2Item setLocal = (SetLocalAVM2Item)getProperty.object;
                if (receiver instanceof LocalRegAVM2Item) {
                    LocalRegAVM2Item getLocal = (LocalRegAVM2Item)receiver;
                    if (getLocal.regIndex == setLocal.regIndex) {
                        receiver = getProperty.object = getProperty.object.value;
                    }
                }
            }
        }
        stack.push(new CallAVM2Item(ins, localData.lineStartInstruction, receiver, function, args));
    }

    @Override
    public int getStackPopCount(AVM2Instruction ins, ABC abc) {
        return ins.operands[0] + 2;
    }

    @Override
    public int getStackPushCount(AVM2Instruction ins, ABC abc) {
        return 1;
    }
}

