/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2.instructions;

import com.jpexs.decompiler.flash.BaseLocalData;
import com.jpexs.decompiler.flash.abc.ABCOutputStream;
import com.jpexs.decompiler.flash.abc.AVM2LocalData;
import com.jpexs.decompiler.flash.abc.avm2.AVM2Code;
import com.jpexs.decompiler.flash.abc.avm2.AVM2ConstantPool;
import com.jpexs.decompiler.flash.abc.avm2.instructions.DeobfuscatePopIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.IfTypeIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.InstructionDefinition;
import com.jpexs.decompiler.flash.abc.avm2.instructions.jumps.JumpIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.jumps.LookupSwitchIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.ReturnValueIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.ReturnVoidIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.ThrowIns;
import com.jpexs.decompiler.flash.abc.types.Float4;
import com.jpexs.decompiler.flash.abc.types.MethodBody;
import com.jpexs.decompiler.flash.abc.types.Multiname;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.ecma.EcmaScript;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.DottedChain;
import com.jpexs.decompiler.graph.GraphSource;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.TranslateStack;
import com.jpexs.decompiler.graph.model.LocalData;
import com.jpexs.helpers.Helper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AVM2Instruction
implements Cloneable,
GraphSourceItem {
    public InstructionDefinition definition;
    public int[] operands;
    private long address;
    public String comment;
    private boolean ignored = false;
    private int line;
    private String file;
    private long virtualAddress = -1L;
    private static final Map<String, String> oldStyleNames = new HashMap<String, String>();

    @Override
    public long getFileOffset() {
        return -1L;
    }

    @Override
    public long getLineOffset() {
        if (this.virtualAddress > -1L) {
            return this.virtualAddress;
        }
        return this.getAddress();
    }

    public void setFileLine(String file, int line) {
        this.file = file;
        this.line = line;
    }

    public AVM2Instruction(long offset, int insructionCode, int[] operands) {
        this(offset, AVM2Code.instructionSet[insructionCode], operands);
    }

    public AVM2Instruction(long address, InstructionDefinition definition, int[] operands) {
        this.definition = definition;
        this.operands = operands != null && operands.length > 0 ? operands : null;
        this.address = address;
    }

    public byte[] getBytes() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            ABCOutputStream aos = new ABCOutputStream(bos);
            aos.write(this.definition.instructionCode);
            block9: for (int i = 0; i < this.definition.operands.length; ++i) {
                int opt = this.definition.operands[i] & 0xFF00;
                switch (opt) {
                    case 768: {
                        aos.writeS24(this.operands[i]);
                        continue block9;
                    }
                    case 256: 
                    case 1536: {
                        aos.writeU30(this.operands[i]);
                        continue block9;
                    }
                    case 512: {
                        aos.writeU8(this.operands[i]);
                        continue block9;
                    }
                    case 1280: {
                        aos.writeU8(0xFF & this.operands[i]);
                        continue block9;
                    }
                    case 1024: {
                        aos.writeU30(this.operands[i]);
                        for (int j = i + 1; j < this.operands.length; ++j) {
                            aos.writeS24(this.operands[j]);
                        }
                        continue block9;
                    }
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bos.toByteArray();
    }

    @Override
    public int getBytesLength() {
        int cnt = 1;
        block7: for (int i = 0; i < this.definition.operands.length; ++i) {
            int opt = this.definition.operands[i] & 0xFF00;
            switch (opt) {
                case 768: {
                    cnt += 3;
                    continue block7;
                }
                case 256: 
                case 1536: {
                    cnt += ABCOutputStream.getU30ByteLength(this.operands[i]);
                    continue block7;
                }
                case 512: {
                    ++cnt;
                    continue block7;
                }
                case 1280: {
                    ++cnt;
                    continue block7;
                }
                case 1024: {
                    cnt += ABCOutputStream.getU30ByteLength(this.operands[i]);
                    for (int j = i + 1; j < this.operands.length; ++j) {
                        cnt += 3;
                    }
                    continue block7;
                }
            }
        }
        return cnt;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(this.definition.instructionName);
        if (this.operands != null) {
            for (int i = 0; i < this.operands.length; ++i) {
                s.append(" ");
                s.append(this.operands[i]);
            }
        }
        return s.toString();
    }

    public List<Long> getOffsets() {
        ArrayList<Long> ret = new ArrayList<Long>();
        String s = "";
        block5: for (int i = 0; i < this.definition.operands.length; ++i) {
            switch (this.definition.operands[i]) {
                case 779: {
                    ret.add(this.address + (long)this.operands[i] + (long)this.getBytesLength());
                    continue block5;
                }
                case 786: {
                    ret.add(this.address + (long)this.operands[i]);
                    continue block5;
                }
                case 1024: {
                    for (int j = i + 1; j < this.operands.length; ++j) {
                        ret.add(this.address + (long)this.operands[j]);
                    }
                    continue block5;
                }
            }
        }
        return ret;
    }

    public Object getParam(AVM2ConstantPool constants, int idx) {
        switch (this.definition.operands[idx]) {
            case 257: {
                return constants.getMultiname(this.operands[idx]);
            }
            case 260: {
                return constants.getString(this.operands[idx]);
            }
            case 270: {
                return constants.getInt(this.operands[idx]);
            }
            case 271: {
                return constants.getUInt(this.operands[idx]);
            }
            case 272: {
                return constants.getDouble(this.operands[idx]);
            }
            case 779: {
                return this.address + (long)this.operands[idx] + (long)this.getBytesLength();
            }
            case 786: {
                return this.address + (long)this.operands[idx];
            }
            case 1024: {
                return (long)this.operands[idx];
            }
        }
        return (long)this.operands[idx];
    }

    public Long getParamAsLong(AVM2ConstantPool constants, int idx) {
        return (Long)this.getParam(constants, idx);
    }

    public String getParams(AVM2ConstantPool constants, List<DottedChain> fullyQualifiedNames) {
        StringBuilder s = new StringBuilder();
        block32: for (int i = 0; i < this.definition.operands.length; ++i) {
            if (i > 0) {
                s.append(",");
            }
            switch (this.definition.operands[i]) {
                case 279: {
                    if (this.operands[i] == 0) {
                        s.append(" null");
                        continue block32;
                    }
                    s.append(" ");
                    try {
                        s.append(Multiname.namespaceToString(constants, this.operands[i]));
                    }
                    catch (IndexOutOfBoundsException iob) {
                        s.append("Unknown(").append(this.operands[i]).append(")");
                    }
                    continue block32;
                }
                case 257: {
                    if (this.operands[i] == 0) {
                        s.append(" null");
                        continue block32;
                    }
                    s.append(" ");
                    try {
                        Multiname multiname = constants.getMultiname(this.operands[i]);
                        if (multiname == null) continue block32;
                        s.append(multiname.toString(constants, fullyQualifiedNames));
                    }
                    catch (IndexOutOfBoundsException iob) {
                        s.append("Unknown(").append(this.operands[i]).append(")");
                    }
                    continue block32;
                }
                case 260: {
                    try {
                        String str;
                        if (this.operands[i] == 0 || (str = constants.getString(this.operands[i])) == null) {
                            s.append(" null");
                            continue block32;
                        }
                        s.append(" \"");
                        s.append(Helper.escapePCodeString(str));
                        s.append("\"");
                    }
                    catch (IndexOutOfBoundsException iob) {
                        s.append(" Unknown(").append(this.operands[i]).append(")");
                    }
                    continue block32;
                }
                case 270: {
                    if (this.operands[i] == 0) {
                        s.append(" null");
                        continue block32;
                    }
                    s.append(" ");
                    try {
                        s.append(constants.getInt(this.operands[i]));
                    }
                    catch (IndexOutOfBoundsException iob) {
                        s.append("Unknown(").append(this.operands[i]).append(")");
                    }
                    continue block32;
                }
                case 271: {
                    if (this.operands[i] == 0) {
                        s.append(" null");
                        continue block32;
                    }
                    s.append(" ");
                    try {
                        s.append(constants.getUInt(this.operands[i]));
                    }
                    catch (IndexOutOfBoundsException iob) {
                        s.append("Unknown(").append(this.operands[i]).append(")");
                    }
                    continue block32;
                }
                case 272: {
                    if (this.operands[i] == 0) {
                        s.append(" null");
                        continue block32;
                    }
                    s.append(" ");
                    try {
                        s.append(EcmaScript.toString(constants.getDouble(this.operands[i])));
                    }
                    catch (IndexOutOfBoundsException iob) {
                        s.append("Unknown(").append(this.operands[i]).append(")");
                    }
                    continue block32;
                }
                case 277: {
                    if (this.operands[i] == 0) {
                        s.append(" null");
                        continue block32;
                    }
                    s.append(" ");
                    try {
                        s.append(EcmaScript.toString(constants.getFloat(this.operands[i])));
                    }
                    catch (IndexOutOfBoundsException iob) {
                        s.append("Unknown(").append(this.operands[i]).append(")");
                    }
                    continue block32;
                }
                case 278: {
                    if (this.operands[i] == 0) {
                        s.append(" null");
                        continue block32;
                    }
                    try {
                        Float4 f4 = constants.getFloat4(this.operands[i]);
                        s.append(" ").append(EcmaScript.toString(Float.valueOf(f4.values[0])));
                        s.append(" ").append(EcmaScript.toString(Float.valueOf(f4.values[1])));
                        s.append(" ").append(EcmaScript.toString(Float.valueOf(f4.values[2])));
                        s.append(" ").append(EcmaScript.toString(Float.valueOf(f4.values[3])));
                    }
                    catch (IndexOutOfBoundsException iob) {
                        s.append(" Unknown(").append(this.operands[i]).append(")");
                    }
                    continue block32;
                }
                case 273: {
                    if (this.operands[i] == 0) {
                        s.append(" null");
                        continue block32;
                    }
                    s.append(" ");
                    try {
                        s.append(constants.getDecimal(this.operands[i]));
                    }
                    catch (IndexOutOfBoundsException iob) {
                        s.append("Unknown(").append(this.operands[i]).append(")");
                    }
                    continue block32;
                }
                case 779: {
                    s.append(" ");
                    s.append("ofs");
                    s.append(Helper.formatAddress(this.address + (long)this.operands[i] + (long)this.getBytesLength()));
                    continue block32;
                }
                case 786: {
                    s.append(" ");
                    s.append("ofs");
                    s.append(Helper.formatAddress(this.address + (long)this.operands[i]));
                    continue block32;
                }
                case 1024: {
                    if (Configuration.useOldStyleLookupSwitchAs3PCode.get().booleanValue()) {
                        s.append(" ");
                        s.append(this.operands[i]);
                    } else {
                        s.append(" [");
                    }
                    boolean first = Configuration.useOldStyleLookupSwitchAs3PCode.get() == false;
                    for (int j = i + 1; j < this.operands.length; ++j) {
                        if (!first) {
                            s.append(", ");
                        }
                        first = false;
                        s.append("ofs");
                        s.append(Helper.formatAddress(this.address + (long)this.operands[j]));
                    }
                    if (Configuration.useOldStyleLookupSwitchAs3PCode.get().booleanValue()) continue block32;
                    s.append("]");
                    continue block32;
                }
                default: {
                    s.append(" ");
                    s.append(this.operands[i]);
                }
            }
        }
        return s.toString();
    }

    public String getComment() {
        if (this.isIgnored()) {
            return " ;ignored";
        }
        if (this.comment == null || this.comment.isEmpty()) {
            return "";
        }
        return " ;" + this.comment;
    }

    @Override
    public boolean isIgnored() {
        return this.ignored;
    }

    public GraphTextWriter toString(GraphTextWriter writer, LocalData localData) {
        writer.appendNoHilight(Helper.formatAddress(this.address) + " " + String.format("%-30s", Helper.byteArrToString(this.getBytes())) + this.getCustomizedInstructionName());
        writer.appendNoHilight(this.getParams(localData.constantsAvm2, localData.fullyQualifiedNames) + this.getComment());
        return writer;
    }

    private String getCustomizedInstructionName() {
        if (Configuration.useOldStyleGetSetLocalsAs3PCode.get().booleanValue() && oldStyleNames.containsKey(this.definition.instructionName)) {
            return oldStyleNames.get(this.definition.instructionName);
        }
        return this.definition.instructionName;
    }

    public String toStringNoAddress(AVM2ConstantPool constants, List<DottedChain> fullyQualifiedNames) {
        String s = this.getCustomizedInstructionName();
        if (Configuration.padAs3PCodeInstructionName.get().booleanValue()) {
            for (int i = s.length(); i < 19; ++i) {
                s = s + " ";
            }
        }
        s = s + this.getParams(constants, fullyQualifiedNames) + this.getComment();
        return s.trim();
    }

    @Override
    public void translate(BaseLocalData localData, TranslateStack stack, List<GraphTargetItem> output, int staticOperation, String path) throws InterruptedException {
        AVM2LocalData aLocalData = (AVM2LocalData)localData;
        this.definition.translate(aLocalData, stack, this, output, null);
    }

    @Override
    public int getStackPopCount(BaseLocalData localData, TranslateStack stack) {
        AVM2LocalData aLocalData = (AVM2LocalData)localData;
        return this.getStackPopCount(aLocalData);
    }

    @Override
    public int getStackPushCount(BaseLocalData localData, TranslateStack stack) {
        AVM2LocalData aLocalData = (AVM2LocalData)localData;
        return this.getStackPushCount(aLocalData);
    }

    public int getStackPopCount(AVM2LocalData aLocalData) {
        return this.definition.getStackPopCount(this, aLocalData.abc);
    }

    public int getStackPushCount(AVM2LocalData aLocalData) {
        return this.definition.getStackPushCount(this, aLocalData.abc);
    }

    @Override
    public boolean isJump() {
        return this.definition instanceof JumpIns;
    }

    @Override
    public boolean isBranch() {
        return this.definition instanceof IfTypeIns || this.definition instanceof LookupSwitchIns;
    }

    @Override
    public boolean isExit() {
        return this.definition instanceof ReturnValueIns || this.definition instanceof ReturnVoidIns || this.definition instanceof ThrowIns;
    }

    @Override
    public long getAddress() {
        return this.address;
    }

    public void setAddress(long address) {
        this.address = address;
    }

    public long getTargetAddress() {
        return this.address + 4L + (long)this.operands[0];
    }

    public void setTargetOffset(int offset) {
        this.operands[0] = offset;
    }

    @Override
    public List<Integer> getBranches(GraphSource code) {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        if (this.definition instanceof IfTypeIns) {
            ret.add(code.adr2pos(this.getTargetAddress()));
            if (!(this.definition instanceof JumpIns)) {
                ret.add(code.adr2pos(this.address + (long)this.getBytesLength()));
            }
        }
        if (this.definition instanceof LookupSwitchIns) {
            ret.add(code.adr2pos(this.address + (long)this.operands[0]));
            for (int k = 2; k < this.operands.length; ++k) {
                ret.add(code.adr2pos(this.address + (long)this.operands[k]));
            }
        }
        return ret;
    }

    @Override
    public boolean ignoredLoops() {
        return false;
    }

    @Override
    public void setIgnored(boolean ignored, int pos) {
        this.ignored = ignored;
    }

    @Override
    public boolean isDeobfuscatePop() {
        return this.definition instanceof DeobfuscatePopIns;
    }

    public AVM2Instruction clone() {
        try {
            AVM2Instruction ret = (AVM2Instruction)super.clone();
            if (this.operands != null) {
                ret.operands = Arrays.copyOf(this.operands, this.operands.length);
            }
            return ret;
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException();
        }
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public String getFile() {
        return this.file;
    }

    public void setOperand(int operandIndex, int newValue, AVM2Code code, MethodBody body) {
        int oldByteCount = this.getBytesLength();
        this.operands[operandIndex] = newValue;
        int newByteCount = this.getBytesLength();
        int byteDelta = newByteCount - oldByteCount;
        if (byteDelta != 0) {
            code.updateInstructionByteCountByAddr(this.address, byteDelta, body);
        }
        body.setModified();
    }

    public void setOperands(int[] operands, AVM2Code code, MethodBody body) {
        int oldByteCount = this.getBytesLength();
        this.operands = operands;
        int newByteCount = this.getBytesLength();
        int byteDelta = newByteCount - oldByteCount;
        if (byteDelta != 0) {
            code.updateInstructionByteCountByAddr(this.address, byteDelta, body);
        }
        body.setModified();
    }

    @Override
    public long getVirtualAddress() {
        return this.virtualAddress;
    }

    @Override
    public void setVirtualAddress(long virtualAddress) {
        this.virtualAddress = virtualAddress;
    }

    static {
        for (int i = 0; i <= 3; ++i) {
            oldStyleNames.put("getlocal" + i, "getlocal_" + i);
            oldStyleNames.put("setlocal" + i, "setlocal_" + i);
        }
    }
}

