/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2;

import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.avm2.AVM2Code;
import com.jpexs.decompiler.flash.abc.avm2.InstructionStats;
import com.jpexs.decompiler.flash.abc.types.MethodBody;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.DottedChain;
import com.jpexs.decompiler.graph.model.LocalData;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class CodeStats {
    public int maxstack = 0;
    public int maxscope = 0;
    public int maxlocal = 1;
    public int initscope = 0;
    public boolean has_set_dxns = false;
    public boolean has_activation = false;
    public InstructionStats[] instructionStats;

    public GraphTextWriter toString(GraphTextWriter writer, ABC abc, List<DottedChain> fullyQualifiedNames) {
        writer.appendNoHilight("Stats: maxstack=" + this.maxstack + ", maxscope=" + this.maxscope + ", maxlocal=" + this.maxlocal).newLine();
        int i = 0;
        int ms = 0;
        for (InstructionStats stats : this.instructionStats) {
            int deltastack = stats.ins.definition.getStackDelta(stats.ins, abc);
            if (stats.stackpos > ms) {
                ms = stats.stackpos;
            }
            writer.appendNoHilight(i + ":" + stats.stackpos + (deltastack >= 0 ? "+" + deltastack : Integer.valueOf(deltastack)) + "," + stats.scopepos + "    " + stats.ins.toString(writer, LocalData.create(new ArrayList<MethodBody>(), null, abc, null, fullyQualifiedNames, new HashSet<Integer>()))).newLine();
            ++i;
        }
        return writer;
    }

    public CodeStats() {
    }

    public CodeStats(AVM2Code code) {
        this.instructionStats = new InstructionStats[code.code.size()];
        for (int i = 0; i < code.code.size(); ++i) {
            this.instructionStats[i] = new InstructionStats(code.code.get(i));
        }
    }
}

