/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2;

import com.jpexs.decompiler.flash.EndOfStreamException;
import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.ABCInputStream;
import com.jpexs.decompiler.flash.abc.CopyOutputStream;
import com.jpexs.decompiler.flash.abc.avm2.AVM2ConstantPool;
import com.jpexs.decompiler.flash.abc.avm2.AVM2RuntimeInfo;
import com.jpexs.decompiler.flash.abc.avm2.CodeStats;
import com.jpexs.decompiler.flash.abc.avm2.ConvertException;
import com.jpexs.decompiler.flash.abc.avm2.ConvertOutput;
import com.jpexs.decompiler.flash.abc.avm2.LocalDataArea;
import com.jpexs.decompiler.flash.abc.avm2.OffsetUpdater;
import com.jpexs.decompiler.flash.abc.avm2.deobfuscation.AVM2DeobfuscatorGetSet;
import com.jpexs.decompiler.flash.abc.avm2.deobfuscation.AVM2DeobfuscatorJumps;
import com.jpexs.decompiler.flash.abc.avm2.deobfuscation.AVM2DeobfuscatorRegistersOld;
import com.jpexs.decompiler.flash.abc.avm2.deobfuscation.AVM2DeobfuscatorSimpleOld;
import com.jpexs.decompiler.flash.abc.avm2.deobfuscation.AVM2DeobfuscatorZeroJumpsNullPushes;
import com.jpexs.decompiler.flash.abc.avm2.exceptions.AVM2ExecutionException;
import com.jpexs.decompiler.flash.abc.avm2.exceptions.AVM2VerifyErrorException;
import com.jpexs.decompiler.flash.abc.avm2.graph.AVM2Graph;
import com.jpexs.decompiler.flash.abc.avm2.graph.AVM2GraphSource;
import com.jpexs.decompiler.flash.abc.avm2.instructions.AVM2Instruction;
import com.jpexs.decompiler.flash.abc.avm2.instructions.AVM2InstructionFlag;
import com.jpexs.decompiler.flash.abc.avm2.instructions.IfTypeIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.InstructionDefinition;
import com.jpexs.decompiler.flash.abc.avm2.instructions.UnknownInstruction;
import com.jpexs.decompiler.flash.abc.avm2.instructions.alchemy.Lf32Ins;
import com.jpexs.decompiler.flash.abc.avm2.instructions.alchemy.Lf64Ins;
import com.jpexs.decompiler.flash.abc.avm2.instructions.alchemy.Li16Ins;
import com.jpexs.decompiler.flash.abc.avm2.instructions.alchemy.Li32Ins;
import com.jpexs.decompiler.flash.abc.avm2.instructions.alchemy.Li8Ins;
import com.jpexs.decompiler.flash.abc.avm2.instructions.alchemy.Sf32Ins;
import com.jpexs.decompiler.flash.abc.avm2.instructions.alchemy.Sf64Ins;
import com.jpexs.decompiler.flash.abc.avm2.instructions.alchemy.Si16Ins;
import com.jpexs.decompiler.flash.abc.avm2.instructions.alchemy.Si32Ins;
import com.jpexs.decompiler.flash.abc.avm2.instructions.alchemy.Si8Ins;
import com.jpexs.decompiler.flash.abc.avm2.instructions.alchemy.Sxi16Ins;
import com.jpexs.decompiler.flash.abc.avm2.instructions.alchemy.Sxi1Ins;
import com.jpexs.decompiler.flash.abc.avm2.instructions.alchemy.Sxi8Ins;
import com.jpexs.decompiler.flash.abc.avm2.instructions.arithmetic.AddIIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.arithmetic.AddIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.arithmetic.DecrementIIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.arithmetic.DecrementIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.arithmetic.DivideIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.arithmetic.IncrementIIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.arithmetic.IncrementIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.arithmetic.ModuloIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.arithmetic.MultiplyIIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.arithmetic.MultiplyIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.arithmetic.NegateIIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.arithmetic.NegateIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.arithmetic.NotIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.arithmetic.SubtractIIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.arithmetic.SubtractIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.bitwise.BitAndIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.bitwise.BitNotIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.bitwise.BitOrIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.bitwise.BitXorIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.bitwise.LShiftIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.bitwise.RShiftIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.bitwise.URShiftIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.comparison.EqualsIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.comparison.GreaterEqualsIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.comparison.GreaterThanIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.comparison.LessEqualsIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.comparison.LessThanIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.comparison.StrictEqualsIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.construction.ConstructIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.construction.ConstructPropIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.construction.ConstructSuperIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.construction.NewActivationIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.construction.NewArrayIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.construction.NewCatchIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.construction.NewClassIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.construction.NewFunctionIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.construction.NewObjectIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.debug.DebugFileIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.debug.DebugIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.debug.DebugLineIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.executing.CallIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.executing.CallMethodIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.executing.CallPropLexIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.executing.CallPropVoidIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.executing.CallPropertyIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.executing.CallStaticIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.executing.CallSuperIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.executing.CallSuperVoidIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.jumps.IfEqIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.jumps.IfFalseIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.jumps.IfGeIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.jumps.IfGtIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.jumps.IfLeIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.jumps.IfLtIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.jumps.IfNGeIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.jumps.IfNGtIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.jumps.IfNLeIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.jumps.IfNLtIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.jumps.IfNeIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.jumps.IfStrictEqIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.jumps.IfStrictNeIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.jumps.IfTrueIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.jumps.JumpIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.jumps.LookupSwitchIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.localregs.DecLocalIIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.localregs.DecLocalIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.localregs.GetLocal0Ins;
import com.jpexs.decompiler.flash.abc.avm2.instructions.localregs.GetLocal1Ins;
import com.jpexs.decompiler.flash.abc.avm2.instructions.localregs.GetLocal2Ins;
import com.jpexs.decompiler.flash.abc.avm2.instructions.localregs.GetLocal3Ins;
import com.jpexs.decompiler.flash.abc.avm2.instructions.localregs.GetLocalIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.localregs.GetLocalTypeIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.localregs.IncLocalIIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.localregs.IncLocalIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.localregs.KillIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.localregs.SetLocal0Ins;
import com.jpexs.decompiler.flash.abc.avm2.instructions.localregs.SetLocal1Ins;
import com.jpexs.decompiler.flash.abc.avm2.instructions.localregs.SetLocal2Ins;
import com.jpexs.decompiler.flash.abc.avm2.instructions.localregs.SetLocal3Ins;
import com.jpexs.decompiler.flash.abc.avm2.instructions.localregs.SetLocalIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.localregs.SetLocalTypeIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.BkptIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.BkptLineIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.DeletePropertyIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.FindDefIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.FindPropertyIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.FindPropertyStrictIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.GetDescendantsIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.GetGlobalScopeIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.GetGlobalSlotIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.GetLexIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.GetOuterScopeIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.GetPropertyIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.GetScopeObjectIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.GetSlotIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.GetSuperIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.HasNext2Ins;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.HasNextIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.InIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.InitPropertyIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.LabelIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.NextNameIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.NextValueIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.NopIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.ReturnValueIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.ReturnVoidIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.SetGlobalSlotIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.SetPropertyIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.SetSlotIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.SetSuperIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.ThrowIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.TimestampIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.decimalsupport.AddPIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.decimalsupport.ConvertMIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.decimalsupport.ConvertMPIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.decimalsupport.DecLocalPIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.decimalsupport.DecrementPIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.decimalsupport.DividePIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.decimalsupport.IncLocalPIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.decimalsupport.IncrementPIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.decimalsupport.ModuloPIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.decimalsupport.MultiplyPIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.decimalsupport.NegatePIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.decimalsupport.PushDNanIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.decimalsupport.PushDecimalIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.decimalsupport.SubtractPIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.deprecated.CoerceBIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.deprecated.CoerceDIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.deprecated.CoerceIIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.deprecated.CoerceUIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.floatsupport.ConvertF4Ins;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.floatsupport.ConvertFIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.floatsupport.Lf32x4Ins;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.floatsupport.PushFloat4Ins;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.floatsupport.PushFloatIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.floatsupport.Sf32x4Ins;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.floatsupport.UnPlusIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.unknown.AbsJumpIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.unknown.AddDIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.unknown.AllocIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.unknown.CallInterfaceIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.unknown.CallSuperIdIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.unknown.CodeGenOpIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.unknown.ConcatIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.unknown.DecodeIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.unknown.DelDescendantsIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.unknown.DeletePropertyLateIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.unknown.DoubleToAtomIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.unknown.InvalidIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.unknown.MarkIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.unknown.PrologueIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.unknown.PushConstantIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.unknown.SendEnterIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.unknown.SetPropertyLateIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.unknown.SweepIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.unknown.VerifyOpIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.unknown.VerifyPassIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.unknown.WbIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.stack.DupIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.stack.PopIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.stack.PopScopeIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.stack.PushByteIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.stack.PushDoubleIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.stack.PushFalseIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.stack.PushIntIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.stack.PushNamespaceIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.stack.PushNanIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.stack.PushNullIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.stack.PushScopeIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.stack.PushShortIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.stack.PushStringIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.stack.PushTrueIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.stack.PushUIntIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.stack.PushUndefinedIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.stack.PushWithIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.stack.SwapIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.types.ApplyTypeIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.types.AsTypeIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.types.AsTypeLateIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.types.CoerceAIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.types.CoerceIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.types.CoerceOIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.types.CoerceOrConvertTypeIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.types.CoerceSIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.types.ConvertBIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.types.ConvertDIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.types.ConvertIIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.types.ConvertOIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.types.ConvertSIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.types.ConvertUIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.types.InstanceOfIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.types.IsTypeIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.types.IsTypeLateIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.types.TypeOfIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.xml.CheckFilterIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.xml.DXNSIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.xml.DXNSLateIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.xml.EscXAttrIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.xml.EscXElemIns;
import com.jpexs.decompiler.flash.abc.avm2.model.AVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.CoerceAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.ConvertAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.FindPropertyAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.FullMultinameAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.GetLexAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.GetPropertyAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.GetSlotAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.InitPropertyAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.LocalRegAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.NewActivationAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.NewFunctionAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.NullAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.ReturnVoidAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.SetLocalAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.SetPropertyAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.SetSlotAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.SetTypeAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.UndefinedAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.clauses.DeclarationAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.clauses.ForEachInAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.clauses.ForInAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.parser.script.AbcIndexing;
import com.jpexs.decompiler.flash.abc.types.ABCException;
import com.jpexs.decompiler.flash.abc.types.AssignedValue;
import com.jpexs.decompiler.flash.abc.types.ConvertData;
import com.jpexs.decompiler.flash.abc.types.MethodBody;
import com.jpexs.decompiler.flash.abc.types.MethodInfo;
import com.jpexs.decompiler.flash.abc.types.Multiname;
import com.jpexs.decompiler.flash.abc.types.traits.Trait;
import com.jpexs.decompiler.flash.abc.types.traits.TraitSlotConst;
import com.jpexs.decompiler.flash.abc.types.traits.Traits;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.dumpview.DumpInfo;
import com.jpexs.decompiler.flash.ecma.Undefined;
import com.jpexs.decompiler.flash.exporters.modes.ScriptExportMode;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.flash.helpers.HighlightedTextWriter;
import com.jpexs.decompiler.flash.helpers.SWFDecompilerPlugin;
import com.jpexs.decompiler.flash.helpers.hilight.HighlightSpecialType;
import com.jpexs.decompiler.graph.AbstractGraphTargetVisitor;
import com.jpexs.decompiler.graph.Block;
import com.jpexs.decompiler.graph.DottedChain;
import com.jpexs.decompiler.graph.GraphPart;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.ScopeStack;
import com.jpexs.decompiler.graph.SecondPassException;
import com.jpexs.decompiler.graph.SimpleValue;
import com.jpexs.decompiler.graph.TranslateStack;
import com.jpexs.decompiler.graph.TypeItem;
import com.jpexs.decompiler.graph.model.ScriptEndItem;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.Reference;
import com.jpexs.helpers.ReflectionTools;
import com.jpexs.helpers.stat.Statistics;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AVM2Code
implements Cloneable {
    private static final Logger logger;
    private static final boolean DEBUG_MODE = false;
    public static int toSourceLimit;
    public List<AVM2Instruction> code;
    public static boolean DEBUG_REWRITE;
    public static final int OPT_U30 = 256;
    public static final int OPT_U8 = 512;
    public static final int OPT_S24 = 768;
    public static final int OPT_CASE_OFFSETS = 1024;
    public static final int OPT_S8 = 1280;
    public static final int OPT_S16 = 1536;
    public static final int DAT_MULTINAME_INDEX = 257;
    public static final int DAT_ARG_COUNT = 258;
    public static final int DAT_METHOD_INDEX = 259;
    public static final int DAT_STRING_INDEX = 260;
    public static final int DAT_DEBUG_TYPE = 517;
    public static final int DAT_REGISTER_INDEX = 518;
    public static final int DAT_LINENUM = 263;
    public static final int DAT_LOCAL_REG_INDEX = 264;
    public static final int DAT_SLOT_INDEX = 265;
    public static final int DAT_SCOPE_INDEX = 266;
    public static final int DAT_OFFSET = 779;
    public static final int DAT_EXCEPTION_INDEX = 268;
    public static final int DAT_CLASS_INDEX = 269;
    public static final int DAT_INT_INDEX = 270;
    public static final int DAT_UINT_INDEX = 271;
    public static final int DAT_DOUBLE_INDEX = 272;
    public static final int DAT_DECIMAL_INDEX = 273;
    public static final int DAT_CASE_BASEOFFSET = 786;
    public static final int DAT_NUMBER_CONTEXT = 275;
    public static final int DAT_DISPATCH_ID = 276;
    public static final int DAT_FLOAT_INDEX = 277;
    public static final int DAT_FLOAT4_INDEX = 278;
    public static final int DAT_NAMESPACE_INDEX = 279;
    private static Map<Integer, String> operandDataTypeIdentifiers;
    private static final String[][] instructionAliasesArray;
    public static final Map<String, String> instructionAliases;
    public static final InstructionDefinition[] instructionSet;
    public static final InstructionDefinition[] allInstructionSet;
    public static final String IDENTOPEN = "/*IDENTOPEN*/";
    public static final String IDENTCLOSE = "/*IDENTCLOSE*/";
    private int toSourceCount = 0;

    public static String operandTypeSizeToString(int ot) {
        int sizeType = ot & 0xFF00;
        switch (sizeType) {
            case 256: {
                return "U30";
            }
            case 1536: {
                return "S16";
            }
            case 512: {
                return "U8";
            }
            case 1280: {
                return "S8";
            }
            case 768: {
                return "S24";
            }
            case 1024: {
                return "S24(=n), S24[n]";
            }
        }
        return "";
    }

    public static String operandTypeToString(int ot, boolean withTypeSize) {
        String typeSize = AVM2Code.operandTypeSizeToString(ot);
        if (ot == 1024) {
            return "number" + (withTypeSize ? "(U30)" : "") + ", offset" + (withTypeSize ? "(S24)" : "") + ", offset" + (withTypeSize ? "(S24)" : "") + ", ...";
        }
        if (operandDataTypeIdentifiers.containsKey(ot)) {
            String dataType = operandDataTypeIdentifiers.get(ot);
            return dataType + (withTypeSize ? "(" + typeSize + ")" : "");
        }
        return typeSize;
    }

    public AVM2Code() {
        this.code = new ArrayList<AVM2Instruction>();
    }

    public AVM2Code(int capacity) {
        this.code = new ArrayList<AVM2Instruction>(capacity);
    }

    public AVM2Code(ArrayList<AVM2Instruction> instructions) {
        this.code = instructions;
    }

    public Object execute(HashMap<Integer, Object> arguments, AVM2ConstantPool constants) throws AVM2ExecutionException {
        return this.execute(arguments, constants, null);
    }

    public Object execute(HashMap<Integer, Object> arguments, AVM2ConstantPool constants, AVM2RuntimeInfo runtimeInfo) throws AVM2ExecutionException {
        int pos = 0;
        LocalDataArea lda = new LocalDataArea();
        lda.methodName = "methodName";
        lda.localRegisters = arguments;
        lda.runtimeInfo = runtimeInfo;
        for (AVM2Instruction ins : this.code) {
            if (ins.definition instanceof CallSuperVoidIns) continue;
            ins.definition.verify(lda, constants, ins);
        }
        while (pos < this.code.size()) {
            AVM2Instruction ins = this.code.get(pos);
            if (!ins.definition.execute(lda, constants, ins)) {
                return null;
            }
            if (lda.jump != null) {
                try {
                    pos = this.adr2pos(lda.jump);
                }
                catch (ConvertException ex) {
                    throw new AVM2VerifyErrorException(1021, lda.isDebug());
                }
                lda.jump = null;
            } else {
                ++pos;
            }
            if (lda.returnValue == null) continue;
            return lda.returnValue;
        }
        return Undefined.INSTANCE;
    }

    public void calculateDebugFileLine(ABC abc) {
        this.calculateDebugFileLine(null, 0, 0, abc, new HashSet<Integer>(), new HashSet<Integer>());
    }

    private boolean calculateDebugFileLine(String debugFile, int debugLine, int pos, ABC abc, Set<Integer> seen, Set<Integer> seenMethods) {
        while (pos < this.code.size()) {
            MethodBody innerBody;
            int newMethodInfo;
            AVM2Instruction ins = this.code.get(pos);
            if (seen.contains(pos)) {
                return true;
            }
            seen.add(pos);
            if (ins.definition instanceof DebugFileIns) {
                debugFile = abc.constants.getString(ins.operands[0]);
            }
            if (ins.definition instanceof DebugLineIns) {
                debugLine = ins.operands[0];
            }
            ins.setFileLine(debugFile, debugLine);
            if (ins.definition instanceof NewFunctionIns && pos + 1 < this.code.size() && !(this.code.get((int)(pos + 1)).definition instanceof PopIns) && !seenMethods.contains(newMethodInfo = ins.operands[0]) && (innerBody = abc.findBody(newMethodInfo)) != null) {
                seenMethods.add(newMethodInfo);
                innerBody.getCode().calculateDebugFileLine(debugFile, debugLine, 0, abc, new HashSet<Integer>(), seenMethods);
            }
            if (ins.definition instanceof ReturnValueIns) {
                return true;
            }
            if (ins.definition instanceof ReturnVoidIns) {
                return true;
            }
            if (ins.definition instanceof JumpIns) {
                try {
                    pos = this.adr2pos(ins.getTargetAddress());
                    continue;
                }
                catch (ConvertException ex) {
                    return false;
                }
            }
            if (ins.definition instanceof IfTypeIns) {
                try {
                    int newpos = this.adr2pos(ins.getTargetAddress());
                    this.calculateDebugFileLine(debugFile, debugLine, newpos, abc, seen, seenMethods);
                }
                catch (ConvertException ex) {
                    return false;
                }
            }
            if (ins.definition instanceof LookupSwitchIns) {
                for (int i = 0; i < ins.operands.length; ++i) {
                    if (i == 1) continue;
                    try {
                        int newpos = this.adr2pos(this.pos2adr(pos) + (long)ins.operands[i]);
                        if (this.calculateDebugFileLine(debugFile, debugLine, newpos, abc, seen, seenMethods)) continue;
                        return false;
                    }
                    catch (ConvertException ex) {
                        return false;
                    }
                }
            }
            ++pos;
        }
        return true;
    }

    public void removeWrongIndices(AVM2ConstantPool constants) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AVM2Code(ABCInputStream ais, MethodBody body) throws IOException {
        HashMap<Long, AVM2Instruction> codeMap = new HashMap<Long, AVM2Instruction>();
        DumpInfo diParent = ais.dumpInfo;
        ArrayList<Long> addresses = new ArrayList<Long>();
        ArrayList<Long> unAdresses = new ArrayList<Long>();
        ArrayList<Long> switchAddresses = new ArrayList<Long>();
        int availableBytes = ais.available();
        for (int i = 0; i < availableBytes; ++i) {
            codeMap.put(Long.valueOf(i), new AVM2Instruction((long)i, 2, null));
        }
        long startPos = ais.getPosition();
        addresses.add(startPos);
        if (body != null) {
            for (ABCException e : body.exceptions) {
                addresses.add(Long.valueOf(e.target));
            }
        }
        block20: while (!(addresses.isEmpty() && switchAddresses.isEmpty() && unAdresses.isEmpty())) {
            long address;
            boolean isSwitch = false;
            boolean handleJumps = true;
            if (!addresses.isEmpty()) {
                address = (Long)addresses.remove(0);
            } else if (!switchAddresses.isEmpty()) {
                address = (Long)switchAddresses.remove(0);
                isSwitch = true;
            } else {
                address = (Long)unAdresses.remove(0);
                handleJumps = false;
            }
            if (address < startPos) continue;
            try {
                long startOffset;
                ais.seek(address);
                while (ais.available() > 0 && (!codeMap.containsKey(startOffset = ais.getPosition()) || ((AVM2Instruction)codeMap.get((Object)Long.valueOf((long)startOffset))).definition instanceof NopIns)) {
                    DumpInfo di = ais.newDumpLevel("instruction", "instruction");
                    InstructionDefinition instr = null;
                    try {
                        int swlen;
                        long target;
                        long p;
                        int instructionCode = ais.read("instructionCode");
                        instr = instructionSet[instructionCode];
                        if (instructionCode == 27) {
                            if (!isSwitch) {
                                switchAddresses.add(startOffset);
                                continue block20;
                            }
                            isSwitch = false;
                        }
                        if (di != null) {
                            di.name = instr.instructionName;
                        }
                        if (instr == null) continue block20;
                        int[] actualOperands = null;
                        if (instructionCode == 27) {
                            long totalBytes;
                            int firstOperand = ais.readS24("default_offset");
                            int case_count = ais.readU30("case_count");
                            long afterCasePos = ais.getPosition() + (long)(3 * (case_count + 1));
                            boolean invalidSwitch = false;
                            for (long a = startOffset; a < afterCasePos; ++a) {
                                if (!codeMap.containsKey(a) || ((AVM2Instruction)codeMap.get((Object)Long.valueOf((long)a))).definition instanceof NopIns) continue;
                                invalidSwitch = true;
                                break;
                            }
                            if (afterCasePos > (totalBytes = ais.getPosition() + (long)ais.available())) {
                                invalidSwitch = true;
                            }
                            if (invalidSwitch) continue block20;
                            actualOperands = new int[case_count + 3];
                            actualOperands[0] = firstOperand;
                            actualOperands[1] = case_count;
                            for (int c = 0; c < case_count + 1; ++c) {
                                actualOperands[2 + c] = ais.readS24("actualOperand");
                            }
                        } else if (instr.operands.length > 0) {
                            actualOperands = new int[instr.operands.length];
                            block24: for (int op = 0; op < instr.operands.length; ++op) {
                                switch (instr.operands[op] & 0xFF00) {
                                    case 256: {
                                        actualOperands[op] = ais.readU30("operand");
                                        continue block24;
                                    }
                                    case 1536: {
                                        actualOperands[op] = (short)ais.readU30("operand");
                                        continue block24;
                                    }
                                    case 512: {
                                        actualOperands[op] = ais.read("operand");
                                        continue block24;
                                    }
                                    case 1280: {
                                        actualOperands[op] = (byte)ais.read("operand");
                                        continue block24;
                                    }
                                    case 768: {
                                        actualOperands[op] = ais.readS24("operand");
                                    }
                                }
                            }
                        }
                        AVM2Instruction ai = new AVM2Instruction(startOffset, instr, actualOperands);
                        long endOffset = ais.getPosition();
                        boolean hasRoom = true;
                        for (p = startOffset; p < endOffset; ++p) {
                            if (!codeMap.containsKey(p) || ((AVM2Instruction)codeMap.get((Object)Long.valueOf((long)p))).definition instanceof NopIns) continue;
                            hasRoom = false;
                        }
                        if (!hasRoom) continue block20;
                        for (p = startOffset; p < endOffset; ++p) {
                            codeMap.put(p, ai);
                        }
                        if (instr instanceof IfTypeIns) {
                            if (handleJumps) {
                                target = ais.getPosition() + (long)actualOperands[0];
                                addresses.add(target);
                            } else {
                                actualOperands[0] = 0;
                            }
                        }
                        if (instr instanceof JumpIns) {
                            if (handleJumps) {
                                target = ais.getPosition() + (long)actualOperands[0];
                                addresses.add(target);
                                unAdresses.add(ais.getPosition());
                                continue block20;
                            }
                            actualOperands[0] = 0;
                        }
                        if (instr.isExitInstruction() && handleJumps) {
                            unAdresses.add(ais.getPosition());
                            continue block20;
                        }
                        if (!(instr instanceof LookupSwitchIns) || actualOperands == null) continue;
                        if (handleJumps) {
                            addresses.add(startOffset + (long)actualOperands[0]);
                            for (int c = 2; c < actualOperands.length; ++c) {
                                addresses.add(startOffset + (long)actualOperands[c]);
                            }
                            unAdresses.add(ais.getPosition());
                            continue block20;
                        }
                        actualOperands[0] = swlen = (int)(endOffset - startOffset);
                        for (int c = 2; c < actualOperands.length; ++c) {
                            actualOperands[c] = swlen;
                        }
                    }
                    finally {
                        if (instr == null) {
                            ais.endDumpLevel();
                            continue block20;
                        }
                        ais.endDumpLevel(instr.instructionCode);
                    }
                }
            }
            catch (EndOfStreamException ex) {
                ais.endDumpLevelUntil(diParent);
            }
        }
        if (diParent != null) {
            diParent.sortChildren();
        }
        this.code = new ArrayList<AVM2Instruction>(codeMap.size());
        AVM2Instruction prev = null;
        for (int i = 0; i < availableBytes; ++i) {
            AVM2Instruction ins = (AVM2Instruction)codeMap.get(i);
            if (prev != ins) {
                this.code.add(ins);
            }
            prev = ins;
        }
    }

    public void compact() {
        if (this.code instanceof ArrayList) {
            ((ArrayList)this.code).trimToSize();
        }
    }

    public void setInstructionOperand(int ip, int operandIndex, int value, MethodBody body) {
        int oldVal = this.code.get((int)ip).operands[ip];
        this.code.get((int)ip).operands[ip] = value;
    }

    public byte[] getBytes() {
        return this.getBytes(null);
    }

    public byte[] getBytes(byte[] origBytes) {
        OutputStream cos;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        if (origBytes != null && DEBUG_REWRITE) {
            ByteArrayInputStream origis = new ByteArrayInputStream(origBytes);
            cos = new CopyOutputStream(bos, origis);
        } else {
            cos = bos;
        }
        try {
            for (AVM2Instruction instruction : this.code) {
                cos.write(instruction.getBytes());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bos.toByteArray();
    }

    public void markOffsets() {
        long address = 0L;
        for (int i = 0; i < this.code.size(); ++i) {
            this.code.get(i).setAddress(address);
            address += (long)this.code.get(i).getBytesLength();
        }
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        for (AVM2Instruction instruction : this.code) {
            s.append(instruction.toString());
            s.append(Helper.newLine);
        }
        return s.toString();
    }

    public String toASMSource(ABC abc) {
        return this.toASMSource(abc, abc.constants);
    }

    public String toASMSource(ABC abc, AVM2ConstantPool constants) {
        HighlightedTextWriter writer = new HighlightedTextWriter(Configuration.getCodeFormatting(), false);
        this.toASMSource(abc, constants, null, null, new ArrayList<Integer>(), ScriptExportMode.PCODE, writer);
        return writer.toString();
    }

    public GraphTextWriter toASMSource(ABC abc, AVM2ConstantPool constants, MethodInfo info, MethodBody body, ScriptExportMode exportMode, GraphTextWriter writer) {
        return this.toASMSource(abc, constants, info, body, new ArrayList<Integer>(), exportMode, writer);
    }

    public GraphTextWriter toASMSource(ABC abc, AVM2ConstantPool constants, MethodInfo info, MethodBody body, List<Integer> outputMap, ScriptExportMode exportMode, GraphTextWriter writer) {
        boolean markOffsets;
        if (info != null) {
            writer.appendNoHilight("method");
            if (Configuration.indentAs3PCode.get().booleanValue()) {
                writer.indent();
            }
            writer.newLine();
            info.toASMSource(constants, writer);
        }
        writer.newLine();
        Set<Long> importantOffsets = this.getImportantOffsets(body, true);
        if (body != null) {
            writer.appendNoHilight("body");
            if (Configuration.indentAs3PCode.get().booleanValue()) {
                writer.indent();
            }
            writer.newLine();
            writer.appendNoHilight("maxstack ");
            writer.appendNoHilight(body.max_stack);
            writer.newLine();
            writer.appendNoHilight("localcount ");
            writer.appendNoHilight(body.max_regs);
            writer.newLine();
            writer.appendNoHilight("initscopedepth ");
            writer.appendNoHilight(body.init_scope_depth);
            writer.newLine();
            writer.appendNoHilight("maxscopedepth ");
            writer.appendNoHilight(body.max_scope_depth);
            writer.newLine();
            for (Trait t : body.traits.traits) {
                t.convertTraitHeader(abc, writer);
                if (Configuration.indentAs3PCode.get().booleanValue()) {
                    writer.unindent();
                }
                writer.appendNoHilight("end ; trait").newLine();
            }
        }
        writer.newLine();
        writer.appendNoHilight("code");
        if (Configuration.indentAs3PCode.get().booleanValue()) {
            writer.indent();
        }
        writer.newLine();
        int ip = 0;
        int largeLimit = Configuration.limitAs3PCodeOffsetMatching.get();
        boolean bl = markOffsets = this.code.size() <= largeLimit;
        if (exportMode == ScriptExportMode.HEX) {
            Helper.byteArrayToHexWithHeader(writer, this.getBytes());
        } else if (exportMode == ScriptExportMode.PCODE || exportMode == ScriptExportMode.PCODE_HEX) {
            for (AVM2Instruction ins : this.code) {
                long addr = ins.getAddress();
                if (exportMode == ScriptExportMode.PCODE_HEX) {
                    writer.appendNoHilight("; ");
                    writer.appendNoHilight(Helper.bytesToHexString(ins.getBytes()));
                    writer.newLine();
                }
                if (Configuration.showAllAddresses.get().booleanValue() || importantOffsets.contains(addr)) {
                    String label = "ofs" + Helper.formatAddress(addr) + ":";
                    if (Configuration.labelOnSeparateLineAs3PCode.get().booleanValue() && Configuration.indentAs3PCode.get().booleanValue()) {
                        writer.unindent().unindent().unindent();
                    }
                    writer.appendNoHilight(label);
                    if (Configuration.labelOnSeparateLineAs3PCode.get().booleanValue()) {
                        writer.newLine();
                        if (Configuration.indentAs3PCode.get().booleanValue()) {
                            writer.indent().indent().indent();
                        }
                    }
                }
                if (!ins.isIgnored()) {
                    if (markOffsets) {
                        writer.append("", addr, ins.getFileOffset());
                    }
                    writer.appendNoHilight(ins.toStringNoAddress(constants, new ArrayList<DottedChain>()));
                    writer.newLine();
                    outputMap.add(ip);
                }
                ++ip;
            }
        } else if (exportMode == ScriptExportMode.CONSTANTS) {
            writer.appendNoHilight("Constant export mode is not supported.").newLine();
        }
        if (Configuration.indentAs3PCode.get().booleanValue()) {
            writer.unindent();
        }
        writer.appendNoHilight("end ; code").newLine();
        if (body != null) {
            for (int e = 0; e < body.exceptions.length; ++e) {
                ABCException exception = body.exceptions[e];
                writer.appendNoHilight("try");
                writer.appendNoHilight(" from ");
                writer.appendNoHilight("ofs");
                writer.appendNoHilight(Helper.formatAddress(this.pos2adr(this.adr2pos(exception.start, true))));
                writer.appendNoHilight(" to ");
                writer.appendNoHilight("ofs");
                writer.appendNoHilight(Helper.formatAddress(this.pos2adr(this.adr2pos(exception.end, true))));
                writer.appendNoHilight(" target ");
                writer.appendNoHilight("ofs");
                writer.appendNoHilight(Helper.formatAddress(exception.target));
                writer.appendNoHilight(" type ");
                writer.hilightSpecial(exception.type_index == 0 ? "null" : constants.getMultiname(exception.type_index).toString(constants, new ArrayList<DottedChain>()), HighlightSpecialType.TRY_TYPE, e);
                writer.appendNoHilight(" name ");
                writer.hilightSpecial(exception.name_index == 0 ? "null" : constants.getMultiname(exception.name_index).toString(constants, new ArrayList<DottedChain>()), HighlightSpecialType.TRY_NAME, e);
                writer.appendNoHilight(" end");
                writer.newLine();
            }
            if (Configuration.indentAs3PCode.get().booleanValue()) {
                writer.unindent();
            }
            writer.appendNoHilight("end ; body").newLine();
        }
        if (info != null) {
            if (Configuration.indentAs3PCode.get().booleanValue()) {
                writer.unindent();
            }
            writer.appendNoHilight("end ; method").newLine();
        }
        return writer;
    }

    public Set<Long> getImportantOffsets(MethodBody body, boolean tryEnds) {
        HashSet<Long> ret = new HashSet<Long>();
        if (body != null) {
            for (ABCException exception : body.exceptions) {
                ret.add(this.pos2adr(this.adr2pos(exception.start, true)));
                if (tryEnds) {
                    ret.add(this.pos2adr(this.adr2pos(exception.end, true)));
                }
                ret.add(Long.valueOf(exception.target));
            }
        }
        for (AVM2Instruction ins : this.code) {
            ret.addAll(ins.getOffsets());
        }
        return ret;
    }

    public AVM2Instruction adr2ins(long address) throws ConvertException {
        int pos = this.adr2pos(address, false);
        if (pos == this.code.size()) {
            return null;
        }
        return this.code.get(pos);
    }

    public int adr2pos(long address) throws ConvertException {
        return this.adr2pos(address, false);
    }

    public int adr2pos(long address, boolean nearest) throws ConvertException {
        int ret = this.adr2posNoEx(address);
        if (ret < 0) {
            if (nearest && address < this.getEndOffset()) {
                return -ret - 1;
            }
            throw new ConvertException("Invalid jump to ofs" + Helper.formatAddress(address), -1);
        }
        return ret;
    }

    private int adr2posNoEx(long address) {
        int min = 0;
        int max = this.code.size() - 1;
        while (max >= min) {
            int mid = (min + max) / 2;
            long midValue = this.code.get(mid).getAddress();
            if (midValue == address) {
                return mid;
            }
            if (midValue < address) {
                min = mid + 1;
                continue;
            }
            max = mid - 1;
        }
        if (address == this.getEndOffset()) {
            return this.code.size();
        }
        return -min - 1;
    }

    public long pos2adr(int pos) {
        if (pos == this.code.size()) {
            return this.getEndOffset();
        }
        return (int)this.code.get(pos).getAddress();
    }

    public long getEndOffset() {
        if (this.code.isEmpty()) {
            return 0L;
        }
        AVM2Instruction ins = this.code.get(this.code.size() - 1);
        return (int)(ins.getAddress() + (long)ins.getBytesLength());
    }

    public Map<Integer, String> getLocalRegNamesFromDebug(ABC abc) {
        HashMap<Integer, String> regIndexToName = new HashMap<Integer, String>();
        HashMap<String, Integer> regNameToIndex = new HashMap<String, Integer>();
        for (AVM2Instruction ins : this.code) {
            int existingIndex;
            if (!(ins.definition instanceof DebugIns) || ins.operands[0] != 1) continue;
            String v = abc.constants.getString(ins.operands[1]);
            int regIndex = ins.operands[2] + 1;
            if (regNameToIndex.containsKey(v) && (existingIndex = ((Integer)regNameToIndex.get(v)).intValue()) != regIndex) {
                return new HashMap<Integer, String>();
            }
            regNameToIndex.put(v, regIndex);
            regIndexToName.put(regIndex, v);
        }
        return regIndexToName;
    }

    public int getIpThroughJumpAndDebugLine(int ip) {
        if (this.code.isEmpty()) {
            return ip;
        }
        if (ip >= this.code.size()) {
            return this.code.size() - 1;
        }
        while (ip < this.code.size()) {
            if (this.code.get((int)ip).definition instanceof DebugLineIns) {
                ++ip;
                continue;
            }
            if (!(this.code.get((int)ip).definition instanceof JumpIns)) break;
            ip = this.adr2pos(this.pos2adr(ip + 1) + (long)this.code.get((int)ip).operands[0]);
        }
        if (ip >= this.code.size()) {
            return this.code.size() - 1;
        }
        return ip;
    }

    public long getAddrThroughJumpAndDebugLine(long addr) throws ConvertException {
        return this.pos2adr(this.getIpThroughJumpAndDebugLine(this.adr2pos(addr, true)));
    }

    public ConvertOutput toSourceOutput(Set<GraphPart> switchParts, List<MethodBody> callStack, AbcIndexing abcIndex, Map<Integer, Set<Integer>> setLocalPosToGetLocalPos, boolean thisHasDefaultToPrimitive, Reference<GraphSourceItem> lineStartItem, String path, GraphPart part, boolean processJumps, boolean isStatic, int scriptIndex, int classIndex, HashMap<Integer, GraphTargetItem> localRegs, TranslateStack stack, ScopeStack scopeStack, ScopeStack localScopeStack, ABC abc, MethodBody body, int start, int end, HashMap<Integer, String> localRegNames, HashMap<Integer, GraphTargetItem> localRegTypes, List<DottedChain> fullyQualifiedNames, boolean[] visited, HashMap<Integer, Integer> localRegAssigmentIps) throws ConvertException, InterruptedException {
        boolean debugMode = false;
        if (debugMode) {
            System.err.println("OPEN SubSource:" + start + "-" + end + " " + this.code.get(start).toString() + " to " + this.code.get(end).toString());
        }
        if (visited == null) {
            visited = new boolean[this.code.size()];
        }
        ++this.toSourceCount;
        if (toSourceLimit > 0 && this.toSourceCount >= toSourceLimit) {
            throw new ConvertException("Limit of subs(" + toSourceLimit + ") was reached", start);
        }
        ArrayList<GraphTargetItem> output = new ArrayList<GraphTargetItem>();
        int ip = start;
        block2: while (ip <= end) {
            boolean processTry = processJumps;
            if (ip > end || visited[ip]) break;
            if (Configuration.simplifyExpressions.get().booleanValue()) {
                stack.simplify();
            }
            visited[ip] = true;
            AVM2Instruction ins = this.code.get(ip);
            if (stack.isEmpty()) {
                lineStartItem.setVal(ins);
            }
            if (debugMode) {
                System.err.println("translating ip " + ip + " ins " + ins.toString() + " stack:" + stack.toString() + " localScopeStack:" + localScopeStack.toString());
            }
            if (ins.definition instanceof NewFunctionIns && ip + 1 <= end && this.code.get((int)(ip + 1)).definition instanceof PopIns) {
                ip += 2;
                continue;
            }
            if (ins.definition instanceof DupIns) {
                do {
                    boolean isAnd;
                    AVM2Instruction insAfter;
                    AVM2Instruction aVM2Instruction = insAfter = ip + 1 < this.code.size() ? this.code.get(ip + 1) : null;
                    if (insAfter == null) {
                        ins.definition.translate(switchParts, callStack, abcIndex, setLocalPosToGetLocalPos, lineStartItem, isStatic, scriptIndex, classIndex, localRegs, stack, scopeStack, localScopeStack, ins, output, body, abc, localRegNames, localRegTypes, fullyQualifiedNames, path, localRegAssigmentIps, ip, this, thisHasDefaultToPrimitive);
                        ++ip;
                        continue block2;
                    }
                    AVM2Instruction insBefore = ins;
                    if (ip - 1 >= start) {
                        insBefore = this.code.get(ip - 1);
                    }
                    if (insAfter.definition instanceof ConvertBIns) {
                        insAfter = this.code.get(++ip + 1);
                    }
                    if (processJumps && insAfter.definition instanceof IfFalseIns) {
                        isAnd = true;
                        continue;
                    }
                    if (processJumps && insAfter.definition instanceof IfTrueIns) {
                        isAnd = false;
                        continue;
                    }
                    ins.definition.translate(switchParts, callStack, abcIndex, setLocalPosToGetLocalPos, lineStartItem, isStatic, scriptIndex, classIndex, localRegs, stack, scopeStack, localScopeStack, ins, output, body, abc, localRegNames, localRegTypes, fullyQualifiedNames, path, localRegAssigmentIps, ip, this, thisHasDefaultToPrimitive);
                    ++ip;
                    continue block2;
                } while (ins.definition instanceof DupIns);
                continue;
            }
            if (ins.definition instanceof ReturnValueIns || ins.definition instanceof ReturnVoidIns || ins.definition instanceof ThrowIns) {
                ins.definition.translate(switchParts, callStack, abcIndex, setLocalPosToGetLocalPos, lineStartItem, isStatic, scriptIndex, classIndex, localRegs, stack, scopeStack, localScopeStack, ins, output, body, abc, localRegNames, localRegTypes, fullyQualifiedNames, path, localRegAssigmentIps, ip, this, thisHasDefaultToPrimitive);
                break;
            }
            if (ins.definition instanceof NewFunctionIns) {
                String functionName = "";
                if (ip >= start + 2 && ip <= end - 4) {
                    AVM2Instruction prev2 = this.code.get(ip - 2);
                    if (prev2.definition instanceof NewObjectIns && prev2.operands[0] == 0 && this.code.get((int)(ip - 1)).definition instanceof PushWithIns) {
                        boolean hasDup = false;
                        int plus = 0;
                        if (this.code.get((int)(ip + 1)).definition instanceof DupIns) {
                            hasDup = true;
                            plus = 1;
                        }
                        AVM2Instruction psco = this.code.get(ip + 1 + plus);
                        if (psco.definition instanceof GetScopeObjectIns && psco.operands[0] == localScopeStack.size() - 1 && this.code.get((int)(ip + plus + 2)).definition instanceof SwapIns && this.code.get((int)(ip + plus + 4)).definition instanceof PopScopeIns && this.code.get((int)(ip + plus + 3)).definition instanceof SetPropertyIns) {
                            functionName = abc.constants.getMultiname(this.code.get((int)(ip + plus + 3)).operands[0]).getName(abc.constants, fullyQualifiedNames, true, true);
                            localScopeStack.pop();
                            output.remove(output.size() - 1);
                            ip = ip + plus + 4;
                        }
                    }
                }
                ins.definition.translate(switchParts, callStack, abcIndex, setLocalPosToGetLocalPos, lineStartItem, isStatic, scriptIndex, classIndex, localRegs, stack, scopeStack, localScopeStack, ins, output, body, abc, localRegNames, localRegTypes, fullyQualifiedNames, path, localRegAssigmentIps, ip, this, thisHasDefaultToPrimitive);
                NewFunctionAVM2Item nft = (NewFunctionAVM2Item)stack.peek();
                nft.functionName = functionName;
                ++ip;
                continue;
            }
            ins.definition.translate(switchParts, callStack, abcIndex, setLocalPosToGetLocalPos, lineStartItem, isStatic, scriptIndex, classIndex, localRegs, stack, scopeStack, localScopeStack, ins, output, body, abc, localRegNames, localRegTypes, fullyQualifiedNames, path, localRegAssigmentIps, ip, this, thisHasDefaultToPrimitive);
            ++ip;
        }
        if (debugMode) {
            System.err.println("CLOSE SubSource:" + start + "-" + end + " " + this.code.get(start).toString() + " to " + this.code.get(end).toString());
        }
        return new ConvertOutput(stack, output);
    }

    public int getRegisterCount() {
        int maxRegister = -1;
        for (AVM2Instruction ins : this.code) {
            int regId = -1;
            if (ins.definition instanceof SetLocalTypeIns) {
                regId = ((SetLocalTypeIns)ins.definition).getRegisterId(ins);
            }
            if (ins.definition instanceof GetLocalTypeIns) {
                regId = ((GetLocalTypeIns)ins.definition).getRegisterId(ins);
            }
            if (regId <= maxRegister) continue;
            maxRegister = regId;
        }
        return maxRegister + 1;
    }

    public HashMap<Integer, GraphTargetItem> getLocalRegTypes(AVM2ConstantPool constants, List<DottedChain> fullyQualifiedNames) {
        HashMap<Integer, GraphTargetItem> ret = new HashMap<Integer, GraphTargetItem>();
        AVM2Instruction prev = null;
        for (AVM2Instruction ins : this.code) {
            if (ins.definition instanceof SetLocalTypeIns && prev != null && prev.definition instanceof CoerceOrConvertTypeIns) {
                ret.put(((SetLocalTypeIns)ins.definition).getRegisterId(ins), ((CoerceOrConvertTypeIns)((Object)prev.definition)).getTargetType(constants, prev));
            }
            prev = ins;
        }
        return ret;
    }

    public void initToSource() {
        this.toSourceCount = 0;
    }

    private GraphTargetItem handleDeclareReg(int minreg, GraphTargetItem assignment, DeclarationAVM2Item[] declaredRegisters, List<Slot> declaredSlots, int reg) {
        if (reg < minreg) {
            return assignment;
        }
        GraphTargetItem vtype = TypeItem.UNBOUNDED;
        if (assignment.value instanceof ConvertAVM2Item) {
            vtype = ((ConvertAVM2Item)assignment.value).type;
        } else if (assignment.value instanceof CoerceAVM2Item) {
            vtype = ((CoerceAVM2Item)assignment.value).typeObj;
        } else if (assignment instanceof LocalRegAVM2Item) {
            vtype = ((LocalRegAVM2Item)assignment).type;
        } else if (assignment instanceof GetSlotAVM2Item) {
            vtype = ((GetSlotAVM2Item)assignment).slotType;
        } else if (assignment.value instanceof SimpleValue && ((SimpleValue)((Object)assignment.value)).isSimpleValue()) {
            vtype = assignment.value.returnType();
        }
        boolean isNull = false;
        if (vtype.equals(new TypeItem(DottedChain.NULL))) {
            vtype = TypeItem.UNBOUNDED;
            isNull = true;
        }
        if (declaredRegisters[reg] == null) {
            declaredRegisters[reg] = new DeclarationAVM2Item(assignment, vtype);
            if (assignment instanceof SetTypeAVM2Item) {
                ((SetTypeAVM2Item)((Object)assignment)).setDeclaration(declaredRegisters[reg]);
            }
            declaredRegisters[reg].typeIsNull = isNull;
            return declaredRegisters[reg];
        }
        if (declaredRegisters[reg].typeIsNull) {
            declaredRegisters[reg].type = vtype;
            declaredRegisters[reg].typeIsNull = isNull;
        } else if (declaredRegisters[reg].type != TypeItem.UNBOUNDED && !declaredRegisters[reg].type.equals(vtype)) {
            declaredRegisters[reg].type = TypeItem.UNBOUNDED;
        }
        if (assignment instanceof SetTypeAVM2Item) {
            ((SetTypeAVM2Item)((Object)assignment)).setDeclaration(declaredRegisters[reg]);
        }
        return assignment;
    }

    private int slotListIndexOf(List<Slot> list, String propertyName, ABC abc) {
        int index = 0;
        for (Slot s : list) {
            if (propertyName.equals(abc.constants.getString(s.multiname.name_index))) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private void injectDeclarations(int level, final List<String> paramNames, List<GraphTargetItem> items, int minreg, DeclarationAVM2Item[] declaredRegisters, List<Slot> declaredSlots, List<DeclarationAVM2Item> declaredSlotsDec, List<String> declaredProperties, List<DeclarationAVM2Item> declaredPropsDec, final ABC abc, MethodBody body) {
        FullMultinameAVM2Item propName;
        SetPropertyAVM2Item sp;
        final LinkedHashMap<String, TraitSlotConst> traits = new LinkedHashMap<String, TraitSlotConst>();
        for (Trait t : body.traits.traits) {
            if (!(t instanceof TraitSlotConst)) continue;
            TraitSlotConst tsc = (TraitSlotConst)t;
            Multiname tratMultiname = abc.constants.getMultiname(tsc.name_index);
            String bodyTraitName = tratMultiname.getName(abc.constants, new ArrayList<DottedChain>(), true, true);
            traits.put(bodyTraitName, tsc);
        }
        if (level == 0) {
            final LinkedHashSet<String> beginDeclaredSlotsNames = new LinkedHashSet<String>();
            for (int i = 0; i < items.size(); ++i) {
                GraphTargetItem item = items.get(i);
                String propNameStr = null;
                GraphTargetItem value = null;
                if (item instanceof SetSlotAVM2Item) {
                    SetSlotAVM2Item ss = (SetSlotAVM2Item)item;
                    if (ss.slotName == null) break;
                    propNameStr = ss.slotName.getName(abc.constants, new ArrayList<DottedChain>(), true, true);
                    value = ss.value;
                } else {
                    if (!(item instanceof SetPropertyAVM2Item)) break;
                    sp = (SetPropertyAVM2Item)item;
                    if (!(sp.object instanceof FindPropertyAVM2Item) || !(sp.propertyName instanceof FullMultinameAVM2Item)) break;
                    propName = (FullMultinameAVM2Item)sp.propertyName;
                    propNameStr = propName.resolvedMultinameName;
                    value = sp.value;
                }
                value = value.getNotCoerced();
                final Reference<Boolean> hasPrevReference = new Reference<Boolean>(false);
                value.visitRecursivelyNoBlock(new AbstractGraphTargetVisitor(){

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Override
                    public void visit(GraphTargetItem subItem) {
                        Multiname propertyMultiName;
                        if (subItem instanceof GetPropertyAVM2Item) {
                            GetPropertyAVM2Item propItem = (GetPropertyAVM2Item)subItem;
                            if (!(propItem.object instanceof FindPropertyAVM2Item)) return;
                            propertyMultiName = abc.constants.getMultiname(((FullMultinameAVM2Item)propItem.propertyName).multinameIndex);
                        } else {
                            if (!(subItem instanceof GetLexAVM2Item)) return;
                            GetLexAVM2Item lex = (GetLexAVM2Item)subItem;
                            propertyMultiName = lex.propertyName;
                        }
                        String propertyName = propertyMultiName.getName(abc.constants, new ArrayList<DottedChain>(), true, true);
                        if (!traits.containsKey(propertyName)) return;
                        Slot sl = new Slot(new NewActivationAVM2Item(null, null), propertyMultiName);
                        if (paramNames.contains(propertyName) || !traits.containsKey(propertyName) || beginDeclaredSlotsNames.contains(propertyName)) return;
                        hasPrevReference.setVal(true);
                    }
                });
                if (hasPrevReference.getVal().booleanValue()) break;
                beginDeclaredSlotsNames.add(propNameStr);
            }
            int pos = 0;
            for (String traitName : traits.keySet()) {
                if (paramNames.contains(traitName) || beginDeclaredSlotsNames.contains(traitName)) continue;
                Slot sl = new Slot(new NewActivationAVM2Item(null, null), abc.constants.getMultiname(((TraitSlotConst)traits.get((Object)traitName)).name_index));
                TraitSlotConst tsc = (TraitSlotConst)traits.get(traitName);
                GraphTargetItem type = AbcIndexing.multinameToType(tsc.type_index, abc.constants);
                DeclarationAVM2Item d = new DeclarationAVM2Item(new GetLexAVM2Item(null, null, sl.multiname, abc.constants, type, TypeItem.UNBOUNDED, false), type);
                declaredSlotsDec.add(d);
                declaredSlots.add(sl);
                d.showValue = false;
                items.add(pos, d);
                ++pos;
                declaredPropsDec.add(d);
                declaredProperties.add(traitName);
            }
        }
        for (int i = 0; i < items.size(); ++i) {
            GraphTargetItem currentItem = items.get(i);
            final ArrayList<GraphTargetItem> itemsOnLine = new ArrayList<GraphTargetItem>();
            itemsOnLine.add(currentItem);
            currentItem.visitRecursivelyNoBlock(new AbstractGraphTargetVisitor(){

                @Override
                public void visit(GraphTargetItem item) {
                    itemsOnLine.add(item);
                }
            });
            if (currentItem instanceof ForEachInAVM2Item) {
                int reg;
                ForEachInAVM2Item fei = (ForEachInAVM2Item)currentItem;
                if (fei.expression.object instanceof LocalRegAVM2Item && declaredRegisters[reg = ((LocalRegAVM2Item)fei.expression.object).regIndex] == null) {
                    fei.expression.object = this.handleDeclareReg(minreg, fei.expression.object, declaredRegisters, declaredSlots, reg);
                }
            }
            if (currentItem instanceof ForInAVM2Item) {
                ForInAVM2Item fi = (ForInAVM2Item)currentItem;
                if (fi.expression.object instanceof LocalRegAVM2Item) {
                    int reg = ((LocalRegAVM2Item)fi.expression.object).regIndex;
                    fi.expression.object = this.handleDeclareReg(minreg, fi.expression.object, declaredRegisters, declaredSlots, reg);
                }
            }
            for (GraphTargetItem subItem : itemsOnLine) {
                if (subItem instanceof SetLocalAVM2Item) {
                    SetLocalAVM2Item setLocal = (SetLocalAVM2Item)subItem;
                    int reg = setLocal.regIndex;
                    GraphTargetItem dec = this.handleDeclareReg(minreg, subItem, declaredRegisters, declaredSlots, reg);
                    if (dec != subItem) {
                        if (subItem == currentItem) {
                            items.set(i, dec);
                        } else {
                            ((DeclarationAVM2Item)dec).showValue = false;
                            items.add(i, dec);
                            ++i;
                        }
                    }
                }
                if (subItem instanceof SetPropertyAVM2Item) {
                    sp = (SetPropertyAVM2Item)subItem;
                    if (sp.object instanceof FindPropertyAVM2Item && sp.propertyName instanceof FullMultinameAVM2Item) {
                        propName = (FullMultinameAVM2Item)sp.propertyName;
                        if (!paramNames.contains(propName.resolvedMultinameName)) {
                            if (!declaredProperties.contains(propName.resolvedMultinameName)) {
                                if (traits.containsKey(propName.resolvedMultinameName)) {
                                    TraitSlotConst tsc = (TraitSlotConst)traits.get(propName.resolvedMultinameName);
                                    GraphTargetItem type = AbcIndexing.multinameToType(tsc.type_index, abc.constants);
                                    DeclarationAVM2Item d = new DeclarationAVM2Item(subItem, type);
                                    sp.setDeclaration(d);
                                    declaredPropsDec.add(d);
                                    declaredProperties.add(propName.resolvedMultinameName);
                                    Slot sl = new Slot(new NewActivationAVM2Item(null, null), abc.constants.getMultiname(tsc.name_index));
                                    declaredSlotsDec.add(d);
                                    declaredSlots.add(sl);
                                    if (subItem == currentItem) {
                                        items.set(i, d);
                                    } else {
                                        d.showValue = false;
                                        items.add(i, d);
                                        ++i;
                                    }
                                }
                            } else {
                                int idx = declaredProperties.indexOf(propName.resolvedMultinameName);
                                sp.setDeclaration(declaredPropsDec.get(idx));
                            }
                        }
                    }
                }
                if (!(subItem instanceof SetSlotAVM2Item)) continue;
                SetSlotAVM2Item ssti = (SetSlotAVM2Item)subItem;
                if (!(ssti.scope instanceof NewActivationAVM2Item)) continue;
                Slot sl = new Slot(ssti.scope, ssti.slotName);
                String slotPropertyName = sl.multiname.getName(abc.constants, new ArrayList<DottedChain>(), true, false);
                if (paramNames.contains(slotPropertyName)) continue;
                int index = this.slotListIndexOf(declaredSlots, slotPropertyName, abc);
                if (index == -1) {
                    GraphTargetItem type = TypeItem.UNBOUNDED;
                    if (traits.containsKey(slotPropertyName)) {
                        type = AbcIndexing.multinameToType(((TraitSlotConst)traits.get((Object)slotPropertyName)).type_index, abc.constants);
                    }
                    DeclarationAVM2Item d = new DeclarationAVM2Item(subItem, type);
                    ssti.setDeclaration(d);
                    declaredSlotsDec.add(d);
                    declaredSlots.add(sl);
                    declaredPropsDec.add(d);
                    declaredProperties.add(slotPropertyName);
                    if (subItem == currentItem) {
                        items.set(i, d);
                        continue;
                    }
                    d.showValue = false;
                    items.add(i, d);
                    ++i;
                    continue;
                }
                ssti.setDeclaration(declaredSlotsDec.get(index));
            }
            if (!(currentItem instanceof Block)) continue;
            Block blk = (Block)((Object)currentItem);
            for (List<GraphTargetItem> sub : blk.getSubs()) {
                this.injectDeclarations(level + 1, paramNames, sub, minreg, declaredRegisters, declaredSlots, declaredSlotsDec, declaredProperties, declaredPropsDec, abc, body);
            }
        }
    }

    public List<GraphTargetItem> toGraphTargetItems(List<MethodBody> callStack, AbcIndexing abcIndex, boolean thisHasDefaultToPrimitive, ConvertData convertData, String path, int methodIndex, boolean isStatic, int scriptIndex, int classIndex, ABC abc, MethodBody body, HashMap<Integer, String> localRegNames, ScopeStack scopeStack, int initializerType, List<DottedChain> fullyQualifiedNames, List<Traits> initTraits, int staticOperation, HashMap<Integer, Integer> localRegAssigmentIps) throws InterruptedException {
        List<GraphTargetItem> list;
        this.initToSource();
        HashMap<Integer, GraphTargetItem> localRegs = new HashMap<Integer, GraphTargetItem>();
        int regCount = this.getRegisterCount();
        for (int i = 0; i < regCount; ++i) {
            localRegs.put(0, new UndefinedAVM2Item(null, null));
        }
        HashMap<Integer, GraphTargetItem> localRegTypes = new HashMap<Integer, GraphTargetItem>();
        for (int i = 0; i < abc.method_info.get((int)methodIndex).param_types.length; ++i) {
            localRegTypes.put(i + 1, AbcIndexing.multinameToType(abc.method_info.get((int)methodIndex).param_types[i], abc.constants));
        }
        try {
            list = AVM2Graph.translateViaGraph(null, callStack, abcIndex, path, this, abc, body, isStatic, scriptIndex, classIndex, localRegs, scopeStack, localRegNames, localRegTypes, fullyQualifiedNames, staticOperation, localRegAssigmentIps, thisHasDefaultToPrimitive);
        }
        catch (SecondPassException spe) {
            list = AVM2Graph.translateViaGraph(spe.getData(), callStack, abcIndex, path, this, abc, body, isStatic, scriptIndex, classIndex, localRegs, scopeStack, localRegNames, localRegTypes, fullyQualifiedNames, staticOperation, localRegAssigmentIps, thisHasDefaultToPrimitive);
        }
        if (initTraits != null) {
            for (int i = 0; i < list.size(); ++i) {
                GraphTargetItem ti = list.get(i);
                if (!(ti instanceof InitPropertyAVM2Item) && !(ti instanceof SetPropertyAVM2Item)) continue;
                int multinameIndex = 0;
                GraphTargetItem value = null;
                if (ti instanceof InitPropertyAVM2Item) {
                    multinameIndex = ((InitPropertyAVM2Item)ti).propertyName.multinameIndex;
                    value = ((InitPropertyAVM2Item)ti).value;
                }
                if (ti instanceof SetPropertyAVM2Item) {
                    multinameIndex = ((FullMultinameAVM2Item)((SetPropertyAVM2Item)ti).propertyName).multinameIndex;
                    value = ((SetPropertyAVM2Item)ti).value;
                }
                Multiname m = abc.constants.getMultiname(multinameIndex);
                block5: for (Traits ts : initTraits) {
                    for (int j = 0; j < ts.traits.size(); ++j) {
                        Trait t = ts.traits.get(j);
                        Multiname tm = abc.constants.getMultiname(t.name_index);
                        if (tm == null || !tm.equals(m) || !(t instanceof TraitSlotConst)) continue;
                        if (!((TraitSlotConst)t).isConst() && initializerType != -2 && initializerType != -3) continue block5;
                        TraitSlotConst tsc = (TraitSlotConst)t;
                        if (value == null || convertData.assignedValues.containsKey(tsc)) continue block5;
                        if (value instanceof NewFunctionAVM2Item) {
                            NewFunctionAVM2Item f = (NewFunctionAVM2Item)value;
                            f.functionName = tsc.getName(abc).getName(abc.constants, fullyQualifiedNames, true, true);
                        }
                        AssignedValue av = new AssignedValue(value, initializerType, methodIndex);
                        convertData.assignedValues.put(tsc, av);
                        list.remove(i);
                        --i;
                    }
                }
            }
        }
        if (initializerType == -2 || initializerType == -3) {
            ArrayList<GraphTargetItem> newList = new ArrayList<GraphTargetItem>();
            for (GraphTargetItem ti : list) {
                if (ti instanceof ReturnVoidAVM2Item || ti instanceof InitPropertyAVM2Item) continue;
                newList.add(ti);
            }
            list = newList;
            if (list.isEmpty()) {
                return list;
            }
        }
        DeclarationAVM2Item[] d = new DeclarationAVM2Item[regCount];
        int[] param_types = abc.method_info.get((int)body.method_info).param_types;
        int r = 1;
        for (int i = 0; i < param_types.length; ++i) {
            GraphTargetItem type = param_types[i] == 0 ? TypeItem.UNBOUNDED : new TypeItem(abc.constants.getMultiname(param_types[i]).getNameWithNamespace(abc.constants, true));
            if (d.length > r) {
                d[r] = new DeclarationAVM2Item(new SetLocalAVM2Item(null, null, r, new NullAVM2Item(null, null), type), type);
            }
            ++r;
        }
        if (abc.method_info.get(body.method_info).flagNeed_arguments()) {
            if (d.length > r) {
                d[r] = new DeclarationAVM2Item(new SetLocalAVM2Item(null, null, r, new NullAVM2Item(null, null), TypeItem.ARRAY), TypeItem.ARRAY);
            }
            ++r;
        }
        if (abc.method_info.get(body.method_info).flagNeed_rest()) {
            if (d.length > r) {
                d[r] = new DeclarationAVM2Item(new SetLocalAVM2Item(null, null, r, new NullAVM2Item(null, null), TypeItem.ARRAY), TypeItem.ARRAY);
            }
            ++r;
        }
        HashMap<Integer, String> registerNames = body.getLocalRegNames(abc);
        ArrayList<String> paramNamesList = new ArrayList<String>();
        for (int ir = 0; ir < r; ++ir) {
            paramNamesList.add(AVM2Item.localRegName(localRegNames, ir));
        }
        this.injectDeclarations(0, paramNamesList, list, 1, d, new ArrayList<Slot>(), new ArrayList<DeclarationAVM2Item>(), new ArrayList<String>(), new ArrayList<DeclarationAVM2Item>(), abc, body);
        int lastPos = list.size() - 1;
        if (lastPos < 0) {
            lastPos = 0;
        }
        if (list.size() > lastPos && list.get(lastPos) instanceof ScriptEndItem) {
            --lastPos;
        }
        if (lastPos < 0) {
            lastPos = 0;
        }
        if (list.size() > lastPos && list.get(lastPos) instanceof ReturnVoidAVM2Item) {
            list.remove(lastPos);
        }
        return list;
    }

    public void updateInstructionByteCountByAddr(final long instructionAddress, final int byteDelta, MethodBody body) {
        if (byteDelta != 0) {
            this.updateOffsets(new OffsetUpdater(){

                @Override
                public long updateInstructionOffset(long address) {
                    if (address > instructionAddress) {
                        return address + (long)byteDelta;
                    }
                    return address;
                }

                @Override
                public int updateOperandOffset(long insAddr, long targetAddress, int offset) {
                    if (targetAddress > instructionAddress && insAddr <= instructionAddress) {
                        return offset + byteDelta;
                    }
                    if (targetAddress <= instructionAddress && insAddr > instructionAddress) {
                        return offset - byteDelta;
                    }
                    return offset;
                }
            }, body);
            body.setModified();
        }
    }

    public void updateInstructionByteCount(int pos, int byteDelta, MethodBody body) {
        AVM2Instruction instruction = this.code.get(pos);
        this.updateInstructionByteCountByAddr(instruction.getAddress(), byteDelta, body);
    }

    public void updateOffsets(OffsetUpdater updater, MethodBody body) {
        for (int i = 0; i < this.code.size(); ++i) {
            long target;
            AVM2Instruction ins = this.code.get(i);
            if (ins.definition instanceof LookupSwitchIns) {
                target = ins.getAddress() + (long)ins.operands[0];
                ins.operands[0] = updater.updateOperandOffset(ins.getAddress(), target, ins.operands[0]);
                for (int k = 2; k < ins.operands.length; ++k) {
                    target = ins.getAddress() + (long)ins.operands[k];
                    ins.operands[k] = updater.updateOperandOffset(ins.getAddress(), target, ins.operands[k]);
                }
            } else if (ins.definition instanceof IfTypeIns) {
                target = ins.getTargetAddress();
                try {
                    ins.operands[0] = updater.updateOperandOffset(ins.getAddress(), target, ins.operands[0]);
                }
                catch (ConvertException cex) {
                    throw new ConvertException("Invalid offset (" + ins + ")", i);
                }
            }
            ins.setAddress(updater.updateInstructionOffset(ins.getAddress()));
        }
        if (body != null) {
            for (ABCException ex : body.exceptions) {
                ex.start = updater.updateOperandOffset(-1L, ex.start, ex.start);
                ex.end = updater.updateOperandOffset(-1L, ex.end, ex.end);
                ex.target = updater.updateOperandOffset(-1L, ex.target, ex.target);
            }
        }
    }

    public void fixJumps(String path, MethodBody body) throws InterruptedException {
        if (this.code.isEmpty()) {
            return;
        }
        final ArrayList insAddrToRemove = new ArrayList();
        final long endOffset = this.getEndOffset();
        this.updateOffsets(new OffsetUpdater(){

            @Override
            public long updateInstructionOffset(long address) {
                return address;
            }

            @Override
            public int updateOperandOffset(long insAddr, long targetAddress, int offset) {
                if (targetAddress > endOffset || targetAddress < 0L || AVM2Code.this.adr2posNoEx(targetAddress) < 0) {
                    insAddrToRemove.add(insAddr);
                }
                return offset;
            }
        }, body);
        boolean someIgnored = false;
        for (Long insAddr : insAddrToRemove) {
            int pos = this.adr2posNoEx(insAddr);
            if (pos <= -1) continue;
            this.code.get(pos).setIgnored(true, 0);
            someIgnored = true;
        }
        if (someIgnored) {
            logger.log(Level.WARNING, "{0}: One or more invalid jump offsets found in the code. Those instructions were ignored.", path);
        }
        this.removeIgnored(body);
    }

    public void checkValidOffsets(MethodBody body) {
        this.updateOffsets(new OffsetUpdater(){

            @Override
            public long updateInstructionOffset(long address) {
                AVM2Code.this.adr2pos(address);
                return address;
            }

            @Override
            public int updateOperandOffset(long insAddr, long targetAddress, int offset) {
                AVM2Code.this.adr2pos(targetAddress);
                return offset;
            }
        }, body);
    }

    public void removeInstruction(int pos, MethodBody body) {
        int bc;
        if (pos < 0 || pos >= this.code.size()) {
            throw new IndexOutOfBoundsException();
        }
        AVM2Instruction ins = this.code.get(pos);
        final long remOffset = ins.getAddress();
        final int byteCount = bc = ins.getBytesLength();
        this.updateOffsets(new OffsetUpdater(){

            @Override
            public long updateInstructionOffset(long address) {
                if (address > remOffset) {
                    return address - (long)byteCount;
                }
                return address;
            }

            @Override
            public int updateOperandOffset(long jumpInsAddr, long jumpTargetAddr, int jumpOffset) {
                if (jumpTargetAddr > remOffset && jumpInsAddr < remOffset) {
                    return jumpOffset - byteCount;
                }
                if (jumpTargetAddr <= remOffset && jumpInsAddr > remOffset) {
                    return jumpOffset + byteCount;
                }
                return jumpOffset;
            }
        }, body);
        this.code.remove(pos);
    }

    public void insertInstruction(int pos, AVM2Instruction instruction, MethodBody body) {
        this.insertInstruction(pos, instruction, false, body);
    }

    public void replaceInstruction(int pos, final AVM2Instruction instruction, MethodBody body) {
        AVM2Instruction oldInstruction = this.code.get(pos);
        instruction.setAddress(oldInstruction.getAddress());
        int oldByteCount = oldInstruction.getBytesLength();
        int newByteCount = instruction.getBytesLength();
        final int byteDelta = newByteCount - oldByteCount;
        if (byteDelta != 0) {
            this.updateOffsets(new OffsetUpdater(){

                @Override
                public long updateInstructionOffset(long address) {
                    if (address > instruction.getAddress()) {
                        return address + (long)byteDelta;
                    }
                    return address;
                }

                @Override
                public int updateOperandOffset(long insAddr, long targetAddress, int offset) {
                    if (targetAddress > instruction.getAddress() && insAddr <= instruction.getAddress()) {
                        return offset + byteDelta;
                    }
                    if (targetAddress <= instruction.getAddress() && insAddr > instruction.getAddress()) {
                        return offset - byteDelta;
                    }
                    return offset;
                }
            }, body);
        }
        this.code.set(pos, instruction);
    }

    public void insertInstruction(int pos, AVM2Instruction instruction, final boolean mapOffsetsAfterIns, MethodBody body) {
        if (pos < 0) {
            pos = 0;
        }
        if (pos > this.code.size()) {
            pos = this.code.size();
        }
        final int byteCount = instruction.getBytesLength();
        if (this.code.size() == 0) {
            instruction.setAddress(0L);
        } else if (pos == this.code.size()) {
            instruction.setAddress(this.code.get(pos - 1).getAddress() + (long)this.code.get(pos - 1).getBytesLength());
        } else {
            instruction.setAddress(this.code.get(pos).getAddress());
        }
        final long x = instruction.getAddress();
        this.updateOffsets(new OffsetUpdater(){

            @Override
            public long updateInstructionOffset(long offset) {
                if (offset >= x) {
                    return offset + (long)byteCount;
                }
                return offset;
            }

            @Override
            public int updateOperandOffset(long j, long t, int offset_jt) {
                if ((t > x || mapOffsetsAfterIns && t == x) && j < x) {
                    return offset_jt + byteCount;
                }
                if ((t < x || mapOffsetsAfterIns && t == x) && j > x) {
                    return offset_jt - byteCount;
                }
                if (j == x && t < x) {
                    return offset_jt - byteCount;
                }
                return offset_jt;
            }
        }, body);
        instruction.setAddress(x);
        this.code.add(pos, instruction);
    }

    public int removeTraps(Trait trait, int methodInfo, MethodBody body, ABC abc, int scriptIndex, int classIndex, boolean isStatic, String path) throws InterruptedException {
        SWFDecompilerPlugin.fireAvm2CodeRemoveTraps(path, classIndex, isStatic, scriptIndex, abc, trait, methodInfo, body);
        try (Statistics s = new Statistics("AVM2DeobfuscatorGetSet");){
            new AVM2DeobfuscatorGetSet().avm2CodeRemoveTraps(path, classIndex, isStatic, scriptIndex, abc, trait, methodInfo, body);
        }
        s = new Statistics("AVM2DeobfuscatorSimple");
        var10_10 = null;
        try {
            new AVM2DeobfuscatorSimpleOld().avm2CodeRemoveTraps(path, classIndex, isStatic, scriptIndex, abc, trait, methodInfo, body);
        }
        catch (Throwable throwable) {
            var10_10 = throwable;
            throw throwable;
        }
        finally {
            if (s != null) {
                if (var10_10 != null) {
                    try {
                        s.close();
                    }
                    catch (Throwable throwable) {
                        var10_10.addSuppressed(throwable);
                    }
                } else {
                    s.close();
                }
            }
        }
        s = new Statistics("AVM2DeobfuscatorRegisters");
        var10_10 = null;
        try {
            new AVM2DeobfuscatorRegistersOld().avm2CodeRemoveTraps(path, classIndex, isStatic, scriptIndex, abc, trait, methodInfo, body);
        }
        catch (Throwable throwable) {
            var10_10 = throwable;
            throw throwable;
        }
        finally {
            if (s != null) {
                if (var10_10 != null) {
                    try {
                        s.close();
                    }
                    catch (Throwable throwable) {
                        var10_10.addSuppressed(throwable);
                    }
                } else {
                    s.close();
                }
            }
        }
        s = new Statistics("AVM2DeobfuscatorJumps");
        var10_10 = null;
        try {
            new AVM2DeobfuscatorJumps().avm2CodeRemoveTraps(path, classIndex, isStatic, scriptIndex, abc, trait, methodInfo, body);
        }
        catch (Throwable throwable) {
            var10_10 = throwable;
            throw throwable;
        }
        finally {
            if (s != null) {
                if (var10_10 != null) {
                    try {
                        s.close();
                    }
                    catch (Throwable throwable) {
                        var10_10.addSuppressed(throwable);
                    }
                } else {
                    s.close();
                }
            }
        }
        s = new Statistics("AVM2DeobfuscatorZeroJumpsNullPushes");
        var10_10 = null;
        try {
            new AVM2DeobfuscatorZeroJumpsNullPushes().avm2CodeRemoveTraps(path, classIndex, isStatic, scriptIndex, abc, trait, methodInfo, body);
        }
        catch (Throwable throwable) {
            var10_10 = throwable;
            throw throwable;
        }
        finally {
            if (s != null) {
                if (var10_10 != null) {
                    try {
                        s.close();
                    }
                    catch (Throwable throwable) {
                        var10_10.addSuppressed(throwable);
                    }
                } else {
                    s.close();
                }
            }
        }
        return 1;
    }

    private void handleRegister(CodeStats stats, int reg) {
        if (reg + 1 > stats.maxlocal) {
            stats.maxlocal = reg + 1;
        }
    }

    private boolean walkCode(CodeStats stats, int pos, int stack, int scope, ABC abc, boolean autoFill) {
        while (pos < this.code.size()) {
            int i;
            AVM2Instruction ins = this.code.get(pos);
            if (stats.instructionStats[pos].seen) {
                return true;
            }
            if (ins.definition instanceof NewFunctionIns) {
                MethodBody innerBody = abc.findBody(ins.operands[0]);
                if (autoFill) {
                    innerBody.autoFillStats(abc, stats.initscope + (stats.has_activation ? 1 : 0), false);
                }
            }
            stats.instructionStats[pos].seen = true;
            stats.instructionStats[pos].stackpos = stack;
            stats.instructionStats[pos].scopepos = scope;
            int stackDelta = ins.definition.getStackDelta(ins, abc);
            int scopeDelta = ins.definition.getScopeStackDelta(ins, abc);
            int oldStack = stack;
            stats.instructionStats[pos].stackpos_after = stack += stackDelta;
            stats.instructionStats[pos].scopepos_after = scope += scopeDelta;
            if (stack > stats.maxstack) {
                stats.maxstack = stack;
            }
            if (scope > stats.maxscope) {
                stats.maxscope = scope;
            }
            if (ins.definition instanceof DXNSIns || ins.definition instanceof DXNSLateIns) {
                stats.has_set_dxns = true;
            }
            if (ins.definition instanceof NewActivationIns) {
                stats.has_activation = true;
            }
            if (ins.definition instanceof SetLocalTypeIns) {
                this.handleRegister(stats, ((SetLocalTypeIns)ins.definition).getRegisterId(ins));
            } else if (ins.definition instanceof GetLocalTypeIns) {
                this.handleRegister(stats, ((GetLocalTypeIns)ins.definition).getRegisterId(ins));
            } else {
                for (i = 0; i < ins.definition.operands.length; ++i) {
                    int op = ins.definition.operands[i];
                    if (op != 264) continue;
                    this.handleRegister(stats, ins.operands[i]);
                }
            }
            if (ins.definition instanceof ReturnValueIns) {
                return true;
            }
            if (ins.definition instanceof ReturnVoidIns) {
                return true;
            }
            if (ins.definition instanceof ThrowIns) {
                return true;
            }
            if (ins.definition instanceof JumpIns) {
                try {
                    pos = this.adr2pos(ins.getTargetAddress());
                    continue;
                }
                catch (ConvertException ex) {
                    return false;
                }
            }
            if (ins.definition instanceof IfTypeIns) {
                try {
                    int newpos = this.adr2pos(ins.getTargetAddress());
                    this.walkCode(stats, newpos, stack, scope, abc, autoFill);
                }
                catch (ConvertException ex) {
                    return false;
                }
            }
            if (ins.definition instanceof LookupSwitchIns) {
                for (i = 0; i < ins.operands.length; ++i) {
                    if (i == 1) continue;
                    try {
                        int newpos = this.adr2pos(this.pos2adr(pos) + (long)ins.operands[i]);
                        if (this.walkCode(stats, newpos, stack, scope, abc, autoFill)) continue;
                        return false;
                    }
                    catch (ConvertException ex) {
                        return false;
                    }
                }
            }
            ++pos;
        }
        return true;
    }

    public CodeStats getStats(ABC abc, MethodBody body, int initScope, boolean autoFill) {
        CodeStats stats = new CodeStats(this);
        stats.initscope = initScope;
        if (!this.walkCode(stats, 0, 0, initScope, abc, autoFill)) {
            return null;
        }
        int scopePos = -1;
        for (int e = 0; e < body.exceptions.length; ++e) {
            ABCException ex = body.exceptions[e];
            try {
                if (scopePos == -1) {
                    scopePos = stats.instructionStats[this.adr2pos((long)((long)ex.end)) - 1].scopepos_after;
                }
                ArrayList<Integer> visited = new ArrayList<Integer>();
                for (int i = 0; i < stats.instructionStats.length; ++i) {
                    if (!stats.instructionStats[i].seen) continue;
                    visited.add(i);
                }
                if (!this.walkCode(stats, this.adr2pos(ex.target), 1, scopePos, abc, autoFill)) {
                    return null;
                }
                int maxIp = 0;
                for (int i = 0; i < stats.instructionStats.length; ++i) {
                    if (!stats.instructionStats[i].seen || visited.contains(i)) continue;
                    maxIp = i;
                }
                scopePos = stats.instructionStats[maxIp].scopepos_after;
                int nextIp = maxIp + 1;
                if (!(this.code.get((int)maxIp).definition instanceof JumpIns)) continue;
                nextIp = this.adr2pos(this.pos2adr(nextIp) + (long)this.code.get((int)maxIp).operands[0]);
                continue;
            }
            catch (ConvertException convertException) {
                // empty catch block
            }
        }
        return stats;
    }

    public CodeStats getMaxLocal() {
        CodeStats stats = new CodeStats();
        for (AVM2Instruction ins : this.code) {
            if (ins.definition instanceof SetLocalTypeIns) {
                this.handleRegister(stats, ((SetLocalTypeIns)ins.definition).getRegisterId(ins));
                continue;
            }
            if (ins.definition instanceof GetLocalTypeIns) {
                this.handleRegister(stats, ((GetLocalTypeIns)ins.definition).getRegisterId(ins));
                continue;
            }
            for (int i = 0; i < ins.definition.operands.length; ++i) {
                int op = ins.definition.operands[i];
                if (op != 264) continue;
                this.handleRegister(stats, ins.operands[i]);
            }
        }
        return stats;
    }

    private void visitCode(int ip, int lastIp, HashMap<Integer, List<Integer>> refs) throws InterruptedException {
        LinkedList<Integer> toVisit = new LinkedList<Integer>();
        LinkedList<Integer> toVisitLast = new LinkedList<Integer>();
        toVisit.add(ip);
        toVisitLast.add(lastIp);
        block6: while (!toVisit.isEmpty()) {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            ip = (Integer)toVisit.remove();
            lastIp = (Integer)toVisitLast.remove();
            while (ip < this.code.size()) {
                block14: {
                    if (!refs.containsKey(ip)) {
                        refs.put(ip, new ArrayList(2));
                    }
                    refs.get(ip).add(lastIp);
                    lastIp = ip;
                    if (refs.get(ip).size() > 1) continue block6;
                    AVM2Instruction ins = this.code.get(ip);
                    if (ins.definition instanceof ThrowIns || ins.definition instanceof ReturnValueIns || ins.definition instanceof ReturnVoidIns) continue block6;
                    if (ins.definition instanceof LookupSwitchIns) {
                        try {
                            for (int i = 2; i < ins.operands.length; ++i) {
                                toVisit.add(this.adr2pos(this.pos2adr(ip) + (long)ins.operands[i]));
                                toVisitLast.add(ip);
                            }
                            ip = this.adr2pos(this.pos2adr(ip) + (long)ins.operands[0]);
                            continue;
                        }
                        catch (ConvertException i) {
                            // empty catch block
                        }
                    }
                    if (ins.definition instanceof JumpIns) {
                        try {
                            ip = this.adr2pos(ins.getTargetAddress());
                            continue;
                        }
                        catch (ConvertException ex) {
                            logger.log(Level.FINE, null, ex);
                            break block14;
                        }
                    }
                    if (ins.definition instanceof IfTypeIns) {
                        try {
                            toVisit.add(this.adr2pos(ins.getTargetAddress()));
                            toVisitLast.add(ip);
                        }
                        catch (ConvertException ex) {
                            logger.log(Level.FINE, null, ex);
                        }
                    }
                }
                ++ip;
            }
        }
    }

    public HashMap<Integer, List<Integer>> visitCode(MethodBody body) throws InterruptedException {
        HashMap<Integer, List<Integer>> refs = new HashMap<Integer, List<Integer>>();
        for (int i = 0; i < this.code.size(); ++i) {
            refs.put(i, new ArrayList());
        }
        this.visitCode(0, 0, refs);
        for (ABCException e : body.exceptions) {
            try {
                this.visitCode(this.adr2pos(e.target), -1, refs);
            }
            catch (ConvertException ex) {
                logger.log(Level.SEVERE, "Visitcode error", ex);
            }
        }
        return refs;
    }

    public void removeIgnored(MethodBody body) throws InterruptedException {
        for (int i = 0; i < this.code.size(); ++i) {
            if (!this.code.get(i).isIgnored()) continue;
            this.removeInstruction(i, body);
            --i;
        }
    }

    public int removeDeadCode(MethodBody body) throws InterruptedException {
        return this.removeDeadCode(body, new Reference<Integer>(-1));
    }

    public int removeDeadCode(MethodBody body, Reference<Integer> minChangedIpRef) throws InterruptedException {
        int i;
        HashMap<Integer, List<Integer>> refs = this.visitCode(body);
        int cnt = 0;
        Integer minChangedIp = -1;
        for (i = this.code.size() - 1; i >= 0; --i) {
            if (!refs.get(i).isEmpty()) continue;
            minChangedIp = i;
            this.code.get(i).setIgnored(true, 0);
            ++cnt;
        }
        this.removeIgnored(body);
        for (i = this.code.size() - 1; i >= 0; --i) {
            AVM2Instruction ins = this.code.get(i);
            if (!(ins.definition instanceof JumpIns) || ins.operands[0] != 0) continue;
            ins.setIgnored(true, 0);
            if (minChangedIp == -1 || minChangedIp > i) {
                minChangedIp = i;
            }
            ++cnt;
        }
        this.removeIgnored(body);
        minChangedIpRef.setVal(minChangedIp);
        return cnt;
    }

    public boolean inlineJumpExit() {
        boolean modified = false;
        int csize = this.code.size();
        for (int i = 0; i < csize; ++i) {
            AVM2Instruction ins = this.code.get(i);
            int insLen = this.code.get(i).getBytesLength();
            long ofs = this.pos2adr(i);
            if (!(ins.definition instanceof JumpIns)) continue;
            long targetOfs = ofs + (long)insLen + (long)ins.operands[0];
            try {
                AVM2Instruction ins2;
                int ni = this.adr2pos(targetOfs);
                if (ni >= this.code.size() || ni <= -1 || !(ins2 = this.code.get(ni)).isExit()) continue;
                this.code.set(i, new AVM2Instruction(ofs, ins2.definition, ins2.operands));
                modified = true;
                continue;
            }
            catch (ConvertException convertException) {
                // empty catch block
            }
        }
        return modified;
    }

    private static int getMostCommonIp(AVM2GraphSource code, List<Integer> branches) {
        ArrayList reachable = new ArrayList();
        for (int i = 0; i < branches.size(); ++i) {
            ArrayList<Integer> r = new ArrayList<Integer>();
            AVM2Code.getReachableIps(code, branches.get(i), r);
        }
        HashMap<Integer, Integer> levelMap = new HashMap<Integer, Integer>();
        for (Object first : reachable) {
            int maxclevel = 0;
            HashSet<Integer> visited = new HashSet<Integer>();
            Iterator iterator = first.iterator();
            while (iterator.hasNext()) {
                Integer p = (Integer)iterator.next();
                if (visited.contains(p)) continue;
                visited.add(p);
                boolean common = true;
                int commonLevel = 1;
                for (List r : reachable) {
                    if (r == first || !r.contains(p)) continue;
                    ++commonLevel;
                }
                if (commonLevel <= maxclevel) continue;
                maxclevel = commonLevel;
                if (levelMap.containsKey(p) && (Integer)levelMap.get(p) > commonLevel) {
                    commonLevel = (Integer)levelMap.get(p);
                }
                levelMap.put(p, commonLevel);
                if (!common) continue;
            }
        }
        for (int i = reachable.size() - 1; i >= 2; --i) {
            for (Integer p : levelMap.keySet()) {
                if ((Integer)levelMap.get(p) != i) continue;
                return p;
            }
        }
        for (Integer p : levelMap.keySet()) {
            if (((Integer)levelMap.get(p)).intValue() != branches.size()) continue;
            return p;
        }
        return -1;
    }

    public static void getReachableIps(AVM2GraphSource code, int ip, List<Integer> reachable) {
        do {
            if (reachable.contains(ip)) {
                return;
            }
            reachable.add(ip);
            AVM2Instruction ins = code.get(ip);
            if (ins.isJump() || ins.isBranch()) {
                List<Integer> branches = ins.getBranches(code);
                for (int i = 1; i < branches.size(); ++i) {
                    AVM2Code.getReachableIps(code, branches.get(i), reachable);
                }
                ip = branches.get(0);
                continue;
            }
            ++ip;
        } while (ip < code.size());
    }

    public static boolean isDirectAncestor(int currentIp, int ancestor, HashMap<Integer, List<Integer>> refs) {
        return AVM2Code.isDirectAncestor(currentIp, ancestor, refs, new ArrayList<Integer>());
    }

    private static boolean isDirectAncestor(int currentIp, int ancestor, HashMap<Integer, List<Integer>> refs, List<Integer> visited) {
        if (currentIp == -1) {
            return true;
        }
        do {
            List<Integer> currentRefs;
            if (currentIp == ancestor) {
                return true;
            }
            if (currentIp == 0) {
                return false;
            }
            if (visited.contains(currentIp)) {
                return true;
            }
            visited.add(currentIp);
            if (refs.containsKey(currentIp) && (currentRefs = refs.get(currentIp)) != null && !currentRefs.isEmpty()) {
                for (int i = 1; i < currentRefs.size(); ++i) {
                    if (AVM2Code.isDirectAncestor(currentRefs.get(i), ancestor, refs, visited)) continue;
                    return false;
                }
                currentIp = currentRefs.get(0);
                continue;
            }
            --currentIp;
        } while (currentIp >= 0);
        return false;
    }

    public static boolean getPreviousReachableIps(int currentIp, HashMap<Integer, List<Integer>> refs, Set<Integer> reachable, Set<Integer> visited) {
        do {
            List<Integer> currentRefs;
            if (visited.contains(currentIp)) {
                return false;
            }
            reachable.add(currentIp);
            visited.add(currentIp);
            if (refs.containsKey(currentIp) && (currentRefs = refs.get(currentIp)) != null && !currentRefs.isEmpty()) {
                if (currentRefs.size() == 1) {
                    currentIp = currentRefs.get(0);
                    continue;
                }
                boolean r = false;
                for (int i = 0; i < currentRefs.size(); ++i) {
                    HashSet<Integer> nr = new HashSet<Integer>();
                    boolean v = AVM2Code.getPreviousReachableIps(currentRefs.get(i), refs, nr, visited);
                    if (!v || nr.contains(0)) {
                        reachable.addAll(nr);
                    }
                    r = r || v;
                }
                return r;
            }
            --currentIp;
        } while (currentIp >= 0);
        return true;
    }

    public AVM2Code clone() {
        try {
            AVM2Code ret = (AVM2Code)super.clone();
            if (this.code != null) {
                ArrayList<AVM2Instruction> codeCopy = new ArrayList<AVM2Instruction>(this.code.size());
                for (AVM2Instruction ins : this.code) {
                    codeCopy.add(ins.clone());
                }
                ret.code = codeCopy;
            }
            return ret;
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException();
        }
    }

    public void markVirtualAddresses() {
        for (AVM2Instruction ins : this.code) {
            ins.setVirtualAddress(ins.getAddress());
        }
    }

    static {
        int i;
        logger = Logger.getLogger(AVM2Code.class.getName());
        toSourceLimit = -1;
        DEBUG_REWRITE = false;
        operandDataTypeIdentifiers = ReflectionTools.getConstNamesMap(AVM2Code.class, Integer.class, "^DAT_(.*)$");
        instructionAliasesArray = new String[][]{{"getlocal0", "getlocal_0"}, {"getlocal1", "getlocal_1"}, {"getlocal2", "getlocal_2"}, {"getlocal3", "getlocal_3"}, {"setlocal0", "setlocal_0"}, {"setlocal1", "setlocal_1"}, {"setlocal2", "setlocal_2"}, {"setlocal3", "setlocal_3"}};
        instructionAliases = new HashMap<String, String>();
        for (String[] aliases : instructionAliasesArray) {
            for (int s = 1; s < aliases.length; ++s) {
                instructionAliases.put(aliases[s], aliases[0]);
            }
        }
        instructionSet = new InstructionDefinition[256];
        allInstructionSet = new InstructionDefinition[]{null, new BkptIns(), new NopIns(), new ThrowIns(), new GetSuperIns(), new SetSuperIns(), new DXNSIns(), new DXNSLateIns(), new KillIns(), new LabelIns(), new Lf32x4Ins(), new Sf32x4Ins(), new IfNLtIns(), new IfNLeIns(), new IfNGtIns(), new IfNGeIns(), new JumpIns(), new IfTrueIns(), new IfFalseIns(), new IfEqIns(), new IfNeIns(), new IfLtIns(), new IfLeIns(), new IfGtIns(), new IfGeIns(), new IfStrictEqIns(), new IfStrictNeIns(), new LookupSwitchIns(), new PushWithIns(), new PopScopeIns(), new NextNameIns(), new HasNextIns(), new PushNullIns(), new PushUndefinedIns(), new PushFloatIns(), new PushConstantIns(), new NextValueIns(), new PushByteIns(), new PushShortIns(), new PushTrueIns(), new PushFalseIns(), new PushNanIns(), new PopIns(), new DupIns(), new SwapIns(), new PushStringIns(), new PushIntIns(), new PushUIntIns(), new PushDoubleIns(), new PushScopeIns(), new PushNamespaceIns(), new HasNext2Ins(), new PushDecimalIns(), new PushDNanIns(), new Li8Ins(), new Li16Ins(), new Li32Ins(), new Lf32Ins(), new Lf64Ins(), new Si8Ins(), new Si16Ins(), new Si32Ins(), new Sf32Ins(), new Sf64Ins(), null, new NewFunctionIns(), new CallIns(), new ConstructIns(), new CallMethodIns(), new CallStaticIns(), new CallSuperIns(), new CallPropertyIns(), new ReturnVoidIns(), new ReturnValueIns(), new ConstructSuperIns(), new ConstructPropIns(), new CallSuperIdIns(), new CallPropLexIns(), new CallInterfaceIns(), new CallSuperVoidIns(), new CallPropVoidIns(), new Sxi1Ins(), new Sxi8Ins(), new Sxi16Ins(), new ApplyTypeIns(), new PushFloat4Ins(), new NewObjectIns(), new NewArrayIns(), new NewActivationIns(), new NewClassIns(), new GetDescendantsIns(), new NewCatchIns(), new DelDescendantsIns(), new FindPropertyStrictIns(), new FindPropertyIns(), new FindDefIns(), new GetLexIns(), new SetPropertyIns(), new GetLocalIns(), new SetLocalIns(), new GetGlobalScopeIns(), new GetScopeObjectIns(), new GetPropertyIns(), new GetOuterScopeIns(), new InitPropertyIns(), new SetPropertyLateIns(), new DeletePropertyIns(), new DeletePropertyLateIns(), new GetSlotIns(), new SetSlotIns(), new GetGlobalSlotIns(), new SetGlobalSlotIns(), new ConvertSIns(), new EscXElemIns(), new EscXAttrIns(), new ConvertIIns(), new ConvertUIns(), new ConvertDIns(), new ConvertBIns(), new ConvertOIns(), new CheckFilterIns(), new ConvertMIns(), new ConvertFIns(), new ConvertMPIns(), new UnPlusIns(), new ConvertF4Ins(), null, null, null, null, new CoerceIns(), new CoerceBIns(), new CoerceAIns(), new CoerceIIns(), new CoerceDIns(), new CoerceSIns(), new AsTypeIns(), new AsTypeLateIns(), new CoerceUIns(), new CoerceOIns(), null, null, null, null, null, new NegatePIns(), new NegateIns(), new IncrementIns(), new IncLocalIns(), new DecrementIns(), new DecLocalIns(), new TypeOfIns(), new NotIns(), new BitNotIns(), null, null, new ConcatIns(), new AddDIns(), new IncrementPIns(), new IncLocalPIns(), new DecrementPIns(), new DecLocalPIns(), new AddIns(), new SubtractIns(), new MultiplyIns(), new DivideIns(), new ModuloIns(), new LShiftIns(), new RShiftIns(), new URShiftIns(), new BitAndIns(), new BitOrIns(), new BitXorIns(), new EqualsIns(), new StrictEqualsIns(), new LessThanIns(), new LessEqualsIns(), new GreaterThanIns(), new GreaterEqualsIns(), new InstanceOfIns(), new IsTypeIns(), new IsTypeLateIns(), new InIns(), new AddPIns(), new SubtractPIns(), new MultiplyPIns(), new DividePIns(), new ModuloPIns(), null, null, null, null, null, null, new IncrementIIns(), new DecrementIIns(), new IncLocalIIns(), new DecLocalIIns(), new NegateIIns(), new AddIIns(), new SubtractIIns(), new MultiplyIIns(), null, null, null, null, null, null, null, null, new GetLocal0Ins(), new GetLocal1Ins(), new GetLocal2Ins(), new GetLocal3Ins(), new SetLocal0Ins(), new SetLocal1Ins(), new SetLocal2Ins(), new SetLocal3Ins(), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, new InvalidIns(), new AbsJumpIns(), new DebugIns(), new DebugLineIns(), new DebugFileIns(), new BkptLineIns(), new TimestampIns(), null, new VerifyPassIns(), new AllocIns(), new MarkIns(), new WbIns(), new PrologueIns(), new SendEnterIns(), new DoubleToAtomIns(), new SweepIns(), new CodeGenOpIns(), new VerifyOpIns(), new DecodeIns()};
        for (i = 0; i < allInstructionSet.length; ++i) {
            if (allInstructionSet[i] == null) continue;
            int opCode = AVM2Code.allInstructionSet[i].instructionCode;
            if (instructionSet[opCode] == null) {
                AVM2Code.instructionSet[opCode] = allInstructionSet[i];
                continue;
            }
            if (instructionSet[opCode].hasFlag(AVM2InstructionFlag.NO_FLASH_PLAYER) && !allInstructionSet[i].hasFlag(AVM2InstructionFlag.NO_FLASH_PLAYER)) {
                AVM2Code.instructionSet[opCode] = allInstructionSet[i];
                continue;
            }
            if (instructionSet[opCode].hasFlag(AVM2InstructionFlag.ES4_NUMERICS_MINOR) && !allInstructionSet[i].hasFlag(AVM2InstructionFlag.ES4_NUMERICS_MINOR)) {
                AVM2Code.instructionSet[opCode] = allInstructionSet[i];
                continue;
            }
            if (!instructionSet[opCode].hasFlag(AVM2InstructionFlag.FLOAT_MAJOR) || allInstructionSet[i].hasFlag(AVM2InstructionFlag.FLOAT_MAJOR)) continue;
            AVM2Code.instructionSet[opCode] = allInstructionSet[i];
        }
        for (i = 0; i < instructionSet.length; ++i) {
            if (instructionSet[i] != null) continue;
            AVM2Code.instructionSet[i] = new UnknownInstruction(i);
        }
    }

    private class Slot {
        public final GraphTargetItem scope;
        public final Multiname multiname;

        public Slot(GraphTargetItem scope, Multiname multiname) {
            this.scope = scope;
            this.multiname = multiname;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Slot) {
                Slot slot = (Slot)obj;
                return Objects.equals(slot.scope.getThroughRegister(), this.scope.getThroughRegister()) && slot.multiname == this.multiname;
            }
            return false;
        }

        public int hashCode() {
            int hash = 7;
            hash = 59 * hash + (this.scope != null ? Objects.hashCode(this.scope.getThroughRegister()) : 0);
            hash = 59 * hash + Objects.hashCode(this.multiname);
            return hash;
        }
    }
}

