/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.ClassPath;
import com.jpexs.decompiler.flash.abc.avm2.ConvertException;
import com.jpexs.decompiler.flash.abc.avm2.instructions.AVM2Instruction;
import com.jpexs.decompiler.flash.abc.avm2.instructions.debug.DebugFileIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.debug.DebugIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.debug.DebugLineIns;
import com.jpexs.decompiler.flash.abc.avm2.model.GlobalAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.parser.script.AbcIndexing;
import com.jpexs.decompiler.flash.abc.types.ConvertData;
import com.jpexs.decompiler.flash.abc.types.MethodBody;
import com.jpexs.decompiler.flash.abc.types.Multiname;
import com.jpexs.decompiler.flash.abc.types.Namespace;
import com.jpexs.decompiler.flash.abc.types.ScriptInfo;
import com.jpexs.decompiler.flash.abc.types.traits.Trait;
import com.jpexs.decompiler.flash.abc.types.traits.TraitClass;
import com.jpexs.decompiler.flash.abc.types.traits.TraitFunction;
import com.jpexs.decompiler.flash.abc.types.traits.TraitMethodGetterSetter;
import com.jpexs.decompiler.flash.abc.types.traits.Traits;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.exporters.modes.ScriptExportMode;
import com.jpexs.decompiler.flash.exporters.settings.ScriptExportSettings;
import com.jpexs.decompiler.flash.helpers.FileTextWriter;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.flash.helpers.HighlightedText;
import com.jpexs.decompiler.flash.helpers.NulWriter;
import com.jpexs.decompiler.flash.helpers.hilight.Highlighting;
import com.jpexs.decompiler.flash.search.MethodId;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.treeitems.AS3ClassTreeItem;
import com.jpexs.decompiler.flash.treeitems.Openable;
import com.jpexs.decompiler.graph.DottedChain;
import com.jpexs.decompiler.graph.ScopeStack;
import com.jpexs.helpers.CancellableWorker;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.Path;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ScriptPack
extends AS3ClassTreeItem {
    private static final Logger logger = Logger.getLogger(ScriptPack.class.getName());
    public final ABC abc;
    public List<ABC> allABCs;
    public final int scriptIndex;
    public final List<Integer> traitIndices;
    private final ClassPath path;
    public boolean isSimple = false;
    public boolean scriptInitializerIsEmpty = false;

    @Override
    public Openable getOpenable() {
        return this.abc.getOpenable();
    }

    public ClassPath getClassPath() {
        return this.path;
    }

    public ScriptPack(ClassPath path, ABC abc, List<ABC> allAbcs, int scriptIndex, List<Integer> traitIndices) {
        super(path.className, path.namespaceSuffix, path);
        this.abc = abc;
        this.scriptIndex = scriptIndex;
        this.traitIndices = traitIndices;
        this.path = path;
        this.allABCs = allAbcs;
    }

    public DottedChain getPathPackage() {
        DottedChain packageName = DottedChain.TOPLEVEL;
        for (int t : this.traitIndices) {
            Multiname name = this.abc.script_info.get((int)this.scriptIndex).traits.traits.get(t).getName(this.abc);
            Namespace ns = name.getNamespace(this.abc.constants);
            if (ns.kind != 22 && ns.kind != 23) continue;
            packageName = ns.getName(this.abc.constants);
        }
        return packageName;
    }

    public Trait getPublicTrait() {
        for (int t : this.traitIndices) {
            Multiname name = this.abc.script_info.get((int)this.scriptIndex).traits.traits.get(t).getName(this.abc);
            Namespace ns = name.getNamespace(this.abc.constants);
            if (ns.kind != 22 && ns.kind != 23) continue;
            return this.abc.script_info.get((int)this.scriptIndex).traits.traits.get(t);
        }
        return null;
    }

    public String getPathScriptName() {
        String scriptName = "";
        for (int t : this.traitIndices) {
            Multiname name = this.abc.script_info.get((int)this.scriptIndex).traits.traits.get(t).getName(this.abc);
            Namespace ns = name.getNamespace(this.abc.constants);
            if (ns.kind != 22 && ns.kind != 23) continue;
            scriptName = name.getName(this.abc.constants, null, false, true);
        }
        return scriptName;
    }

    public File getExportFile(String directory, String extension) {
        String scriptName = this.getPathScriptName();
        DottedChain packageName = this.getPathPackage();
        File outDir = new File(directory + File.separatorChar + packageName.toFilePath());
        String fileName = outDir.toString() + File.separator + Helper.makeFileName(scriptName) + extension;
        return new File(fileName);
    }

    public File getExportFile(String directory, ScriptExportSettings exportSettings) {
        if (exportSettings.singleFile) {
            return null;
        }
        return this.getExportFile(directory, exportSettings.getFileExtension());
    }

    public void convert(AbcIndexing abcIndex, NulWriter writer, List<Trait> traits, ConvertData convertData, ScriptExportMode exportMode, boolean parallel) throws InterruptedException {
        int sinit_index = this.abc.script_info.get((int)this.scriptIndex).init_index;
        int sinit_bodyIndex = this.abc.findBodyIndex(sinit_index);
        if (sinit_bodyIndex != -1) {
            ArrayList<Traits> ts = new ArrayList<Traits>();
            for (Trait t : traits) {
                if (!(t instanceof TraitClass)) continue;
                ts.add(this.abc.class_info.get((int)((TraitClass)t).class_info).static_traits);
            }
            ts.add(this.abc.script_info.get((int)this.scriptIndex).traits);
            writer.mark();
            ArrayList<MethodBody> callStack = new ArrayList<MethodBody>();
            callStack.add(this.abc.bodies.get(sinit_bodyIndex));
            this.abc.bodies.get(sinit_bodyIndex).convert(callStack, abcIndex, convertData, this.path + "/.scriptinitializer", exportMode, true, sinit_index, this.scriptIndex, -1, this.abc, null, new ScopeStack(), -3, writer, new ArrayList<DottedChain>(), ts, true, new HashSet<Integer>());
            this.scriptInitializerIsEmpty = !writer.getMark();
        }
        ScopeStack scopeStack = new ScopeStack();
        scopeStack.push(new GlobalAVM2Item(null, null));
        Iterator<Serializable> iterator = this.traitIndices.iterator();
        while (iterator.hasNext()) {
            int t = (Integer)iterator.next();
            Trait trait = traits.get(t);
            Multiname name = trait.getName(this.abc);
            Namespace ns = name.getNamespace(this.abc.constants);
            if (ns.kind == 22 || ns.kind == 23) {
                trait.convertPackaged(abcIndex, null, convertData, "", this.abc, false, exportMode, this.scriptIndex, -1, writer, new ArrayList<DottedChain>(), parallel, scopeStack);
                continue;
            }
            trait.convert(abcIndex, null, convertData, "", this.abc, false, exportMode, this.scriptIndex, -1, writer, new ArrayList<DottedChain>(), parallel, scopeStack);
        }
    }

    private void appendTo(AbcIndexing abcIndex, GraphTextWriter writer, List<Trait> traits, ConvertData convertData, ScriptExportMode exportMode, boolean parallel) throws InterruptedException {
        boolean first = true;
        int script_init = this.abc.script_info.get((int)this.scriptIndex).init_index;
        int bodyIndex = this.abc.findBodyIndex(script_init);
        if (bodyIndex != -1 && Configuration.enableScriptInitializerDisplay.get().booleanValue()) {
            writer.startTrait(-3L);
            writer.startMethod(script_init);
            if (exportMode != ScriptExportMode.AS_METHOD_STUBS) {
                if (!this.scriptInitializerIsEmpty) {
                    writer.startBlock();
                    ArrayList<MethodBody> callStack = new ArrayList<MethodBody>();
                    callStack.add(this.abc.bodies.get(bodyIndex));
                    this.abc.bodies.get(bodyIndex).toString(callStack, abcIndex, this.path + "/.scriptinitializer", exportMode, this.abc, null, writer, new ArrayList<DottedChain>(), new HashSet<Integer>());
                    writer.endBlock();
                } else {
                    writer.append(" ");
                }
            }
            writer.endMethod();
            writer.endTrait();
            if (!this.scriptInitializerIsEmpty) {
                writer.newLine();
            }
            first = false;
        }
        for (int t : this.traitIndices) {
            if (!first) {
                writer.newLine();
            }
            Trait trait = traits.get(t);
            writer.startTrait(t);
            Multiname name = trait.getName(this.abc);
            Namespace ns = name.getNamespace(this.abc.constants);
            if (ns.kind == 22 || ns.kind == 23) {
                trait.toStringPackaged(abcIndex, null, convertData, "", this.abc, false, exportMode, this.scriptIndex, -1, writer, new ArrayList<DottedChain>(), parallel, false);
            } else {
                trait.toString(abcIndex, null, convertData, "", this.abc, false, exportMode, this.scriptIndex, -1, writer, new ArrayList<DottedChain>(), parallel, false);
            }
            if (!(trait instanceof TraitClass)) {
                writer.endTrait();
            }
            first = false;
        }
    }

    public void toSource(final AbcIndexing abcIndex, GraphTextWriter writer, final List<Trait> traits, final ConvertData convertData, final ScriptExportMode exportMode, final boolean parallel, boolean ignoreFrameScripts) throws InterruptedException {
        writer.suspendMeasure();
        int timeout = Configuration.decompilationTimeoutFile.get();
        try {
            CancellableWorker.call(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    ScriptPack.this.convert(abcIndex, new NulWriter(), traits, convertData, exportMode, parallel);
                    return null;
                }
            }, timeout, TimeUnit.SECONDS);
        }
        catch (TimeoutException ex) {
            writer.continueMeasure();
            logger.log(Level.SEVERE, "Decompilation timeout", ex);
            Helper.appendTimeoutCommentAs3(writer, timeout, 0);
            return;
        }
        catch (CancellationException ex) {
            throw new InterruptedException();
        }
        catch (ExecutionException ex) {
            writer.continueMeasure();
            Exception convertException = ex;
            Throwable cause = ex.getCause();
            if (cause instanceof Exception) {
                convertException = (Exception)cause;
            }
            if (convertException instanceof CancellationException) {
                throw new InterruptedException();
            }
            if (convertException instanceof InterruptedException) {
                throw (InterruptedException)convertException;
            }
            logger.log(Level.SEVERE, "Decompilation error", convertException);
            Helper.appendErrorComment(writer, convertException);
            return;
        }
        writer.continueMeasure();
        this.appendTo(abcIndex, writer, traits, convertData, exportMode, parallel);
    }

    public File export(AbcIndexing abcIndex, File file, ScriptExportSettings exportSettings, boolean parallel) throws IOException, InterruptedException {
        if (!exportSettings.singleFile && file.exists() && !Configuration.overwriteExistingFiles.get().booleanValue()) {
            return file;
        }
        if (file != null) {
            Path.createDirectorySafe(file.getParentFile());
        }
        try (FileTextWriter writer = exportSettings.singleFile ? null : new FileTextWriter(Configuration.getCodeFormatting(), new FileOutputStream(file));){
            FileTextWriter writer2 = exportSettings.singleFile ? exportSettings.singleFileWriter : writer;
            ConvertData convertData = new ConvertData();
            convertData.ignoreFrameScripts = exportSettings.ignoreFrameScripts;
            this.toSource(abcIndex, writer2, this.abc.script_info.get((int)this.scriptIndex).traits.traits, convertData, exportSettings.mode, parallel, exportSettings.ignoreFrameScripts);
        }
        catch (FileNotFoundException ex) {
            logger.log(Level.SEVERE, "The file path is probably too long", ex);
        }
        return file;
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + System.identityHashCode(this.abc);
        hash = 79 * hash + this.scriptIndex;
        hash = 79 * hash + Objects.hashCode(this.path);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ScriptPack other = (ScriptPack)obj;
        if (this.abc != other.abc) {
            return false;
        }
        if (this.scriptIndex != other.scriptIndex) {
            return false;
        }
        return Objects.equals(this.path, other.path);
    }

    @Override
    public boolean isModified() {
        if (this.scriptIndex >= this.abc.script_info.size()) {
            return false;
        }
        return this.abc.script_info.get(this.scriptIndex).isModified();
    }

    public void clearModified() {
        if (this.scriptIndex >= this.abc.script_info.size()) {
            return;
        }
        this.abc.script_info.get(this.scriptIndex).setModified(false);
    }

    public void injectDebugInfo(File directoryPath) {
        HashMap bodyToPosToLine = new HashMap();
        HashMap bodyLineToPos = new HashMap();
        HashMap bodyToRegToName = new HashMap();
        HashMap bodyToRegToLine = new HashMap();
        HashSet<Integer> lonelyBody = new HashSet<Integer>();
        try {
            HighlightedText decompiled = SWF.getCached(this);
            int line = 1;
            String txt = decompiled.text;
            txt = txt.replace("\r", "");
            for (int i = 0; i < txt.length(); ++i) {
                block25: {
                    String regName;
                    int regIndex;
                    int bodyIndex2;
                    block29: {
                        block26: {
                            int pos;
                            block28: {
                                long instrOffset;
                                block27: {
                                    int traitIndex;
                                    Trait trait;
                                    Highlighting sh = Highlighting.searchPos(decompiled.getSpecialHighlights(), i);
                                    Highlighting cls = Highlighting.searchPos(decompiled.getClassHighlights(), i);
                                    Highlighting trt = Highlighting.searchPos(decompiled.getTraitHighlights(), i);
                                    Highlighting method = Highlighting.searchPos(decompiled.getMethodHighlights(), i);
                                    if (method == null) break block25;
                                    Highlighting instr = Highlighting.searchPos(decompiled.getInstructionHighlights(), i);
                                    int classIndex = cls == null ? -1 : (int)cls.getProperties().index;
                                    int methodIndex = (int)method.getProperties().index;
                                    bodyIndex2 = this.abc.findBodyIndex(methodIndex);
                                    if (bodyIndex2 == -1) break block25;
                                    pos = -1;
                                    regIndex = -1;
                                    regName = null;
                                    if (sh != null && sh.getProperties().declaration && sh.getProperties().regIndex > -1) {
                                        regIndex = sh.getProperties().regIndex;
                                        regName = sh.getProperties().localName;
                                    }
                                    if (instr == null) break block26;
                                    if (instr.getProperties().declaration && instr.getProperties().regIndex > -1) {
                                        regIndex = instr.getProperties().regIndex;
                                        regName = instr.getProperties().localName;
                                    }
                                    instrOffset = instr.getProperties().firstLineOffset;
                                    if (trt == null || cls == null || (trait = this.abc.findTraitByTraitId(classIndex, traitIndex = (int)trt.getProperties().index)) instanceof TraitMethodGetterSetter && ((TraitMethodGetterSetter)trait).method_info != methodIndex || !(trait instanceof TraitFunction) || ((TraitFunction)trait).method_info != methodIndex) {
                                        // empty if block
                                    }
                                    if (instrOffset != -1L) break block27;
                                    lonelyBody.add(bodyIndex2);
                                    break block25;
                                }
                                try {
                                    pos = this.abc.bodies.get(bodyIndex2).getCode().adr2pos(instrOffset);
                                }
                                catch (ConvertException convertException) {
                                    // empty catch block
                                }
                                if (pos != -1) break block28;
                                lonelyBody.add(bodyIndex2);
                                break block25;
                            }
                            if (!bodyToPosToLine.containsKey(bodyIndex2)) {
                                bodyToPosToLine.put(bodyIndex2, new HashMap());
                                bodyLineToPos.put(bodyIndex2, new HashMap());
                            }
                            ((Map)bodyToPosToLine.get(bodyIndex2)).put(pos, line);
                            ((Map)bodyLineToPos.get(bodyIndex2)).put(line, pos);
                            break block29;
                        }
                        lonelyBody.add(bodyIndex2);
                    }
                    if (regIndex > -1 && regName != null) {
                        if (!bodyToRegToName.containsKey(bodyIndex2)) {
                            bodyToRegToName.put(bodyIndex2, new HashMap());
                            bodyToRegToLine.put(bodyIndex2, new HashMap());
                        }
                        if (!((Map)bodyToRegToName.get(bodyIndex2)).containsKey(regIndex)) {
                            ((Map)bodyToRegToName.get(bodyIndex2)).put(regIndex, regName);
                            ((Map)bodyToRegToLine.get(bodyIndex2)).put(regIndex, line);
                        }
                    }
                }
                if (txt.charAt(i) != '\n') continue;
                ++line;
            }
        }
        catch (InterruptedException ex) {
            logger.log(Level.SEVERE, "Cannot decompile", ex);
        }
        int scriptInitBody = this.abc.findBodyIndex(this.abc.script_info.get((int)this.scriptIndex).init_index);
        if (!bodyToRegToName.containsKey(scriptInitBody)) {
            lonelyBody.add(scriptInitBody);
        }
        String pkg = this.path.packageStr.toString();
        String cls = this.path.className;
        String filename = new File(directoryPath, this.path.packageStr.toFilePath()) + ";" + pkg.replace(".", File.separator) + ";" + cls + ".as";
        Iterator<Object> iterator = lonelyBody.iterator();
        while (iterator.hasNext()) {
            int bodyIndex = (Integer)iterator.next();
            if (bodyToPosToLine.keySet().contains(bodyIndex)) continue;
            MethodBody b = this.abc.bodies.get(bodyIndex);
            List<AVM2Instruction> code = b.getCode().code;
            for (int i = 0; i < code.size(); ++i) {
                AVM2Instruction ins = code.get(i);
                if (ins.definition instanceof DebugLineIns) {
                    b.removeInstruction(i);
                    --i;
                    continue;
                }
                if (ins.definition instanceof DebugFileIns) {
                    b.removeInstruction(i);
                    --i;
                    continue;
                }
                if (!(ins.definition instanceof DebugIns)) continue;
                b.removeInstruction(i);
                --i;
            }
            b.setModified();
        }
        iterator = bodyToPosToLine.keySet().iterator();
        while (iterator.hasNext()) {
            int bodyIndex = (Integer)iterator.next();
            ArrayList<AVM2Instruction> delIns = new ArrayList<AVM2Instruction>();
            MethodBody b = this.abc.bodies.get(bodyIndex);
            List<AVM2Instruction> code = b.getCode().code;
            for (AVM2Instruction ins : code) {
                if (ins.definition instanceof DebugLineIns) {
                    delIns.add(ins);
                }
                if (ins.definition instanceof DebugFileIns) {
                    delIns.add(ins);
                }
                if (!(ins.definition instanceof DebugIns)) continue;
                delIns.add(ins);
            }
            int dpos = 0;
            b.insertInstruction(0, new AVM2Instruction(0L, 241, new int[]{this.abc.constants.getStringId(filename, true)}), true);
            ++dpos;
            TreeSet regs = bodyToRegToName.containsKey(bodyIndex) ? ((Map)bodyToRegToName.get(bodyIndex)).keySet() : new TreeSet();
            Iterator bodyIndex2 = regs.iterator();
            while (bodyIndex2.hasNext()) {
                int r = (Integer)bodyIndex2.next();
                String name = (String)((Map)bodyToRegToName.get(bodyIndex)).get(r);
                int line = (Integer)((Map)bodyToRegToLine.get(bodyIndex)).get(r);
                b.insertInstruction(dpos++, new AVM2Instruction(0L, 239, new int[]{1, this.abc.constants.getStringId(name, true), r - 1, line}));
            }
            ArrayList pos = new ArrayList(((Map)bodyToPosToLine.get(bodyIndex)).keySet());
            Collections.sort(pos);
            Collections.reverse(pos);
            HashSet<Integer> addedLines = new HashSet<Integer>();
            Iterator name = pos.iterator();
            while (name.hasNext()) {
                int i = (Integer)name.next();
                int line = (Integer)((Map)bodyToPosToLine.get(bodyIndex)).get(i);
                if (addedLines.contains(line)) continue;
                addedLines.add(line);
                logger.log(Level.FINE, "Script {0}: Insert debugline({1}) at pos {2} to body {3}", new Object[]{this.path, line, i, bodyIndex});
                b.insertInstruction(i + dpos, new AVM2Instruction(0L, 240, new int[]{line}));
            }
            block11: for (int i = 0; i < code.size(); ++i) {
                AVM2Instruction ins = code.get(i);
                for (AVM2Instruction d : delIns) {
                    if (ins != d) continue;
                    b.removeInstruction(i);
                    --i;
                    continue block11;
                }
            }
            b.setModified();
        }
        ((Tag)((Object)this.abc.parentTag)).setModified(true);
    }

    public void injectPCodeDebugInfo(int abcIndex) {
        HashMap<Integer, String> bodyToIdentifier = new HashMap<Integer, String>();
        try {
            HighlightedText decompiled = SWF.getCached(this);
            String txt = decompiled.text;
            txt = txt.replace("\r", "");
            for (int i = 0; i < txt.length(); ++i) {
                Trait trait;
                Highlighting sh = Highlighting.searchPos(decompiled.getSpecialHighlights(), i);
                Highlighting cls = Highlighting.searchPos(decompiled.getClassHighlights(), i);
                Highlighting trt = Highlighting.searchPos(decompiled.getTraitHighlights(), i);
                Highlighting method = Highlighting.searchPos(decompiled.getMethodHighlights(), i);
                if (method == null) continue;
                int classIndex = cls == null ? -1 : (int)cls.getProperties().index;
                int methodIndex = (int)method.getProperties().index;
                int bodyIndex = this.abc.findBodyIndex(methodIndex);
                if (bodyIndex == -1) continue;
                int traitIndex = -10;
                if (trt != null && cls != null && ((trait = this.abc.findTraitByTraitId(classIndex, traitIndex = (int)trt.getProperties().index)) instanceof TraitMethodGetterSetter && ((TraitMethodGetterSetter)trait).method_info != methodIndex || trait instanceof TraitFunction && ((TraitFunction)trait).method_info != methodIndex)) continue;
                bodyToIdentifier.put(bodyIndex, "abc:" + abcIndex + ",script:" + this.scriptIndex + ",class:" + classIndex + ",trait:" + traitIndex + ",method:" + methodIndex + ",body:" + bodyIndex);
            }
        }
        catch (InterruptedException ex) {
            logger.log(Level.SEVERE, "Cannot decompile", ex);
        }
        int scriptInitBody = this.abc.findBodyIndex(this.abc.script_info.get((int)this.scriptIndex).init_index);
        if (!bodyToIdentifier.containsKey(scriptInitBody)) {
            bodyToIdentifier.put(scriptInitBody, "abc:" + abcIndex + ",script:" + this.scriptIndex + ",class:-1,trait:-3,method:" + this.abc.script_info.get((int)this.scriptIndex).init_index + ",body:" + scriptInitBody);
        }
        String pkg = this.path.packageStr.toString();
        String cls = this.path.className;
        Iterator iterator = bodyToIdentifier.keySet().iterator();
        while (iterator.hasNext()) {
            int i;
            int bodyIndex = (Integer)iterator.next();
            String bodyName = (String)bodyToIdentifier.get(bodyIndex);
            MethodBody b = this.abc.bodies.get(bodyIndex);
            List<AVM2Instruction> list = b.getCode().code;
            int siz = list.size();
            for (i = 0; i < siz; ++i) {
                b.insertInstruction(i * 2, new AVM2Instruction(0L, 240, new int[]{i + 1}));
            }
            for (i = 1; i < list.size(); i += 2) {
                if (list.get((int)i).definition instanceof DebugLineIns) {
                    b.removeInstruction(i);
                    b.removeInstruction(i - 1);
                    i -= 2;
                    continue;
                }
                if (list.get((int)i).definition instanceof DebugFileIns) {
                    b.removeInstruction(i);
                    b.removeInstruction(i - 1);
                    i -= 2;
                    continue;
                }
                if (!(list.get((int)i).definition instanceof DebugIns)) continue;
                b.removeInstruction(i);
                b.removeInstruction(i - 1);
                i -= 2;
            }
            String filename = "#PCODE " + bodyName + ";" + pkg.replace(".", File.separator) + ";" + cls + ".as";
            b.insertInstruction(0, new AVM2Instruction(0L, 241, new int[]{this.abc.constants.getStringId(filename, true)}));
            b.setModified();
        }
        ((Tag)((Object)this.abc.parentTag)).setModified(true);
    }

    public void getMethodInfos(List<MethodId> methodInfos) {
        int script_init = this.abc.script_info.get((int)this.scriptIndex).init_index;
        methodInfos.add(new MethodId(-3, -1, script_init));
        List<Trait> traits = this.abc.script_info.get((int)this.scriptIndex).traits.traits;
        for (int t : this.traitIndices) {
            Trait trait = traits.get(t);
            trait.getMethodInfos(this.abc, -4, -1, methodInfos);
        }
    }

    public void delete(ABC abc, boolean d) {
        ScriptInfo si = abc.script_info.get(this.scriptIndex);
        if (this.isSimple) {
            si.delete(abc, d);
        } else {
            for (int t : this.traitIndices) {
                si.traits.traits.get(t).delete(abc, d);
            }
        }
    }
}

