/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc;

import com.jpexs.decompiler.flash.EndOfStreamException;
import com.jpexs.decompiler.flash.SWFInputStream;
import com.jpexs.decompiler.flash.abc.types.Decimal;
import com.jpexs.decompiler.flash.abc.types.Float4;
import com.jpexs.decompiler.flash.abc.types.InstanceInfo;
import com.jpexs.decompiler.flash.abc.types.MethodInfo;
import com.jpexs.decompiler.flash.abc.types.Multiname;
import com.jpexs.decompiler.flash.abc.types.Namespace;
import com.jpexs.decompiler.flash.abc.types.ValueKind;
import com.jpexs.decompiler.flash.abc.types.traits.Trait;
import com.jpexs.decompiler.flash.abc.types.traits.TraitClass;
import com.jpexs.decompiler.flash.abc.types.traits.TraitFunction;
import com.jpexs.decompiler.flash.abc.types.traits.TraitMethodGetterSetter;
import com.jpexs.decompiler.flash.abc.types.traits.TraitSlotConst;
import com.jpexs.decompiler.flash.abc.types.traits.Traits;
import com.jpexs.decompiler.flash.dumpview.DumpInfo;
import com.jpexs.decompiler.flash.dumpview.DumpInfoSpecial;
import com.jpexs.decompiler.flash.dumpview.DumpInfoSpecialType;
import com.jpexs.helpers.MemoryInputStream;
import com.jpexs.helpers.utf8.Utf8Helper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class ABCInputStream
implements AutoCloseable {
    private static final int CLASS_PROTECTED_NS = 8;
    private static final int ATTR_METADATA = 4;
    private final MemoryInputStream is;
    private ByteArrayOutputStream bufferOs = null;
    public static final boolean DEBUG_READ = false;
    public DumpInfo dumpInfo;
    private byte[] stringDataBuffer = new byte[256];

    public void startBuffer() {
        if (this.bufferOs == null) {
            this.bufferOs = new ByteArrayOutputStream();
        } else {
            this.bufferOs.reset();
        }
    }

    public byte[] stopBuffer() {
        if (this.bufferOs == null) {
            return SWFInputStream.BYTE_ARRAY_EMPTY;
        }
        byte[] ret = this.bufferOs.toByteArray();
        this.bufferOs.reset();
        return ret;
    }

    public ABCInputStream(MemoryInputStream is) {
        this.is = is;
    }

    public void seek(long pos) throws IOException {
        this.is.seek(pos);
    }

    public DumpInfo newDumpLevel(String name, String type) {
        return this.newDumpLevel(name, type, DumpInfoSpecialType.NONE);
    }

    public DumpInfo newDumpLevel(String name, String type, DumpInfoSpecialType specialType) {
        if (this.dumpInfo != null) {
            long startByte = this.is.getPos();
            DumpInfo di = specialType == DumpInfoSpecialType.NONE ? new DumpInfo(name, type, null, startByte, 0, 0L, 0) : new DumpInfoSpecial(name, type, null, startByte, 0, 0L, 0, specialType);
            di.parent = this.dumpInfo;
            this.dumpInfo.getChildInfos().add(di);
            this.dumpInfo = di;
        }
        return this.dumpInfo;
    }

    public void endDumpLevel() {
        this.endDumpLevel(null);
    }

    public void endDumpLevel(Object value) {
        if (this.dumpInfo != null) {
            this.dumpInfo.lengthBytes = this.is.getPos() - this.dumpInfo.startByte;
            this.dumpInfo.previewValue = value;
            this.dumpInfo = this.dumpInfo.parent;
        }
    }

    public void endDumpLevelUntil(DumpInfo di) {
        if (di != null) {
            while (this.dumpInfo != null && this.dumpInfo != di) {
                this.endDumpLevel();
            }
        }
    }

    private int readInternal() throws IOException {
        int i = this.is.read();
        if (i == -1) {
            throw new EndOfStreamException();
        }
        if (this.bufferOs != null && i != -1) {
            this.bufferOs.write(i);
        }
        return i;
    }

    public int read(String name) throws IOException {
        this.newDumpLevel(name, "byte");
        int ret = this.readInternal();
        this.endDumpLevel(ret);
        return ret;
    }

    private int read(byte[] b) throws IOException {
        int currBytesRead = this.is.read(b);
        if (this.bufferOs != null && currBytesRead > 0) {
            this.bufferOs.write(b, 0, currBytesRead);
        }
        return currBytesRead;
    }

    public int readU8(String name) throws IOException {
        this.newDumpLevel(name, "U8");
        int ret = this.readInternal();
        this.endDumpLevel(ret);
        return ret;
    }

    private long readU32Internal() throws IOException {
        boolean nextByte;
        long ret = 0L;
        int bytePos = 0;
        int byteCount = 0;
        do {
            int i;
            nextByte = (i = this.readInternal()) >> 7 == 1;
            ret += (long)(i &= 0x7F) << bytePos;
            bytePos += 7;
        } while (nextByte && ++byteCount < 5);
        return ret;
    }

    public long readU32(String name) throws IOException {
        this.newDumpLevel(name, "U32");
        long ret = this.readU32Internal();
        this.endDumpLevel(ret);
        return ret;
    }

    private int readU30Internal() throws IOException {
        long u32 = this.readU32Internal();
        return (int)(u32 & 0x3FFFFFFFL);
    }

    public int readU30(String name) throws IOException {
        this.newDumpLevel(name, "U30");
        int ret = this.readU30Internal();
        this.endDumpLevel(ret);
        return ret;
    }

    public int readS24(String name) throws IOException {
        this.newDumpLevel(name, "S24");
        int ret = this.readInternal() + (this.readInternal() << 8) + (this.readInternal() << 16);
        if (ret >> 23 == 1) {
            ret |= 0xFF000000;
        }
        this.endDumpLevel(ret);
        return ret;
    }

    public int readU16(String name) throws IOException {
        this.newDumpLevel(name, "U16");
        int ret = this.readInternal() + (this.readInternal() << 8);
        this.endDumpLevel(ret);
        return ret;
    }

    public int readS32(String name) throws IOException {
        boolean nextByte;
        long ret = 0L;
        int bytePos = 0;
        int byteCount = 0;
        this.newDumpLevel(name, "S32");
        do {
            int i;
            nextByte = (i = this.readInternal()) >> 7 == 1;
            ret += (long)((i &= 0x7F) << bytePos);
            ++byteCount;
            if ((bytePos += 7) != 35) continue;
            if (ret >> 31 != 1L) break;
            ret = -(ret & Integer.MAX_VALUE);
            break;
        } while (nextByte && byteCount < 5);
        this.endDumpLevel(ret);
        return (int)ret;
    }

    public int available() throws IOException {
        return this.is.available();
    }

    private long readLong() throws IOException {
        this.safeRead(8, this.stringDataBuffer);
        byte[] readBuffer = this.stringDataBuffer;
        return ((long)readBuffer[7] << 56) + ((long)(readBuffer[6] & 0xFF) << 48) + ((long)(readBuffer[5] & 0xFF) << 40) + ((long)(readBuffer[4] & 0xFF) << 32) + ((long)(readBuffer[3] & 0xFF) << 24) + (long)((readBuffer[2] & 0xFF) << 16) + (long)((readBuffer[1] & 0xFF) << 8) + (long)(readBuffer[0] & 0xFF);
    }

    public double readDouble(String name) throws IOException {
        this.newDumpLevel(name, "Double");
        long el = this.readLong();
        double ret = Double.longBitsToDouble(el);
        this.endDumpLevel(ret);
        return ret;
    }

    private void safeRead(int count, byte[] data) throws IOException {
        for (int i = 0; i < count; ++i) {
            data[i] = (byte)this.readInternal();
        }
    }

    public Namespace readNamespace(String name) throws IOException {
        this.newDumpLevel(name, "Namespace");
        int kind = this.read("kind");
        int name_index = 0;
        for (int k = 0; k < Namespace.nameSpaceKinds.length; ++k) {
            if (Namespace.nameSpaceKinds[k] != kind) continue;
            name_index = this.readU30("name_index");
            break;
        }
        this.endDumpLevel();
        return new Namespace(kind, name_index);
    }

    public Multiname readMultiname(String name) throws IOException {
        int kind = this.readU8("kind");
        Multiname result = null;
        this.newDumpLevel(name, "Multiname");
        if (kind == 7 || kind == 13) {
            int namespace_index = this.readU30("namespace_index");
            int name_index = this.readU30("name_index");
            result = Multiname.createQName(kind == 13, name_index, namespace_index);
        } else if (kind == 15 || kind == 16) {
            int name_index = this.readU30("name_index");
            result = Multiname.createRTQName(kind == 16, name_index);
        } else if (kind == 17 || kind == 18) {
            result = Multiname.createRTQNameL(kind == 18);
        } else if (kind == 9 || kind == 14) {
            int name_index = this.readU30("name_index");
            int namespace_set_index = this.readU30("namespace_set_index");
            result = Multiname.createMultiname(kind == 14, name_index, namespace_set_index);
        } else if (kind == 27 || kind == 28) {
            int namespace_set_index = this.readU30("namespace_set_index");
            result = Multiname.createMultinameL(kind == 28, namespace_set_index);
        } else if (kind == 29) {
            int qname_index = this.readU30("qname_index");
            int paramsLength = this.readU30("paramsLength");
            int[] params = new int[paramsLength];
            for (int i = 0; i < paramsLength; ++i) {
                params[i] = this.readU30("param");
            }
            result = Multiname.createTypeName(qname_index, params);
        } else {
            throw new IOException("Unknown kind of Multiname:0x" + Integer.toHexString(kind));
        }
        this.endDumpLevel();
        return result;
    }

    public MethodInfo readMethodInfo(String name) throws IOException {
        int i;
        this.newDumpLevel(name, "method_info");
        int param_count = this.readU30("param_count");
        int ret_type = this.readU30("ret_type");
        int[] param_types = new int[param_count];
        for (int i2 = 0; i2 < param_count; ++i2) {
            param_types[i2] = this.readU30("param_type");
        }
        int name_index = this.readU30("name_index");
        int flags = this.read("flags");
        ValueKind[] optional = new ValueKind[]{};
        if ((flags & 8) == 8) {
            int optional_count = this.readU30("optional_count");
            optional = new ValueKind[optional_count];
            for (i = 0; i < optional_count; ++i) {
                optional[i] = new ValueKind(this.readU30("value_index"), this.read("value_kind"));
            }
        }
        int[] param_names = new int[param_count];
        if ((flags & 0x80) == 128) {
            for (i = 0; i < param_count; ++i) {
                param_names[i] = this.readU30("param_name");
            }
        }
        this.endDumpLevel();
        return new MethodInfo(param_types, ret_type, name_index, flags, optional, param_names);
    }

    public Trait readTrait(String name) throws IOException {
        Trait trait;
        this.newDumpLevel(name, "Trait");
        long pos = this.getPosition();
        this.startBuffer();
        int name_index = this.readU30("name_index");
        int kind = this.read("kind");
        int kindType = 0xF & kind;
        int kindFlags = kind >> 4;
        switch (kindType) {
            case 0: 
            case 6: {
                TraitSlotConst t1 = new TraitSlotConst();
                t1.slot_id = this.readU30("slot_id");
                t1.type_index = this.readU30("type_index");
                t1.value_index = this.readU30("value_index");
                if (t1.value_index != 0) {
                    t1.value_kind = this.read("value_kind");
                }
                trait = t1;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                TraitMethodGetterSetter t2 = new TraitMethodGetterSetter();
                t2.disp_id = this.readU30("disp_id");
                t2.method_info = this.readU30("method_info");
                trait = t2;
                break;
            }
            case 4: {
                TraitClass t3 = new TraitClass();
                t3.slot_id = this.readU30("slot_id");
                t3.class_info = this.readU30("class_info");
                trait = t3;
                break;
            }
            case 5: {
                TraitFunction t4 = new TraitFunction();
                t4.slot_id = this.readU30("slot_id");
                t4.method_info = this.readU30("method_info");
                trait = t4;
                break;
            }
            default: {
                throw new IOException("Unknown trait kind:" + kind);
            }
        }
        trait.fileOffset = pos;
        trait.kindType = kindType;
        trait.kindFlags = kindFlags;
        trait.name_index = name_index;
        if ((kindFlags & 4) != 0) {
            int metadata_count = this.readU30("metadata_count");
            trait.metadata = new int[metadata_count];
            for (int i = 0; i < metadata_count; ++i) {
                trait.metadata[i] = this.readU30("metadata");
            }
        }
        trait.bytes = this.stopBuffer();
        this.endDumpLevel();
        return trait;
    }

    public Traits readTraits(String name) throws IOException {
        this.newDumpLevel(name, "Traits");
        int count = this.readU30("count");
        Traits traits = new Traits(count);
        for (int i = 0; i < count; ++i) {
            traits.traits.add(this.readTrait("trait"));
        }
        this.endDumpLevel();
        return traits;
    }

    private byte[] readBytesInternal(int count) throws IOException {
        byte[] ret = new byte[count];
        for (int i = 0; i < count; ++i) {
            ret[i] = (byte)this.readInternal();
        }
        return ret;
    }

    public byte[] readBytes(int count, String name, DumpInfoSpecialType specialType) throws IOException {
        this.newDumpLevel(name, "Bytes", specialType);
        byte[] ret = this.readBytesInternal(count);
        this.endDumpLevel();
        return ret;
    }

    public Decimal readDecimal(String name) throws IOException {
        this.newDumpLevel(name, "Decimal");
        byte[] data = this.readBytesInternal(16);
        this.endDumpLevel();
        return new Decimal(data);
    }

    public Float readFloat(String name) throws IOException {
        this.newDumpLevel(name, "Float");
        int intBits = this.readInternal() + (this.readInternal() << 8);
        float ret = Float.intBitsToFloat(intBits);
        this.endDumpLevel(Float.valueOf(ret));
        return Float.valueOf(ret);
    }

    public Float4 readFloat4(String name) throws IOException {
        this.newDumpLevel(name, "Float4");
        float f1 = this.readFloat("value1").floatValue();
        float f2 = this.readFloat("value2").floatValue();
        float f3 = this.readFloat("value3").floatValue();
        float f4 = this.readFloat("value4").floatValue();
        Float4 ret = new Float4(f1, f2, f3, f4);
        this.endDumpLevel(ret);
        return ret;
    }

    public InstanceInfo readInstanceInfo(String name) throws IOException {
        this.newDumpLevel(name, "instance_info");
        InstanceInfo ret = new InstanceInfo(null);
        ret.name_index = this.readU30("name_index");
        ret.super_index = this.readU30("super_index");
        ret.flags = this.readInternal();
        if ((ret.flags & 8) != 0) {
            ret.protectedNS = this.readU30("protectedNS");
        }
        int interfaces_count = this.readU30("interfaces_count");
        ret.interfaces = new int[interfaces_count];
        for (int i = 0; i < interfaces_count; ++i) {
            ret.interfaces[i] = this.readU30("interface");
        }
        ret.iinit_index = this.readU30("iinit_index");
        ret.instance_traits = this.readTraits("instance_traits");
        this.endDumpLevel();
        return ret;
    }

    public String readString(String name) throws IOException {
        this.newDumpLevel(name, "String");
        int length = this.readU30Internal();
        if (this.stringDataBuffer.length < length) {
            int newLength;
            for (newLength = this.stringDataBuffer.length * 2; newLength < length; newLength *= 2) {
            }
            this.stringDataBuffer = new byte[newLength];
        }
        this.safeRead(length, this.stringDataBuffer);
        String r = new String(this.stringDataBuffer, 0, length, Utf8Helper.charset);
        this.endDumpLevel(r);
        return r;
    }

    public long getPosition() {
        return this.is.getPos();
    }

    @Override
    public void close() {
    }
}

