/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc;

import com.jpexs.decompiler.flash.AppResources;
import com.jpexs.decompiler.flash.DeobfuscationListener;
import com.jpexs.decompiler.flash.EndOfStreamException;
import com.jpexs.decompiler.flash.EventListener;
import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.abc.ABCInputStream;
import com.jpexs.decompiler.flash.abc.ABCMethodIndexing;
import com.jpexs.decompiler.flash.abc.ABCOpenException;
import com.jpexs.decompiler.flash.abc.ABCOutputStream;
import com.jpexs.decompiler.flash.abc.ABCVersion;
import com.jpexs.decompiler.flash.abc.RenameType;
import com.jpexs.decompiler.flash.abc.ScriptPack;
import com.jpexs.decompiler.flash.abc.avm2.AVM2Code;
import com.jpexs.decompiler.flash.abc.avm2.AVM2ConstantPool;
import com.jpexs.decompiler.flash.abc.avm2.AVM2Deobfuscation;
import com.jpexs.decompiler.flash.abc.avm2.instructions.AVM2Instruction;
import com.jpexs.decompiler.flash.abc.avm2.instructions.executing.CallPropertyIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.stack.PushStringIns;
import com.jpexs.decompiler.flash.abc.types.ABCException;
import com.jpexs.decompiler.flash.abc.types.ClassInfo;
import com.jpexs.decompiler.flash.abc.types.InstanceInfo;
import com.jpexs.decompiler.flash.abc.types.MetadataInfo;
import com.jpexs.decompiler.flash.abc.types.MethodBody;
import com.jpexs.decompiler.flash.abc.types.MethodInfo;
import com.jpexs.decompiler.flash.abc.types.Multiname;
import com.jpexs.decompiler.flash.abc.types.Namespace;
import com.jpexs.decompiler.flash.abc.types.NamespaceSet;
import com.jpexs.decompiler.flash.abc.types.ScriptInfo;
import com.jpexs.decompiler.flash.abc.types.ValueKind;
import com.jpexs.decompiler.flash.abc.types.traits.Trait;
import com.jpexs.decompiler.flash.abc.types.traits.TraitClass;
import com.jpexs.decompiler.flash.abc.types.traits.TraitFunction;
import com.jpexs.decompiler.flash.abc.types.traits.TraitMethodGetterSetter;
import com.jpexs.decompiler.flash.abc.types.traits.TraitSlotConst;
import com.jpexs.decompiler.flash.abc.types.traits.TraitType;
import com.jpexs.decompiler.flash.abc.types.traits.Traits;
import com.jpexs.decompiler.flash.abc.usages.ClassNameMultinameUsage;
import com.jpexs.decompiler.flash.abc.usages.ConstVarNameMultinameUsage;
import com.jpexs.decompiler.flash.abc.usages.ConstVarTypeMultinameUsage;
import com.jpexs.decompiler.flash.abc.usages.DefinitionUsage;
import com.jpexs.decompiler.flash.abc.usages.MethodBodyMultinameUsage;
import com.jpexs.decompiler.flash.abc.usages.MethodNameMultinameUsage;
import com.jpexs.decompiler.flash.abc.usages.MethodParamsMultinameUsage;
import com.jpexs.decompiler.flash.abc.usages.MethodReturnTypeMultinameUsage;
import com.jpexs.decompiler.flash.abc.usages.MultinameUsage;
import com.jpexs.decompiler.flash.abc.usages.SuperClassMultinameUsage;
import com.jpexs.decompiler.flash.abc.usages.SuperInterfaceMultinameUsage;
import com.jpexs.decompiler.flash.abc.usages.TypeNameMultinameUsage;
import com.jpexs.decompiler.flash.dumpview.DumpInfo;
import com.jpexs.decompiler.flash.dumpview.DumpInfoSpecial;
import com.jpexs.decompiler.flash.dumpview.DumpInfoSpecialType;
import com.jpexs.decompiler.flash.helpers.SWFDecompilerPlugin;
import com.jpexs.decompiler.flash.importers.As3ScriptReplaceException;
import com.jpexs.decompiler.flash.importers.As3ScriptReplacerInterface;
import com.jpexs.decompiler.flash.tags.ABCContainerTag;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.treeitems.Openable;
import com.jpexs.decompiler.flash.treeitems.OpenableList;
import com.jpexs.decompiler.flash.types.annotations.Internal;
import com.jpexs.decompiler.graph.DottedChain;
import com.jpexs.helpers.utf8.Utf8PrintWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ABC
implements Openable {
    public ABCVersion version = new ABCVersion(46, 16);
    public AVM2ConstantPool constants = new AVM2ConstantPool();
    public List<MethodInfo> method_info = new ArrayList<MethodInfo>();
    public List<MetadataInfo> metadata_info = new ArrayList<MetadataInfo>();
    public List<InstanceInfo> instance_info = new ArrayList<InstanceInfo>();
    public List<ClassInfo> class_info = new ArrayList<ClassInfo>();
    public List<ScriptInfo> script_info = new ArrayList<ScriptInfo>();
    public List<MethodBody> bodies = new ArrayList<MethodBody>();
    private ABCMethodIndexing abcMethodIndexing;
    public static final int MINORwithDECIMAL = 17;
    protected Set<EventListener> listeners = new HashSet<EventListener>();
    private static final Logger logger = Logger.getLogger(ABC.class.getName());
    private AVM2Deobfuscation deobfuscation;
    @Internal
    public ABCContainerTag parentTag;
    private Map<String, DottedChain> namespaceMap;
    private String file;
    private String fileTitle;
    private OpenableList openableList;
    private boolean isOpenable = false;

    public ABC(ABCContainerTag tag) {
        this.parentTag = tag;
        this.deobfuscation = null;
    }

    @Override
    public Openable getOpenable() {
        if (this.isOpenable) {
            return this;
        }
        return this.parentTag.getSwf();
    }

    public SWF getSwf() {
        return this.parentTag.getSwf();
    }

    public List<ABCContainerTag> getAbcTags() {
        Openable openable = this.getOpenable();
        if (openable instanceof SWF) {
            return ((SWF)openable).getAbcList();
        }
        return new ArrayList<ABCContainerTag>();
    }

    public int addMethodBody(MethodBody body) {
        this.bodies.add(body);
        this.abcMethodIndexing = null;
        return this.bodies.size() - 1;
    }

    public int addMethodInfo(MethodInfo mi) {
        this.method_info.add(mi);
        return this.method_info.size() - 1;
    }

    public void deleteClass(int class_info, boolean d) {
        ABC abc = this;
        ClassInfo classInfo = abc.class_info.get(class_info);
        classInfo.deleted = d;
        InstanceInfo instanceInfo = abc.instance_info.get(class_info);
        instanceInfo.deleted = d;
        classInfo.static_traits.delete(abc, d);
        abc.method_info.get(classInfo.cinit_index).delete(abc, d);
        instanceInfo.instance_traits.delete(abc, d);
        abc.method_info.get(instanceInfo.iinit_index).delete(abc, d);
        int protectedNS = instanceInfo.protectedNS;
        if (protectedNS != 0) {
            abc.constants.getNamespace((int)protectedNS).deleted = d;
        }
    }

    public int getMetadataId(MetadataInfo newMetadata, boolean add) {
        for (int m = 0; m < this.metadata_info.size(); ++m) {
            MetadataInfo metadata = this.metadata_info.get(m);
            if (metadata.name_index != newMetadata.name_index || !Arrays.equals(metadata.keys, newMetadata.keys) || !Arrays.equals(metadata.values, newMetadata.values)) continue;
            return m;
        }
        if (add) {
            int newIndex = this.metadata_info.size();
            this.metadata_info.add(newMetadata);
            ((Tag)((Object)this.parentTag)).setModified(true);
            return newIndex;
        }
        return -1;
    }

    public TraitMethodGetterSetter addMethod(int classId, String name, boolean isStatic) {
        Multiname multiname = new Multiname();
        multiname.kind = 7;
        multiname.name_index = this.constants.getStringId(name, true);
        multiname.namespace_index = this.constants.getNamespaceId(22, "", 0, true);
        int multinameId = this.constants.getMultinameId(multiname, true);
        MethodInfo methodInfo = new MethodInfo();
        int methodInfoId = this.addMethodInfo(methodInfo);
        MethodBody methodBody = new MethodBody();
        methodBody.method_info = methodInfoId;
        this.addMethodBody(methodBody);
        TraitMethodGetterSetter trait = new TraitMethodGetterSetter();
        trait.name_index = multinameId;
        trait.kindType = 1;
        if (isStatic) {
            trait.kindFlags = 1;
        }
        trait.method_info = methodInfoId;
        if (isStatic) {
            ClassInfo classInfo = this.class_info.get(classId);
            classInfo.static_traits.addTrait(trait);
            trait.disp_id = classInfo.getNextDispId();
        } else {
            InstanceInfo instanceInfo = this.instance_info.get(classId);
            instanceInfo.instance_traits.addTrait(trait);
        }
        return trait;
    }

    public void addEventListener(EventListener listener) {
        this.listeners.add(listener);
    }

    public void removeEventListener(EventListener listener) {
        this.listeners.remove(listener);
    }

    protected void informListeners(String event, Object data) {
        for (EventListener listener : this.listeners) {
            listener.handleEvent(event, data);
        }
    }

    public int removeTraps() throws InterruptedException {
        return this.removeTraps(null);
    }

    public int removeTraps(DeobfuscationListener listener) throws InterruptedException {
        int rem = 0;
        for (int s = 0; s < this.script_info.size(); ++s) {
            rem += this.script_info.get(s).removeTraps(s, this, "");
            if (listener == null) continue;
            listener.itemDeobfuscated();
        }
        return rem;
    }

    public int removeDeadCode() throws InterruptedException {
        return this.removeDeadCode(null);
    }

    public int removeDeadCode(DeobfuscationListener listener) throws InterruptedException {
        int rem = 0;
        for (MethodBody body : this.bodies) {
            rem += body.removeDeadCode(this.constants, null, this.method_info.get(body.method_info));
        }
        return rem;
    }

    public Set<Integer> getNsStringUsages() {
        HashSet<Integer> ret = new HashSet<Integer>();
        for (int n = 1; n < this.constants.getNamespaceCount(); ++n) {
            ret.add(this.constants.getNamespace((int)n).name_index);
        }
        return ret;
    }

    public void getTraitStringUsages(Set<Integer> ret, Traits traits) {
        for (Trait t : traits.traits) {
            if (t instanceof TraitClass) {
                int ci = ((TraitClass)t).class_info;
                this.getTraitStringUsages(ret, this.instance_info.get((int)ci).instance_traits);
                this.getTraitStringUsages(ret, this.class_info.get((int)ci).static_traits);
            }
            if (!(t instanceof TraitSlotConst)) continue;
            TraitSlotConst tsc = (TraitSlotConst)t;
            if (tsc.value_kind != 1) continue;
            ret.add(tsc.value_index);
        }
    }

    public Set<Integer> getStringUsages() {
        HashSet<Integer> ret = new HashSet<Integer>();
        for (ScriptInfo si : this.script_info) {
            this.getTraitStringUsages(ret, si.traits);
        }
        for (MethodInfo mi : this.method_info) {
            if ((mi.flags & MethodInfo.FLAG_HAS_OPTIONAL) != MethodInfo.FLAG_HAS_OPTIONAL) continue;
            for (ValueKind vk : mi.optional) {
                if (vk.value_kind != 1) continue;
                ret.add(vk.value_index);
            }
        }
        for (MethodBody body : this.bodies) {
            this.getTraitStringUsages(ret, body.traits);
            for (AVM2Instruction ins : body.getCode().code) {
                for (int i = 0; i < ins.definition.operands.length; ++i) {
                    if (ins.definition.operands[i] != 260) continue;
                    ret.add(ins.operands[i]);
                }
            }
        }
        return ret;
    }

    private void setStringUsageType(Map<Integer, String> ret, int strIndex, String usageType) {
        if (ret.containsKey(strIndex)) {
            if (!"name".equals(usageType) && !ret.get(strIndex).equals(usageType)) {
                if ("class".equals(usageType) || ret.get(strIndex).equals("class")) {
                    ret.put(strIndex, "class");
                } else {
                    ret.put(strIndex, "name");
                }
            }
        } else {
            ret.put(strIndex, usageType);
        }
    }

    private void getStringUsageTypes(Map<Integer, String> ret, Traits traits) {
        for (Trait t : traits.traits) {
            MethodBody body;
            int strIndex = this.constants.getMultiname((int)t.name_index).name_index;
            String usageType = "";
            if (t instanceof TraitClass) {
                TraitClass tc = (TraitClass)t;
                this.getStringUsageTypes(ret, this.class_info.get((int)tc.class_info).static_traits);
                this.getStringUsageTypes(ret, this.instance_info.get((int)tc.class_info).instance_traits);
                if (this.instance_info.get((int)tc.class_info).name_index != 0) {
                    this.setStringUsageType(ret, this.constants.getMultiname((int)this.instance_info.get((int)tc.class_info).name_index).name_index, "class");
                }
                if (this.instance_info.get((int)tc.class_info).super_index != 0) {
                    this.setStringUsageType(ret, this.constants.getMultiname((int)this.instance_info.get((int)tc.class_info).super_index).name_index, "class");
                }
                for (int iface : this.instance_info.get((int)tc.class_info).interfaces) {
                    this.setStringUsageType(ret, this.constants.getMultiname((int)iface).name_index, "class");
                }
                usageType = "class";
            }
            if (t instanceof TraitMethodGetterSetter) {
                TraitMethodGetterSetter tm = (TraitMethodGetterSetter)t;
                usageType = "method";
                body = this.findBody(tm.method_info);
                if (body != null) {
                    this.getStringUsageTypes(ret, body.traits);
                }
            }
            if (t instanceof TraitFunction) {
                TraitFunction tf = (TraitFunction)t;
                body = this.findBody(tf.method_info);
                if (body != null) {
                    this.getStringUsageTypes(ret, body.traits);
                }
                usageType = "function";
            }
            if (t instanceof TraitSlotConst) {
                TraitSlotConst ts = (TraitSlotConst)t;
                if (ts.isVar()) {
                    usageType = "var";
                }
                if (ts.isConst()) {
                    usageType = "const";
                }
            }
            this.setStringUsageType(ret, strIndex, usageType);
        }
    }

    public void getStringUsageTypes(Map<Integer, String> ret) {
        for (ScriptInfo script : this.script_info) {
            this.getStringUsageTypes(ret, script.traits);
        }
    }

    public void renameMultiname(int multinameIndex, String newname) {
        if (multinameIndex <= 0 || multinameIndex >= this.constants.getMultinameCount()) {
            throw new IllegalArgumentException("Multiname with index " + multinameIndex + " does not exist");
        }
        Set<Integer> stringUsages = this.getStringUsages();
        Set<Integer> namespaceUsages = this.getNsStringUsages();
        int strIndex = this.constants.getMultiname((int)multinameIndex).name_index;
        if (stringUsages.contains(strIndex) || namespaceUsages.contains(strIndex)) {
            this.constants.getMultiname((int)multinameIndex).name_index = strIndex = this.constants.getStringId(newname, true);
        } else {
            this.constants.setString(strIndex, newname);
        }
    }

    public void deobfuscateIdentifiers(Map<Integer, String> stringUsageTypes, Set<Integer> stringUsages, HashMap<DottedChain, DottedChain> namesMap, RenameType renameType, boolean doClasses) {
        int i;
        Set<Integer> namespaceUsages = this.getNsStringUsages();
        AVM2Deobfuscation deobfuscation = this.getDeobfuscation();
        if (doClasses) {
            for (i = 0; i < this.instance_info.size(); ++i) {
                this.informListeners("deobfuscate", "class " + i + "/" + this.instance_info.size());
                InstanceInfo insti = this.instance_info.get(i);
                if (insti.name_index != 0) {
                    this.constants.getMultiname((int)insti.name_index).name_index = deobfuscation.deobfuscateName(stringUsageTypes, stringUsages, namespaceUsages, namesMap, this.constants.getMultiname((int)insti.name_index).name_index, true, renameType);
                    if (this.constants.getMultiname((int)insti.name_index).namespace_index != 0) {
                        this.constants.getNamespace((int)this.constants.getMultiname((int)insti.name_index).namespace_index).name_index = deobfuscation.deobfuscatePackageName(stringUsageTypes, stringUsages, namesMap, this.constants.getNamespace((int)this.constants.getMultiname((int)insti.name_index).namespace_index).name_index, renameType);
                    }
                }
                if (insti.super_index != 0) {
                    this.constants.getMultiname((int)insti.super_index).name_index = deobfuscation.deobfuscateName(stringUsageTypes, stringUsages, namespaceUsages, namesMap, this.constants.getMultiname((int)insti.super_index).name_index, true, renameType);
                }
                for (int iface : insti.interfaces) {
                    this.constants.getMultiname((int)iface).name_index = deobfuscation.deobfuscateName(stringUsageTypes, stringUsages, namespaceUsages, namesMap, this.constants.getMultiname((int)iface).name_index, true, renameType);
                }
            }
        } else {
            return;
        }
        for (i = 1; i < this.constants.getMultinameCount(); ++i) {
            this.informListeners("deobfuscate", "name " + i + "/" + this.constants.getMultinameCount());
            Multiname m = this.constants.getMultiname(i);
            int strIndex = m.name_index;
            if (m.kind == 9 && strIndex > 0 && "*".equals(this.constants.getString(strIndex))) continue;
            this.constants.getMultiname((int)i).name_index = deobfuscation.deobfuscateName(stringUsageTypes, stringUsages, namespaceUsages, namesMap, this.constants.getMultiname((int)i).name_index, false, renameType);
        }
        for (i = 1; i < this.constants.getNamespaceCount(); ++i) {
            this.informListeners("deobfuscate", "namespace " + i + "/" + this.constants.getNamespaceCount());
            if (this.constants.getNamespace((int)i).kind != 22) continue;
            this.constants.getNamespace((int)i).name_index = deobfuscation.deobfuscatePackageName(stringUsageTypes, stringUsages, namesMap, this.constants.getNamespace((int)i).name_index, renameType);
        }
        for (MethodBody body : this.bodies) {
            for (int ip = 0; ip < body.getCode().code.size(); ++ip) {
                Multiname m;
                int mIndex;
                if (!(body.getCode().code.get((int)ip).definition instanceof CallPropertyIns) || (mIndex = body.getCode().code.get((int)ip).operands[0]) <= 0 || !(m = this.constants.getMultiname(mIndex)).getNameWithNamespace(this.constants, true).toRawString().equals("flash.utils.getDefinitionByName") || ip <= 0 || !(body.getCode().code.get((int)(ip - 1)).definition instanceof PushStringIns)) continue;
                int strIndex = body.getCode().code.get((int)(ip - 1)).operands[0];
                String fullname = this.constants.getString(strIndex);
                String pkg = "";
                String name = fullname;
                boolean hasFourDots = false;
                if (fullname.contains("::")) {
                    pkg = fullname.substring(0, fullname.lastIndexOf("::"));
                    name = fullname.substring(fullname.lastIndexOf("::") + 2);
                    hasFourDots = true;
                } else if (fullname.contains(".")) {
                    pkg = fullname.substring(0, fullname.lastIndexOf(46));
                    name = fullname.substring(fullname.lastIndexOf(46) + 1);
                }
                if (!pkg.isEmpty()) {
                    int pkgStrIndex = this.constants.getStringId(pkg, true);
                    pkgStrIndex = deobfuscation.deobfuscatePackageName(stringUsageTypes, stringUsages, namesMap, pkgStrIndex, renameType);
                    pkg = this.constants.getString(pkgStrIndex);
                }
                int nameStrIndex = this.constants.getStringId(name, true);
                nameStrIndex = deobfuscation.deobfuscateName(stringUsageTypes, stringUsages, namespaceUsages, namesMap, nameStrIndex, true, renameType);
                name = this.constants.getString(nameStrIndex);
                String fullChanged = "";
                if (!pkg.isEmpty()) {
                    fullChanged = pkg + (hasFourDots ? "::" : ".");
                }
                fullChanged = fullChanged + name;
                body.getCode().code.get((int)(ip - 1)).operands[0] = strIndex = this.constants.getStringId(fullChanged, true);
            }
        }
    }

    public boolean hasDecimalSupport() {
        return this.version.minor >= 17;
    }

    public void setDecimalSupport(boolean val) {
        if (val) {
            if (this.version.minor != 17) {
                this.version.minor = 17;
                ((Tag)((Object)this.parentTag)).setModified(true);
            }
        } else if (this.version.minor == 17) {
            this.version.minor = 16;
            ((Tag)((Object)this.parentTag)).setModified(true);
        }
    }

    private boolean minVersionCheck(int minMajor, int minMinor) {
        return this.version.compareTo(new ABCVersion(minMajor, minMinor)) >= 0;
    }

    public boolean hasFloatSupport() {
        return this.minVersionCheck(47, 16);
    }

    public void setFloatSupport(boolean val) {
        if (val) {
            if (this.version.major < 47) {
                this.version.major = 47;
                ((Tag)((Object)this.parentTag)).setModified(true);
            }
        } else if (this.version.major > 46) {
            this.version.major = 46;
            ((Tag)((Object)this.parentTag)).setModified(true);
        }
    }

    public boolean hasExceptionSupport() {
        return this.version.compareTo(new ABCVersion(46, 15)) > 0;
    }

    public ABC(ABCInputStream ais, SWF swf, ABCContainerTag tag) throws IOException {
        this(ais, swf, tag, null, null);
    }

    public ABC(ABCInputStream ais, SWF swf, ABCContainerTag tag, String file, String fileTitle) throws IOException {
        this.parentTag = tag;
        this.file = file;
        this.fileTitle = fileTitle;
        if (file != null || fileTitle != null) {
            this.isOpenable = true;
        }
        try {
            this.read(ais, swf);
        }
        catch (IOException ie) {
            throw new ABCOpenException(AppResources.translate("error.abc.invalid"), ie);
        }
        this.refreshMultinameNamespaceSuffixes();
        this.getMethodIndexing();
        SWFDecompilerPlugin.fireAbcParsed(this, swf);
    }

    private void read(ABCInputStream ais, SWF swf) throws IOException {
        int i;
        int i2;
        int i3;
        int minor_version = ais.readU16("minor_version");
        int major_version = ais.readU16("major_version");
        this.version = new ABCVersion(major_version, minor_version);
        logger.log(Level.FINE, "ABC minor_version: {0}, major_version: {1}", new Object[]{minor_version, major_version});
        ais.newDumpLevel("constant_pool", "cpool_info");
        int constant_int_pool_count = ais.readU30("int_count");
        this.constants.ensureIntCapacity(constant_int_pool_count);
        if (constant_int_pool_count > 1) {
            ais.newDumpLevel("integers", "integer[]");
            for (int i4 = 1; i4 < constant_int_pool_count; ++i4) {
                this.constants.addInt(ais.readS32("int"));
            }
            ais.endDumpLevel();
        }
        int constant_uint_pool_count = ais.readU30("uint_count");
        this.constants.ensureUIntCapacity(constant_uint_pool_count);
        if (constant_uint_pool_count > 1) {
            ais.newDumpLevel("uintegers", "uinteger[]");
            for (int i5 = 1; i5 < constant_uint_pool_count; ++i5) {
                this.constants.addUInt(ais.readU32("uint"));
            }
            ais.endDumpLevel();
        }
        int constant_double_pool_count = ais.readU30("double_count");
        this.constants.ensureDoubleCapacity(constant_double_pool_count);
        if (constant_double_pool_count > 1) {
            ais.newDumpLevel("doubles", "double[]");
            for (int i6 = 1; i6 < constant_double_pool_count; ++i6) {
                this.constants.addDouble(ais.readDouble("double"));
            }
            ais.endDumpLevel();
        }
        if (this.hasDecimalSupport()) {
            int constant_decimal_pool_count = ais.readU30("decimal_count");
            this.constants.ensureDecimalCapacity(constant_decimal_pool_count);
            if (constant_decimal_pool_count > 1) {
                ais.newDumpLevel("decimals", "decimal[]");
                for (i3 = 1; i3 < constant_decimal_pool_count; ++i3) {
                    this.constants.addDecimal(ais.readDecimal("decimal"));
                }
                ais.endDumpLevel();
            }
        }
        if (this.hasFloatSupport()) {
            int constant_float4_pool_count;
            int constant_float_pool_count = ais.readU30("float_count");
            if (constant_float_pool_count > 1) {
                ais.newDumpLevel("floats", "float[]");
                for (i3 = 1; i3 < constant_float_pool_count; ++i3) {
                    this.constants.addFloat(ais.readFloat("float"));
                }
                ais.endDumpLevel();
            }
            if ((constant_float4_pool_count = ais.readU30("float4_count")) > 1) {
                ais.newDumpLevel("floats4", "float4[]");
                for (i2 = 1; i2 < constant_float4_pool_count; ++i2) {
                    this.constants.addFloat4(ais.readFloat4("float4"));
                }
                ais.endDumpLevel();
            }
        }
        int constant_string_pool_count = ais.readU30("string_count");
        this.constants.ensureStringCapacity(constant_string_pool_count);
        if (constant_string_pool_count > 1) {
            ais.newDumpLevel("strings", "string[]");
            for (i3 = 1; i3 < constant_string_pool_count; ++i3) {
                long pos = ais.getPosition();
                this.constants.addString(ais.readString("string"));
            }
            ais.endDumpLevel();
        }
        int constant_namespace_pool_count = ais.readU30("namespace_count");
        this.constants.ensureNamespaceCapacity(constant_namespace_pool_count);
        if (constant_namespace_pool_count > 1) {
            ais.newDumpLevel("namespaces", "namespace[]");
            for (i2 = 1; i2 < constant_namespace_pool_count; ++i2) {
                this.constants.addNamespace(ais.readNamespace("namespace"));
            }
            ais.endDumpLevel();
        }
        int constant_namespace_set_pool_count = ais.readU30("ns_set_count");
        this.constants.ensureNamespaceSetCapacity(constant_namespace_set_pool_count);
        if (constant_namespace_set_pool_count > 1) {
            ais.newDumpLevel("ns_sets", "ns_set[]");
            for (int i7 = 1; i7 < constant_namespace_set_pool_count; ++i7) {
                ais.newDumpLevel("ns_set_infos", "ns_set_info[]");
                this.constants.addNamespaceSet(new NamespaceSet());
                int namespace_count = ais.readU30("count");
                this.constants.getNamespaceSet((int)i7).namespaces = new int[namespace_count];
                for (int j = 0; j < namespace_count; ++j) {
                    this.constants.getNamespaceSet((int)i7).namespaces[j] = ais.readU30("ns");
                }
                ais.endDumpLevel();
            }
            ais.endDumpLevel();
        }
        int constant_multiname_pool_count = ais.readU30("multiname_count");
        this.constants.ensureMultinameCapacity(constant_multiname_pool_count);
        if (constant_multiname_pool_count > 1) {
            ais.newDumpLevel("multiname", "multinames[]");
            for (int i8 = 1; i8 < constant_multiname_pool_count; ++i8) {
                this.constants.addMultiname(ais.readMultiname("multiname"));
            }
            ais.endDumpLevel();
        }
        ais.endDumpLevel();
        int methods_count = ais.readU30("methods_count");
        this.method_info = new ArrayList<MethodInfo>(methods_count);
        for (int i9 = 0; i9 < methods_count; ++i9) {
            this.method_info.add(ais.readMethodInfo("method"));
        }
        int metadata_count = ais.readU30("metadata_count");
        this.metadata_info = new ArrayList<MetadataInfo>(metadata_count);
        for (int i10 = 0; i10 < metadata_count; ++i10) {
            int name_index = ais.readU30("name_index");
            int values_count = ais.readU30("values_count");
            int[] keys = new int[values_count];
            for (int v = 0; v < values_count; ++v) {
                keys[v] = ais.readU30("key");
            }
            int[] values = new int[values_count];
            for (int v = 0; v < values_count; ++v) {
                values[v] = ais.readU30("value");
            }
            this.metadata_info.add(new MetadataInfo(name_index, keys, values));
        }
        int class_count = ais.readU30("class_count");
        this.instance_info = new ArrayList<InstanceInfo>(class_count);
        for (i = 0; i < class_count; ++i) {
            this.instance_info.add(ais.readInstanceInfo("instance"));
        }
        this.class_info = new ArrayList<ClassInfo>(class_count);
        for (i = 0; i < class_count; ++i) {
            ais.newDumpLevel("class", "class_info");
            ClassInfo ci = new ClassInfo(null);
            ci.cinit_index = ais.readU30("cinit_index");
            ci.static_traits = ais.readTraits("static_traits");
            this.class_info.add(ci);
            ais.endDumpLevel();
        }
        int script_count = ais.readU30("script_count");
        this.script_info = new ArrayList<ScriptInfo>(script_count);
        for (int i11 = 0; i11 < script_count; ++i11) {
            ais.newDumpLevel("script", "script_info");
            ScriptInfo si = new ScriptInfo(null);
            si.init_index = ais.readU30("init_index");
            si.traits = ais.readTraits("traits");
            this.script_info.add(si);
            ais.endDumpLevel();
            si.setModified(false);
        }
        int bodies_count = ais.readU30("bodies_count");
        this.bodies = new ArrayList<MethodBody>(bodies_count);
        for (int i12 = 0; i12 < bodies_count; ++i12) {
            DumpInfo di = ais.dumpInfo;
            DumpInfoSpecial dis = (DumpInfoSpecial)ais.newDumpLevel("method_body", "method_body_info", DumpInfoSpecialType.ABC_METHOD_BODY);
            MethodBody mb = new MethodBody(this, null, null, null);
            try {
                mb.method_info = ais.readU30("method_info");
                if (dis != null) {
                    dis.specialValue = mb.method_info;
                }
                mb.max_stack = ais.readU30("max_stack");
                mb.max_regs = ais.readU30("max_regs");
                mb.init_scope_depth = ais.readU30("init_scope_depth");
                mb.max_scope_depth = ais.readU30("max_scope_depth");
                int code_length = ais.readU30("code_length");
                mb.setCodeBytes(ais.readBytes(code_length, "code", DumpInfoSpecialType.ABC_CODE));
                int ex_count = ais.readU30("ex_count");
                mb.exceptions = new ABCException[ex_count];
                for (int j = 0; j < ex_count; ++j) {
                    ABCException abce = new ABCException();
                    abce.start = ais.readU30("start");
                    abce.end = ais.readU30("end");
                    abce.target = ais.readU30("target");
                    abce.type_index = ais.readU30("type_index");
                    abce.name_index = this.hasExceptionSupport() ? ais.readU30("name_index") : 0;
                    mb.exceptions[j] = abce;
                }
                mb.traits = ais.readTraits("traits");
                this.bodies.add(mb);
                ais.endDumpLevel();
            }
            catch (EndOfStreamException ex) {
                logger.log(Level.SEVERE, "MethodBody reading: End of stream", ex);
                ais.endDumpLevelUntil(di);
                break;
            }
            SWFDecompilerPlugin.fireMethodBodyParsed(this, mb, swf);
        }
    }

    public void saveToStream(OutputStream os) throws IOException {
        int i;
        ABCOutputStream aos = new ABCOutputStream(os);
        aos.writeU16(this.version.minor);
        aos.writeU16(this.version.major);
        aos.writeU30(this.constants.getIntCount());
        for (i = 1; i < this.constants.getIntCount(); ++i) {
            aos.writeS32(this.constants.getInt(i));
        }
        aos.writeU30(this.constants.getUIntCount());
        for (i = 1; i < this.constants.getUIntCount(); ++i) {
            aos.writeU32(this.constants.getUInt(i));
        }
        aos.writeU30(this.constants.getDoubleCount());
        for (i = 1; i < this.constants.getDoubleCount(); ++i) {
            aos.writeDouble(this.constants.getDouble(i));
        }
        if (this.hasDecimalSupport()) {
            aos.writeU30(this.constants.getDecimalCount());
            for (i = 1; i < this.constants.getDecimalCount(); ++i) {
                aos.writeDecimal(this.constants.getDecimal(i));
            }
        }
        if (this.hasFloatSupport()) {
            aos.writeU30(this.constants.getFloatCount());
            for (i = 1; i < this.constants.getFloatCount(); ++i) {
                aos.writeFloat(this.constants.getFloat(i).floatValue());
            }
            aos.writeU30(this.constants.getFloat4Count());
            for (i = 1; i < this.constants.getFloat4Count(); ++i) {
                aos.writeFloat4(this.constants.getFloat4(i));
            }
        }
        aos.writeU30(this.constants.getStringCount());
        for (i = 1; i < this.constants.getStringCount(); ++i) {
            aos.writeString(this.constants.getString(i));
        }
        aos.writeU30(this.constants.getNamespaceCount());
        for (i = 1; i < this.constants.getNamespaceCount(); ++i) {
            aos.writeNamespace(this.constants.getNamespace(i));
        }
        aos.writeU30(this.constants.getNamespaceSetCount());
        for (i = 1; i < this.constants.getNamespaceSetCount(); ++i) {
            aos.writeU30(this.constants.getNamespaceSet((int)i).namespaces.length);
            for (int j = 0; j < this.constants.getNamespaceSet((int)i).namespaces.length; ++j) {
                aos.writeU30(this.constants.getNamespaceSet((int)i).namespaces[j]);
            }
        }
        aos.writeU30(this.constants.getMultinameCount());
        for (i = 1; i < this.constants.getMultinameCount(); ++i) {
            aos.writeMultiname(this.constants.getMultiname(i));
        }
        aos.writeU30(this.method_info.size());
        for (MethodInfo mi : this.method_info) {
            aos.writeMethodInfo(mi);
        }
        aos.writeU30(this.metadata_info.size());
        for (MetadataInfo mi : this.metadata_info) {
            int j;
            aos.writeU30(mi.name_index);
            aos.writeU30(mi.values.length);
            for (j = 0; j < mi.values.length; ++j) {
                aos.writeU30(mi.keys[j]);
            }
            for (j = 0; j < mi.values.length; ++j) {
                aos.writeU30(mi.values[j]);
            }
        }
        aos.writeU30(this.class_info.size());
        for (InstanceInfo ii : this.instance_info) {
            aos.writeInstanceInfo(ii);
        }
        for (ClassInfo ci : this.class_info) {
            aos.writeU30(ci.cinit_index);
            aos.writeTraits(ci.static_traits);
        }
        aos.writeU30(this.script_info.size());
        for (ScriptInfo si : this.script_info) {
            aos.writeU30(si.init_index);
            aos.writeTraits(si.traits);
        }
        aos.writeU30(this.bodies.size());
        for (MethodBody mb : this.bodies) {
            aos.writeU30(mb.method_info);
            aos.writeU30(mb.max_stack);
            aos.writeU30(mb.max_regs);
            aos.writeU30(mb.init_scope_depth);
            aos.writeU30(mb.max_scope_depth);
            byte[] codeBytes = mb.getCodeBytes();
            aos.writeU30(codeBytes.length);
            aos.write(codeBytes);
            aos.writeU30(mb.exceptions.length);
            for (int j = 0; j < mb.exceptions.length; ++j) {
                aos.writeU30(mb.exceptions[j].start);
                aos.writeU30(mb.exceptions[j].end);
                aos.writeU30(mb.exceptions[j].target);
                aos.writeU30(mb.exceptions[j].type_index);
                aos.writeU30(mb.exceptions[j].name_index);
            }
            aos.writeTraits(mb.traits);
        }
    }

    public MethodBody findBody(MethodInfo methodInfo) {
        return this.getMethodIndexing().findMethodBody(methodInfo);
    }

    public MethodBody findBody(int methodInfo) {
        return this.getMethodIndexing().findMethodBody(methodInfo);
    }

    public int findBodyIndex(MethodInfo methodInfo) {
        return this.getMethodIndexing().findMethodBodyIndex(methodInfo);
    }

    public int findBodyIndex(int methodInfo) {
        return this.getMethodIndexing().findMethodBodyIndex(methodInfo);
    }

    public MethodBody findBodyClassInitializerByClass(String classNameWithSuffix) {
        for (int i = 0; i < this.instance_info.size(); ++i) {
            MethodBody body;
            if (!classNameWithSuffix.equals(this.constants.getMultiname(this.instance_info.get((int)i).name_index).getName(this.constants, null, true, true)) || (body = this.findBody(this.class_info.get((int)i).cinit_index)) == null) continue;
            return body;
        }
        return null;
    }

    public MethodBody findBodyInstanceInitializerByClass(String classNameWithSuffix) {
        for (int i = 0; i < this.instance_info.size(); ++i) {
            MethodBody body;
            if (!classNameWithSuffix.equals(this.constants.getMultiname(this.instance_info.get((int)i).name_index).getName(this.constants, null, true, true)) || (body = this.findBody(this.instance_info.get((int)i).iinit_index)) == null) continue;
            return body;
        }
        return null;
    }

    public MethodBody findBodyByClassAndName(String classNameWithSuffix, String methodNameWithSuffix) {
        for (int i = 0; i < this.instance_info.size(); ++i) {
            MethodBody body;
            TraitMethodGetterSetter t2;
            if (!classNameWithSuffix.equals(this.constants.getMultiname(this.instance_info.get((int)i).name_index).getName(this.constants, null, true, true))) continue;
            for (Trait t : this.instance_info.get((int)i).instance_traits.traits) {
                if (!(t instanceof TraitMethodGetterSetter) || !methodNameWithSuffix.equals((t2 = (TraitMethodGetterSetter)t).getName(this).getName(this.constants, null, true, true)) || (body = this.findBody(t2.method_info)) == null) continue;
                return body;
            }
            for (Trait t : this.class_info.get((int)i).static_traits.traits) {
                if (!(t instanceof TraitMethodGetterSetter) || !methodNameWithSuffix.equals((t2 = (TraitMethodGetterSetter)t).getName(this).getName(this.constants, null, true, true)) || (body = this.findBody(t2.method_info)) == null) continue;
                return body;
            }
        }
        return null;
    }

    public boolean isStaticTraitId(int classIndex, int traitId) {
        if (classIndex == -1) {
            return true;
        }
        if (traitId < this.class_info.get((int)classIndex).static_traits.traits.size()) {
            return true;
        }
        return traitId >= this.class_info.get((int)classIndex).static_traits.traits.size() + this.instance_info.get((int)classIndex).instance_traits.traits.size();
    }

    public Trait findTraitByTraitId(int classIndex, int traitId) {
        if (classIndex == -1) {
            return null;
        }
        List<Trait> staticTraits = this.class_info.get((int)classIndex).static_traits.traits;
        if (traitId >= 0 && traitId < staticTraits.size()) {
            return staticTraits.get(traitId);
        }
        List<Trait> instanceTraits = this.instance_info.get((int)classIndex).instance_traits.traits;
        if (traitId >= 0 && traitId < staticTraits.size() + instanceTraits.size()) {
            return instanceTraits.get(traitId -= staticTraits.size());
        }
        return null;
    }

    public int findMethodIdByTraitId(int classIndex, int traitId) {
        if (classIndex == -1) {
            return -1;
        }
        List<Trait> staticTraits = this.class_info.get((int)classIndex).static_traits.traits;
        if (traitId < staticTraits.size()) {
            if (staticTraits.get(traitId) instanceof TraitMethodGetterSetter) {
                return ((TraitMethodGetterSetter)staticTraits.get((int)traitId)).method_info;
            }
            return -1;
        }
        List<Trait> instanceTraits = this.instance_info.get((int)classIndex).instance_traits.traits;
        if (traitId < staticTraits.size() + instanceTraits.size()) {
            if (instanceTraits.get(traitId -= staticTraits.size()) instanceof TraitMethodGetterSetter) {
                return ((TraitMethodGetterSetter)instanceTraits.get((int)traitId)).method_info;
            }
            return -1;
        }
        if ((traitId -= staticTraits.size() + instanceTraits.size()) == 0) {
            return this.instance_info.get((int)classIndex).iinit_index;
        }
        if (traitId == 1) {
            return this.class_info.get((int)classIndex).cinit_index;
        }
        return -1;
    }

    private Map<String, DottedChain> getNamespaceMap() {
        if (this.namespaceMap == null) {
            HashMap<String, DottedChain> map = new HashMap<String, DottedChain>();
            for (ScriptInfo si : this.script_info) {
                for (Trait t : si.traits.traits) {
                    TraitSlotConst s;
                    if (!(t instanceof TraitSlotConst) || !(s = (TraitSlotConst)t).isNamespace()) continue;
                    String key = this.constants.getNamespace(s.value_index).getName(this.constants).toRawString();
                    DottedChain val = this.constants.getMultiname(s.name_index).getNameWithNamespace(this.constants, true);
                    map.put(key, val);
                }
            }
            this.namespaceMap = map;
        }
        return this.namespaceMap;
    }

    private AVM2Deobfuscation getDeobfuscation() {
        if (this.deobfuscation == null) {
            this.deobfuscation = new AVM2Deobfuscation(this.getSwf(), this.constants);
        }
        return this.deobfuscation;
    }

    public final ABCMethodIndexing getMethodIndexing() {
        if (this.abcMethodIndexing == null) {
            this.abcMethodIndexing = new ABCMethodIndexing(this);
        }
        return this.abcMethodIndexing;
    }

    public void resetMethodIndexing() {
        this.abcMethodIndexing = null;
    }

    public DottedChain nsValueToName(String valueStr) {
        if (valueStr == null) {
            return DottedChain.EMPTY;
        }
        if (this.getNamespaceMap().containsKey(valueStr)) {
            return this.getNamespaceMap().get(valueStr);
        }
        DottedChain ns = this.getDeobfuscation().builtInNs(valueStr);
        if (ns == null) {
            return DottedChain.EMPTY;
        }
        return ns;
    }

    public List<ScriptPack> getScriptPacks(String packagePrefix, List<ABC> allAbcs) {
        ArrayList<ScriptPack> ret = new ArrayList<ScriptPack>();
        for (int i = 0; i < this.script_info.size(); ++i) {
            if (this.script_info.get((int)i).deleted) continue;
            ret.addAll(this.script_info.get(i).getPacks(this, i, packagePrefix, allAbcs));
        }
        return ret;
    }

    public void dump(OutputStream os) {
        int i;
        Utf8PrintWriter output = new Utf8PrintWriter(os);
        this.constants.dump(output);
        for (i = 0; i < this.method_info.size(); ++i) {
            output.println("MethodInfo[" + i + "]:" + this.method_info.get(i).toString(this.constants, new ArrayList<DottedChain>()));
        }
        for (i = 0; i < this.metadata_info.size(); ++i) {
            output.println("MetadataInfo[" + i + "]:" + this.metadata_info.get(i).toString(this.constants));
        }
        for (i = 0; i < this.instance_info.size(); ++i) {
            output.println("InstanceInfo[" + i + "]:" + this.instance_info.get(i).toString(this, new ArrayList<DottedChain>()));
        }
        for (i = 0; i < this.class_info.size(); ++i) {
            output.println("ClassInfo[" + i + "]:" + this.class_info.get(i).toString(this, new ArrayList<DottedChain>()));
        }
        for (i = 0; i < this.script_info.size(); ++i) {
            output.println("ScriptInfo[" + i + "]:" + this.script_info.get(i).toString(this, new ArrayList<DottedChain>()));
        }
        for (i = 0; i < this.bodies.size(); ++i) {
            output.println("MethodBody[" + i + "]:");
        }
    }

    private void checkMultinameUsedInMethod(int multinameIndex, boolean exactMatch, int methodInfo, List<MultinameUsage> ret, int scriptIndex, int classIndex, int traitIndex, int traitsType, boolean isInitializer, Traits traits, int parentTraitIndex) {
        MethodBody body;
        for (int p = 0; p < this.method_info.get((int)methodInfo).param_types.length; ++p) {
            if (!this.isSameName(multinameIndex, this.method_info.get((int)methodInfo).param_types[p], exactMatch)) continue;
            ret.add(new MethodParamsMultinameUsage(this, multinameIndex, scriptIndex, classIndex, traitIndex, traitsType, isInitializer, traits, parentTraitIndex));
            break;
        }
        if (this.isSameName(multinameIndex, this.method_info.get((int)methodInfo).ret_type, exactMatch)) {
            ret.add(new MethodReturnTypeMultinameUsage(this, multinameIndex, scriptIndex, classIndex, traitIndex, traitsType, isInitializer, traits, parentTraitIndex));
        }
        if ((body = this.findBody(methodInfo)) != null) {
            this.findMultinameUsageInTraits(body.traits, multinameIndex, exactMatch, traitsType, scriptIndex, classIndex, ret, traitIndex);
            for (ABCException e : body.exceptions) {
                if (!this.isSameName(multinameIndex, e.name_index, exactMatch) && !this.isSameName(multinameIndex, e.type_index, exactMatch)) continue;
                ret.add(new MethodBodyMultinameUsage(this, multinameIndex, scriptIndex, classIndex, traitIndex, traitsType, isInitializer, traits, parentTraitIndex));
                return;
            }
            for (AVM2Instruction ins : body.getCode().code) {
                for (int o = 0; o < ins.definition.operands.length; ++o) {
                    if (ins.definition.operands[o] != 257 || !this.isSameName(multinameIndex, ins.operands[o], exactMatch)) continue;
                    ret.add(new MethodBodyMultinameUsage(this, multinameIndex, scriptIndex, classIndex, traitIndex, traitsType, isInitializer, traits, parentTraitIndex));
                    return;
                }
            }
        }
    }

    private void checkAllMultinameUsedInMethod(int methodInfo, List<List<MultinameUsage>> ret, int scriptIndex, int classIndex, int traitIndex, int traitsType, boolean isInitializer, Traits traits, int parentTraitIndex) {
        boolean[] foundMultinames = new boolean[this.constants.getMultinameCount()];
        for (int p = 0; p < this.method_info.get((int)methodInfo).param_types.length; ++p) {
            int methodParamsMultinameIndex = this.method_info.get((int)methodInfo).param_types[p];
            if (foundMultinames[methodParamsMultinameIndex]) continue;
            ret.get(methodParamsMultinameIndex).add(new MethodParamsMultinameUsage(this, methodParamsMultinameIndex, scriptIndex, classIndex, traitIndex, traitsType, isInitializer, traits, parentTraitIndex));
            foundMultinames[methodParamsMultinameIndex] = true;
        }
        int methodReturnTypeMultinameIndex = this.method_info.get((int)methodInfo).ret_type;
        ret.get(methodReturnTypeMultinameIndex).add(new MethodReturnTypeMultinameUsage(this, methodReturnTypeMultinameIndex, scriptIndex, classIndex, traitIndex, traitsType, isInitializer, traits, parentTraitIndex));
        MethodBody body = this.findBody(methodInfo);
        if (body != null) {
            this.findAllMultinameUsageInTraits(body.traits, traitsType, scriptIndex, classIndex, ret, traitIndex);
            foundMultinames = new boolean[this.constants.getMultinameCount()];
            for (ABCException e : body.exceptions) {
                if (!foundMultinames[e.name_index]) {
                    ret.get(e.name_index).add(new MethodBodyMultinameUsage(this, e.name_index, scriptIndex, classIndex, traitIndex, traitsType, isInitializer, traits, parentTraitIndex));
                    foundMultinames[e.name_index] = true;
                }
                if (foundMultinames[e.type_index]) continue;
                ret.get(e.type_index).add(new MethodBodyMultinameUsage(this, e.type_index, scriptIndex, classIndex, traitIndex, traitsType, isInitializer, traits, parentTraitIndex));
                foundMultinames[e.type_index] = true;
            }
            for (AVM2Instruction ins : body.getCode().code) {
                for (int o = 0; o < ins.definition.operands.length; ++o) {
                    int mi;
                    if (ins.definition.operands[o] != 257 || (mi = ins.operands[o]) >= foundMultinames.length || foundMultinames[mi]) continue;
                    ret.get(mi).add(new MethodBodyMultinameUsage(this, mi, scriptIndex, classIndex, traitIndex, traitsType, isInitializer, traits, parentTraitIndex));
                    foundMultinames[mi] = true;
                }
            }
        }
    }

    private boolean isSameName(int expectedQNameIndex, int checkedNameIndex, boolean exactMatch) {
        if (expectedQNameIndex == checkedNameIndex) {
            return true;
        }
        if (exactMatch) {
            return false;
        }
        Multiname expectedQName = this.constants.getMultiname(expectedQNameIndex);
        Multiname checkedName = this.constants.getMultiname(checkedNameIndex);
        if (checkedName == null) {
            return false;
        }
        if (expectedQName.name_index != checkedName.name_index) {
            return false;
        }
        if (checkedName.kind == 7) {
            return expectedQName.namespace_index == checkedName.namespace_index;
        }
        if (checkedName.kind != 9) {
            return false;
        }
        for (int ns : this.constants.getNamespaceSet((int)checkedName.namespace_set_index).namespaces) {
            if (ns != expectedQName.namespace_index) continue;
            return true;
        }
        return false;
    }

    private void findMultinameUsageInTraits(Traits traits, int multinameIndex, boolean exactMatch, int traitsType, int scriptIndex, int classIndex, List<MultinameUsage> ret, int parentTraitIndex) {
        for (int t = 0; t < traits.traits.size(); ++t) {
            if (traits.traits.get(t) instanceof TraitClass) {
                TraitClass tc = (TraitClass)traits.traits.get(t);
                if (this.isSameName(multinameIndex, tc.name_index, exactMatch)) {
                    ret.add(new ClassNameMultinameUsage(this, multinameIndex, tc.class_info, scriptIndex));
                }
                int c = tc.class_info;
                if (this.isSameName(multinameIndex, this.instance_info.get((int)c).super_index, exactMatch)) {
                    ret.add(new SuperClassMultinameUsage(this, multinameIndex, c, scriptIndex));
                }
                for (int i = 0; i < this.instance_info.get((int)c).interfaces.length; ++i) {
                    if (!this.isSameName(multinameIndex, this.instance_info.get((int)c).interfaces[i], exactMatch)) continue;
                    ret.add(new SuperInterfaceMultinameUsage(this, multinameIndex, c, scriptIndex));
                }
                this.checkMultinameUsedInMethod(multinameIndex, exactMatch, this.instance_info.get((int)c).iinit_index, ret, -1, c, 0, 2, true, null, -1);
                this.checkMultinameUsedInMethod(multinameIndex, exactMatch, this.class_info.get((int)c).cinit_index, ret, -1, c, 0, 1, true, null, -1);
                this.findMultinameUsageInTraits(this.instance_info.get((int)c).instance_traits, multinameIndex, exactMatch, 2, -1, c, ret, -1);
                this.findMultinameUsageInTraits(this.class_info.get((int)c).static_traits, multinameIndex, exactMatch, 1, -1, c, ret, -1);
            }
            if (traits.traits.get(t) instanceof TraitSlotConst) {
                TraitSlotConst tsc = (TraitSlotConst)traits.traits.get(t);
                if (this.isSameName(multinameIndex, tsc.name_index, exactMatch)) {
                    ret.add(new ConstVarNameMultinameUsage(this, multinameIndex, scriptIndex, classIndex, t, traitsType, traits, parentTraitIndex));
                }
                if (this.isSameName(multinameIndex, tsc.type_index, exactMatch)) {
                    ret.add(new ConstVarTypeMultinameUsage(this, multinameIndex, scriptIndex, classIndex, t, traitsType, traits, parentTraitIndex));
                }
            }
            if (!(traits.traits.get(t) instanceof TraitMethodGetterSetter)) continue;
            TraitMethodGetterSetter tmgs = (TraitMethodGetterSetter)traits.traits.get(t);
            if (this.isSameName(multinameIndex, tmgs.name_index, exactMatch)) {
                ret.add(new MethodNameMultinameUsage(this, multinameIndex, scriptIndex, classIndex, t, traitsType, false, traits, parentTraitIndex));
            }
            this.checkMultinameUsedInMethod(multinameIndex, exactMatch, tmgs.method_info, ret, scriptIndex, classIndex, t, traitsType, false, traits, parentTraitIndex);
        }
    }

    private void findAllMultinameUsageInTraits(Traits traits, int traitsType, int scriptIndex, int classIndex, List<List<MultinameUsage>> ret, int parentTraitIndex) {
        for (int t = 0; t < traits.traits.size(); ++t) {
            if (traits.traits.get(t) instanceof TraitClass) {
                TraitClass tc = (TraitClass)traits.traits.get(t);
                ret.get(tc.name_index).add(new ClassNameMultinameUsage(this, tc.name_index, tc.class_info, scriptIndex));
                int c = tc.class_info;
                int classNameMultinameIndex = this.instance_info.get((int)c).name_index;
                ret.get(classNameMultinameIndex).add(new ClassNameMultinameUsage(this, classNameMultinameIndex, c, scriptIndex));
                int extendsMultinameIndex = this.instance_info.get((int)c).super_index;
                ret.get(extendsMultinameIndex).add(new SuperClassMultinameUsage(this, extendsMultinameIndex, c, scriptIndex));
                for (int i = 0; i < this.instance_info.get((int)c).interfaces.length; ++i) {
                    int implementsMultinameIndex = this.instance_info.get((int)c).interfaces[i];
                    ret.get(implementsMultinameIndex).add(new SuperInterfaceMultinameUsage(this, implementsMultinameIndex, c, scriptIndex));
                }
                this.checkAllMultinameUsedInMethod(this.instance_info.get((int)c).iinit_index, ret, -1, c, 0, 2, true, null, -1);
                this.checkAllMultinameUsedInMethod(this.class_info.get((int)c).cinit_index, ret, -1, c, 0, 1, true, null, -1);
                this.findAllMultinameUsageInTraits(this.instance_info.get((int)c).instance_traits, 2, -1, c, ret, -1);
                this.findAllMultinameUsageInTraits(this.class_info.get((int)c).static_traits, 1, -1, c, ret, -1);
            }
            if (traits.traits.get(t) instanceof TraitSlotConst) {
                TraitSlotConst tsc = (TraitSlotConst)traits.traits.get(t);
                ret.get(tsc.name_index).add(new ConstVarNameMultinameUsage(this, tsc.name_index, scriptIndex, classIndex, t, traitsType, traits, parentTraitIndex));
                ret.get(tsc.type_index).add(new ConstVarTypeMultinameUsage(this, tsc.type_index, scriptIndex, classIndex, t, traitsType, traits, parentTraitIndex));
            }
            if (!(traits.traits.get(t) instanceof TraitMethodGetterSetter)) continue;
            TraitMethodGetterSetter tmgs = (TraitMethodGetterSetter)traits.traits.get(t);
            ret.get(tmgs.name_index).add(new MethodNameMultinameUsage(this, tmgs.name_index, scriptIndex, classIndex, t, traitsType, false, traits, parentTraitIndex));
            this.checkAllMultinameUsedInMethod(tmgs.method_info, ret, scriptIndex, classIndex, t, traitsType, false, traits, parentTraitIndex);
        }
    }

    public List<MultinameUsage> findMultinameDefinition(int multinameIndex) {
        List<MultinameUsage> usages = this.findMultinameUsage(multinameIndex, false);
        ArrayList<MultinameUsage> ret = new ArrayList<MultinameUsage>();
        for (MultinameUsage u : usages) {
            if (!(u instanceof DefinitionUsage)) continue;
            ret.add(u);
        }
        return ret;
    }

    public List<MultinameUsage> findMultinameUsageOfNamespace(int namespaceIndex) {
        ArrayList<MultinameUsage> ret = new ArrayList<MultinameUsage>();
        for (int multinameIndex = 1; multinameIndex < this.constants.getMultinameCount(); ++multinameIndex) {
            if (this.constants.getMultiname((int)multinameIndex).namespace_index != namespaceIndex) continue;
            ret.addAll(this.findMultinameUsage(multinameIndex, false));
        }
        return ret;
    }

    public Set<MultinameUsage> getCollidingMultinameUsages() {
        for (int multinameIndex = 1; multinameIndex < this.constants.getMultinameCount(); ++multinameIndex) {
            this.constants.getMultiname(multinameIndex).setDisplayNamespace(false);
        }
        HashMap<String, ArrayList<Integer>> nameToQNameIndices = new HashMap<String, ArrayList<Integer>>();
        for (int multinameIndex = 1; multinameIndex < this.constants.getMultinameCount(); ++multinameIndex) {
            Multiname m = this.constants.getMultiname(multinameIndex);
            if (m.kind != 7 && m.kind != 13) continue;
            String name = m.getName(this.constants, new ArrayList<DottedChain>(), true, false);
            ArrayList<Integer> indices = (ArrayList<Integer>)nameToQNameIndices.get(name);
            if (indices == null) {
                indices = new ArrayList<Integer>();
                nameToQNameIndices.put(name, indices);
            }
            indices.add(multinameIndex);
        }
        HashSet<MultinameUsage> collidingUsages = new HashSet<MultinameUsage>();
        List<List<MultinameUsage>> usagesList = this.findAllMultinameUsage();
        for (String name : nameToQNameIndices.keySet()) {
            List multinameIndices = (List)nameToQNameIndices.get(name);
            if (multinameIndices.size() <= 1) continue;
            ArrayList<List<MultinameUsage>> allUsages = new ArrayList<List<MultinameUsage>>();
            Iterator iterator = multinameIndices.iterator();
            while (iterator.hasNext()) {
                int multinameIndex = (Integer)iterator.next();
                List<MultinameUsage> usages = usagesList.get(multinameIndex);
                for (MultinameUsage usage : usages) {
                    for (List list : allUsages) {
                        for (MultinameUsage prevUsage : list) {
                            if (!prevUsage.collides(usage)) continue;
                            collidingUsages.add(usage);
                            collidingUsages.add(prevUsage);
                        }
                    }
                }
                allUsages.add(usages);
            }
        }
        return collidingUsages;
    }

    public void refreshMultinameNamespaceSuffixes() {
        Set<MultinameUsage> collidingMultinameUsages = this.getCollidingMultinameUsages();
        HashSet<Integer> collidingMultinameIndices = new HashSet<Integer>();
        for (MultinameUsage col : collidingMultinameUsages) {
            collidingMultinameIndices.add(col.getMultinameIndex());
        }
        Iterator<MultinameUsage> iterator = collidingMultinameIndices.iterator();
        while (iterator.hasNext()) {
            int multinameIndex = (Integer)((Object)iterator.next());
            this.constants.getMultiname(multinameIndex).setDisplayNamespace(true);
        }
    }

    public List<MultinameUsage> findMultinameUsage(int multinameIndex, boolean exactMatch) {
        ArrayList<MultinameUsage> ret = new ArrayList<MultinameUsage>();
        if (multinameIndex == 0) {
            return ret;
        }
        for (int s = 0; s < this.script_info.size(); ++s) {
            this.checkMultinameUsedInMethod(multinameIndex, exactMatch, this.script_info.get((int)s).init_index, ret, s, -1, 0, 3, true, null, -1);
            this.findMultinameUsageInTraits(this.script_info.get((int)s).traits, multinameIndex, exactMatch, 3, s, -1, ret, -1);
        }
        block1: for (int t = 1; t < this.constants.getMultinameCount(); ++t) {
            Multiname multiname = this.constants.getMultiname(t);
            if (multiname.kind != 29) continue;
            if (multiname.qname_index == multinameIndex) {
                ret.add(new TypeNameMultinameUsage(this, multinameIndex, t, -1));
                continue;
            }
            for (int mp : multiname.params) {
                if (mp != multinameIndex) continue;
                ret.add(new TypeNameMultinameUsage(this, multinameIndex, t, -1));
                continue block1;
            }
        }
        return ret;
    }

    public List<List<MultinameUsage>> findAllMultinameUsage() {
        ArrayList<List<MultinameUsage>> ret = new ArrayList<List<MultinameUsage>>();
        for (int i = 0; i < this.constants.getMultinameCount(); ++i) {
            ret.add(new ArrayList());
        }
        for (int s = 0; s < this.script_info.size(); ++s) {
            this.checkAllMultinameUsedInMethod(this.script_info.get((int)s).init_index, ret, s, -1, 0, 3, true, null, -1);
            this.findAllMultinameUsageInTraits(this.script_info.get((int)s).traits, 3, s, -1, ret, -1);
        }
        boolean[] foundMultinames = new boolean[this.constants.getMultinameCount()];
        for (int t = 1; t < this.constants.getMultinameCount(); ++t) {
            Multiname multiname = this.constants.getMultiname(t);
            if (multiname.kind != 29) continue;
            if (!foundMultinames[multiname.qname_index]) {
                ((List)ret.get(multiname.qname_index)).add(new TypeNameMultinameUsage(this, multiname.qname_index, t, -1));
                foundMultinames[multiname.qname_index] = true;
            }
            for (int mp : multiname.params) {
                if (foundMultinames[mp]) continue;
                ((List)ret.get(mp)).add(new TypeNameMultinameUsage(this, mp, t, -1));
                foundMultinames[mp] = true;
            }
        }
        return ret;
    }

    public int findMethodInfoByName(int classId, String methodNameWithSuffix) {
        if (classId > -1) {
            for (Trait t : this.instance_info.get((int)classId).instance_traits.traits) {
                if (!(t instanceof TraitMethodGetterSetter) || !t.getName(this).getName(this.constants, null, true, true).equals(methodNameWithSuffix)) continue;
                return ((TraitMethodGetterSetter)t).method_info;
            }
        }
        return -1;
    }

    public int findMethodBodyByName(int classId, String methodNameWithSuffix) {
        if (classId > -1) {
            for (Trait t : this.instance_info.get((int)classId).instance_traits.traits) {
                if (!(t instanceof TraitMethodGetterSetter) || !t.getName(this).getName(this.constants, null, true, true).equals(methodNameWithSuffix)) continue;
                return this.findBodyIndex(((TraitMethodGetterSetter)t).method_info);
            }
        }
        return -1;
    }

    public int findMethodBodyByName(String className, String methodName) {
        int classId = this.findClassByName(className);
        return this.findMethodBodyByName(classId, methodName);
    }

    public int findClassByName(DottedChain name) {
        String str = name == null ? null : name.toRawString();
        return this.findClassByName(str);
    }

    public int findClassByName(String nameWithSuffix) {
        for (int c = 0; c < this.instance_info.size(); ++c) {
            DottedChain s;
            if (this.instance_info.get((int)c).deleted || !nameWithSuffix.equals((s = this.constants.getMultiname(this.instance_info.get((int)c).name_index).getNameWithNamespace(this.constants, true)).toRawString())) continue;
            return c;
        }
        return -1;
    }

    public List<ScriptPack> findScriptPacksByPath(String name, List<ABC> allAbcs) {
        ArrayList<ScriptPack> ret = new ArrayList<ScriptPack>();
        List<ScriptPack> allPacks = this.getScriptPacks(null, allAbcs);
        if (name.endsWith(".**") || name.equals("**") || name.endsWith(".++") || name.equals("++")) {
            name = name.substring(0, name.length() - 2);
            for (ScriptPack en : allPacks) {
                if (!en.getClassPath().toString().startsWith(name)) continue;
                ret.add(en);
            }
        } else if (name.endsWith(".*") || name.equals("*") || name.endsWith(".+") || name.equals("+")) {
            name = name.substring(0, name.length() - 1);
            for (ScriptPack en : allPacks) {
                String rem;
                String classPathStr = en.getClassPath().toString();
                if (!classPathStr.startsWith(name) || (rem = name.isEmpty() ? classPathStr : classPathStr.substring(name.length())).contains(".")) continue;
                ret.add(en);
            }
        } else {
            ScriptPack p = this.findScriptPackByPath(name, allAbcs);
            if (p != null) {
                ret.add(p);
            }
        }
        return ret;
    }

    public ScriptPack findScriptPackByPath(String name, List<ABC> allAbcs) {
        List<ScriptPack> packs = this.getScriptPacks(null, allAbcs);
        for (ScriptPack en : packs) {
            if (!en.getClassPath().toString().equals(name)) continue;
            return en;
        }
        return null;
    }

    public int getGlobalTraitId(TraitType type, boolean isStatic, int classIndex, int index) {
        if (type == TraitType.INITIALIZER) {
            if (!isStatic) {
                return -1;
            }
            return -2;
        }
        if (type == TraitType.SCRIPT_INITIALIZER) {
            return -3;
        }
        if (classIndex == -1) {
            return index;
        }
        if (isStatic) {
            return index;
        }
        return this.class_info.get((int)classIndex).static_traits.traits.size() + index;
    }

    private void removeClassFromTraits(Traits traits, int index) {
        for (Trait t : traits.traits) {
            if (!(t instanceof TraitClass)) continue;
            TraitClass tc = (TraitClass)t;
            this.removeClassFromTraits(this.instance_info.get((int)tc.class_info).instance_traits, index);
            this.removeClassFromTraits(this.class_info.get((int)tc.class_info).static_traits, index);
            if (tc.class_info <= index) continue;
            --tc.class_info;
        }
    }

    public void addClass(ClassInfo ci, InstanceInfo ii, int index) {
        for (MethodBody b : this.bodies) {
            for (AVM2Instruction ins : b.getCode().code) {
                for (int i = 0; i < ins.definition.operands.length; ++i) {
                    if (ins.definition.operands[i] != 269 || ins.operands[i] < index) continue;
                    ins.setOperand(i, ins.operands[i] + 1, b.getCode(), b);
                }
            }
        }
        for (ScriptInfo si : this.script_info) {
            this.addClassInTraits(si.traits, index);
        }
        for (MethodBody b : this.bodies) {
            this.addClassInTraits(b.traits, index);
        }
        this.instance_info.add(index, ii);
        this.class_info.add(index, ci);
    }

    private void addClassInTraits(Traits traits, int index) {
        for (Trait t : traits.traits) {
            if (!(t instanceof TraitClass)) continue;
            TraitClass tc = (TraitClass)t;
            this.addClassInTraits(this.instance_info.get((int)tc.class_info).instance_traits, index);
            this.addClassInTraits(this.class_info.get((int)tc.class_info).static_traits, index);
            if (tc.class_info < index) continue;
            ++tc.class_info;
        }
    }

    public void reorganizeClasses(Map<Integer, Integer> classIndexMap) {
        for (MethodBody b : this.bodies) {
            for (AVM2Instruction ins : b.getCode().code) {
                for (int i = 0; i < ins.definition.operands.length; ++i) {
                    if (ins.definition.operands[i] != 269 || !classIndexMap.containsKey(ins.operands[i])) continue;
                    ins.setOperand(i, classIndexMap.get(ins.operands[i]), b.getCode(), b);
                }
            }
        }
        for (ScriptInfo si : this.script_info) {
            this.reorganizeClassesInTraits(si.traits, classIndexMap);
        }
        for (MethodBody b : this.bodies) {
            this.reorganizeClassesInTraits(b.traits, classIndexMap);
        }
        HashMap<Integer, InstanceInfo> backupInstanceInfos = new HashMap<Integer, InstanceInfo>();
        HashMap<Integer, ClassInfo> backupClassInfos = new HashMap<Integer, ClassInfo>();
        Iterator<Serializable> iterator = classIndexMap.keySet().iterator();
        while (iterator.hasNext()) {
            int from = (Integer)iterator.next();
            backupInstanceInfos.put(from, this.instance_info.get(from));
            backupClassInfos.put(from, this.class_info.get(from));
        }
        iterator = classIndexMap.keySet().iterator();
        while (iterator.hasNext()) {
            int from = (Integer)iterator.next();
            int to = classIndexMap.get(from);
            this.instance_info.set(to, (InstanceInfo)backupInstanceInfos.get(from));
            this.class_info.set(to, (ClassInfo)backupClassInfos.get(from));
        }
    }

    private void reorganizeClassesInTraits(Traits traits, Map<Integer, Integer> classIndexMap) {
        for (Trait t : traits.traits) {
            if (!(t instanceof TraitClass)) continue;
            TraitClass tc = (TraitClass)t;
            this.reorganizeClassesInTraits(this.instance_info.get((int)tc.class_info).instance_traits, classIndexMap);
            this.reorganizeClassesInTraits(this.class_info.get((int)tc.class_info).static_traits, classIndexMap);
            if (!classIndexMap.containsKey(tc.class_info)) continue;
            tc.class_info = classIndexMap.get(tc.class_info);
        }
    }

    public void removeClass(int index) {
        for (MethodBody b : this.bodies) {
            for (AVM2Instruction ins : b.getCode().code) {
                for (int i = 0; i < ins.definition.operands.length; ++i) {
                    if (ins.definition.operands[i] != 269 || ins.operands[i] <= index) continue;
                    ins.setOperand(i, ins.operands[i] - 1, b.getCode(), b);
                }
            }
        }
        for (ScriptInfo si : this.script_info) {
            this.removeClassFromTraits(si.traits, index);
        }
        for (MethodBody b : this.bodies) {
            this.removeClassFromTraits(b.traits, index);
        }
        this.instance_info.remove(index);
        this.class_info.remove(index);
    }

    private void removeMethodFromTraits(Traits traits, int index) {
        for (Trait t : traits.traits) {
            if (t instanceof TraitClass) {
                TraitClass tc = (TraitClass)t;
                this.removeMethodFromTraits(this.instance_info.get((int)tc.class_info).instance_traits, index);
                this.removeMethodFromTraits(this.class_info.get((int)tc.class_info).static_traits, index);
            }
            if (t instanceof TraitMethodGetterSetter) {
                TraitMethodGetterSetter tmgs = (TraitMethodGetterSetter)t;
                if (tmgs.method_info > index) {
                    --tmgs.method_info;
                }
            }
            if (!(t instanceof TraitFunction)) continue;
            TraitFunction tf = (TraitFunction)t;
            if (tf.method_info <= index) continue;
            --tf.method_info;
        }
    }

    public void removeMethod(int index) {
        int bindex = -1;
        for (int b = 0; b < this.bodies.size(); ++b) {
            if (this.bodies.get((int)b).method_info != index) continue;
            this.bodies.remove(b);
            bindex = b--;
        }
        for (MethodBody b : this.bodies) {
            if (b.method_info > index) {
                --b.method_info;
            }
            for (AVM2Instruction ins : b.getCode().code) {
                for (int i = 0; i < ins.definition.operands.length; ++i) {
                    if (ins.definition.operands[i] != 259 || ins.operands[i] <= index) continue;
                    ins.setOperand(i, ins.operands[i] - 1, b.getCode(), b);
                }
            }
            this.removeMethodFromTraits(b.traits, index);
        }
        for (int c = 0; c < this.instance_info.size(); ++c) {
            InstanceInfo ii = this.instance_info.get(c);
            if (ii.iinit_index > index) {
                --ii.iinit_index;
            }
            ClassInfo ci = this.class_info.get(c);
            if (ci.cinit_index <= index) continue;
            --ci.cinit_index;
        }
        for (ScriptInfo si : this.script_info) {
            if (si.init_index > index) {
                --si.init_index;
            }
            this.removeMethodFromTraits(si.traits, index);
        }
        this.abcMethodIndexing = null;
        this.method_info.remove(index);
    }

    public boolean replaceScriptPack(As3ScriptReplacerInterface replacer, ScriptPack pack, String as) throws As3ScriptReplaceException, IOException, InterruptedException {
        replacer.replaceScript(pack, as);
        ((Tag)((Object)this.parentTag)).setModified(true);
        return pack.isSimple;
    }

    private void packMethods() {
        for (int m = 0; m < this.method_info.size(); ++m) {
            if (!this.method_info.get((int)m).deleted) continue;
            this.removeMethod(m);
            --m;
        }
    }

    public void pack() {
        this.packMethods();
        for (int c = 0; c < this.instance_info.size(); ++c) {
            if (!this.instance_info.get((int)c).deleted) continue;
            this.removeClass(c);
            --c;
        }
        this.packMethods();
        for (int s = 0; s < this.script_info.size(); ++s) {
            if (!this.script_info.get((int)s).deleted) continue;
            this.script_info.remove(s);
            --s;
        }
        this.getSwf().clearAbcListCache();
        this.getSwf().clearScriptCache();
        this.getMethodIndexing();
        this.getSwf().getAbcIndex().refreshAbc(this);
    }

    public void mergeABC(ABC secondABC) {
        HashMap<Integer, Integer> mergeStringMap = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> mergeIntMap = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> mergeUIntMap = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> mergeDoubleMap = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> mergeFloatMap = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> mergeFloat4Map = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> mergeDecimalMap = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> mergeNamespaceMap = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> mergeNamespaceSetMap = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> mergeMultinameMap = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> mergeMethodInfoMap = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> mergeMethodBodyMap = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> mergeClassIndexMap = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> mergeMetaDataMap = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> mergeScriptInfoMap = new HashMap<Integer, Integer>();
        this.mergeABC(secondABC, mergeStringMap, mergeIntMap, mergeUIntMap, mergeDoubleMap, mergeFloatMap, mergeFloat4Map, mergeDecimalMap, mergeNamespaceMap, mergeNamespaceSetMap, mergeMultinameMap, mergeMethodInfoMap, mergeMethodBodyMap, mergeClassIndexMap, mergeMetaDataMap, mergeScriptInfoMap);
    }

    public void mergeABC(ABC secondABC, Map<Integer, Integer> mergeStringMap, Map<Integer, Integer> mergeIntMap, Map<Integer, Integer> mergeUIntMap, Map<Integer, Integer> mergeDoubleMap, Map<Integer, Integer> mergeFloatMap, Map<Integer, Integer> mergeFloat4Map, Map<Integer, Integer> mergeDecimalMap, Map<Integer, Integer> mergeNamespaceMap, Map<Integer, Integer> mergeNamespaceSetMap, Map<Integer, Integer> mergeMultinameMap, Map<Integer, Integer> mergeMethodInfoMap, Map<Integer, Integer> mergeMethodBodyMap, Map<Integer, Integer> mergeClassIndexMap, Map<Integer, Integer> mergeMetaDataMap, Map<Integer, Integer> mergeScriptInfoMap) {
        ClassInfo secondClassInfo;
        int c;
        if (!this.version.equals(secondABC.version)) {
            throw new RuntimeException("ABC versions mismatch");
        }
        this.constants.merge(secondABC.constants, mergeStringMap, mergeIntMap, mergeUIntMap, mergeDoubleMap, mergeFloatMap, mergeFloat4Map, mergeDecimalMap, mergeNamespaceMap, mergeNamespaceSetMap, mergeMultinameMap);
        for (int m = 0; m < secondABC.metadata_info.size(); ++m) {
            MetadataInfo secondMetadataInfo = secondABC.metadata_info.get(m);
            MetadataInfo newMetadataInfo = new MetadataInfo();
            newMetadataInfo.name_index = mergeStringMap.get(secondMetadataInfo.name_index);
            newMetadataInfo.keys = new int[secondMetadataInfo.keys.length];
            newMetadataInfo.values = new int[secondMetadataInfo.values.length];
            for (int i = 0; i < secondMetadataInfo.keys.length; ++i) {
                newMetadataInfo.keys[i] = mergeStringMap.get(secondMetadataInfo.keys[i]);
                newMetadataInfo.values[i] = mergeStringMap.get(secondMetadataInfo.values[i]);
            }
            int newIndex = this.metadata_info.size();
            this.metadata_info.add(newMetadataInfo);
            mergeMetaDataMap.put(m, newIndex);
        }
        for (int i = 0; i < secondABC.method_info.size(); ++i) {
            MethodInfo secondMethodInfo = secondABC.method_info.get(i);
            int[] newParamTypes = new int[secondMethodInfo.param_types.length];
            for (int t = 0; t < secondMethodInfo.param_types.length; ++t) {
                newParamTypes[t] = mergeMultinameMap.get(secondMethodInfo.param_types[t]);
            }
            int[] newParamNames = new int[secondMethodInfo.paramNames.length];
            for (int n = 0; n < secondMethodInfo.paramNames.length; ++n) {
                newParamNames[n] = mergeStringMap.get(secondMethodInfo.paramNames[n]);
            }
            int newRetType = mergeMultinameMap.get(secondMethodInfo.ret_type);
            int newNameIndex = mergeStringMap.get(secondMethodInfo.name_index);
            ValueKind[] newOptional = new ValueKind[secondMethodInfo.optional.length];
            for (int k = 0; k < secondMethodInfo.optional.length; ++k) {
                int vkind = secondMethodInfo.optional[k].value_kind;
                Map<Integer, Integer> valueMergeMap = null;
                switch (vkind) {
                    case 1: {
                        valueMergeMap = mergeStringMap;
                        break;
                    }
                    case 3: {
                        valueMergeMap = mergeIntMap;
                        break;
                    }
                    case 4: {
                        valueMergeMap = mergeUIntMap;
                        break;
                    }
                    case 6: {
                        valueMergeMap = mergeDoubleMap;
                        break;
                    }
                    case 2: {
                        if (this.hasDecimalSupport()) {
                            valueMergeMap = mergeDecimalMap;
                            break;
                        }
                        if (!this.hasFloatSupport()) break;
                        valueMergeMap = mergeFloatMap;
                        break;
                    }
                    case 30: {
                        if (!this.hasFloatSupport()) break;
                        valueMergeMap = mergeFloat4Map;
                        break;
                    }
                    case 5: 
                    case 8: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: {
                        valueMergeMap = mergeNamespaceMap;
                    }
                }
                int newValueIndex = valueMergeMap != null ? valueMergeMap.get(secondMethodInfo.optional[k].value_index) : secondMethodInfo.optional[k].value_index;
                newOptional[k] = new ValueKind(newValueIndex, vkind);
            }
            MethodInfo newMethodInfo = new MethodInfo(newParamTypes, newRetType, newNameIndex, secondMethodInfo.flags, newOptional, newParamNames);
            int newIndex = this.addMethodInfo(newMethodInfo);
            mergeMethodInfoMap.put(i, newIndex);
        }
        int classFirstIndex = this.class_info.size();
        for (c = 0; c < secondABC.class_info.size(); ++c) {
            secondClassInfo = secondABC.class_info.get(c);
            ClassInfo newClassInfo = new ClassInfo();
            int newIndex = this.class_info.size();
            this.class_info.add(newClassInfo);
            mergeClassIndexMap.put(c, newIndex);
            newClassInfo.cinit_index = mergeMethodInfoMap.get(secondClassInfo.cinit_index);
            newClassInfo.lastDispId = secondClassInfo.lastDispId;
            InstanceInfo secondInstanceInfo = secondABC.instance_info.get(c);
            InstanceInfo newInstanceInfo = new InstanceInfo();
            newInstanceInfo.iinit_index = mergeMethodInfoMap.get(secondInstanceInfo.iinit_index);
            newInstanceInfo.super_index = mergeMultinameMap.get(secondInstanceInfo.super_index);
            newInstanceInfo.interfaces = new int[secondInstanceInfo.interfaces.length];
            for (int i = 0; i < secondInstanceInfo.interfaces.length; ++i) {
                newInstanceInfo.interfaces[i] = mergeMultinameMap.get(secondInstanceInfo.interfaces[i]);
            }
            newInstanceInfo.protectedNS = mergeNamespaceMap.get(secondInstanceInfo.protectedNS);
            newInstanceInfo.name_index = mergeMultinameMap.get(secondInstanceInfo.name_index);
            newInstanceInfo.flags = secondInstanceInfo.flags;
            this.instance_info.add(newInstanceInfo);
        }
        for (c = 0; c < secondABC.class_info.size(); ++c) {
            secondClassInfo = secondABC.class_info.get(c);
            InstanceInfo secondInstanceInfo = secondABC.instance_info.get(c);
            ClassInfo newClassInfo = this.class_info.get(classFirstIndex + c);
            InstanceInfo newInstanceInfo = this.instance_info.get(classFirstIndex + c);
            newClassInfo.static_traits = this.mergeTraits(secondClassInfo.static_traits, mergeMultinameMap, mergeStringMap, mergeIntMap, mergeUIntMap, mergeDoubleMap, mergeFloatMap, mergeFloat4Map, mergeDecimalMap, mergeNamespaceMap, mergeMetaDataMap, mergeMethodInfoMap, mergeClassIndexMap);
            newInstanceInfo.instance_traits = this.mergeTraits(secondInstanceInfo.instance_traits, mergeMultinameMap, mergeStringMap, mergeIntMap, mergeUIntMap, mergeDoubleMap, mergeFloatMap, mergeFloat4Map, mergeDecimalMap, mergeNamespaceMap, mergeMetaDataMap, mergeMethodInfoMap, mergeClassIndexMap);
        }
        for (int s = 0; s < secondABC.script_info.size(); ++s) {
            ScriptInfo secondScriptInfo = secondABC.script_info.get(s);
            ScriptInfo newScriptInfo = new ScriptInfo();
            newScriptInfo.init_index = mergeMethodInfoMap.get(secondScriptInfo.init_index);
            newScriptInfo.traits = this.mergeTraits(secondScriptInfo.traits, mergeMultinameMap, mergeStringMap, mergeIntMap, mergeUIntMap, mergeDoubleMap, mergeFloatMap, mergeFloat4Map, mergeDecimalMap, mergeNamespaceMap, mergeMetaDataMap, mergeMethodInfoMap, mergeClassIndexMap);
            int newIndex = this.script_info.size();
            this.script_info.add(newScriptInfo);
            mergeScriptInfoMap.put(s, newIndex);
        }
        for (int b = 0; b < secondABC.bodies.size(); ++b) {
            MethodBody secondBody = secondABC.bodies.get(b);
            MethodBody newBody = secondBody.clone(true);
            newBody.method_info = mergeMethodInfoMap.get(secondBody.method_info);
            for (int e = 0; e < secondBody.exceptions.length; ++e) {
                newBody.exceptions[e].name_index = mergeMultinameMap.get(secondBody.exceptions[e].name_index);
                newBody.exceptions[e].type_index = mergeMultinameMap.get(secondBody.exceptions[e].type_index);
            }
            AVM2Code newCode = newBody.getCode();
            for (AVM2Instruction newIns : newCode.code) {
                int[] newOperands = newIns.operands == null ? null : (int[])newIns.operands.clone();
                boolean modified = false;
                if (newIns.operands != null) {
                    for (int i = 0; i < newIns.definition.operands.length; ++i) {
                        Map<Integer, Integer> mergeMap = null;
                        switch (newIns.definition.operands[i]) {
                            case 269: {
                                mergeMap = mergeClassIndexMap;
                                break;
                            }
                            case 260: {
                                mergeMap = mergeStringMap;
                                break;
                            }
                            case 270: {
                                mergeMap = mergeIntMap;
                                break;
                            }
                            case 271: {
                                mergeMap = mergeUIntMap;
                                break;
                            }
                            case 272: {
                                mergeMap = mergeDoubleMap;
                                break;
                            }
                            case 273: {
                                mergeMap = mergeDecimalMap;
                                break;
                            }
                            case 277: {
                                mergeMap = mergeFloatMap;
                                break;
                            }
                            case 278: {
                                mergeMap = mergeFloat4Map;
                                break;
                            }
                            case 279: {
                                mergeMap = mergeNamespaceMap;
                                break;
                            }
                            case 259: {
                                mergeMap = mergeMethodInfoMap;
                                break;
                            }
                            case 257: {
                                mergeMap = mergeMultinameMap;
                            }
                        }
                        if (mergeMap == null) continue;
                        newOperands[i] = mergeMap.get(newIns.operands[i]);
                        modified = true;
                    }
                }
                if (modified) {
                    newIns.setOperands(newOperands, newCode, newBody);
                }
                newBody.traits = this.mergeTraits(secondBody.traits, mergeMultinameMap, mergeStringMap, mergeIntMap, mergeUIntMap, mergeDoubleMap, mergeFloatMap, mergeFloat4Map, mergeDecimalMap, mergeNamespaceMap, mergeMetaDataMap, mergeMethodInfoMap, mergeClassIndexMap);
            }
            newBody.setModified();
            int newIndex = this.bodies.size();
            this.bodies.add(newBody);
            mergeMethodBodyMap.put(b, newIndex);
        }
        this.abcMethodIndexing = null;
        this.getSwf().clearScriptCache();
        ((Tag)((Object)this.parentTag)).setModified(true);
    }

    private Traits mergeTraits(Traits secondTraits, Map<Integer, Integer> mergeMultinameMap, Map<Integer, Integer> mergeStringMap, Map<Integer, Integer> mergeIntMap, Map<Integer, Integer> mergeUIntMap, Map<Integer, Integer> mergeDoubleMap, Map<Integer, Integer> mergeFloatMap, Map<Integer, Integer> mergeFloat4Map, Map<Integer, Integer> mergeDecimalMap, Map<Integer, Integer> mergeNamespaceMap, Map<Integer, Integer> mergeMetaDataMap, Map<Integer, Integer> mergeMethodInfoMap, Map<Integer, Integer> mergeClassIndexMap) {
        Traits newTraits = new Traits();
        for (Trait t : secondTraits.traits) {
            Trait newTrait = null;
            if (t instanceof TraitMethodGetterSetter) {
                newTrait = this.mergeTrait((TraitMethodGetterSetter)t, mergeMultinameMap, mergeMethodInfoMap, mergeMetaDataMap);
            } else if (t instanceof TraitSlotConst) {
                newTrait = this.mergeTrait((TraitSlotConst)t, mergeMultinameMap, mergeStringMap, mergeIntMap, mergeUIntMap, mergeDoubleMap, mergeFloatMap, mergeFloat4Map, mergeDecimalMap, mergeNamespaceMap, mergeMetaDataMap);
            } else if (t instanceof TraitFunction) {
                newTrait = this.mergeTrait((TraitFunction)t, mergeMultinameMap, mergeMethodInfoMap, mergeMetaDataMap);
            } else if (t instanceof TraitClass) {
                newTrait = this.mergeTrait((TraitClass)t, mergeClassIndexMap, mergeMultinameMap, mergeMetaDataMap);
            }
            newTraits.addTrait(newTrait);
        }
        return newTraits;
    }

    private TraitMethodGetterSetter mergeTrait(TraitMethodGetterSetter secondTrait, Map<Integer, Integer> mergeMultinameMap, Map<Integer, Integer> mergeMethodInfoMap, Map<Integer, Integer> mergeMetaDataMap) {
        TraitMethodGetterSetter newTrait = secondTrait.clone();
        newTrait.method_info = mergeMethodInfoMap.get(secondTrait.method_info);
        newTrait.name_index = mergeMultinameMap.get(secondTrait.name_index);
        for (int m = 0; m < secondTrait.metadata.length; ++m) {
            newTrait.metadata[m] = mergeMetaDataMap.get(secondTrait.metadata[m]);
        }
        return newTrait;
    }

    private TraitSlotConst mergeTrait(TraitSlotConst secondTrait, Map<Integer, Integer> mergeMultinameMap, Map<Integer, Integer> mergeStringMap, Map<Integer, Integer> mergeIntMap, Map<Integer, Integer> mergeUIntMap, Map<Integer, Integer> mergeDoubleMap, Map<Integer, Integer> mergeFloatMap, Map<Integer, Integer> mergeFloat4Map, Map<Integer, Integer> mergeDecimalMap, Map<Integer, Integer> mergeNamespaceMap, Map<Integer, Integer> mergeMetaDataMap) {
        TraitSlotConst newTrait = secondTrait.clone();
        newTrait.name_index = mergeMultinameMap.get(secondTrait.name_index);
        for (int m = 0; m < secondTrait.metadata.length; ++m) {
            newTrait.metadata[m] = mergeMetaDataMap.get(secondTrait.metadata[m]);
        }
        newTrait.type_index = mergeMultinameMap.get(secondTrait.type_index);
        Map<Integer, Integer> valueMergeMap = null;
        switch (newTrait.value_kind) {
            case 1: {
                valueMergeMap = mergeStringMap;
                break;
            }
            case 3: {
                valueMergeMap = mergeIntMap;
                break;
            }
            case 4: {
                valueMergeMap = mergeUIntMap;
                break;
            }
            case 6: {
                valueMergeMap = mergeDoubleMap;
                break;
            }
            case 2: {
                if (this.hasDecimalSupport()) {
                    valueMergeMap = mergeDecimalMap;
                    break;
                }
                if (!this.hasFloatSupport()) break;
                valueMergeMap = mergeFloatMap;
                break;
            }
            case 30: {
                if (!this.hasFloatSupport()) break;
                valueMergeMap = mergeFloat4Map;
                break;
            }
            case 5: 
            case 8: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                valueMergeMap = mergeNamespaceMap;
            }
        }
        if (valueMergeMap != null) {
            newTrait.value_index = valueMergeMap.get(secondTrait.value_index);
        }
        return newTrait;
    }

    private TraitFunction mergeTrait(TraitFunction secondTrait, Map<Integer, Integer> mergeMultinameMap, Map<Integer, Integer> mergeMethodInfoMap, Map<Integer, Integer> mergeMetaDataMap) {
        TraitFunction newTrait = secondTrait.clone();
        newTrait.method_info = mergeMethodInfoMap.get(secondTrait.method_info);
        newTrait.name_index = mergeMultinameMap.get(secondTrait.name_index);
        for (int m = 0; m < secondTrait.metadata.length; ++m) {
            newTrait.metadata[m] = mergeMetaDataMap.get(secondTrait.metadata[m]);
        }
        return newTrait;
    }

    private TraitClass mergeTrait(TraitClass secondTrait, Map<Integer, Integer> mergeClassMap, Map<Integer, Integer> mergeMultinameMap, Map<Integer, Integer> mergeMetaDataMap) {
        TraitClass newTrait = secondTrait.clone();
        newTrait.class_info = mergeClassMap.get(secondTrait.class_info);
        newTrait.name_index = mergeMultinameMap.get(secondTrait.name_index);
        for (int m = 0; m < secondTrait.metadata.length; ++m) {
            newTrait.metadata[m] = mergeMetaDataMap.get(secondTrait.metadata[m]);
        }
        return newTrait;
    }

    public DottedChain findCustomNs(int link_ns_index) {
        if (link_ns_index <= 0) {
            return null;
        }
        Namespace ns = this.constants.getNamespace(link_ns_index);
        if (ns.kind != 8 && ns.kind != 23) {
            return null;
        }
        String name = this.constants.getString(ns.name_index);
        if (name.equals("http://adobe.com/AS3/2006/builtin")) {
            return DottedChain.parseNoSuffix("AS3");
        }
        return this.getSwf().getAbcIndex().nsValueToName(name);
    }

    public void clearPacksCache() {
        for (ScriptInfo si : this.script_info) {
            si.clearPacksCache();
        }
    }

    public void free() {
        this.deobfuscation = null;
        this.abcMethodIndexing = null;
    }

    @Override
    public String getFile() {
        return this.file;
    }

    @Override
    public String getFileTitle() {
        if (this.fileTitle != null) {
            return this.fileTitle;
        }
        return this.file;
    }

    @Override
    public String getTitleOrShortFileName() {
        if (this.fileTitle != null) {
            return this.fileTitle;
        }
        return new File(this.file).getName();
    }

    @Override
    public String getShortPathTitle() {
        if (this.openableList != null && this.openableList.isBundle()) {
            return this.openableList.name + "/" + this.getTitleOrShortFileName();
        }
        return this.getTitleOrShortFileName();
    }

    @Override
    public String getShortFileName() {
        return new File(this.getTitleOrShortFileName()).getName();
    }

    @Override
    public String getFullPathTitle() {
        if (this.openableList != null && this.openableList.isBundle()) {
            return this.openableList.sourceInfo.getFileTitleOrName() + "/" + this.getFileTitle();
        }
        return this.getFileTitle();
    }

    @Override
    public boolean isModified() {
        return this.getSwf().isModified();
    }

    @Override
    public void setOpenableList(OpenableList openableList) {
        this.openableList = openableList;
        this.getSwf().setOpenableList(openableList);
    }

    @Override
    public OpenableList getOpenableList() {
        return this.openableList;
    }

    public String toString() {
        return this.getTitleOrShortFileName();
    }

    @Override
    public void saveTo(OutputStream os) throws IOException {
        this.saveToStream(os);
    }

    @Override
    public void setFile(String file) {
        this.file = file;
        this.fileTitle = null;
    }

    @Override
    public void clearModified() {
        this.getSwf().clearModified();
        ArrayList<ABC> allAbcs = new ArrayList<ABC>();
        allAbcs.add(this);
        List<ScriptPack> packs = this.getScriptPacks(null, allAbcs);
        for (ScriptPack pack : packs) {
            if (!pack.isModified()) continue;
            pack.clearModified();
        }
    }
}

