/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash;

import com.jpexs.decompiler.flash.Bundle;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.MemoryInputStream;
import com.jpexs.helpers.ReReadableInputStream;
import com.jpexs.helpers.streams.SeekableInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ZippedBundle
implements Bundle {
    protected Set<String> keySet = new HashSet<String>();
    protected FileInputStream fis;
    protected ReReadableInputStream is;
    protected File filename;

    public ZippedBundle(InputStream is) throws IOException {
        this(is, null);
    }

    public ZippedBundle(File filename) throws IOException {
        this(null, filename);
    }

    protected ZippedBundle(InputStream is, File filename) throws IOException {
        this.initBundle(is, filename);
    }

    protected void initBundle(InputStream is, File filename) throws IOException {
        ZipEntry entry;
        if (filename != null) {
            this.fis = new FileInputStream(filename);
            is = this.fis;
        }
        this.filename = filename;
        this.is = new ReReadableInputStream(is);
        ZipInputStream zip = new ZipInputStream(this.is);
        this.keySet.clear();
        while ((entry = zip.getNextEntry()) != null) {
            if (!entry.getName().toLowerCase().endsWith(".swf") && !entry.getName().toLowerCase().endsWith(".gfx") && !entry.getName().toLowerCase().endsWith(".abc")) continue;
            this.keySet.add(entry.getName());
        }
    }

    @Override
    public int length() {
        return this.keySet.size();
    }

    @Override
    public Set<String> getKeys() {
        return this.keySet;
    }

    @Override
    public SeekableInputStream getOpenable(String key) throws IOException {
        ZipEntry entry;
        if (!this.keySet.contains(key)) {
            return null;
        }
        MemoryInputStream ret = null;
        this.is.reset();
        ZipInputStream zip = new ZipInputStream(this.is);
        while ((entry = zip.getNextEntry()) != null) {
            if (entry.getName().equals(key)) {
                MemoryInputStream mis;
                ret = mis = new MemoryInputStream(Helper.readStream(zip));
                break;
            }
            zip.closeEntry();
        }
        return ret;
    }

    @Override
    public Map<String, SeekableInputStream> getAll() throws IOException {
        HashMap<String, SeekableInputStream> ret = new HashMap<String, SeekableInputStream>();
        for (String key : this.getKeys()) {
            ret.put(key, this.getOpenable(key));
        }
        return ret;
    }

    @Override
    public String getExtension() {
        return "zip";
    }

    @Override
    public boolean isReadOnly() {
        return this.filename == null || !this.filename.canWrite();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean putOpenable(String key, InputStream swfIs) throws IOException {
        if (this.isReadOnly()) {
            return false;
        }
        if (key == null) {
            return false;
        }
        if (!this.getKeys().contains(key)) {
            return false;
        }
        File tempFile = new File(this.filename.getAbsolutePath() + ".tmp");
        try {
            ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(tempFile));
            this.is.reset();
            ZipInputStream zis = new ZipInputStream(this.is);
            byte[] swfData = Helper.readStream(swfIs);
            try {
                ZipEntry entryIn;
                while ((entryIn = zis.getNextEntry()) != null) {
                    InputStream src;
                    ZipEntry entryOut;
                    if (entryIn.getName().equals(key)) {
                        entryOut = new ZipEntry(key);
                        src = new ByteArrayInputStream(swfData);
                    } else {
                        src = zis;
                        entryOut = entryIn;
                    }
                    zos.putNextEntry(entryOut);
                    Helper.copyStream(src, zos, entryOut.getSize() == -1L ? Long.MAX_VALUE : entryOut.getSize());
                    zos.closeEntry();
                    zis.closeEntry();
                }
            }
            finally {
                zis.close();
                zos.close();
            }
            this.is.close();
            this.fis.close();
        }
        catch (IOException ex) {
            tempFile.delete();
            throw ex;
        }
        this.filename.delete();
        tempFile.renameTo(this.filename);
        this.initBundle(null, this.filename);
        return true;
    }
}

