/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.SearchMode;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.MemoryInputStream;
import com.jpexs.helpers.PosMarkedInputStream;
import com.jpexs.helpers.ProgressListener;
import com.jpexs.helpers.Searchable;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class SWFSearch {
    protected Searchable s;
    private final boolean noCheck;
    private final SearchMode searchMode;
    private boolean processed = false;
    private final Set<ProgressListener> listeners = new HashSet<ProgressListener>();
    private final Map<Long, MemoryInputStream> swfStreams = new LinkedHashMap<Long, MemoryInputStream>();

    public SWFSearch(Searchable s, boolean noCheck, SearchMode searchMode) {
        this.s = s;
        this.noCheck = noCheck;
        this.searchMode = searchMode;
    }

    public void addProgressListener(ProgressListener l) {
        this.listeners.add(l);
    }

    public void removeProgressListener(ProgressListener l) {
        this.listeners.remove(l);
    }

    private void setProgress(int p) {
        for (ProgressListener l : this.listeners) {
            l.progress(p);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void process() {
        Map<Long, InputStream> ret = this.s.search(new ProgressListener(){

            @Override
            public void progress(int p) {
                SWFSearch.this.setProgress(p);
            }
        }, (byte[][])new byte[][]{"FWS".getBytes(), "CWS".getBytes(), "ZWS".getBytes(), "GFX".getBytes(), "CFX".getBytes(), "fWS".getBytes(), "cWS".getBytes(), "zWS".getBytes()});
        int pos = 0;
        long biggestSize = 0L;
        long smallestSize = Long.MAX_VALUE;
        block10: for (Long addr : ret.keySet()) {
            this.setProgress(pos * 100 / ret.size());
            ++pos;
            try {
                MemoryInputStream mis = (MemoryInputStream)ret.get(addr);
                mis.reset();
                PosMarkedInputStream pmi = new PosMarkedInputStream(mis);
                SWF swf = this.noCheck ? new SWF(pmi) : new SWF(pmi, null, null, null, false, true, true);
                boolean valid = swf.fileSize > 0L && swf.version > 0 && (!swf.getTags().isEmpty() || this.noCheck) && swf.version <= 64;
                if (!valid) continue;
                long limit = pmi.getPos();
                MemoryInputStream is = new MemoryInputStream(mis.getAllRead(), (int)addr.longValue(), (int)limit);
                switch (this.searchMode) {
                    case ALL: {
                        this.swfStreams.put(addr, is);
                        continue block10;
                    }
                    case BIGGEST: {
                        if (limit <= biggestSize) break;
                        biggestSize = limit;
                        this.swfStreams.clear();
                        this.swfStreams.put(addr, is);
                        continue block10;
                    }
                    case SMALLEST: {
                        if (limit >= smallestSize) break;
                        smallestSize = limit;
                        this.swfStreams.clear();
                        this.swfStreams.put(addr, is);
                        continue block10;
                    }
                    case FIRST: {
                        this.swfStreams.put(addr, is);
                        break block10;
                    }
                    case LAST: {
                        this.swfStreams.clear();
                        this.swfStreams.put(addr, is);
                    }
                }
            }
            catch (OutOfMemoryError ome) {
                Helper.freeMem();
            }
            catch (Error | Exception throwable) {}
        }
        this.setProgress(100);
        this.processed = true;
    }

    public MemoryInputStream get(ProgressListener listener, long address) throws IOException {
        if (!this.processed) {
            return null;
        }
        if (!this.swfStreams.containsKey(address)) {
            return null;
        }
        return this.swfStreams.get(address);
    }

    public Set<Long> getAddresses() {
        return this.swfStreams.keySet();
    }

    public int length() {
        if (!this.processed) {
            return 0;
        }
        return this.swfStreams.size();
    }
}

