/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash;

import com.jpexs.decompiler.flash.EndOfStreamException;
import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.action.Action;
import com.jpexs.decompiler.flash.action.special.ActionEnd;
import com.jpexs.decompiler.flash.action.special.ActionUnknown;
import com.jpexs.decompiler.flash.action.swf3.ActionGetURL;
import com.jpexs.decompiler.flash.action.swf3.ActionGoToLabel;
import com.jpexs.decompiler.flash.action.swf3.ActionGotoFrame;
import com.jpexs.decompiler.flash.action.swf3.ActionNextFrame;
import com.jpexs.decompiler.flash.action.swf3.ActionPlay;
import com.jpexs.decompiler.flash.action.swf3.ActionPrevFrame;
import com.jpexs.decompiler.flash.action.swf3.ActionSetTarget;
import com.jpexs.decompiler.flash.action.swf3.ActionStop;
import com.jpexs.decompiler.flash.action.swf3.ActionStopSounds;
import com.jpexs.decompiler.flash.action.swf3.ActionToggleQuality;
import com.jpexs.decompiler.flash.action.swf3.ActionWaitForFrame;
import com.jpexs.decompiler.flash.action.swf4.ActionAdd;
import com.jpexs.decompiler.flash.action.swf4.ActionAnd;
import com.jpexs.decompiler.flash.action.swf4.ActionAsciiToChar;
import com.jpexs.decompiler.flash.action.swf4.ActionCall;
import com.jpexs.decompiler.flash.action.swf4.ActionCharToAscii;
import com.jpexs.decompiler.flash.action.swf4.ActionCloneSprite;
import com.jpexs.decompiler.flash.action.swf4.ActionDivide;
import com.jpexs.decompiler.flash.action.swf4.ActionEndDrag;
import com.jpexs.decompiler.flash.action.swf4.ActionEquals;
import com.jpexs.decompiler.flash.action.swf4.ActionGetProperty;
import com.jpexs.decompiler.flash.action.swf4.ActionGetTime;
import com.jpexs.decompiler.flash.action.swf4.ActionGetURL2;
import com.jpexs.decompiler.flash.action.swf4.ActionGetVariable;
import com.jpexs.decompiler.flash.action.swf4.ActionGotoFrame2;
import com.jpexs.decompiler.flash.action.swf4.ActionIf;
import com.jpexs.decompiler.flash.action.swf4.ActionJump;
import com.jpexs.decompiler.flash.action.swf4.ActionLess;
import com.jpexs.decompiler.flash.action.swf4.ActionMBAsciiToChar;
import com.jpexs.decompiler.flash.action.swf4.ActionMBCharToAscii;
import com.jpexs.decompiler.flash.action.swf4.ActionMBStringExtract;
import com.jpexs.decompiler.flash.action.swf4.ActionMBStringLength;
import com.jpexs.decompiler.flash.action.swf4.ActionMultiply;
import com.jpexs.decompiler.flash.action.swf4.ActionNot;
import com.jpexs.decompiler.flash.action.swf4.ActionOr;
import com.jpexs.decompiler.flash.action.swf4.ActionPop;
import com.jpexs.decompiler.flash.action.swf4.ActionPush;
import com.jpexs.decompiler.flash.action.swf4.ActionRandomNumber;
import com.jpexs.decompiler.flash.action.swf4.ActionRemoveSprite;
import com.jpexs.decompiler.flash.action.swf4.ActionSetProperty;
import com.jpexs.decompiler.flash.action.swf4.ActionSetTarget2;
import com.jpexs.decompiler.flash.action.swf4.ActionSetVariable;
import com.jpexs.decompiler.flash.action.swf4.ActionStartDrag;
import com.jpexs.decompiler.flash.action.swf4.ActionStringAdd;
import com.jpexs.decompiler.flash.action.swf4.ActionStringEquals;
import com.jpexs.decompiler.flash.action.swf4.ActionStringExtract;
import com.jpexs.decompiler.flash.action.swf4.ActionStringLength;
import com.jpexs.decompiler.flash.action.swf4.ActionStringLess;
import com.jpexs.decompiler.flash.action.swf4.ActionSubtract;
import com.jpexs.decompiler.flash.action.swf4.ActionToInteger;
import com.jpexs.decompiler.flash.action.swf4.ActionTrace;
import com.jpexs.decompiler.flash.action.swf4.ActionWaitForFrame2;
import com.jpexs.decompiler.flash.action.swf5.ActionAdd2;
import com.jpexs.decompiler.flash.action.swf5.ActionBitAnd;
import com.jpexs.decompiler.flash.action.swf5.ActionBitLShift;
import com.jpexs.decompiler.flash.action.swf5.ActionBitOr;
import com.jpexs.decompiler.flash.action.swf5.ActionBitRShift;
import com.jpexs.decompiler.flash.action.swf5.ActionBitURShift;
import com.jpexs.decompiler.flash.action.swf5.ActionBitXor;
import com.jpexs.decompiler.flash.action.swf5.ActionCallFunction;
import com.jpexs.decompiler.flash.action.swf5.ActionCallMethod;
import com.jpexs.decompiler.flash.action.swf5.ActionConstantPool;
import com.jpexs.decompiler.flash.action.swf5.ActionDecrement;
import com.jpexs.decompiler.flash.action.swf5.ActionDefineFunction;
import com.jpexs.decompiler.flash.action.swf5.ActionDefineLocal;
import com.jpexs.decompiler.flash.action.swf5.ActionDefineLocal2;
import com.jpexs.decompiler.flash.action.swf5.ActionDelete;
import com.jpexs.decompiler.flash.action.swf5.ActionDelete2;
import com.jpexs.decompiler.flash.action.swf5.ActionEnumerate;
import com.jpexs.decompiler.flash.action.swf5.ActionEquals2;
import com.jpexs.decompiler.flash.action.swf5.ActionGetMember;
import com.jpexs.decompiler.flash.action.swf5.ActionIncrement;
import com.jpexs.decompiler.flash.action.swf5.ActionInitArray;
import com.jpexs.decompiler.flash.action.swf5.ActionInitObject;
import com.jpexs.decompiler.flash.action.swf5.ActionLess2;
import com.jpexs.decompiler.flash.action.swf5.ActionModulo;
import com.jpexs.decompiler.flash.action.swf5.ActionNewMethod;
import com.jpexs.decompiler.flash.action.swf5.ActionNewObject;
import com.jpexs.decompiler.flash.action.swf5.ActionPushDuplicate;
import com.jpexs.decompiler.flash.action.swf5.ActionReturn;
import com.jpexs.decompiler.flash.action.swf5.ActionSetMember;
import com.jpexs.decompiler.flash.action.swf5.ActionStackSwap;
import com.jpexs.decompiler.flash.action.swf5.ActionStoreRegister;
import com.jpexs.decompiler.flash.action.swf5.ActionTargetPath;
import com.jpexs.decompiler.flash.action.swf5.ActionToNumber;
import com.jpexs.decompiler.flash.action.swf5.ActionToString;
import com.jpexs.decompiler.flash.action.swf5.ActionTypeOf;
import com.jpexs.decompiler.flash.action.swf5.ActionWith;
import com.jpexs.decompiler.flash.action.swf6.ActionEnumerate2;
import com.jpexs.decompiler.flash.action.swf6.ActionGreater;
import com.jpexs.decompiler.flash.action.swf6.ActionInstanceOf;
import com.jpexs.decompiler.flash.action.swf6.ActionStrictEquals;
import com.jpexs.decompiler.flash.action.swf6.ActionStringGreater;
import com.jpexs.decompiler.flash.action.swf7.ActionCastOp;
import com.jpexs.decompiler.flash.action.swf7.ActionDefineFunction2;
import com.jpexs.decompiler.flash.action.swf7.ActionExtends;
import com.jpexs.decompiler.flash.action.swf7.ActionImplementsOp;
import com.jpexs.decompiler.flash.action.swf7.ActionThrow;
import com.jpexs.decompiler.flash.action.swf7.ActionTry;
import com.jpexs.decompiler.flash.amf.amf3.Amf3InputStream;
import com.jpexs.decompiler.flash.amf.amf3.Amf3Value;
import com.jpexs.decompiler.flash.amf.amf3.NoSerializerExistsException;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.dumpview.DumpInfo;
import com.jpexs.decompiler.flash.dumpview.DumpInfoSpecial;
import com.jpexs.decompiler.flash.dumpview.DumpInfoSpecialType;
import com.jpexs.decompiler.flash.tags.CSMTextSettingsTag;
import com.jpexs.decompiler.flash.tags.DebugIDTag;
import com.jpexs.decompiler.flash.tags.DefineBinaryDataTag;
import com.jpexs.decompiler.flash.tags.DefineBitsJPEG2Tag;
import com.jpexs.decompiler.flash.tags.DefineBitsJPEG3Tag;
import com.jpexs.decompiler.flash.tags.DefineBitsJPEG4Tag;
import com.jpexs.decompiler.flash.tags.DefineBitsLossless2Tag;
import com.jpexs.decompiler.flash.tags.DefineBitsLosslessTag;
import com.jpexs.decompiler.flash.tags.DefineBitsTag;
import com.jpexs.decompiler.flash.tags.DefineButton2Tag;
import com.jpexs.decompiler.flash.tags.DefineButtonCxformTag;
import com.jpexs.decompiler.flash.tags.DefineButtonSoundTag;
import com.jpexs.decompiler.flash.tags.DefineButtonTag;
import com.jpexs.decompiler.flash.tags.DefineEditTextTag;
import com.jpexs.decompiler.flash.tags.DefineFont2Tag;
import com.jpexs.decompiler.flash.tags.DefineFont3Tag;
import com.jpexs.decompiler.flash.tags.DefineFont4Tag;
import com.jpexs.decompiler.flash.tags.DefineFontAlignZonesTag;
import com.jpexs.decompiler.flash.tags.DefineFontInfo2Tag;
import com.jpexs.decompiler.flash.tags.DefineFontInfoTag;
import com.jpexs.decompiler.flash.tags.DefineFontNameTag;
import com.jpexs.decompiler.flash.tags.DefineFontTag;
import com.jpexs.decompiler.flash.tags.DefineMorphShape2Tag;
import com.jpexs.decompiler.flash.tags.DefineMorphShapeTag;
import com.jpexs.decompiler.flash.tags.DefineScalingGridTag;
import com.jpexs.decompiler.flash.tags.DefineSceneAndFrameLabelDataTag;
import com.jpexs.decompiler.flash.tags.DefineShape2Tag;
import com.jpexs.decompiler.flash.tags.DefineShape3Tag;
import com.jpexs.decompiler.flash.tags.DefineShape4Tag;
import com.jpexs.decompiler.flash.tags.DefineShapeTag;
import com.jpexs.decompiler.flash.tags.DefineSoundTag;
import com.jpexs.decompiler.flash.tags.DefineSpriteTag;
import com.jpexs.decompiler.flash.tags.DefineText2Tag;
import com.jpexs.decompiler.flash.tags.DefineTextTag;
import com.jpexs.decompiler.flash.tags.DefineVideoStreamTag;
import com.jpexs.decompiler.flash.tags.DoABC2Tag;
import com.jpexs.decompiler.flash.tags.DoABCTag;
import com.jpexs.decompiler.flash.tags.DoActionTag;
import com.jpexs.decompiler.flash.tags.DoInitActionTag;
import com.jpexs.decompiler.flash.tags.EnableDebugger2Tag;
import com.jpexs.decompiler.flash.tags.EnableDebuggerTag;
import com.jpexs.decompiler.flash.tags.EnableTelemetryTag;
import com.jpexs.decompiler.flash.tags.EndTag;
import com.jpexs.decompiler.flash.tags.ExportAssetsTag;
import com.jpexs.decompiler.flash.tags.FileAttributesTag;
import com.jpexs.decompiler.flash.tags.FrameLabelTag;
import com.jpexs.decompiler.flash.tags.FreeAllTag;
import com.jpexs.decompiler.flash.tags.FreeCharacterTag;
import com.jpexs.decompiler.flash.tags.ImportAssets2Tag;
import com.jpexs.decompiler.flash.tags.ImportAssetsTag;
import com.jpexs.decompiler.flash.tags.JPEGTablesTag;
import com.jpexs.decompiler.flash.tags.MetadataTag;
import com.jpexs.decompiler.flash.tags.NameCharacterTag;
import com.jpexs.decompiler.flash.tags.PathsArePostScriptTag;
import com.jpexs.decompiler.flash.tags.PlaceObject2Tag;
import com.jpexs.decompiler.flash.tags.PlaceObject3Tag;
import com.jpexs.decompiler.flash.tags.PlaceObject4Tag;
import com.jpexs.decompiler.flash.tags.PlaceObjectTag;
import com.jpexs.decompiler.flash.tags.ProductInfoTag;
import com.jpexs.decompiler.flash.tags.ProtectTag;
import com.jpexs.decompiler.flash.tags.RemoveObject2Tag;
import com.jpexs.decompiler.flash.tags.RemoveObjectTag;
import com.jpexs.decompiler.flash.tags.ScriptLimitsTag;
import com.jpexs.decompiler.flash.tags.SetBackgroundColorTag;
import com.jpexs.decompiler.flash.tags.SetTabIndexTag;
import com.jpexs.decompiler.flash.tags.ShowFrameTag;
import com.jpexs.decompiler.flash.tags.SoundStreamBlockTag;
import com.jpexs.decompiler.flash.tags.SoundStreamHead2Tag;
import com.jpexs.decompiler.flash.tags.SoundStreamHeadTag;
import com.jpexs.decompiler.flash.tags.StartSound2Tag;
import com.jpexs.decompiler.flash.tags.StartSoundTag;
import com.jpexs.decompiler.flash.tags.SymbolClassTag;
import com.jpexs.decompiler.flash.tags.SyncFrameTag;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.tags.TagStub;
import com.jpexs.decompiler.flash.tags.UnknownTag;
import com.jpexs.decompiler.flash.tags.VideoFrameTag;
import com.jpexs.decompiler.flash.tags.base.ButtonTag;
import com.jpexs.decompiler.flash.tags.gfx.DefineCompactedFont;
import com.jpexs.decompiler.flash.tags.gfx.DefineExternalGradient;
import com.jpexs.decompiler.flash.tags.gfx.DefineExternalImage;
import com.jpexs.decompiler.flash.tags.gfx.DefineExternalImage2;
import com.jpexs.decompiler.flash.tags.gfx.DefineExternalSound;
import com.jpexs.decompiler.flash.tags.gfx.DefineExternalStreamSound;
import com.jpexs.decompiler.flash.tags.gfx.DefineGradientMap;
import com.jpexs.decompiler.flash.tags.gfx.DefineSubImage;
import com.jpexs.decompiler.flash.tags.gfx.ExporterInfo;
import com.jpexs.decompiler.flash.tags.gfx.FontTextureInfo;
import com.jpexs.decompiler.flash.timeline.Timelined;
import com.jpexs.decompiler.flash.types.ALPHABITMAPDATA;
import com.jpexs.decompiler.flash.types.ALPHACOLORMAPDATA;
import com.jpexs.decompiler.flash.types.ARGB;
import com.jpexs.decompiler.flash.types.BITMAPDATA;
import com.jpexs.decompiler.flash.types.BUTTONCONDACTION;
import com.jpexs.decompiler.flash.types.BUTTONRECORD;
import com.jpexs.decompiler.flash.types.CLIPACTIONRECORD;
import com.jpexs.decompiler.flash.types.CLIPACTIONS;
import com.jpexs.decompiler.flash.types.CLIPEVENTFLAGS;
import com.jpexs.decompiler.flash.types.COLORMAPDATA;
import com.jpexs.decompiler.flash.types.CXFORM;
import com.jpexs.decompiler.flash.types.CXFORMWITHALPHA;
import com.jpexs.decompiler.flash.types.FILLSTYLE;
import com.jpexs.decompiler.flash.types.FILLSTYLEARRAY;
import com.jpexs.decompiler.flash.types.FOCALGRADIENT;
import com.jpexs.decompiler.flash.types.GLYPHENTRY;
import com.jpexs.decompiler.flash.types.GRADIENT;
import com.jpexs.decompiler.flash.types.GRADRECORD;
import com.jpexs.decompiler.flash.types.KERNINGRECORD;
import com.jpexs.decompiler.flash.types.LANGCODE;
import com.jpexs.decompiler.flash.types.LINESTYLE;
import com.jpexs.decompiler.flash.types.LINESTYLE2;
import com.jpexs.decompiler.flash.types.LINESTYLEARRAY;
import com.jpexs.decompiler.flash.types.MATRIX;
import com.jpexs.decompiler.flash.types.MORPHFILLSTYLE;
import com.jpexs.decompiler.flash.types.MORPHFILLSTYLEARRAY;
import com.jpexs.decompiler.flash.types.MORPHFOCALGRADIENT;
import com.jpexs.decompiler.flash.types.MORPHGRADIENT;
import com.jpexs.decompiler.flash.types.MORPHGRADRECORD;
import com.jpexs.decompiler.flash.types.MORPHLINESTYLE;
import com.jpexs.decompiler.flash.types.MORPHLINESTYLE2;
import com.jpexs.decompiler.flash.types.MORPHLINESTYLEARRAY;
import com.jpexs.decompiler.flash.types.PIX15;
import com.jpexs.decompiler.flash.types.PIX24;
import com.jpexs.decompiler.flash.types.RECT;
import com.jpexs.decompiler.flash.types.RGB;
import com.jpexs.decompiler.flash.types.RGBA;
import com.jpexs.decompiler.flash.types.SHAPE;
import com.jpexs.decompiler.flash.types.SHAPEWITHSTYLE;
import com.jpexs.decompiler.flash.types.SOUNDENVELOPE;
import com.jpexs.decompiler.flash.types.SOUNDINFO;
import com.jpexs.decompiler.flash.types.TEXTRECORD;
import com.jpexs.decompiler.flash.types.ZONEDATA;
import com.jpexs.decompiler.flash.types.ZONERECORD;
import com.jpexs.decompiler.flash.types.filters.BEVELFILTER;
import com.jpexs.decompiler.flash.types.filters.BLURFILTER;
import com.jpexs.decompiler.flash.types.filters.COLORMATRIXFILTER;
import com.jpexs.decompiler.flash.types.filters.CONVOLUTIONFILTER;
import com.jpexs.decompiler.flash.types.filters.DROPSHADOWFILTER;
import com.jpexs.decompiler.flash.types.filters.FILTER;
import com.jpexs.decompiler.flash.types.filters.GLOWFILTER;
import com.jpexs.decompiler.flash.types.filters.GRADIENTBEVELFILTER;
import com.jpexs.decompiler.flash.types.filters.GRADIENTGLOWFILTER;
import com.jpexs.decompiler.flash.types.shaperecords.CurvedEdgeRecord;
import com.jpexs.decompiler.flash.types.shaperecords.EndShapeRecord;
import com.jpexs.decompiler.flash.types.shaperecords.SHAPERECORD;
import com.jpexs.decompiler.flash.types.shaperecords.StraightEdgeRecord;
import com.jpexs.decompiler.flash.types.shaperecords.StyleChangeRecord;
import com.jpexs.helpers.ByteArrayRange;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.ImmediateFuture;
import com.jpexs.helpers.MemoryInputStream;
import com.jpexs.helpers.ProgressListener;
import com.jpexs.helpers.utf8.Utf8Helper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.InflaterInputStream;

public class SWFInputStream
implements AutoCloseable {
    private MemoryInputStream is;
    private long startingPos;
    private static final Logger logger = Logger.getLogger(SWFInputStream.class.getName());
    public static final byte[] BYTE_ARRAY_EMPTY = new byte[0];
    private final List<ProgressListener> listeners = new ArrayList<ProgressListener>();
    private long percentMax;
    private SWF swf;
    public DumpInfo dumpInfo;
    private byte[] data;
    private int limit;
    private int lastPercent = -1;
    private int bitPos = 0;
    private int tempByte = 0;

    public String getCharset() {
        if (this.swf == null) {
            return Utf8Helper.charsetName;
        }
        return this.swf.getCharset();
    }

    public void addPercentListener(ProgressListener listener) {
        this.listeners.add(listener);
    }

    public void removePercentListener(ProgressListener listener) {
        int index = this.listeners.indexOf(listener);
        if (index > -1) {
            this.listeners.remove(index);
        }
    }

    private void informListeners() {
        int percent;
        if (this.listeners.size() > 0 && this.percentMax > 0L && this.lastPercent != (percent = (int)(this.getPos() * 100L / this.percentMax))) {
            for (ProgressListener pl : this.listeners) {
                pl.progress(percent);
            }
            this.lastPercent = percent;
        }
    }

    public void setPercentMax(long percentMax) {
        this.percentMax = percentMax;
    }

    public SWFInputStream(SWF swf, byte[] data, long startingPos, int limit) throws IOException {
        this.swf = swf;
        this.startingPos = startingPos;
        this.data = data;
        this.limit = limit;
        this.is = new MemoryInputStream(data, 0, limit);
    }

    public SWFInputStream(SWF swf, byte[] data) throws IOException {
        this(swf, data, 0L, data.length);
    }

    public SWF getSwf() {
        return this.swf;
    }

    public long getPos() {
        return this.startingPos + this.is.getPos();
    }

    public void seek(long pos) throws IOException {
        this.is.seek(pos - this.startingPos);
    }

    private DumpInfo newDumpLevel(String name, String type) {
        return this.newDumpLevel(name, type, DumpInfoSpecialType.NONE, null);
    }

    private DumpInfo newDumpLevel(String name, String type, DumpInfoSpecialType specialType, Object specialValue) {
        if (this.dumpInfo != null) {
            long startByte = this.is.getPos();
            if (this.bitPos > 0) {
                --startByte;
            }
            DumpInfo di = specialType == DumpInfoSpecialType.NONE ? new DumpInfo(name, type, null, startByte, this.bitPos, 0L, 0) : new DumpInfoSpecial(name, type, null, startByte, this.bitPos, 0L, 0, specialType, specialValue);
            di.parent = this.dumpInfo;
            this.dumpInfo.getChildInfos().add(di);
            this.dumpInfo = di;
        }
        return this.dumpInfo;
    }

    private void endDumpLevel() {
        this.endDumpLevel(null);
    }

    private void endDumpLevel(Object value) {
        if (this.dumpInfo != null) {
            if (this.dumpInfo.startBit == 0 && this.bitPos == 0) {
                this.dumpInfo.lengthBytes = this.is.getPos() - this.dumpInfo.startByte;
            } else {
                this.dumpInfo.lengthBits = (int)((this.is.getPos() - this.dumpInfo.startByte - 1L) * 8L - (long)this.dumpInfo.startBit + (long)(this.bitPos == 0 ? 8 : this.bitPos));
            }
            this.dumpInfo.previewValue = value;
            this.dumpInfo = this.dumpInfo.parent;
        }
    }

    private void endDumpLevelUntil(DumpInfo di) {
        if (di != null) {
            while (this.dumpInfo != null && this.dumpInfo != di) {
                this.endDumpLevel();
            }
        }
    }

    private int readEx() throws IOException {
        this.bitPos = 0;
        return this.readNoBitReset();
    }

    private void alignByte() {
        this.bitPos = 0;
    }

    private int readNoBitReset() throws IOException, EndOfStreamException {
        int r = this.is.read();
        if (r == -1) {
            throw new EndOfStreamException();
        }
        this.informListeners();
        return r;
    }

    public int readUI8(String name) throws IOException {
        this.newDumpLevel(name, "UI8");
        int ret = this.readEx();
        this.endDumpLevel(ret);
        return ret;
    }

    public String readString(String name) throws IOException {
        this.newDumpLevel(name, "string");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while (true) {
            int r;
            if ((r = this.readEx()) == 0) {
                this.endDumpLevel();
                return new String(baos.toByteArray(), this.swf == null ? Utf8Helper.charsetName : this.swf.getCharset());
            }
            baos.write(r);
        }
    }

    public String readNetString(String name) throws IOException {
        this.newDumpLevel(name, "string");
        int length = this.readEx();
        String ret = new String(this.readBytesInternalEx(length), this.swf.getCharset());
        this.endDumpLevel();
        return ret;
    }

    public long readUI32(String name) throws IOException {
        this.newDumpLevel(name, "UI32");
        long ret = this.readUI32Internal();
        this.endDumpLevel(ret);
        return ret;
    }

    private long readUI32Internal() throws IOException {
        return (long)(this.readEx() + (this.readEx() << 8) + (this.readEx() << 16) + (this.readEx() << 24)) & 0xFFFFFFFFL;
    }

    public int readUI16(String name) throws IOException {
        this.newDumpLevel(name, "UI16");
        int ret = this.readUI16Internal();
        this.endDumpLevel(ret);
        return ret;
    }

    private int readUI16Internal() throws IOException {
        return this.readEx() + (this.readEx() << 8);
    }

    public int readUI24(String name) throws IOException {
        this.newDumpLevel(name, "UI24");
        int ret = this.readEx() + (this.readEx() << 8) + (this.readEx() << 16);
        this.endDumpLevel(ret);
        return ret;
    }

    public long readSI32(String name) throws IOException {
        this.newDumpLevel(name, "SI32");
        long uval = this.readSI32Internal();
        this.endDumpLevel(uval);
        return uval;
    }

    private long readSI32Internal() throws IOException {
        long uval = this.readEx() + (this.readEx() << 8) + (this.readEx() << 16) + (this.readEx() << 24);
        if (uval >= Integer.MIN_VALUE) {
            uval = -(((uval ^ 0xFFFFFFFFFFFFFFFFL) & 0xFFFFFFFFFFFFFFFFL) + 1L);
        }
        return uval;
    }

    public int readSI16(String name) throws IOException {
        this.newDumpLevel(name, "SI16");
        int uval = this.readSI16Internal();
        this.endDumpLevel(uval);
        return uval;
    }

    private int readSI16Internal() throws IOException {
        int uval = this.readEx() + (this.readEx() << 8);
        if (uval >= 32768) {
            uval = -((~uval & 0xFFFF) + 1);
        }
        return uval;
    }

    public int readSI8(String name) throws IOException {
        this.newDumpLevel(name, "SI8");
        int ret = this.readSI8Internal();
        this.endDumpLevel(ret);
        return ret;
    }

    public int readSI8Internal() throws IOException {
        int uval = this.readEx();
        if (uval >= 128) {
            uval = -((~uval & 0xFF) + 1);
        }
        return uval;
    }

    public double readFIXED(String name) throws IOException {
        this.newDumpLevel(name, "FIXED");
        long si = this.readSI32Internal();
        double ret = (double)si / 65536.0;
        this.endDumpLevel(ret);
        return ret;
    }

    public float readFIXED8(String name) throws IOException {
        this.newDumpLevel(name, "FIXED8");
        int si = this.readSI16Internal();
        float ret = (float)si / 256.0f;
        this.endDumpLevel(Float.valueOf(ret));
        return ret;
    }

    private long readLong() throws IOException {
        byte[] readBuffer = this.readBytesInternalEx(8L);
        return ((long)readBuffer[3] << 56) + ((long)(readBuffer[2] & 0xFF) << 48) + ((long)(readBuffer[1] & 0xFF) << 40) + ((long)(readBuffer[0] & 0xFF) << 32) + ((long)(readBuffer[7] & 0xFF) << 24) + (long)((readBuffer[6] & 0xFF) << 16) + (long)((readBuffer[5] & 0xFF) << 8) + (long)(readBuffer[4] & 0xFF);
    }

    public double readDOUBLE(String name) throws IOException {
        this.newDumpLevel(name, "DOUBLE");
        long el = this.readLong();
        double ret = Double.longBitsToDouble(el);
        this.endDumpLevel(ret);
        return ret;
    }

    public float readFLOAT(String name) throws IOException {
        this.newDumpLevel(name, "FLOAT");
        int val = (int)this.readUI32Internal();
        float ret = Float.intBitsToFloat(val);
        this.endDumpLevel(Float.valueOf(ret));
        return ret;
    }

    public float readFLOAT16(String name) throws IOException {
        this.newDumpLevel(name, "FLOAT16");
        int val = this.readUI16Internal();
        int sign = val >> 15;
        int mantisa = val & 0x3FF;
        int exp = val >> 10 & 0x1F;
        float ret = (float)(sign == 1 ? -1 : 1) * (float)Math.pow(2.0, exp) * (1.0f + (float)mantisa / 1024.0f);
        this.endDumpLevel(Float.valueOf(ret));
        return ret;
    }

    public byte[] readBytesEx(long count, String name) throws IOException {
        if (count <= 0L) {
            return BYTE_ARRAY_EMPTY;
        }
        this.newDumpLevel(name, "bytes");
        byte[] ret = this.readBytesInternalEx(count);
        this.endDumpLevel();
        return ret;
    }

    public Amf3Value readAmf3Object(String name) throws IOException, NoSerializerExistsException {
        Amf3InputStream ai = new Amf3InputStream(this.is);
        ai.dumpInfo = this.dumpInfo;
        return new Amf3Value(ai.readValue("amfData"));
    }

    public ByteArrayRange readByteRangeEx(long count, String name) throws IOException {
        return this.readByteRangeEx(count, name, DumpInfoSpecialType.NONE, null);
    }

    public ByteArrayRange readByteRangeEx(long count, String name, DumpInfoSpecialType specialType, Object specialValue) throws IOException {
        if (count <= 0L) {
            return ByteArrayRange.EMPTY;
        }
        this.newDumpLevel(name, "bytes", specialType, specialValue);
        int startPos = (int)this.is.getPos();
        this.skipBytesEx(count);
        this.endDumpLevel();
        return new ByteArrayRange(this.data, startPos, (int)count);
    }

    private byte[] readBytesInternalEx(long count) throws IOException {
        if (count <= 0L) {
            return BYTE_ARRAY_EMPTY;
        }
        this.bitPos = 0;
        byte[] ret = new byte[(int)count];
        if ((long)this.is.read(ret) != count) {
            throw new EndOfStreamException();
        }
        this.informListeners();
        return ret;
    }

    public void skipBytesEx(long count) throws IOException {
        if (count <= 0L) {
            return;
        }
        this.bitPos = 0;
        this.is.seek(this.is.getPos() + count);
        if (this.is.available() < 0) {
            throw new EndOfStreamException();
        }
        this.informListeners();
    }

    public void skipBytesEx(long count, String name) throws IOException {
        if (count <= 0L) {
            return;
        }
        this.newDumpLevel(name, "bytes");
        this.skipBytesEx(count);
        this.endDumpLevel();
    }

    public void skipBytes(long count) throws IOException {
        try {
            this.skipBytesEx(count);
        }
        catch (EndOfStreamException | EOFException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
    }

    public byte[] readBytes(int count, String name) throws IOException {
        if (count <= 0) {
            return BYTE_ARRAY_EMPTY;
        }
        this.newDumpLevel(name, "bytes");
        byte[] ret = new byte[count];
        int i = 0;
        try {
            for (i = 0; i < count; ++i) {
                ret[i] = (byte)this.readEx();
            }
        }
        catch (EndOfStreamException | EOFException ex) {
            ret = Arrays.copyOf(ret, i);
            logger.log(Level.SEVERE, null, ex);
        }
        this.endDumpLevel();
        return ret;
    }

    public byte[] readBytesZlib(long count, String name) throws IOException {
        if (count == 0L) {
            return BYTE_ARRAY_EMPTY;
        }
        this.newDumpLevel(name, "bytesZlib");
        byte[] data = this.readBytesInternalEx(count);
        this.endDumpLevel();
        return SWFInputStream.uncompressByteArray(data);
    }

    public static byte[] uncompressByteArray(byte[] data) throws IOException {
        return SWFInputStream.uncompressByteArray(data, 0, data.length);
    }

    public static byte[] uncompressByteArray(byte[] data, int offset, int length) throws IOException {
        int c;
        InflaterInputStream dis = new InflaterInputStream(new ByteArrayInputStream(data, offset, length));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[4096];
        while ((c = dis.read(buf)) > 0) {
            baos.write(buf, 0, c);
        }
        return baos.toByteArray();
    }

    public long readEncodedU32(String name) throws IOException {
        this.newDumpLevel(name, "encodedU32");
        int result = this.readEx();
        if ((result & 0x80) == 0) {
            this.endDumpLevel(result);
            return result;
        }
        if (((result = result & 0x7F | this.readEx() << 7) & 0x4000) == 0) {
            this.endDumpLevel(result);
            return result;
        }
        if (((result = result & 0x3FFF | this.readEx() << 14) & 0x200000) == 0) {
            this.endDumpLevel(result);
            return result;
        }
        if (((result = result & 0x1FFFFF | this.readEx() << 21) & 0x10000000) == 0) {
            this.endDumpLevel(result);
            return result;
        }
        result = result & 0xFFFFFFF | this.readEx() << 28;
        this.endDumpLevel(result);
        return result;
    }

    public long readUB(int nBits, String name) throws IOException {
        if (nBits == 0) {
            return 0L;
        }
        this.newDumpLevel(name, "UB");
        long ret = this.readUBInternal(nBits);
        this.endDumpLevel(ret);
        return ret;
    }

    private long readUBInternal(int nBits) throws IOException {
        if (nBits == 0) {
            return 0L;
        }
        long ret = 0L;
        if (this.bitPos == 0) {
            this.tempByte = this.readNoBitReset();
        }
        for (int bit = 0; bit < nBits; ++bit) {
            int nb = this.tempByte >> 7 - this.bitPos & 1;
            ret += (long)(nb << nBits - 1 - bit);
            ++this.bitPos;
            if (this.bitPos != 8) continue;
            this.bitPos = 0;
            if (bit == nBits - 1) continue;
            this.tempByte = this.readNoBitReset();
        }
        return ret;
    }

    public long readSB(int nBits, String name) throws IOException {
        if (nBits == 0) {
            return 0L;
        }
        this.newDumpLevel(name, "SB");
        long ret = this.readSBInternal(nBits);
        this.endDumpLevel(ret);
        return ret;
    }

    private long readSBInternal(int nBits) throws IOException {
        int uval = (int)this.readUBInternal(nBits);
        int shift = 32 - nBits;
        uval = uval << shift >> shift;
        return uval;
    }

    public float readFB(int nBits, String name) throws IOException {
        if (nBits == 0) {
            return 0.0f;
        }
        this.newDumpLevel(name, "FB");
        float val = this.readSBInternal(nBits);
        float ret = val / 65536.0f;
        this.endDumpLevel(Float.valueOf(ret));
        return ret;
    }

    public RECT readRECT(String name) throws IOException {
        RECT ret = new RECT();
        this.newDumpLevel(name, "RECT");
        int NBits = (int)this.readUB(5, "NBits");
        ret.Xmin = (int)this.readSB(NBits, "Xmin");
        ret.Xmax = (int)this.readSB(NBits, "Xmax");
        ret.Ymin = (int)this.readSB(NBits, "Ymin");
        ret.Ymax = (int)this.readSB(NBits, "Ymax");
        ret.nbits = NBits;
        this.alignByte();
        this.endDumpLevel();
        return ret;
    }

    private static void dumpTag(PrintStream out, Tag tag, int index, int level) {
        StringBuilder sb = new StringBuilder();
        sb.append(Helper.formatHex((int)tag.getPos(), 8));
        sb.append(": ");
        sb.append(Helper.indent(level, "", "  "));
        sb.append(Helper.formatInt(index, 4));
        sb.append(". ");
        sb.append(Helper.format(tag.toString(), 25 - 2 * level));
        sb.append(" tagId=");
        sb.append(Helper.formatInt(tag.getId(), 3));
        sb.append(" len=");
        sb.append(Helper.formatInt(tag.getOriginalDataLength(), 8));
        sb.append("  ");
        sb.append(Helper.bytesToHexString(64, tag.getOriginalData(), 0));
        out.println(sb.toString());
        if (tag instanceof DefineSpriteTag) {
            int i = 0;
            for (Tag subTag : ((DefineSpriteTag)tag).getTags()) {
                SWFInputStream.dumpTag(out, subTag, i++, level + 1);
            }
        }
    }

    @Override
    public void close() {
    }

    public List<Tag> readTagList(Timelined timelined, int level, boolean parallel, boolean skipUnusualTags, boolean parseTags, boolean lazy) throws IOException, InterruptedException {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
        boolean parallel1 = level == 0 && parallel;
        ExecutorService executor = null;
        ArrayList<ImmediateFuture<Tag>> futureResults = new ArrayList<ImmediateFuture<Tag>>();
        if (parallel1) {
            executor = Executors.newFixedThreadPool(Configuration.getParallelThreadCount());
            futureResults = new ArrayList();
        }
        ArrayList<Tag> tags = new ArrayList<Tag>();
        while (this.available() > 0) {
            Future<Tag> future;
            DumpInfo di;
            Tag tag;
            long pos = this.getPos();
            this.newDumpLevel(null, "TAG", DumpInfoSpecialType.TAG, this.getPos());
            try {
                tag = this.readTag(timelined, level, pos, false, parallel1, skipUnusualTags, lazy);
            }
            catch (EndOfStreamException | EOFException ex) {
                tag = null;
            }
            boolean doParse = true;
            if (parseTags && !parallel1 && doParse && tag instanceof TagStub) {
                tag = SWFInputStream.resolveTag((TagStub)tag, level, parallel, skipUnusualTags, lazy, true);
            }
            if ((di = this.dumpInfo) != null && tag != null) {
                di.name = tag.getName();
            }
            this.endDumpLevel(tag == null ? null : Integer.valueOf(tag.getId()));
            if (tag == null) break;
            tag.setTimelined(timelined);
            if (!parallel1) {
                tags.add(tag);
            }
            if (Configuration.dumpTags.get().booleanValue() && level == 0) {
                SWFInputStream.dumpTag(System.out, tag, tags.size() - 1, level);
            }
            if (parseTags && doParse && parallel1 && tag instanceof TagStub && executor != null) {
                future = executor.submit(new TagResolutionTask((TagStub)tag, di, level, parallel1, skipUnusualTags, lazy));
                futureResults.add((ImmediateFuture<Tag>)future);
            } else {
                future = new ImmediateFuture<Tag>(tag);
                futureResults.add((ImmediateFuture<Tag>)future);
                if (!(tag instanceof TagStub) && di != null) {
                    di.name = tag.getName();
                }
            }
            if (tag.getId() != 0) continue;
            break;
        }
        if (parallel1) {
            for (Future future : futureResults) {
                try {
                    tags.add((Tag)future.get());
                }
                catch (InterruptedException ex) {
                    future.cancel(true);
                }
                catch (ExecutionException e) {
                    logger.log(Level.SEVERE, "Error during tag reading", e);
                }
            }
            if (executor != null) {
                executor.shutdown();
            }
        }
        return tags;
    }

    public static Tag resolveTag(TagStub tag, int level, boolean parallel, boolean skipUnusualTags, boolean lazy, boolean logErrors) throws InterruptedException {
        Tag ret;
        ByteArrayRange data = tag.getOriginalRange();
        SWF swf = tag.getSwf();
        SWFInputStream sis = tag.getDataStream();
        try {
            block1 : switch (tag.getId()) {
                case 0: {
                    ret = new EndTag(sis, data);
                    break;
                }
                case 1: {
                    ret = new ShowFrameTag(sis, data);
                    break;
                }
                case 2: {
                    ret = new DefineShapeTag(sis, data, lazy);
                    break;
                }
                case 3: {
                    ret = new FreeCharacterTag(sis, data);
                    break;
                }
                case 4: {
                    ret = new PlaceObjectTag(sis, data);
                    break;
                }
                case 5: {
                    ret = new RemoveObjectTag(sis, data);
                    break;
                }
                case 6: {
                    ret = new DefineBitsTag(sis, data);
                    break;
                }
                case 7: {
                    ret = new DefineButtonTag(sis, data);
                    break;
                }
                case 8: {
                    ret = new JPEGTablesTag(sis, data);
                    break;
                }
                case 9: {
                    ret = new SetBackgroundColorTag(sis, data);
                    break;
                }
                case 10: {
                    ret = new DefineFontTag(sis, data);
                    break;
                }
                case 11: {
                    ret = new DefineTextTag(sis, data);
                    break;
                }
                case 12: {
                    ret = new DoActionTag(sis, data);
                    break;
                }
                case 13: {
                    ret = new DefineFontInfoTag(sis, data);
                    break;
                }
                case 14: {
                    ret = new DefineSoundTag(sis, data);
                    break;
                }
                case 15: {
                    ret = new StartSoundTag(sis, data);
                    break;
                }
                case 17: {
                    ret = new DefineButtonSoundTag(sis, data);
                    break;
                }
                case 18: {
                    ret = new SoundStreamHeadTag(sis, data);
                    break;
                }
                case 19: {
                    ret = new SoundStreamBlockTag(sis, data);
                    break;
                }
                case 20: {
                    ret = new DefineBitsLosslessTag(sis, data);
                    break;
                }
                case 21: {
                    ret = new DefineBitsJPEG2Tag(sis, data);
                    break;
                }
                case 22: {
                    ret = new DefineShape2Tag(sis, data, lazy);
                    break;
                }
                case 23: {
                    ret = new DefineButtonCxformTag(sis, data);
                    break;
                }
                case 24: {
                    ret = new ProtectTag(sis, data);
                    break;
                }
                case 25: {
                    ret = new PathsArePostScriptTag(sis, data);
                    break;
                }
                case 26: {
                    ret = new PlaceObject2Tag(sis, data);
                    break;
                }
                case 28: {
                    ret = new RemoveObject2Tag(sis, data);
                    break;
                }
                case 29: {
                    ret = new SyncFrameTag(sis, data);
                    break;
                }
                case 31: {
                    ret = new FreeAllTag(sis, data);
                    break;
                }
                case 32: {
                    ret = new DefineShape3Tag(sis, data, lazy);
                    break;
                }
                case 33: {
                    ret = new DefineText2Tag(sis, data);
                    break;
                }
                case 34: {
                    ret = new DefineButton2Tag(sis, data);
                    break;
                }
                case 35: {
                    ret = new DefineBitsJPEG3Tag(sis, data);
                    break;
                }
                case 36: {
                    ret = new DefineBitsLossless2Tag(sis, data);
                    break;
                }
                case 37: {
                    ret = new DefineEditTextTag(sis, data);
                    break;
                }
                case 39: {
                    ret = new DefineSpriteTag(sis, level, data, parallel, skipUnusualTags);
                    break;
                }
                case 40: {
                    ret = new NameCharacterTag(sis, data);
                    break;
                }
                case 41: {
                    ret = new ProductInfoTag(sis, data);
                    break;
                }
                case 43: {
                    ret = new FrameLabelTag(sis, data);
                    break;
                }
                case 45: {
                    ret = new SoundStreamHead2Tag(sis, data);
                    break;
                }
                case 46: {
                    ret = new DefineMorphShapeTag(sis, data);
                    break;
                }
                case 48: {
                    ret = new DefineFont2Tag(sis, data);
                    break;
                }
                case 56: {
                    ret = new ExportAssetsTag(sis, data);
                    break;
                }
                case 57: {
                    ret = new ImportAssetsTag(sis, data);
                    break;
                }
                case 58: {
                    ret = new EnableDebuggerTag(sis, data);
                    break;
                }
                case 59: {
                    ret = new DoInitActionTag(sis, data);
                    break;
                }
                case 60: {
                    ret = new DefineVideoStreamTag(sis, data);
                    break;
                }
                case 61: {
                    ret = new VideoFrameTag(sis, data);
                    break;
                }
                case 62: {
                    ret = new DefineFontInfo2Tag(sis, data);
                    break;
                }
                case 63: {
                    ret = new DebugIDTag(sis, data);
                    break;
                }
                case 64: {
                    ret = new EnableDebugger2Tag(sis, data);
                    break;
                }
                case 65: {
                    ret = new ScriptLimitsTag(sis, data);
                    break;
                }
                case 66: {
                    ret = new SetTabIndexTag(sis, data);
                    break;
                }
                case 69: {
                    ret = new FileAttributesTag(sis, data);
                    break;
                }
                case 70: {
                    ret = new PlaceObject3Tag(sis, data);
                    break;
                }
                case 71: {
                    ret = new ImportAssets2Tag(sis, data);
                    break;
                }
                case 72: {
                    ret = new DoABCTag(sis, data);
                    break;
                }
                case 73: {
                    ret = new DefineFontAlignZonesTag(sis, data);
                    break;
                }
                case 74: {
                    ret = new CSMTextSettingsTag(sis, data);
                    break;
                }
                case 75: {
                    ret = new DefineFont3Tag(sis, data);
                    break;
                }
                case 76: {
                    ret = new SymbolClassTag(sis, data);
                    break;
                }
                case 77: {
                    ret = new MetadataTag(sis, data);
                    break;
                }
                case 78: {
                    ret = new DefineScalingGridTag(sis, data);
                    break;
                }
                case 82: {
                    ret = new DoABC2Tag(sis, data);
                    break;
                }
                case 83: {
                    ret = new DefineShape4Tag(sis, data, lazy);
                    break;
                }
                case 84: {
                    ret = new DefineMorphShape2Tag(sis, data);
                    break;
                }
                case 86: {
                    ret = new DefineSceneAndFrameLabelDataTag(sis, data);
                    break;
                }
                case 87: {
                    ret = new DefineBinaryDataTag(sis, data);
                    break;
                }
                case 88: {
                    ret = new DefineFontNameTag(sis, data);
                    break;
                }
                case 89: {
                    ret = new StartSound2Tag(sis, data);
                    break;
                }
                case 90: {
                    ret = new DefineBitsJPEG4Tag(sis, data);
                    break;
                }
                case 91: {
                    ret = new DefineFont4Tag(sis, data);
                    break;
                }
                case 93: {
                    ret = new EnableTelemetryTag(sis, data);
                    break;
                }
                case 94: {
                    ret = new PlaceObject4Tag(sis, data);
                    break;
                }
                default: {
                    if (swf.gfx) {
                        switch (tag.getId()) {
                            case 1000: {
                                ret = new ExporterInfo(sis, data);
                                break block1;
                            }
                            case 1001: {
                                ret = new DefineExternalImage(sis, data);
                                break block1;
                            }
                            case 1002: {
                                ret = new FontTextureInfo(sis, data);
                                break block1;
                            }
                            case 1003: {
                                ret = new DefineExternalGradient(sis, data);
                                break block1;
                            }
                            case 1004: {
                                ret = new DefineGradientMap(sis, data);
                                break block1;
                            }
                            case 1005: {
                                ret = new DefineCompactedFont(sis, data);
                                break block1;
                            }
                            case 1006: {
                                ret = new DefineExternalSound(sis, data);
                                break block1;
                            }
                            case 1007: {
                                ret = new DefineExternalStreamSound(sis, data);
                                break block1;
                            }
                            case 1008: {
                                ret = new DefineSubImage(sis, data);
                                break block1;
                            }
                            case 1009: {
                                ret = new DefineExternalImage2(sis, data);
                                break block1;
                            }
                        }
                        ret = new UnknownTag(sis, tag.getId(), data);
                        break;
                    }
                    ret = new UnknownTag(sis, tag.getId(), data);
                }
            }
            if (sis.available() > 0) {
                ret.remainingData = sis.readByteRangeEx(sis.available(), "remaining");
            }
        }
        catch (IOException ex) {
            if (logErrors) {
                logger.log(Level.SEVERE, "Error during tag reading. SWF: " + swf.getTitleOrShortFileName() + " ID: " + tag.getId() + " name: " + tag.getName() + " pos: " + data.getPos(), ex);
            }
            ret = new TagStub(swf, tag.getId(), "Error", data, null);
        }
        ret.forceWriteAsLong = tag.forceWriteAsLong;
        ret.setTimelined(tag.getTimelined());
        return ret;
    }

    public Tag readTag(Timelined timelined, int level, long pos, boolean resolve, boolean parallel, boolean skipUnusualTags, boolean lazy) throws IOException, InterruptedException {
        int tagIDTagLength = this.readUI16("tagIDTagLength");
        int tagID = tagIDTagLength >> 6;
        logger.log(Level.FINE, "Reading tag. ID={0}, position: {1}", new Object[]{tagID, pos});
        long tagLength = tagIDTagLength & 0x3F;
        boolean readLong = false;
        if (tagLength == 63L) {
            tagLength = this.readSI32("tagLength");
            readLong = true;
        }
        int headerLength = readLong ? 6 : 2;
        SWFInputStream tagDataStream = this.getLimitedStream((int)tagLength);
        int available = this.available();
        if (tagLength > (long)available) {
            tagLength = available;
        }
        ByteArrayRange dataRange = new ByteArrayRange(this.data, (int)pos, (int)(tagLength + (long)headerLength));
        this.skipBytes(tagLength);
        TagStub tagStub = new TagStub(this.swf, tagID, "Unresolved", dataRange, tagDataStream);
        tagStub.forceWriteAsLong = readLong;
        Tag ret = tagStub;
        if (tagDataStream.dumpInfo == null && this.dumpInfo != null) {
            this.dumpInfo.tagToResolve = tagStub;
        }
        if (resolve) {
            DumpInfo di = this.dumpInfo;
            try {
                ret = SWFInputStream.resolveTag(tagStub, level, parallel, skipUnusualTags, lazy, true);
            }
            catch (Exception ex) {
                tagDataStream.endDumpLevelUntil(di);
                logger.log(Level.SEVERE, "Problem in " + timelined.toString(), ex);
            }
            if (Configuration._debugMode.get().booleanValue()) {
                byte[] data = ret.getOriginalData();
                byte[] dataNew = ret.getData();
                int ignoreFirst = 0;
                for (int i = 0; i < data.length && i < dataNew.length; ++i) {
                    if (dataNew[i] == data[i]) continue;
                    if (ignoreFirst > 0) {
                        --ignoreFirst;
                        continue;
                    }
                    String e = "TAG " + ret.toString() + " WRONG, ";
                    for (int j = i - 10; j <= i + 5; ++j) {
                        while (j < 0) {
                            ++j;
                        }
                        if (j >= data.length || j >= dataNew.length) break;
                        e = j >= i ? e + Long.toHexString(data[j] & 0xFF) + " ( is " + Long.toHexString(dataNew[j] & 0xFF) + ") " : e + Long.toHexString(data[j] & 0xFF) + " ";
                    }
                    logger.fine(e);
                }
            }
        }
        return ret;
    }

    public Action readAction() throws IOException {
        try {
            int actionCode = this.readUI8("actionCode");
            if (actionCode == 0) {
                return new ActionEnd(this.getCharset());
            }
            if (actionCode == -1) {
                return null;
            }
            int actionLength = 0;
            if (actionCode >= 128) {
                actionLength = this.readUI16("actionLength");
            }
            switch (actionCode) {
                case 129: {
                    return new ActionGotoFrame(actionLength, this);
                }
                case 131: {
                    return new ActionGetURL(actionLength, this, this.swf.version);
                }
                case 4: {
                    return new ActionNextFrame();
                }
                case 5: {
                    return new ActionPrevFrame();
                }
                case 6: {
                    return new ActionPlay();
                }
                case 7: {
                    return new ActionStop();
                }
                case 8: {
                    return new ActionToggleQuality();
                }
                case 9: {
                    return new ActionStopSounds();
                }
                case 138: {
                    return new ActionWaitForFrame(actionLength, this);
                }
                case 139: {
                    return new ActionSetTarget(actionLength, this, this.swf.version);
                }
                case 140: {
                    return new ActionGoToLabel(actionLength, this, this.swf.version);
                }
                case 150: {
                    return new ActionPush(actionLength, this, this.swf.version);
                }
                case 23: {
                    return new ActionPop();
                }
                case 10: {
                    return new ActionAdd();
                }
                case 11: {
                    return new ActionSubtract();
                }
                case 12: {
                    return new ActionMultiply();
                }
                case 13: {
                    return new ActionDivide();
                }
                case 14: {
                    return new ActionEquals(this.getCharset());
                }
                case 15: {
                    return new ActionLess();
                }
                case 16: {
                    return new ActionAnd();
                }
                case 17: {
                    return new ActionOr();
                }
                case 18: {
                    return new ActionNot();
                }
                case 19: {
                    return new ActionStringEquals();
                }
                case 20: {
                    return new ActionStringLength();
                }
                case 33: {
                    return new ActionStringAdd();
                }
                case 21: {
                    return new ActionStringExtract();
                }
                case 41: {
                    return new ActionStringLess();
                }
                case 49: {
                    return new ActionMBStringLength();
                }
                case 53: {
                    return new ActionMBStringExtract();
                }
                case 24: {
                    return new ActionToInteger();
                }
                case 50: {
                    return new ActionCharToAscii();
                }
                case 51: {
                    return new ActionAsciiToChar();
                }
                case 54: {
                    return new ActionMBCharToAscii();
                }
                case 55: {
                    return new ActionMBAsciiToChar();
                }
                case 153: {
                    return new ActionJump(actionLength, this);
                }
                case 157: {
                    return new ActionIf(actionLength, this);
                }
                case 158: {
                    return new ActionCall(actionLength, this.getCharset());
                }
                case 28: {
                    return new ActionGetVariable();
                }
                case 29: {
                    return new ActionSetVariable();
                }
                case 154: {
                    return new ActionGetURL2(actionLength, this, this.getCharset());
                }
                case 159: {
                    return new ActionGotoFrame2(actionLength, this);
                }
                case 32: {
                    return new ActionSetTarget2(this.getCharset());
                }
                case 34: {
                    return new ActionGetProperty();
                }
                case 35: {
                    return new ActionSetProperty();
                }
                case 36: {
                    return new ActionCloneSprite();
                }
                case 37: {
                    return new ActionRemoveSprite();
                }
                case 39: {
                    return new ActionStartDrag();
                }
                case 40: {
                    return new ActionEndDrag();
                }
                case 141: {
                    return new ActionWaitForFrame2(actionLength, this);
                }
                case 38: {
                    return new ActionTrace();
                }
                case 52: {
                    return new ActionGetTime();
                }
                case 48: {
                    return new ActionRandomNumber();
                }
                case 61: {
                    return new ActionCallFunction();
                }
                case 82: {
                    return new ActionCallMethod();
                }
                case 136: {
                    return new ActionConstantPool(actionLength, this, this.swf.version);
                }
                case 155: {
                    return new ActionDefineFunction(actionLength, this, this.swf.version);
                }
                case 60: {
                    return new ActionDefineLocal();
                }
                case 65: {
                    return new ActionDefineLocal2();
                }
                case 58: {
                    return new ActionDelete();
                }
                case 59: {
                    return new ActionDelete2();
                }
                case 70: {
                    return new ActionEnumerate();
                }
                case 73: {
                    return new ActionEquals2();
                }
                case 78: {
                    return new ActionGetMember();
                }
                case 66: {
                    return new ActionInitArray();
                }
                case 67: {
                    return new ActionInitObject();
                }
                case 83: {
                    return new ActionNewMethod();
                }
                case 64: {
                    return new ActionNewObject();
                }
                case 79: {
                    return new ActionSetMember();
                }
                case 69: {
                    return new ActionTargetPath();
                }
                case 148: {
                    return new ActionWith(actionLength, this, this.swf.version);
                }
                case 74: {
                    return new ActionToNumber();
                }
                case 75: {
                    return new ActionToString();
                }
                case 68: {
                    return new ActionTypeOf();
                }
                case 71: {
                    return new ActionAdd2();
                }
                case 72: {
                    return new ActionLess2();
                }
                case 63: {
                    return new ActionModulo();
                }
                case 96: {
                    return new ActionBitAnd();
                }
                case 99: {
                    return new ActionBitLShift();
                }
                case 97: {
                    return new ActionBitOr();
                }
                case 100: {
                    return new ActionBitRShift();
                }
                case 101: {
                    return new ActionBitURShift();
                }
                case 98: {
                    return new ActionBitXor();
                }
                case 81: {
                    return new ActionDecrement();
                }
                case 80: {
                    return new ActionIncrement();
                }
                case 76: {
                    return new ActionPushDuplicate(this.getCharset());
                }
                case 62: {
                    return new ActionReturn();
                }
                case 77: {
                    return new ActionStackSwap(this.getCharset());
                }
                case 135: {
                    return new ActionStoreRegister(actionLength, this);
                }
                case 84: {
                    return new ActionInstanceOf();
                }
                case 85: {
                    return new ActionEnumerate2();
                }
                case 102: {
                    return new ActionStrictEquals();
                }
                case 103: {
                    return new ActionGreater();
                }
                case 104: {
                    return new ActionStringGreater();
                }
                case 142: {
                    return new ActionDefineFunction2(actionLength, this, this.swf.version);
                }
                case 105: {
                    return new ActionExtends(this.getCharset());
                }
                case 43: {
                    return new ActionCastOp();
                }
                case 44: {
                    return new ActionImplementsOp(this.getCharset());
                }
                case 143: {
                    return new ActionTry(actionLength, this, this.swf.version);
                }
                case 42: {
                    return new ActionThrow();
                }
            }
            ActionUnknown r = new ActionUnknown(actionCode, actionLength, this.getCharset());
            if (Configuration.useDetailedLogging.get().booleanValue()) {
                logger.log(Level.SEVERE, "Unknown action code: {0}", actionCode);
            }
            return r;
        }
        catch (EndOfStreamException | ArrayIndexOutOfBoundsException eos) {
            return null;
        }
    }

    public MATRIX readMatrix(String name) throws IOException {
        MATRIX ret = new MATRIX();
        this.newDumpLevel(name, "MATRIX");
        boolean bl = ret.hasScale = this.readUB(1, "hasScale") == 1L;
        if (ret.hasScale) {
            int NScaleBits = (int)this.readUB(5, "NScaleBits");
            ret.scaleX = (int)this.readSB(NScaleBits, "scaleX");
            ret.scaleY = (int)this.readSB(NScaleBits, "scaleY");
            ret.nScaleBits = NScaleBits;
        }
        boolean bl2 = ret.hasRotate = this.readUB(1, "hasRotate") == 1L;
        if (ret.hasRotate) {
            int NRotateBits = (int)this.readUB(5, "NRotateBits");
            ret.rotateSkew0 = (int)this.readSB(NRotateBits, "rotateSkew0");
            ret.rotateSkew1 = (int)this.readSB(NRotateBits, "rotateSkew1");
            ret.nRotateBits = NRotateBits;
        }
        int NTranslateBits = (int)this.readUB(5, "NTranslateBits");
        ret.translateX = (int)this.readSB(NTranslateBits, "translateX");
        ret.translateY = (int)this.readSB(NTranslateBits, "translateY");
        ret.nTranslateBits = NTranslateBits;
        this.alignByte();
        this.endDumpLevel();
        return ret;
    }

    public CXFORMWITHALPHA readCXFORMWITHALPHA(String name) throws IOException {
        int Nbits;
        CXFORMWITHALPHA ret = new CXFORMWITHALPHA();
        this.newDumpLevel(name, "CXFORMWITHALPHA");
        ret.hasAddTerms = this.readUB(1, "hasAddTerms") == 1L;
        ret.hasMultTerms = this.readUB(1, "hasMultTerms") == 1L;
        ret.nbits = Nbits = (int)this.readUB(4, "Nbits");
        if (ret.hasMultTerms) {
            ret.redMultTerm = (int)this.readSB(Nbits, "redMultTerm");
            ret.greenMultTerm = (int)this.readSB(Nbits, "greenMultTerm");
            ret.blueMultTerm = (int)this.readSB(Nbits, "blueMultTerm");
            ret.alphaMultTerm = (int)this.readSB(Nbits, "alphaMultTerm");
        }
        if (ret.hasAddTerms) {
            ret.redAddTerm = (int)this.readSB(Nbits, "redAddTerm");
            ret.greenAddTerm = (int)this.readSB(Nbits, "greenAddTerm");
            ret.blueAddTerm = (int)this.readSB(Nbits, "blueAddTerm");
            ret.alphaAddTerm = (int)this.readSB(Nbits, "alphaAddTerm");
        }
        this.alignByte();
        this.endDumpLevel();
        return ret;
    }

    public CXFORM readCXFORM(String name) throws IOException {
        int Nbits;
        CXFORM ret = new CXFORM();
        this.newDumpLevel(name, "CXFORM");
        ret.hasAddTerms = this.readUB(1, "hasAddTerms") == 1L;
        ret.hasMultTerms = this.readUB(1, "hasMultTerms") == 1L;
        ret.nbits = Nbits = (int)this.readUB(4, "Nbits");
        if (ret.hasMultTerms) {
            ret.redMultTerm = (int)this.readSB(Nbits, "redMultTerm");
            ret.greenMultTerm = (int)this.readSB(Nbits, "greenMultTerm");
            ret.blueMultTerm = (int)this.readSB(Nbits, "blueMultTerm");
        }
        if (ret.hasAddTerms) {
            ret.redAddTerm = (int)this.readSB(Nbits, "redAddTerm");
            ret.greenAddTerm = (int)this.readSB(Nbits, "greenAddTerm");
            ret.blueAddTerm = (int)this.readSB(Nbits, "blueAddTerm");
        }
        this.alignByte();
        this.endDumpLevel();
        return ret;
    }

    public CLIPEVENTFLAGS readCLIPEVENTFLAGS(String name) throws IOException {
        CLIPEVENTFLAGS ret = new CLIPEVENTFLAGS();
        this.newDumpLevel(name, "CLIPEVENTFLAGS");
        ret.clipEventKeyUp = this.readUB(1, "clipEventKeyUp") == 1L;
        ret.clipEventKeyDown = this.readUB(1, "clipEventKeyDown") == 1L;
        ret.clipEventMouseUp = this.readUB(1, "clipEventMouseUp") == 1L;
        ret.clipEventMouseDown = this.readUB(1, "clipEventMouseDown") == 1L;
        ret.clipEventMouseMove = this.readUB(1, "clipEventMouseMove") == 1L;
        ret.clipEventUnload = this.readUB(1, "clipEventUnload") == 1L;
        ret.clipEventEnterFrame = this.readUB(1, "clipEventEnterFrame") == 1L;
        ret.clipEventLoad = this.readUB(1, "clipEventLoad") == 1L;
        ret.clipEventDragOver = this.readUB(1, "clipEventDragOver") == 1L;
        ret.clipEventRollOut = this.readUB(1, "clipEventRollOut") == 1L;
        ret.clipEventRollOver = this.readUB(1, "clipEventRollOver") == 1L;
        ret.clipEventReleaseOutside = this.readUB(1, "clipEventReleaseOutside") == 1L;
        ret.clipEventRelease = this.readUB(1, "clipEventRelease") == 1L;
        ret.clipEventPress = this.readUB(1, "clipEventPress") == 1L;
        ret.clipEventInitialize = this.readUB(1, "clipEventInitialize") == 1L;
        boolean bl = ret.clipEventData = this.readUB(1, "clipEventData") == 1L;
        if (this.swf.version >= 6 && this.available() > 0) {
            ret.reserved = (int)this.readUB(5, "reserved");
            ret.clipEventConstruct = this.readUB(1, "clipEventConstruct") == 1L;
            ret.clipEventKeyPress = this.readUB(1, "clipEventKeyPress") == 1L;
            ret.clipEventDragOut = this.readUB(1, "clipEventDragOut") == 1L;
            ret.reserved2 = (int)this.readUB(8, "reserved2");
        }
        this.endDumpLevel();
        return ret;
    }

    public CLIPACTIONRECORD readCLIPACTIONRECORD(SWF swf, Tag tag, String name, CLIPACTIONS parentClipActions) throws IOException {
        this.newDumpLevel(name, "CLIPACTIONRECORD");
        CLIPACTIONRECORD ret = new CLIPACTIONRECORD(swf, this, tag, parentClipActions);
        this.endDumpLevel();
        if (ret.eventFlags.isClear()) {
            return null;
        }
        return ret;
    }

    public CLIPACTIONS readCLIPACTIONS(SWF swf, Tag tag, String name) throws IOException {
        CLIPACTIONRECORD cr;
        CLIPACTIONS ret = new CLIPACTIONS();
        this.newDumpLevel(name, "CLIPACTIONS");
        ret.reserved = this.readUI16("reserved");
        ret.allEventFlags = this.readCLIPEVENTFLAGS("allEventFlags");
        ret.clipActionRecords = new ArrayList<CLIPACTIONRECORD>();
        while ((cr = this.readCLIPACTIONRECORD(swf, tag, "record", ret)) != null) {
            ret.clipActionRecords.add(cr);
        }
        this.endDumpLevel();
        return ret;
    }

    public COLORMATRIXFILTER readCOLORMATRIXFILTER(String name) throws IOException {
        COLORMATRIXFILTER ret = new COLORMATRIXFILTER();
        this.newDumpLevel(name, "COLORMATRIXFILTER");
        ret.matrix = new float[20];
        for (int i = 0; i < 20; ++i) {
            ret.matrix[i] = this.readFLOAT("cell");
        }
        this.endDumpLevel();
        return ret;
    }

    public RGBA readRGBA(String name) throws IOException {
        RGBA ret = new RGBA();
        this.newDumpLevel(name, "RGBA");
        ret.red = this.readUI8("red");
        ret.green = this.readUI8("green");
        ret.blue = this.readUI8("blue");
        ret.alpha = this.readUI8("alpha");
        this.endDumpLevel();
        return ret;
    }

    public int readRGBAInt(String name) throws IOException {
        this.newDumpLevel(name, "RGBA");
        int ret = this.readUI8("red") << 16 | this.readUI8("green") << 8 | this.readUI8("blue") | this.readUI8("alpha") << 24;
        this.endDumpLevel();
        return ret;
    }

    public ARGB readARGB(String name) throws IOException {
        ARGB ret = new ARGB();
        this.newDumpLevel(name, "ARGB");
        ret.alpha = this.readUI8("alpha");
        ret.red = this.readUI8("red");
        ret.green = this.readUI8("green");
        ret.blue = this.readUI8("blue");
        this.endDumpLevel();
        return ret;
    }

    public int readARGBInt(String name) throws IOException {
        this.newDumpLevel(name, "ARGB");
        int ret = this.readUI8("alpha") << 24 | this.readUI8("red") << 16 | this.readUI8("green") << 8 | this.readUI8("blue");
        this.endDumpLevel();
        return ret;
    }

    public RGB readRGB(String name) throws IOException {
        RGB ret = new RGB();
        this.newDumpLevel(name, "RGB");
        ret.red = this.readUI8("red");
        ret.green = this.readUI8("green");
        ret.blue = this.readUI8("blue");
        this.endDumpLevel();
        return ret;
    }

    public int readRGBInt(String name) throws IOException {
        this.newDumpLevel(name, "RGB");
        int ret = 0xFF000000 | this.readUI8("red") << 16 | this.readUI8("green") << 8 | this.readUI8("blue");
        this.endDumpLevel();
        return ret;
    }

    public CONVOLUTIONFILTER readCONVOLUTIONFILTER(String name) throws IOException {
        CONVOLUTIONFILTER ret = new CONVOLUTIONFILTER();
        this.newDumpLevel(name, "CONVOLUTIONFILTER");
        ret.matrixX = this.readUI8("matrixX");
        ret.matrixY = this.readUI8("matrixY");
        ret.divisor = this.readFLOAT("divisor");
        ret.bias = this.readFLOAT("bias");
        ret.matrix = new float[ret.matrixX][ret.matrixY];
        for (int x = 0; x < ret.matrixX; ++x) {
            for (int y = 0; y < ret.matrixY; ++y) {
                ret.matrix[x][y] = this.readFLOAT("cell");
            }
        }
        ret.defaultColor = this.readRGBA("defaultColor");
        ret.reserved = (int)this.readUB(6, "reserved");
        ret.clamp = this.readUB(1, "clamp") == 1L;
        ret.preserveAlpha = this.readUB(1, "preserveAlpha") == 1L;
        this.endDumpLevel();
        return ret;
    }

    public BLURFILTER readBLURFILTER(String name) throws IOException {
        BLURFILTER ret = new BLURFILTER();
        this.newDumpLevel(name, "BLURFILTER");
        ret.blurX = this.readFIXED("blurX");
        ret.blurY = this.readFIXED("blurY");
        ret.passes = (int)this.readUB(5, "passes");
        ret.reserved = (int)this.readUB(3, "reserved");
        this.endDumpLevel();
        return ret;
    }

    public DROPSHADOWFILTER readDROPSHADOWFILTER(String name) throws IOException {
        DROPSHADOWFILTER ret = new DROPSHADOWFILTER();
        this.newDumpLevel(name, "DROPSHADOWFILTER");
        ret.dropShadowColor = this.readRGBA("dropShadowColor");
        ret.blurX = this.readFIXED("blurX");
        ret.blurY = this.readFIXED("blurY");
        ret.angle = this.readFIXED("angle");
        ret.distance = this.readFIXED("distance");
        ret.strength = this.readFIXED8("strength");
        ret.innerShadow = this.readUB(1, "innerShadow") == 1L;
        ret.knockout = this.readUB(1, "knockout") == 1L;
        ret.compositeSource = this.readUB(1, "compositeSource") == 1L;
        ret.passes = (int)this.readUB(5, "passes");
        this.endDumpLevel();
        return ret;
    }

    public GLOWFILTER readGLOWFILTER(String name) throws IOException {
        GLOWFILTER ret = new GLOWFILTER();
        this.newDumpLevel(name, "GLOWFILTER");
        ret.glowColor = this.readRGBA("glowColor");
        ret.blurX = this.readFIXED("blurX");
        ret.blurY = this.readFIXED("blurY");
        ret.strength = this.readFIXED8("strength");
        ret.innerGlow = this.readUB(1, "innerGlow") == 1L;
        ret.knockout = this.readUB(1, "knockout") == 1L;
        ret.compositeSource = this.readUB(1, "compositeSource") == 1L;
        ret.passes = (int)this.readUB(5, "passes");
        this.endDumpLevel();
        return ret;
    }

    public BEVELFILTER readBEVELFILTER(String name) throws IOException {
        BEVELFILTER ret = new BEVELFILTER();
        this.newDumpLevel(name, "BEVELFILTER");
        ret.highlightColor = this.readRGBA("highlightColor");
        ret.shadowColor = this.readRGBA("shadowColor");
        ret.blurX = this.readFIXED("blurX");
        ret.blurY = this.readFIXED("blurY");
        ret.angle = this.readFIXED("angle");
        ret.distance = this.readFIXED("distance");
        ret.strength = this.readFIXED8("strength");
        ret.innerShadow = this.readUB(1, "innerShadow") == 1L;
        ret.knockout = this.readUB(1, "knockout") == 1L;
        ret.compositeSource = this.readUB(1, "compositeSource") == 1L;
        ret.onTop = this.readUB(1, "onTop") == 1L;
        ret.passes = (int)this.readUB(4, "passes");
        this.endDumpLevel();
        return ret;
    }

    public GRADIENTGLOWFILTER readGRADIENTGLOWFILTER(String name) throws IOException {
        int i;
        GRADIENTGLOWFILTER ret = new GRADIENTGLOWFILTER();
        this.newDumpLevel(name, "GRADIENTGLOWFILTER");
        int numColors = this.readUI8("numColors");
        ret.gradientColors = new RGBA[numColors];
        ret.gradientRatio = new int[numColors];
        for (i = 0; i < numColors; ++i) {
            ret.gradientColors[i] = this.readRGBA("gradientColor");
        }
        for (i = 0; i < numColors; ++i) {
            ret.gradientRatio[i] = this.readUI8("gradientRatio");
        }
        ret.blurX = this.readFIXED("blurX");
        ret.blurY = this.readFIXED("blurY");
        ret.angle = this.readFIXED("angle");
        ret.distance = this.readFIXED("distance");
        ret.strength = this.readFIXED8("strength");
        ret.innerShadow = this.readUB(1, "innerShadow") == 1L;
        ret.knockout = this.readUB(1, "knockout") == 1L;
        ret.compositeSource = this.readUB(1, "compositeSource") == 1L;
        ret.onTop = this.readUB(1, "onTop") == 1L;
        ret.passes = (int)this.readUB(4, "passes");
        this.endDumpLevel();
        return ret;
    }

    public GRADIENTBEVELFILTER readGRADIENTBEVELFILTER(String name) throws IOException {
        int i;
        GRADIENTBEVELFILTER ret = new GRADIENTBEVELFILTER();
        this.newDumpLevel(name, "GRADIENTBEVELFILTER");
        int numColors = this.readUI8("numColors");
        ret.gradientColors = new RGBA[numColors];
        ret.gradientRatio = new int[numColors];
        for (i = 0; i < numColors; ++i) {
            ret.gradientColors[i] = this.readRGBA("gradientColor");
        }
        for (i = 0; i < numColors; ++i) {
            ret.gradientRatio[i] = this.readUI8("gradientRatio");
        }
        ret.blurX = this.readFIXED("blurX");
        ret.blurY = this.readFIXED("blurY");
        ret.angle = this.readFIXED("angle");
        ret.distance = this.readFIXED("distance");
        ret.strength = this.readFIXED8("strength");
        ret.innerShadow = this.readUB(1, "innerShadow") == 1L;
        ret.knockout = this.readUB(1, "knockout") == 1L;
        ret.compositeSource = this.readUB(1, "compositeSource") == 1L;
        ret.onTop = this.readUB(1, "onTop") == 1L;
        ret.passes = (int)this.readUB(4, "passes");
        this.endDumpLevel();
        return ret;
    }

    public List<FILTER> readFILTERLIST(String name) throws IOException {
        this.newDumpLevel(name, "FILTERLIST");
        int numberOfFilters = this.readUI8("numberOfFilters");
        ArrayList<FILTER> ret = new ArrayList<FILTER>(numberOfFilters);
        for (int i = 0; i < numberOfFilters; ++i) {
            ret.add(this.readFILTER("filter"));
        }
        this.endDumpLevel();
        return ret;
    }

    public FILTER readFILTER(String name) throws IOException {
        this.newDumpLevel(name, "FILTER");
        int filterId = this.readUI8("filterId");
        FILTER ret = null;
        switch (filterId) {
            case 0: {
                ret = this.readDROPSHADOWFILTER("filter");
                break;
            }
            case 1: {
                ret = this.readBLURFILTER("filter");
                break;
            }
            case 2: {
                ret = this.readGLOWFILTER("filter");
                break;
            }
            case 3: {
                ret = this.readBEVELFILTER("filter");
                break;
            }
            case 4: {
                ret = this.readGRADIENTGLOWFILTER("filter");
                break;
            }
            case 5: {
                ret = this.readCONVOLUTIONFILTER("filter");
                break;
            }
            case 6: {
                ret = this.readCOLORMATRIXFILTER("filter");
                break;
            }
            case 7: {
                ret = this.readGRADIENTBEVELFILTER("filter");
            }
        }
        this.endDumpLevel();
        return ret;
    }

    public List<BUTTONRECORD> readBUTTONRECORDList(SWF swf, ButtonTag buttonTag, String name) throws IOException {
        BUTTONRECORD br;
        ArrayList<BUTTONRECORD> ret = new ArrayList<BUTTONRECORD>();
        this.newDumpLevel(name, "BUTTONRECORDList");
        while ((br = this.readBUTTONRECORD(swf, buttonTag, "record")) != null) {
            ret.add(br);
        }
        this.endDumpLevel();
        return ret;
    }

    public BUTTONRECORD readBUTTONRECORD(SWF swf, ButtonTag tag, String name) throws IOException {
        BUTTONRECORD ret = new BUTTONRECORD(swf, tag);
        this.newDumpLevel(name, "BUTTONRECORD");
        ret.reserved = (int)this.readUB(2, "reserved");
        ret.buttonHasBlendMode = this.readUB(1, "buttonHasBlendMode") == 1L;
        ret.buttonHasFilterList = this.readUB(1, "buttonHasFilterList") == 1L;
        ret.buttonStateHitTest = this.readUB(1, "buttonStateHitTest") == 1L;
        ret.buttonStateDown = this.readUB(1, "buttonStateDown") == 1L;
        ret.buttonStateOver = this.readUB(1, "buttonStateOver") == 1L;
        boolean bl = ret.buttonStateUp = this.readUB(1, "buttonStateUp") == 1L;
        if (!(ret.buttonHasBlendMode || ret.buttonHasFilterList || ret.buttonStateHitTest || ret.buttonStateDown || ret.buttonStateOver || ret.buttonStateUp || ret.reserved != 0)) {
            this.endDumpLevel();
            return null;
        }
        ret.characterId = this.readUI16("characterId");
        ret.placeDepth = this.readUI16("placeDepth");
        ret.placeMatrix = this.readMatrix("placeMatrix");
        if (tag instanceof DefineButton2Tag) {
            ret.colorTransform = this.readCXFORMWITHALPHA("colorTransform");
            if (ret.buttonHasFilterList) {
                ret.filterList = this.readFILTERLIST("filterList");
            }
            if (ret.buttonHasBlendMode) {
                ret.blendMode = this.readUI8("blendMode");
            }
        }
        this.endDumpLevel();
        return ret;
    }

    public List<BUTTONCONDACTION> readBUTTONCONDACTIONList(SWF swf, Tag tag, String name) throws IOException {
        BUTTONCONDACTION bc;
        ArrayList<BUTTONCONDACTION> ret = new ArrayList<BUTTONCONDACTION>();
        this.newDumpLevel(name, "BUTTONCONDACTIONList");
        while (true) {
            bc = this.readBUTTONCONDACTION(swf, tag, "action");
            if (bc.isLast) break;
            ret.add(bc);
        }
        ret.add(bc);
        this.endDumpLevel();
        return ret;
    }

    public BUTTONCONDACTION readBUTTONCONDACTION(SWF swf, Tag tag, String name) throws IOException {
        this.newDumpLevel(name, "BUTTONCONDACTION");
        BUTTONCONDACTION ret = new BUTTONCONDACTION(swf, this, tag);
        this.endDumpLevel();
        return ret;
    }

    public GRADRECORD readGRADRECORD(int shapeNum, String name) throws IOException {
        GRADRECORD ret = new GRADRECORD();
        this.newDumpLevel(name, "GRADRECORD");
        ret.ratio = this.readUI8("ratio");
        ret.color = shapeNum >= 3 ? this.readRGBA("color") : this.readRGB("color");
        ret.inShape3 = shapeNum >= 3;
        this.endDumpLevel();
        return ret;
    }

    public GRADIENT readGRADIENT(int shapeNum, String name) throws IOException {
        GRADIENT ret = new GRADIENT();
        this.newDumpLevel(name, "GRADIENT");
        ret.spreadMode = (int)this.readUB(2, "spreadMode");
        ret.interpolationMode = (int)this.readUB(2, "interpolationMode");
        int numGradients = (int)this.readUB(4, "numGradients");
        ret.gradientRecords = new GRADRECORD[numGradients];
        for (int i = 0; i < numGradients; ++i) {
            ret.gradientRecords[i] = this.readGRADRECORD(shapeNum, "gradientRecord");
        }
        this.endDumpLevel();
        return ret;
    }

    public FOCALGRADIENT readFOCALGRADIENT(int shapeNum, String name) throws IOException {
        FOCALGRADIENT ret = new FOCALGRADIENT();
        this.newDumpLevel(name, "FOCALGRADIENT");
        ret.spreadMode = (int)this.readUB(2, "spreadMode");
        ret.interpolationMode = (int)this.readUB(2, "interpolationMode");
        int numGradients = (int)this.readUB(4, "numGradients");
        ret.gradientRecords = new GRADRECORD[numGradients];
        for (int i = 0; i < numGradients; ++i) {
            ret.gradientRecords[i] = this.readGRADRECORD(shapeNum, "gradientRecord");
        }
        ret.focalPoint = this.readFIXED8("focalPoint");
        this.endDumpLevel();
        return ret;
    }

    public FILLSTYLE readFILLSTYLE(int shapeNum, String name) throws IOException {
        FILLSTYLE ret = new FILLSTYLE();
        this.newDumpLevel(name, "FILLSTYLE");
        ret.fillStyleType = this.readUI8("fillStyleType");
        if (ret.fillStyleType == 0) {
            ret.color = shapeNum >= 3 ? this.readRGBA("color") : this.readRGB("color");
        }
        boolean bl = ret.inShape3 = shapeNum >= 3;
        if (ret.fillStyleType == 16 || ret.fillStyleType == 18 || ret.fillStyleType == 19) {
            ret.gradientMatrix = this.readMatrix("gradientMatrix");
        }
        if (ret.fillStyleType == 16 || ret.fillStyleType == 18) {
            ret.gradient = this.readGRADIENT(shapeNum, "gradient");
        }
        if (ret.fillStyleType == 19) {
            ret.gradient = this.readFOCALGRADIENT(shapeNum, "gradient");
        }
        if (ret.fillStyleType == 64 || ret.fillStyleType == 65 || ret.fillStyleType == 66 || ret.fillStyleType == 67) {
            ret.bitmapId = this.readUI16("bitmapId");
            ret.bitmapMatrix = this.readMatrix("bitmapMatrix");
        }
        this.endDumpLevel();
        return ret;
    }

    public FILLSTYLEARRAY readFILLSTYLEARRAY(int shapeNum, String name) throws IOException {
        FILLSTYLEARRAY ret = new FILLSTYLEARRAY();
        this.newDumpLevel(name, "FILLSTYLEARRAY");
        int fillStyleCount = this.readUI8("fillStyleCount");
        if (shapeNum > 1 && fillStyleCount == 255) {
            fillStyleCount = this.readUI16("fillStyleCount");
        }
        ret.fillStyles = new FILLSTYLE[fillStyleCount];
        for (int i = 0; i < fillStyleCount; ++i) {
            ret.fillStyles[i] = this.readFILLSTYLE(shapeNum, "fillStyle");
        }
        this.endDumpLevel();
        return ret;
    }

    public LINESTYLE readLINESTYLE(int shapeNum, String name) throws IOException {
        LINESTYLE ret = new LINESTYLE();
        this.newDumpLevel(name, "LINESTYLE");
        ret.width = this.readUI16("width");
        if (shapeNum == 1 || shapeNum == 2) {
            ret.color = this.readRGB("color");
        } else if (shapeNum == 3) {
            ret.color = this.readRGBA("color");
        }
        this.endDumpLevel();
        return ret;
    }

    public LINESTYLE2 readLINESTYLE2(int shapeNum, String name) throws IOException {
        LINESTYLE2 ret = new LINESTYLE2();
        this.newDumpLevel(name, "LINESTYLE2");
        ret.width = this.readUI16("width");
        ret.startCapStyle = (int)this.readUB(2, "startCapStyle");
        ret.joinStyle = (int)this.readUB(2, "joinStyle");
        ret.hasFillFlag = (int)this.readUB(1, "hasFillFlag") == 1;
        ret.noHScaleFlag = (int)this.readUB(1, "noHScaleFlag") == 1;
        ret.noVScaleFlag = (int)this.readUB(1, "noVScaleFlag") == 1;
        ret.pixelHintingFlag = (int)this.readUB(1, "pixelHintingFlag") == 1;
        ret.reserved = (int)this.readUB(5, "reserved");
        ret.noClose = (int)this.readUB(1, "noClose") == 1;
        ret.endCapStyle = (int)this.readUB(2, "endCapStyle");
        if (ret.joinStyle == 2) {
            ret.miterLimitFactor = this.readFIXED8("miterLimitFactor");
        }
        if (!ret.hasFillFlag) {
            ret.color = this.readRGBA("color");
        } else {
            ret.fillType = this.readFILLSTYLE(shapeNum, "fillType");
        }
        this.endDumpLevel();
        return ret;
    }

    public LINESTYLEARRAY readLINESTYLEARRAY(int shapeNum, String name) throws IOException {
        LINESTYLEARRAY ret = new LINESTYLEARRAY();
        this.newDumpLevel(name, "LINESTYLEARRAY");
        int lineStyleCount = this.readUI8("lineStyleCount");
        if (lineStyleCount == 255) {
            lineStyleCount = this.readUI16("lineStyleCount");
        }
        if (shapeNum <= 3) {
            ret.lineStyles = new LINESTYLE[lineStyleCount];
            for (int i = 0; i < lineStyleCount; ++i) {
                ret.lineStyles[i] = this.readLINESTYLE(shapeNum, "lineStyle");
            }
        } else {
            ret.lineStyles2 = new LINESTYLE2[lineStyleCount];
            for (int i = 0; i < lineStyleCount; ++i) {
                ret.lineStyles2[i] = this.readLINESTYLE2(shapeNum, "lineStyle");
            }
        }
        this.endDumpLevel();
        return ret;
    }

    private SHAPERECORD readSHAPERECORD(int fillBits, int lineBits, int shapeNum, boolean morphShape, String name) throws IOException {
        SHAPERECORD ret;
        this.newDumpLevel(name, "SHAPERECORD");
        int typeFlag = (int)this.readUB(1, "typeFlag");
        if (typeFlag == 0) {
            boolean stateMoveTo;
            boolean stateNewStyles = this.readUB(1, "stateNewStyles") == 1L;
            boolean stateLineStyle = this.readUB(1, "stateLineStyle") == 1L;
            boolean stateFillStyle1 = this.readUB(1, "stateFillStyle1") == 1L;
            boolean stateFillStyle0 = this.readUB(1, "stateFillStyle0") == 1L;
            boolean bl = stateMoveTo = this.readUB(1, "stateMoveTo") == 1L;
            if (!(stateNewStyles || stateLineStyle || stateFillStyle1 || stateFillStyle0 || stateMoveTo)) {
                ret = new EndShapeRecord();
            } else {
                StyleChangeRecord scr = new StyleChangeRecord();
                scr.stateNewStyles = stateNewStyles;
                scr.stateLineStyle = stateLineStyle;
                scr.stateFillStyle0 = stateFillStyle0;
                scr.stateFillStyle1 = stateFillStyle1;
                scr.stateMoveTo = stateMoveTo;
                if (stateMoveTo) {
                    scr.moveBits = (int)this.readUB(5, "moveBits");
                    scr.moveDeltaX = (int)this.readSB(scr.moveBits, "moveDeltaX");
                    scr.moveDeltaY = (int)this.readSB(scr.moveBits, "moveDeltaY");
                }
                if (stateFillStyle0) {
                    scr.fillStyle0 = (int)this.readUB(fillBits, "fillStyle0");
                }
                if (stateFillStyle1) {
                    scr.fillStyle1 = (int)this.readUB(fillBits, "fillStyle1");
                }
                if (stateLineStyle) {
                    scr.lineStyle = (int)this.readUB(lineBits, "lineStyle");
                }
                if (stateNewStyles) {
                    if (morphShape) {
                        throw new IOException("MorphShape should not have new styles.");
                    }
                    scr.fillStyles = this.readFILLSTYLEARRAY(shapeNum, "fillStyles");
                    scr.lineStyles = this.readLINESTYLEARRAY(shapeNum, "lineStyles");
                    scr.numFillBits = (int)this.readUB(4, "numFillBits");
                    scr.numLineBits = (int)this.readUB(4, "numLineBits");
                }
                ret = scr;
            }
        } else {
            int straightFlag = (int)this.readUB(1, "straightFlag");
            if (straightFlag == 1) {
                StraightEdgeRecord ser = new StraightEdgeRecord();
                ser.numBits = (int)this.readUB(4, "numBits");
                boolean bl = ser.generalLineFlag = this.readUB(1, "generalLineFlag") == 1L;
                if (!ser.generalLineFlag) {
                    boolean bl2 = ser.vertLineFlag = this.readUB(1, "vertLineFlag") == 1L;
                }
                if (ser.generalLineFlag || !ser.vertLineFlag) {
                    ser.deltaX = (int)this.readSB(ser.numBits + 2, "deltaX");
                }
                if (ser.generalLineFlag || ser.vertLineFlag) {
                    ser.deltaY = (int)this.readSB(ser.numBits + 2, "deltaY");
                }
                ret = ser;
            } else {
                CurvedEdgeRecord cer = new CurvedEdgeRecord();
                cer.numBits = (int)this.readUB(4, "numBits");
                cer.controlDeltaX = (int)this.readSB(cer.numBits + 2, "controlDeltaX");
                cer.controlDeltaY = (int)this.readSB(cer.numBits + 2, "controlDeltaY");
                cer.anchorDeltaX = (int)this.readSB(cer.numBits + 2, "anchorDeltaX");
                cer.anchorDeltaY = (int)this.readSB(cer.numBits + 2, "anchorDeltaY");
                ret = cer;
            }
        }
        this.endDumpLevel();
        return ret;
    }

    public SHAPE readSHAPE(int shapeNum, boolean morphShape, String name) throws IOException {
        SHAPE ret = new SHAPE();
        this.newDumpLevel(name, "SHAPE");
        ret.numFillBits = (int)this.readUB(4, "numFillBits");
        ret.numLineBits = (int)this.readUB(4, "numLineBits");
        ret.shapeRecords = this.readSHAPERECORDS(shapeNum, ret.numFillBits, ret.numLineBits, morphShape, "shapeRecords");
        this.endDumpLevel();
        return ret;
    }

    public SHAPEWITHSTYLE readSHAPEWITHSTYLE(int shapeNum, boolean morphShape, String name) throws IOException {
        SHAPEWITHSTYLE ret = new SHAPEWITHSTYLE();
        this.newDumpLevel(name, "SHAPEWITHSTYLE");
        ret.fillStyles = this.readFILLSTYLEARRAY(shapeNum, "fillStyles");
        ret.lineStyles = this.readLINESTYLEARRAY(shapeNum, "lineStyles");
        ret.numFillBits = (int)this.readUB(4, "numFillBits");
        ret.numLineBits = (int)this.readUB(4, "numLineBits");
        ret.shapeRecords = this.readSHAPERECORDS(shapeNum, ret.numFillBits, ret.numLineBits, morphShape, "shapeRecords");
        this.endDumpLevel();
        return ret;
    }

    private List<SHAPERECORD> readSHAPERECORDS(int shapeNum, int fillBits, int lineBits, boolean morphShape, String name) throws IOException {
        SHAPERECORD rec;
        ArrayList<SHAPERECORD> ret = new ArrayList<SHAPERECORD>();
        this.newDumpLevel(name, "SHAPERECORDS");
        do {
            if ((rec = this.readSHAPERECORD(fillBits, lineBits, shapeNum, morphShape, "record")) instanceof StyleChangeRecord) {
                StyleChangeRecord scRec = (StyleChangeRecord)rec;
                if (scRec.stateNewStyles) {
                    fillBits = scRec.numFillBits;
                    lineBits = scRec.numLineBits;
                }
            }
            ret.add(rec);
        } while (!(rec instanceof EndShapeRecord));
        this.alignByte();
        this.endDumpLevel();
        return ret;
    }

    public SOUNDINFO readSOUNDINFO(String name) throws IOException {
        SOUNDINFO ret = new SOUNDINFO();
        this.newDumpLevel(name, "SOUNDINFO");
        ret.reserved = (int)this.readUB(2, "reserved");
        ret.syncStop = this.readUB(1, "syncStop") == 1L;
        ret.syncNoMultiple = this.readUB(1, "syncNoMultiple") == 1L;
        ret.hasEnvelope = this.readUB(1, "hasEnvelope") == 1L;
        ret.hasLoops = this.readUB(1, "hasLoops") == 1L;
        ret.hasOutPoint = this.readUB(1, "hasOutPoint") == 1L;
        boolean bl = ret.hasInPoint = this.readUB(1, "hasInPoint") == 1L;
        if (ret.hasInPoint) {
            ret.inPoint = this.readUI32("inPoint");
        }
        if (ret.hasOutPoint) {
            ret.outPoint = this.readUI32("outPoint");
        }
        if (ret.hasLoops) {
            ret.loopCount = this.readUI16("loopCount");
        }
        if (ret.hasEnvelope) {
            int envPoints = this.readUI8("envPoints");
            ret.envelopeRecords = new SOUNDENVELOPE[envPoints];
            for (int i = 0; i < envPoints; ++i) {
                ret.envelopeRecords[i] = this.readSOUNDENVELOPE("envelopeRecord");
            }
        }
        this.endDumpLevel();
        return ret;
    }

    public SOUNDENVELOPE readSOUNDENVELOPE(String name) throws IOException {
        SOUNDENVELOPE ret = new SOUNDENVELOPE();
        this.newDumpLevel(name, "SOUNDENVELOPE");
        ret.pos44 = this.readUI32("pos44");
        ret.leftLevel = this.readUI16("leftLevel");
        ret.rightLevel = this.readUI16("rightLevel");
        this.endDumpLevel();
        return ret;
    }

    public GLYPHENTRY readGLYPHENTRY(int glyphBits, int advanceBits, String name) throws IOException {
        GLYPHENTRY ret = new GLYPHENTRY();
        this.newDumpLevel(name, "GLYPHENTRY");
        ret.glyphIndex = (int)this.readUB(glyphBits, "glyphIndex");
        ret.glyphAdvance = (int)this.readSB(advanceBits, "glyphAdvance");
        this.endDumpLevel();
        return ret;
    }

    public TEXTRECORD readTEXTRECORD(int defineTextNum, int glyphBits, int advanceBits, String name) throws IOException {
        TEXTRECORD ret = new TEXTRECORD();
        this.newDumpLevel(name, "TEXTRECORD");
        int first = (int)this.readUB(1, "first");
        this.readUB(3, "styleFlagsHasReserved");
        ret.styleFlagsHasFont = this.readUB(1, "styleFlagsHasFont") == 1L;
        ret.styleFlagsHasColor = this.readUB(1, "styleFlagsHasColor") == 1L;
        ret.styleFlagsHasYOffset = this.readUB(1, "styleFlagsHasYOffset") == 1L;
        boolean bl = ret.styleFlagsHasXOffset = this.readUB(1, "styleFlagsHasXOffset") == 1L;
        if (!(ret.styleFlagsHasFont || ret.styleFlagsHasColor || ret.styleFlagsHasYOffset || ret.styleFlagsHasXOffset || first != 0)) {
            this.endDumpLevel();
            return null;
        }
        if (ret.styleFlagsHasFont) {
            ret.fontId = this.readUI16("fontId");
        }
        if (ret.styleFlagsHasColor) {
            if (defineTextNum == 2) {
                ret.textColorA = this.readRGBA("textColorA");
            } else {
                ret.textColor = this.readRGB("textColor");
            }
        }
        if (ret.styleFlagsHasXOffset) {
            ret.xOffset = this.readSI16("xOffset");
        }
        if (ret.styleFlagsHasYOffset) {
            ret.yOffset = this.readSI16("yOffset");
        }
        if (ret.styleFlagsHasFont) {
            ret.textHeight = this.readUI16("textHeight");
        }
        int glyphCount = this.readUI8("glyphCount");
        ret.glyphEntries = new ArrayList<GLYPHENTRY>(glyphCount);
        for (int i = 0; i < glyphCount; ++i) {
            ret.glyphEntries.add(this.readGLYPHENTRY(glyphBits, advanceBits, "glyphEntry"));
        }
        this.alignByte();
        this.endDumpLevel();
        return ret;
    }

    public MORPHGRADRECORD readMORPHGRADRECORD(String name) throws IOException {
        MORPHGRADRECORD ret = new MORPHGRADRECORD();
        this.newDumpLevel(name, "MORPHGRADRECORD");
        ret.startRatio = this.readUI8("startRatio");
        ret.startColor = this.readRGBA("startColor");
        ret.endRatio = this.readUI8("endRatio");
        ret.endColor = this.readRGBA("endColor");
        this.endDumpLevel();
        return ret;
    }

    public MORPHGRADIENT readMORPHGRADIENT(String name) throws IOException {
        MORPHGRADIENT ret = new MORPHGRADIENT();
        this.newDumpLevel(name, "MORPHGRADIENT");
        ret.spreadMode = (int)this.readUB(2, "spreadMode");
        ret.interPolationMode = (int)this.readUB(2, "interPolationMode");
        int numGradients = (int)this.readUB(4, "numGradients");
        ret.gradientRecords = new MORPHGRADRECORD[numGradients];
        for (int i = 0; i < numGradients; ++i) {
            ret.gradientRecords[i] = this.readMORPHGRADRECORD("gradientRecord");
        }
        this.endDumpLevel();
        return ret;
    }

    public MORPHFOCALGRADIENT readMORPHFOCALGRADIENT(String name) throws IOException {
        MORPHFOCALGRADIENT ret = new MORPHFOCALGRADIENT();
        this.newDumpLevel(name, "MORPHFOCALGRADIENT");
        ret.spreadMode = (int)this.readUB(2, "spreadMode");
        ret.interPolationMode = (int)this.readUB(2, "interPolationMode");
        int numGradients = (int)this.readUB(4, "numGradients");
        ret.gradientRecords = new MORPHGRADRECORD[numGradients];
        for (int i = 0; i < numGradients; ++i) {
            ret.gradientRecords[i] = this.readMORPHGRADRECORD("gradientRecord");
        }
        ret.startFocalPoint = this.readFIXED8("startFocalPoint");
        ret.endFocalPoint = this.readFIXED8("endFocalPoint");
        this.endDumpLevel();
        return ret;
    }

    public MORPHFILLSTYLE readMORPHFILLSTYLE(String name) throws IOException {
        MORPHFILLSTYLE ret = new MORPHFILLSTYLE();
        this.newDumpLevel(name, "MORPHFILLSTYLE");
        ret.fillStyleType = this.readUI8("fillStyleType");
        if (ret.fillStyleType == 0) {
            ret.startColor = this.readRGBA("startColor");
            ret.endColor = this.readRGBA("endColor");
        }
        if (ret.fillStyleType == 16 || ret.fillStyleType == 18 || ret.fillStyleType == 19) {
            ret.startGradientMatrix = this.readMatrix("startGradientMatrix");
            ret.endGradientMatrix = this.readMatrix("endGradientMatrix");
        }
        if (ret.fillStyleType == 16 || ret.fillStyleType == 18) {
            ret.gradient = this.readMORPHGRADIENT("gradient");
        }
        if (ret.fillStyleType == 19) {
            ret.gradient = this.readMORPHFOCALGRADIENT("gradient");
        }
        if (ret.fillStyleType == 64 || ret.fillStyleType == 65 || ret.fillStyleType == 66 || ret.fillStyleType == 67) {
            ret.bitmapId = this.readUI16("bitmapId");
            ret.startBitmapMatrix = this.readMatrix("startBitmapMatrix");
            ret.endBitmapMatrix = this.readMatrix("endBitmapMatrix");
        }
        this.endDumpLevel();
        return ret;
    }

    public MORPHFILLSTYLEARRAY readMORPHFILLSTYLEARRAY(String name) throws IOException {
        MORPHFILLSTYLEARRAY ret = new MORPHFILLSTYLEARRAY();
        this.newDumpLevel(name, "MORPHFILLSTYLEARRAY");
        int fillStyleCount = this.readUI8("fillStyleCount");
        if (fillStyleCount == 255) {
            fillStyleCount = this.readUI16("fillStyleCount");
        }
        ret.fillStyles = new MORPHFILLSTYLE[fillStyleCount];
        for (int i = 0; i < fillStyleCount; ++i) {
            ret.fillStyles[i] = this.readMORPHFILLSTYLE("fillStyle");
        }
        this.endDumpLevel();
        return ret;
    }

    public MORPHLINESTYLE readMORPHLINESTYLE(String name) throws IOException {
        MORPHLINESTYLE ret = new MORPHLINESTYLE();
        this.newDumpLevel(name, "MORPHLINESTYLE");
        ret.startWidth = this.readUI16("startWidth");
        ret.endWidth = this.readUI16("endWidth");
        ret.startColor = this.readRGBA("startColor");
        ret.endColor = this.readRGBA("endColor");
        this.endDumpLevel();
        return ret;
    }

    public MORPHLINESTYLE2 readMORPHLINESTYLE2(String name) throws IOException {
        MORPHLINESTYLE2 ret = new MORPHLINESTYLE2();
        this.newDumpLevel(name, "MORPHLINESTYLE2");
        ret.startWidth = this.readUI16("startWidth");
        ret.endWidth = this.readUI16("endWidth");
        ret.startCapStyle = (int)this.readUB(2, "startCapStyle");
        ret.joinStyle = (int)this.readUB(2, "joinStyle");
        ret.hasFillFlag = (int)this.readUB(1, "hasFillFlag") == 1;
        ret.noHScaleFlag = (int)this.readUB(1, "noHScaleFlag") == 1;
        ret.noVScaleFlag = (int)this.readUB(1, "noVScaleFlag") == 1;
        ret.pixelHintingFlag = (int)this.readUB(1, "pixelHintingFlag") == 1;
        ret.reserved = (int)this.readUB(5, "reserved");
        ret.noClose = (int)this.readUB(1, "noClose") == 1;
        ret.endCapStyle = (int)this.readUB(2, "endCapStyle");
        if (ret.joinStyle == 2) {
            ret.miterLimitFactor = this.readUI16("miterLimitFactor");
        }
        if (!ret.hasFillFlag) {
            ret.startColor = this.readRGBA("startColor");
            ret.endColor = this.readRGBA("endColor");
        } else {
            ret.fillType = this.readMORPHFILLSTYLE("fillType");
        }
        this.endDumpLevel();
        return ret;
    }

    public MORPHLINESTYLEARRAY readMORPHLINESTYLEARRAY(int morphShapeNum, String name) throws IOException {
        MORPHLINESTYLEARRAY ret = new MORPHLINESTYLEARRAY();
        this.newDumpLevel(name, "MORPHLINESTYLEARRAY");
        int lineStyleCount = this.readUI8("lineStyleCount");
        if (lineStyleCount == 255) {
            lineStyleCount = this.readUI16("lineStyleCount");
        }
        if (morphShapeNum == 1) {
            ret.lineStyles = new MORPHLINESTYLE[lineStyleCount];
            for (int i = 0; i < lineStyleCount; ++i) {
                ret.lineStyles[i] = this.readMORPHLINESTYLE("lineStyle");
            }
        } else if (morphShapeNum == 2) {
            ret.lineStyles2 = new MORPHLINESTYLE2[lineStyleCount];
            for (int i = 0; i < lineStyleCount; ++i) {
                ret.lineStyles2[i] = this.readMORPHLINESTYLE2("lineStyle2");
            }
        }
        this.endDumpLevel();
        return ret;
    }

    public KERNINGRECORD readKERNINGRECORD(boolean fontFlagsWideCodes, String name) throws IOException {
        KERNINGRECORD ret = new KERNINGRECORD();
        this.newDumpLevel(name, "KERNINGRECORD");
        if (fontFlagsWideCodes) {
            ret.fontKerningCode1 = this.readUI16("fontKerningCode1");
            ret.fontKerningCode2 = this.readUI16("fontKerningCode2");
        } else {
            ret.fontKerningCode1 = this.readUI8("fontKerningCode1");
            ret.fontKerningCode2 = this.readUI8("fontKerningCode2");
        }
        ret.fontKerningAdjustment = this.readSI16("fontKerningAdjustment");
        this.endDumpLevel();
        return ret;
    }

    public LANGCODE readLANGCODE(String name) throws IOException {
        LANGCODE ret = new LANGCODE();
        this.newDumpLevel(name, "LANGCODE");
        ret.languageCode = this.readUI8("languageCode");
        this.endDumpLevel();
        return ret;
    }

    public ZONERECORD readZONERECORD(String name) throws IOException {
        ZONERECORD ret = new ZONERECORD();
        this.newDumpLevel(name, "ZONERECORD");
        int numZoneData = this.readUI8("numZoneData");
        ret.zonedata = new ZONEDATA[numZoneData];
        for (int i = 0; i < numZoneData; ++i) {
            ret.zonedata[i] = this.readZONEDATA("zonedata");
        }
        this.readUB(6, "reserved");
        ret.zoneMaskY = this.readUB(1, "zoneMaskY") == 1L;
        ret.zoneMaskX = this.readUB(1, "zoneMaskX") == 1L;
        this.endDumpLevel();
        return ret;
    }

    public ZONEDATA readZONEDATA(String name) throws IOException {
        ZONEDATA ret = new ZONEDATA();
        this.newDumpLevel(name, "ZONEDATA");
        ret.alignmentCoordinate = this.readUI16("alignmentCoordinate");
        ret.range = this.readUI16("range");
        this.endDumpLevel();
        return ret;
    }

    public PIX15 readPIX15(String name) throws IOException {
        PIX15 ret = new PIX15();
        this.newDumpLevel(name, "PIX15");
        ret.reserved = (int)this.readUB(1, "reserved");
        ret.red = (int)this.readUB(5, "red");
        ret.green = (int)this.readUB(5, "green");
        ret.blue = (int)this.readUB(5, "blue");
        this.endDumpLevel();
        return ret;
    }

    public int readPIX15Int(String name) throws IOException {
        this.newDumpLevel(name, "PIX15");
        int ret = (int)this.readUB(1, "reserved") << 24 | (int)this.readUB(5, "red") << 19 | (int)this.readUB(5, "green") << 11 | (int)this.readUB(5, "blue") << 3;
        this.endDumpLevel();
        return ret;
    }

    public PIX24 readPIX24(String name) throws IOException {
        PIX24 ret = new PIX24();
        this.newDumpLevel(name, "PIX24");
        ret.reserved = this.readUI8("reserved");
        ret.red = this.readUI8("red");
        ret.green = this.readUI8("green");
        ret.blue = this.readUI8("blue");
        this.endDumpLevel();
        return ret;
    }

    public int readPIX24Int(String name) throws IOException {
        this.newDumpLevel(name, "PIX24");
        int ret = this.readUI8("reserved") << 24 | this.readUI8("red") << 16 | this.readUI8("green") << 8 | this.readUI8("blue");
        this.endDumpLevel();
        return ret;
    }

    public COLORMAPDATA readCOLORMAPDATA(int colorTableSize, int bitmapWidth, int bitmapHeight, String name) throws IOException {
        COLORMAPDATA ret = new COLORMAPDATA();
        this.newDumpLevel(name, "COLORMAPDATA");
        ret.colorTableRGB = new int[colorTableSize + 1];
        for (int i = 0; i < colorTableSize + 1; ++i) {
            ret.colorTableRGB[i] = this.readRGBInt("colorTableRGB");
        }
        int dataLen = 0;
        for (int y = 0; y < bitmapHeight; ++y) {
            int x;
            for (x = 0; x < bitmapWidth; ++x) {
                ++dataLen;
            }
            while (x % 4 != 0) {
                ++dataLen;
                ++x;
            }
        }
        ret.colorMapPixelData = this.readBytesEx(dataLen, "colorMapPixelData");
        this.endDumpLevel();
        return ret;
    }

    public BITMAPDATA readBITMAPDATA(int bitmapFormat, int bitmapWidth, int bitmapHeight, String name) throws IOException {
        BITMAPDATA ret = new BITMAPDATA();
        this.newDumpLevel(name, "BITMAPDATA");
        int pixelCount = bitmapWidth * bitmapHeight;
        int[] pix15 = bitmapFormat == 4 ? new int[pixelCount] : null;
        int[] pix24 = bitmapFormat == 5 ? new int[pixelCount] : null;
        int dataLen = 0;
        int pos = 0;
        for (int y = 0; y < bitmapHeight; ++y) {
            for (int x = 0; x < bitmapWidth; ++x) {
                if (bitmapFormat == 4) {
                    dataLen += 2;
                    pix15[pos++] = this.readPIX15Int("pix15");
                    continue;
                }
                if (bitmapFormat != 5) continue;
                dataLen += 4;
                pix24[pos++] = this.readPIX24Int("pix24");
            }
            while (dataLen % 4 != 0) {
                ++dataLen;
                this.readUI8("padding");
            }
        }
        if (bitmapFormat == 4) {
            ret.bitmapPixelDataPix15 = pix15;
        } else if (bitmapFormat == 5) {
            ret.bitmapPixelDataPix24 = pix24;
        }
        this.endDumpLevel();
        return ret;
    }

    public ALPHABITMAPDATA readALPHABITMAPDATA(int bitmapFormat, int bitmapWidth, int bitmapHeight, String name) throws IOException {
        ALPHABITMAPDATA ret = new ALPHABITMAPDATA();
        this.newDumpLevel(name, "ALPHABITMAPDATA");
        ret.bitmapPixelData = new int[bitmapWidth * bitmapHeight];
        for (int y = 0; y < bitmapHeight; ++y) {
            for (int x = 0; x < bitmapWidth; ++x) {
                ret.bitmapPixelData[y * bitmapWidth + x] = this.readARGBInt("bitmapPixelData");
            }
        }
        this.endDumpLevel();
        return ret;
    }

    public ALPHACOLORMAPDATA readALPHACOLORMAPDATA(int colorTableSize, int bitmapWidth, int bitmapHeight, String name) throws IOException {
        ALPHACOLORMAPDATA ret = new ALPHACOLORMAPDATA();
        this.newDumpLevel(name, "ALPHACOLORMAPDATA");
        ret.colorTableRGB = new int[colorTableSize + 1];
        for (int i = 0; i < colorTableSize + 1; ++i) {
            ret.colorTableRGB[i] = this.readRGBAInt("colorTableRGB");
        }
        int dataLen = 0;
        for (int y = 0; y < bitmapHeight; ++y) {
            int x;
            for (x = 0; x < bitmapWidth; ++x) {
                ++dataLen;
            }
            while (x % 4 != 0) {
                ++dataLen;
                ++x;
            }
        }
        ret.colorMapPixelData = this.readBytesEx(dataLen, "colorMapPixelData");
        this.endDumpLevel();
        return ret;
    }

    public int available() throws IOException {
        return this.is.available();
    }

    public long availableBits() throws IOException {
        if (this.bitPos > 0) {
            return this.available() * 8 + (8 - this.bitPos);
        }
        return this.available() * 8;
    }

    public MemoryInputStream getBaseStream() throws IOException {
        int pos = (int)this.is.getPos();
        MemoryInputStream mis = new MemoryInputStream(this.is.getAllRead(), 0, pos + this.is.available());
        mis.seek(pos);
        return mis;
    }

    public SWFInputStream getLimitedStream(int limit) throws IOException {
        SWFInputStream sis = new SWFInputStream(this.swf, this.is.getAllRead(), this.startingPos, (int)(this.is.getPos() + (long)limit));
        sis.seek(this.is.getPos() + this.startingPos);
        return sis;
    }

    private class TagResolutionTask
    implements Callable<Tag> {
        private final TagStub tag;
        private final DumpInfo dumpInfo;
        private final int level;
        private final boolean parallel;
        private final boolean skipUnusualTags;
        private final boolean lazy;

        public TagResolutionTask(TagStub tag, DumpInfo dumpInfo, int level, boolean parallel, boolean skipUnusualTags, boolean lazy) {
            this.tag = tag;
            this.dumpInfo = dumpInfo;
            this.level = level;
            this.parallel = parallel;
            this.skipUnusualTags = skipUnusualTags;
            this.lazy = lazy;
        }

        @Override
        public Tag call() throws Exception {
            DumpInfo di = this.dumpInfo;
            try {
                Tag t = SWFInputStream.resolveTag(this.tag, this.level, this.parallel, this.skipUnusualTags, this.lazy, true);
                if (this.dumpInfo != null && t != null) {
                    this.dumpInfo.name = t.getName();
                }
                return t;
            }
            catch (Exception ex) {
                this.tag.getDataStream().endDumpLevelUntil(di);
                logger.log(Level.SEVERE, null, ex);
                return this.tag;
            }
        }
    }
}

