/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash;

import com.jpexs.decompiler.flash.abc.RenameType;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.flash.tags.DefineSpriteTag;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.tags.base.PlaceObjectTypeTag;
import com.jpexs.decompiler.graph.DottedChain;
import com.jpexs.helpers.Cache;
import com.jpexs.helpers.Helper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.regex.Pattern;

public class IdentifiersDeobfuscation {
    private static final Random rnd = new Random();
    private final int DEFAULT_FOO_SIZE = 10;
    public HashSet<String> allVariableNamesStr = new HashSet();
    private final HashMap<String, Integer> typeCounts = new HashMap();
    private static final Cache<String, String> as2NameCache = Cache.getInstance(false, true, "as2_ident", true);
    private static final Cache<String, String> as3NameCache = Cache.getInstance(false, true, "as3_ident", true);
    public static final String VALID_FIRST_CHARACTERS = "\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}_$";
    public static final String VALID_NEXT_CHARACTERS = "\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}_$\\p{Nl}\\p{Mn}\\p{Mc}\\p{Nd}\\p{Pc}";
    private static final Pattern VALID_NAME_PATTERN = Pattern.compile("^[a-zA-Z_\\$][a-zA-Z0-9_\\$]*$");
    private static final Pattern IDENTIFIER_PATTERN = Pattern.compile("^[\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}_$][\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}_$\\p{Nl}\\p{Mn}\\p{Mc}\\p{Nd}\\p{Pc}]*$");
    private static final Pattern VALID_NAME_PATTERN_DOT = Pattern.compile("^[a-zA-Z_\\$][a-zA-Z0-9_.\\$]*$");
    private static final Pattern IDENTIFIER_PATTERN_DOT = Pattern.compile("^[\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}_$][\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}_$\\p{Nl}\\p{Mn}\\p{Mc}\\p{Nd}\\p{Pc}.]*$");
    public static final String FOO_CHARACTERS = "bcdfghjklmnpqrstvwz";
    public static final String FOO_JOIN_CHARACTERS = "aeiouy";
    public static final String[] reservedWordsAS2 = new String[]{"and", "break", "case", "catch", "class", "continue", "default", "delete", "do", "dynamic", "each", "else", "eq", "extends", "false", "finally", "for", "function", "ge", "get", "gt", "if", "ifFrameLoaded", "implements", "import", "in", "instanceof", "interface", "intrinsic", "le", "ne", "new", "not", "null", "on", "onClipEvent", "or", "private", "public", "return", "set", "static", "switch", "tellTarget", "throw", "true", "try", "typeof", "undefined", "var", "void", "while", "with"};
    public static final String[] reservedWordsAS3 = new String[]{"as", "break", "case", "catch", "class", "const", "continue", "default", "delete", "do", "else", "extends", "false", "finally", "for", "function", "if", "implements", "import", "in", "instanceof", "interface", "internal", "is", "new", "null", "package", "private", "protected", "public", "return", "super", "switch", "this", "throw", "true", "try", "typeof", "use", "var", "void", "while", "with"};
    public static final String[] reservedWordsAS3_2 = new String[]{"as", "break", "case", "catch", "class", "const", "continue", "default", "delete", "do", "each", "else", "extends", "false", "finally", "for", "function", "get", "if", "implements", "import", "in", "instanceof", "interface", "internal", "is", "native", "new", "null", "override", "package", "private", "protected", "public", "return", "set", "super", "switch", "this", "throw", "true", "try", "typeof", "use", "var", "while", "with", "dynamic", "default", "final", "in", "static"};
    public static final String[] syntacticKeywordsAS3 = new String[]{"each", "get", "set", "namespace", "include", "dynamic", "final", "native", "override", "static"};

    public static boolean isReservedWord(String s, boolean as3) {
        if (s == null) {
            return false;
        }
        String[] reservedWords = as3 ? reservedWordsAS3 : reservedWordsAS2;
        s = s.trim();
        for (String rw : reservedWords) {
            if (!rw.equals(s)) continue;
            return true;
        }
        return false;
    }

    public static boolean isReservedWord2(String s) {
        if (s == null) {
            return false;
        }
        String[] reservedWords = reservedWordsAS3_2;
        s = s.trim();
        for (String rw : reservedWords) {
            if (!rw.equals(s)) continue;
            return true;
        }
        return false;
    }

    public static String fooString(boolean firstUppercase, int rndSize) {
        int len = 3 + rnd.nextInt(rndSize - 3);
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = i % 2 == 0 ? FOO_CHARACTERS.charAt(rnd.nextInt(FOO_CHARACTERS.length())) : FOO_JOIN_CHARACTERS.charAt(rnd.nextInt(FOO_JOIN_CHARACTERS.length()));
            if (i == 0 && firstUppercase) {
                c = Character.toUpperCase(c);
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public void deobfuscateInstanceNames(boolean as3, HashMap<DottedChain, DottedChain> namesMap, RenameType renameType, Iterable<Tag> tags, Map<DottedChain, DottedChain> selected) {
        for (Tag t : tags) {
            String changedClassName;
            String className;
            String changedName;
            if (t instanceof DefineSpriteTag) {
                this.deobfuscateInstanceNames(as3, namesMap, renameType, ((DefineSpriteTag)t).getTags(), selected);
            }
            if (!(t instanceof PlaceObjectTypeTag)) continue;
            PlaceObjectTypeTag po = (PlaceObjectTypeTag)t;
            String name = po.getInstanceName();
            if (name != null && (changedName = this.deobfuscateName(as3, name, false, "instance", namesMap, renameType, selected)) != null) {
                po.setInstanceName(changedName);
                po.setModified(true);
            }
            if ((className = po.getClassName()) == null || (changedClassName = this.deobfuscateNameWithPackage(as3, className, namesMap, renameType, selected)) == null) continue;
            po.setClassName(changedClassName);
            po.setModified(true);
        }
    }

    public DottedChain deobfuscatePackage(boolean as3, DottedChain pkg, HashMap<DottedChain, DottedChain> namesMap, RenameType renameType, Map<DottedChain, DottedChain> selected) {
        if (namesMap.containsKey(pkg)) {
            return namesMap.get(pkg);
        }
        ArrayList<String> ret = new ArrayList<String>(pkg.size());
        boolean isChanged = false;
        for (int p = 0; p < pkg.size(); ++p) {
            String part = pkg.get(p);
            String partChanged = this.deobfuscateName(as3, part, false, "package", namesMap, renameType, selected);
            if (partChanged != null) {
                ret.add(partChanged);
                isChanged = true;
                continue;
            }
            ret.add(part);
        }
        if (isChanged) {
            DottedChain chain = new DottedChain(ret);
            namesMap.put(pkg, chain);
            return chain;
        }
        return null;
    }

    public String deobfuscateNameWithPackage(boolean as3, String n, HashMap<DottedChain, DottedChain> namesMap, RenameType renameType, Map<DottedChain, DottedChain> selected) {
        String changedName;
        DottedChain changedPkg;
        DottedChain nChain = DottedChain.parseNoSuffix(n);
        DottedChain pkg = nChain.getWithoutLast();
        String name = nChain.getLast();
        boolean changed = false;
        if (pkg != null && !pkg.isEmpty() && !pkg.isTopLevel() && (changedPkg = this.deobfuscatePackage(as3, pkg, namesMap, renameType, selected)) != null) {
            changed = true;
            pkg = changedPkg;
        }
        if ((changedName = this.deobfuscateName(as3, name, true, "class", namesMap, renameType, selected)) != null) {
            changed = true;
            name = changedName;
        }
        if (changed) {
            String newClassName = pkg == null || pkg.isEmpty() || pkg.isTopLevel() ? name : pkg + "." + name;
            return newClassName;
        }
        return null;
    }

    private static boolean isValidSlashPath(String s, String ... exceptions) {
        String[] slashParts = s.split("\\/");
        if (s.isEmpty()) {
            return false;
        }
        for (int p = 0; p < slashParts.length; ++p) {
            String part = slashParts[p];
            if (p == 0 && part.isEmpty()) continue;
            if (part.isEmpty() && p < slashParts.length - 1) {
                return false;
            }
            if ("..".equals(part) || IdentifiersDeobfuscation.isValidName(false, part, exceptions)) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidNameWithSlash(String s, String ... exceptions) {
        if (s.contains(":")) {
            String[] pathVar = s.split(":");
            if (!IdentifiersDeobfuscation.isValidSlashPath(pathVar[0], exceptions)) {
                return false;
            }
            for (int i = 1; i < pathVar.length; ++i) {
                if (IdentifiersDeobfuscation.isValidName(false, pathVar[i], exceptions)) continue;
                return false;
            }
            return true;
        }
        return IdentifiersDeobfuscation.isValidName(false, s, exceptions);
    }

    public static boolean isValidNameWithDot(boolean as3, String s, String ... exceptions) {
        for (String e : exceptions) {
            if (!e.equals(s)) continue;
            return true;
        }
        if (IdentifiersDeobfuscation.isReservedWord(s, as3)) {
            return false;
        }
        if (VALID_NAME_PATTERN_DOT.matcher(s).matches()) {
            return true;
        }
        return IDENTIFIER_PATTERN_DOT.matcher(s).matches();
    }

    public static boolean isValidName(boolean as3, String s, String ... exceptions) {
        for (String e : exceptions) {
            if (!e.equals(s)) continue;
            return true;
        }
        if (IdentifiersDeobfuscation.isReservedWord(s, as3)) {
            return false;
        }
        if (VALID_NAME_PATTERN.matcher(s).matches()) {
            return true;
        }
        return IDENTIFIER_PATTERN.matcher(s).matches();
    }

    public String deobfuscateName(boolean as3, String s, boolean firstUppercase, String usageType, HashMap<DottedChain, DottedChain> namesMap, RenameType renameType, Map<DottedChain, DottedChain> selected) {
        if (usageType == null) {
            usageType = "name";
        }
        DottedChain sChain = DottedChain.parseNoSuffix(s);
        if (selected != null && selected.containsKey(sChain)) {
            return selected.get(sChain).toRawString();
        }
        boolean isValid = IdentifiersDeobfuscation.isValidName(as3, s, new String[0]);
        if (!isValid) {
            boolean found;
            if (namesMap.containsKey(sChain)) {
                return namesMap.get(sChain).toRawString();
            }
            String ret = null;
            int rndSize = 10;
            do {
                found = false;
                if (renameType == RenameType.TYPENUMBER) {
                    ret = Helper.getNextId(usageType, this.typeCounts, true);
                    if (!this.allVariableNamesStr.contains(ret)) continue;
                    found = true;
                    continue;
                }
                if (renameType != RenameType.RANDOMWORD || !this.allVariableNamesStr.contains(ret = IdentifiersDeobfuscation.fooString(firstUppercase, rndSize)) && !IdentifiersDeobfuscation.isReservedWord(ret, as3) && !namesMap.containsValue(DottedChain.parseNoSuffix(ret))) continue;
                found = true;
                ++rndSize;
            } while (found);
            namesMap.put(DottedChain.parseNoSuffix(s), DottedChain.parseNoSuffix(ret));
            return ret;
        }
        return null;
    }

    public static GraphTextWriter appendObfuscatedIdentifier(String s, GraphTextWriter writer) {
        writer.append("\u00a7");
        IdentifiersDeobfuscation.escapeOIdentifier(s, writer);
        return writer.append("\u00a7");
    }

    public static String printIdentifier(boolean as3, String s, String ... validExceptions) {
        Cache<String, String> nameCache;
        if (s == null || s.isEmpty()) {
            return "";
        }
        if (s.startsWith("\u00a7") && s.endsWith("\u00a7")) {
            return s;
        }
        for (String e : validExceptions) {
            if (!e.equals(s)) continue;
            return s;
        }
        Cache<String, String> cache = nameCache = as3 ? as3NameCache : as2NameCache;
        if (nameCache.contains(s)) {
            return nameCache.get(s);
        }
        if (IdentifiersDeobfuscation.isValidName(as3, s, new String[0])) {
            nameCache.put(s, s);
            return s;
        }
        String ret = "\u00a7" + IdentifiersDeobfuscation.escapeOIdentifier(s) + "\u00a7";
        nameCache.put(s, ret);
        return ret;
    }

    public static GraphTextWriter escapeOIdentifier(String s, GraphTextWriter writer) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\n') {
                writer.append("\\n");
                continue;
            }
            if (c == '\r') {
                writer.append("\\r");
                continue;
            }
            if (c == '\b') {
                writer.append("\\b");
                continue;
            }
            if (c == '\t') {
                writer.append("\\t");
                continue;
            }
            if (c == '\f') {
                writer.append("\\f");
                continue;
            }
            if (c == '\\') {
                writer.append("\\\\");
                continue;
            }
            if (c == '\u00a7') {
                writer.append("\\\u00a7");
                continue;
            }
            if (c < ' ') {
                writer.append("\\x").append(Helper.byteToHex((byte)c));
                continue;
            }
            int num = 1;
            for (int j = i + 1; j < s.length() && s.charAt(j) == c; ++j) {
                ++num;
            }
            if (num > Configuration.limitSameChars.get()) {
                writer.append("\\{").append(num).append("}");
                i += num - 1;
            }
            writer.append(c);
        }
        return writer;
    }

    public static String escapeOIdentifier(String s) {
        StringBuilder ret = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\n') {
                ret.append("\\n");
                continue;
            }
            if (c == '\r') {
                ret.append("\\r");
                continue;
            }
            if (c == '\t') {
                ret.append("\\t");
                continue;
            }
            if (c == '\b') {
                ret.append("\\b");
                continue;
            }
            if (c == '\f') {
                ret.append("\\f");
                continue;
            }
            if (c == '\\') {
                ret.append("\\\\");
                continue;
            }
            if (c == '\u00a7') {
                ret.append("\\\u00a7");
                continue;
            }
            if (c < ' ') {
                ret.append("\\x").append(Helper.byteToHex((byte)c));
                continue;
            }
            int num = 1;
            for (int j = i + 1; j < s.length() && s.charAt(j) == c; ++j) {
                ++num;
            }
            if (num > Configuration.limitSameChars.get()) {
                ret.append("\\{").append(num).append("}");
                i += num - 1;
            }
            ret.append(c);
        }
        return ret.toString();
    }

    public static void clearCache() {
        as2NameCache.clear();
        as3NameCache.clear();
    }
}

