/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class HarmanDecryption {
    private static final String GLOBAL_KEY = "Adobe AIR SDK (c) 2021 HARMAN Internation Industries Incorporated";

    private static int sum(byte[] data) {
        int s = 0;
        for (int i = 0; i < data.length; ++i) {
            s += data[i] & 0xFF;
        }
        return s;
    }

    private static long getkey(byte[] data) {
        int dsum = HarmanDecryption.sum(data);
        int dmod = dsum % GLOBAL_KEY.length();
        String s = GLOBAL_KEY.substring(dmod) + GLOBAL_KEY.substring(0, dmod);
        s = s + " EncryptSWF ";
        s = s + "" + dsum;
        long ret = 0L;
        for (int i = 0; i < s.length(); ++i) {
            char code = s.charAt(i);
            ret *= 31L;
            ret += (long)code;
        }
        return ret & 0xFFFFFFFFL;
    }

    private static long unpack(byte[] data, int start) {
        return (long)(data[start] & 0xFF) + ((long)(data[start + 1] & 0xFF) << 8) + ((long)(data[start + 2] & 0xFF) << 16) + ((long)(data[start + 3] & 0xFF) << 24);
    }

    public InputStream decrypt(InputStream is, byte[] header) throws IOException, NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        header[0] = (byte)(header[0] - 32);
        long key = HarmanDecryption.getkey(header);
        DataInputStream dais = new DataInputStream(is);
        byte[] encryptedLengthBytes = new byte[4];
        dais.readFully(encryptedLengthBytes);
        long encryptedLength = HarmanDecryption.unpack(encryptedLengthBytes, 0);
        int decryptedLength = (int)(encryptedLength ^ key);
        int paddedLength = decryptedLength + 31 & 0xFFFFFFE0;
        byte[] aesIV = new byte[16];
        System.arraycopy(header, 0, aesIV, 0, header.length);
        System.arraycopy(encryptedLengthBytes, 0, aesIV, 8, 4);
        aesIV[12] = (byte)(key & 0xFFL);
        aesIV[13] = (byte)(key >> 8 & 0xFFL);
        aesIV[14] = (byte)(key >> 16 & 0xFFL);
        aesIV[15] = (byte)(key >> 24 & 0xFFL);
        for (int i = 0; i < 16; ++i) {
            int n = i;
            aesIV[n] = (byte)(aesIV[n] ^ GLOBAL_KEY.charAt(i));
        }
        byte[] aesKey = new byte[32];
        byte[] data = new byte[paddedLength];
        dais.readFully(data);
        byte[] aesKeyData = new byte[32];
        dais.readFully(aesKeyData);
        for (int i = 0; i < 32; i += 4) {
            long value = HarmanDecryption.unpack(aesKeyData, i);
            value = (i & 4) == 4 ? (value -= key) : (value += key);
            aesKey[i] = (byte)(value & 0xFFL);
            aesKey[i + 1] = (byte)(value >> 8 & 0xFFL);
            aesKey[i + 2] = (byte)(value >> 16 & 0xFFL);
            aesKey[i + 3] = (byte)(value >> 24 & 0xFFL);
        }
        SecretKeySpec secretKeySpec = new SecretKeySpec(aesKey, "AES");
        Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
        cipher.init(2, (Key)secretKeySpec, new IvParameterSpec(aesIV));
        byte[] decryptedData = cipher.doFinal(data);
        return new ByteArrayInputStream(Arrays.copyOfRange(decryptedData, 0, decryptedLength));
    }
}

