/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jl.decoder;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public class MarkingBufferedInputStream
extends BufferedInputStream {
    private BufferedInputStream is;
    private long pos = 0L;
    private long markedPos = -1L;
    private boolean fixed = false;

    public long getPosition() {
        return this.pos;
    }

    public void setFixed(boolean fixed) {
        this.fixed = fixed;
    }

    public MarkingBufferedInputStream(InputStream in) {
        super(in);
        this.is = new BufferedInputStream(in);
    }

    @Override
    public synchronized int read() throws IOException {
        if (!this.fixed) {
            ++this.pos;
        }
        return this.is.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        int ret = this.is.read(b);
        if (!this.fixed) {
            this.pos += (long)ret;
        }
        return ret;
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        int ret = this.is.read(b, off, len);
        if (!this.fixed) {
            this.pos += (long)ret;
        }
        return ret;
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.markedPos > -1L) {
            if (!this.fixed) {
                this.pos = this.markedPos;
            }
            this.markedPos = -1L;
        }
        this.is.reset();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.markedPos = this.pos;
        this.is.mark(readlimit);
    }

    @Override
    public synchronized int available() throws IOException {
        return this.is.available();
    }

    @Override
    public synchronized long skip(long n) throws IOException {
        long ret = this.is.skip(n);
        if (!this.fixed) {
            this.pos += ret;
        }
        return ret;
    }

    @Override
    public void skipNBytes(long n) throws IOException {
        if (!this.fixed) {
            this.pos += n;
        }
        this.is.skipNBytes(n);
    }

    @Override
    public void close() throws IOException {
        this.is.close();
    }

    @Override
    public boolean markSupported() {
        return this.is.markSupported();
    }
}

