/*
 * Decompiled with CFR 0.152.
 */
package org.doubletype.ossa.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import org.doubletype.ossa.xml.GlyphFactory;
import org.doubletype.ossa.xml.IGlyphFactory;
import org.doubletype.ossa.xml.IRNode;
import org.doubletype.ossa.xml.RStack;
import org.doubletype.ossa.xml.UJAXP;
import org.doubletype.ossa.xml.URelaxer;
import org.doubletype.ossa.xml.XBody;
import org.doubletype.ossa.xml.XHead;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XStartGlyphElement
implements Serializable,
Cloneable,
IRNode {
    private XHead head_;
    private XBody body_;
    private IRNode parentRNode_;

    public XStartGlyphElement() {
    }

    public XStartGlyphElement(XStartGlyphElement source) {
        this.setup(source);
    }

    public XStartGlyphElement(RStack stack) {
        this.setup(stack);
    }

    public XStartGlyphElement(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public XStartGlyphElement(Element element) {
        this.setup(element);
    }

    public XStartGlyphElement(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public XStartGlyphElement(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public XStartGlyphElement(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public XStartGlyphElement(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public XStartGlyphElement(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public XStartGlyphElement(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(XStartGlyphElement source) {
        if (source.head_ != null) {
            this.setHead((XHead)source.getHead().clone());
        }
        if (source.body_ != null) {
            this.setBody((XBody)source.getBody().clone());
        }
    }

    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        IGlyphFactory factory = GlyphFactory.getFactory();
        RStack stack = new RStack(element);
        this.setHead(factory.createXHead(stack));
        this.setBody(factory.createXBody(stack));
    }

    public Object clone() {
        IGlyphFactory factory = GlyphFactory.getFactory();
        return factory.createXStartGlyphElement(this);
    }

    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("glyphElement");
        this.head_.makeElement(element);
        this.body_.makeElement(element);
        parent.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURI().toURL());
    }

    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public XHead getHead() {
        return this.head_;
    }

    public void setHead(XHead head) {
        this.head_ = head;
        if (head != null) {
            head.rSetParentRNode(this);
        }
    }

    public XBody getBody() {
        return this.body_;
    }

    public void setBody(XBody body) {
        this.body_ = body;
        if (body != null) {
            body.rSetParentRNode(this);
        }
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<glyphElement");
        buffer.append(">");
        this.head_.makeTextElement(buffer);
        this.body_.makeTextElement(buffer);
        buffer.append("</glyphElement>");
    }

    public void makeTextElement(Writer buffer) throws IOException {
        buffer.write("<glyphElement");
        buffer.write(">");
        this.head_.makeTextElement(buffer);
        this.body_.makeTextElement(buffer);
        buffer.write("</glyphElement>");
    }

    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<glyphElement");
        buffer.print(">");
        this.head_.makeTextElement(buffer);
        this.body_.makeTextElement(buffer);
        buffer.print("</glyphElement>");
    }

    public void makeTextAttribute(StringBuffer buffer) {
    }

    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    public void makeTextAttribute(PrintWriter buffer) {
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    @Override
    public IRNode rGetParentRNode() {
        return this.parentRNode_;
    }

    @Override
    public void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    @Override
    public IRNode[] rGetRNodes() {
        ArrayList<IRNode> classNodes = new ArrayList<IRNode>();
        if (this.head_ != null) {
            classNodes.add(this.head_);
        }
        if (this.body_ != null) {
            classNodes.add(this.body_);
        }
        IRNode[] nodes = new IRNode[classNodes.size()];
        return classNodes.toArray(nodes);
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "glyphElement")) {
            return false;
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        IGlyphFactory factory = GlyphFactory.getFactory();
        if (!XHead.isMatchHungry(target)) {
            return false;
        }
        $match$ = true;
        if (!XBody.isMatchHungry(target)) {
            return false;
        }
        $match$ = true;
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return XStartGlyphElement.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (XStartGlyphElement.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

