/*
 * Decompiled with CFR 0.152.
 */
package org.doubletype.ossa.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import org.doubletype.ossa.xml.GlyphFactory;
import org.doubletype.ossa.xml.IGlyphFactory;
import org.doubletype.ossa.xml.IRNode;
import org.doubletype.ossa.xml.RStack;
import org.doubletype.ossa.xml.UJAXP;
import org.doubletype.ossa.xml.URelaxer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XPoint2d
implements Serializable,
Cloneable,
IRNode {
    private double x_;
    private double y_;
    private IRNode parentRNode_;

    public XPoint2d() {
    }

    public XPoint2d(XPoint2d source) {
        this.setup(source);
    }

    public XPoint2d(RStack stack) {
        this.setup(stack);
    }

    public XPoint2d(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public XPoint2d(Element element) {
        this.setup(element);
    }

    public XPoint2d(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public XPoint2d(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public XPoint2d(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public XPoint2d(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public XPoint2d(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public XPoint2d(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(XPoint2d source) {
        this.x_ = source.x_;
        this.y_ = source.y_;
    }

    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        IGlyphFactory factory = GlyphFactory.getFactory();
        RStack stack = new RStack(element);
        this.x_ = URelaxer.getAttributePropertyAsDouble(element, "x");
        this.y_ = URelaxer.getAttributePropertyAsDouble(element, "y");
    }

    public Object clone() {
        IGlyphFactory factory = GlyphFactory.getFactory();
        return factory.createXPoint2d(this);
    }

    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("point2d");
        URelaxer.setAttributePropertyByDouble(element, "x", this.x_);
        URelaxer.setAttributePropertyByDouble(element, "y", this.y_);
        parent.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURI().toURL());
    }

    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public double getX() {
        return this.x_;
    }

    public void setX(double x) {
        this.x_ = x;
    }

    public double getY() {
        return this.y_;
    }

    public void setY(double y) {
        this.y_ = y;
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<point2d");
        buffer.append(" x=\"");
        buffer.append(URelaxer.getString(this.getX()));
        buffer.append("\"");
        buffer.append(" y=\"");
        buffer.append(URelaxer.getString(this.getY()));
        buffer.append("\"");
        buffer.append(">");
        buffer.append("</point2d>");
    }

    public void makeTextElement(Writer buffer) throws IOException {
        buffer.write("<point2d");
        buffer.write(" x=\"");
        buffer.write(URelaxer.getString(this.getX()));
        buffer.write("\"");
        buffer.write(" y=\"");
        buffer.write(URelaxer.getString(this.getY()));
        buffer.write("\"");
        buffer.write(">");
        buffer.write("</point2d>");
    }

    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<point2d");
        buffer.print(" x=\"");
        buffer.print(URelaxer.getString(this.getX()));
        buffer.print("\"");
        buffer.print(" y=\"");
        buffer.print(URelaxer.getString(this.getY()));
        buffer.print("\"");
        buffer.print(">");
        buffer.print("</point2d>");
    }

    public void makeTextAttribute(StringBuffer buffer) {
    }

    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    public void makeTextAttribute(PrintWriter buffer) {
    }

    public String getXAsString() {
        return URelaxer.getString(this.getX());
    }

    public String getYAsString() {
        return URelaxer.getString(this.getY());
    }

    public void setXByString(String string) {
        this.setX(Double.parseDouble(string));
    }

    public void setYByString(String string) {
        this.setY(Double.parseDouble(string));
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    @Override
    public IRNode rGetParentRNode() {
        return this.parentRNode_;
    }

    @Override
    public void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    @Override
    public IRNode[] rGetRNodes() {
        ArrayList classNodes = new ArrayList();
        IRNode[] nodes = new IRNode[classNodes.size()];
        return classNodes.toArray(nodes);
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "point2d")) {
            return false;
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        IGlyphFactory factory = GlyphFactory.getFactory();
        if (!URelaxer.hasAttributeHungry(target, "x")) {
            return false;
        }
        $match$ = true;
        if (!URelaxer.hasAttributeHungry(target, "y")) {
            return false;
        }
        $match$ = true;
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return XPoint2d.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (XPoint2d.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

