/*
 * Decompiled with CFR 0.152.
 */
package org.doubletype.ossa.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.doubletype.ossa.xml.GlyphFactory;
import org.doubletype.ossa.xml.IGlyphFactory;
import org.doubletype.ossa.xml.IRNode;
import org.doubletype.ossa.xml.RStack;
import org.doubletype.ossa.xml.UJAXP;
import org.doubletype.ossa.xml.URelaxer;
import org.doubletype.ossa.xml.XContourPoint;
import org.doubletype.ossa.xml.XInvoke;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XModule
implements Serializable,
Cloneable,
IRNode {
    private String name_;
    private XInvoke invoke_;
    private List<XContourPoint> contourPoint_ = new ArrayList<XContourPoint>();
    private IRNode parentRNode_;

    public XModule() {
        this.name_ = "";
    }

    public XModule(XModule source) {
        this.setup(source);
    }

    public XModule(RStack stack) {
        this.setup(stack);
    }

    public XModule(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public XModule(Element element) {
        this.setup(element);
    }

    public XModule(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public XModule(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public XModule(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public XModule(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public XModule(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public XModule(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(XModule source) {
        this.name_ = source.name_;
        if (source.invoke_ != null) {
            this.setInvoke((XInvoke)source.getInvoke().clone());
        }
        this.contourPoint_.clear();
        int size = source.contourPoint_.size();
        for (int i = 0; i < size; ++i) {
            this.addContourPoint((XContourPoint)source.getContourPoint(i).clone());
        }
    }

    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        IGlyphFactory factory = GlyphFactory.getFactory();
        RStack stack = new RStack(element);
        this.name_ = URelaxer.getAttributePropertyAsString(element, "name");
        this.setInvoke(factory.createXInvoke(stack));
        this.contourPoint_.clear();
        while (XContourPoint.isMatch(stack)) {
            this.addContourPoint(factory.createXContourPoint(stack));
        }
    }

    public Object clone() {
        IGlyphFactory factory = GlyphFactory.getFactory();
        return factory.createXModule(this);
    }

    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("module");
        if (this.name_ != null) {
            URelaxer.setAttributePropertyByString(element, "name", this.name_);
        }
        this.invoke_.makeElement(element);
        int size = this.contourPoint_.size();
        for (int i = 0; i < size; ++i) {
            XContourPoint value = this.contourPoint_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURI().toURL());
    }

    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public String getName() {
        return this.name_;
    }

    public void setName(String name) {
        this.name_ = name;
    }

    public XInvoke getInvoke() {
        return this.invoke_;
    }

    public void setInvoke(XInvoke invoke) {
        this.invoke_ = invoke;
        if (invoke != null) {
            invoke.rSetParentRNode(this);
        }
    }

    public XContourPoint[] getContourPoint() {
        XContourPoint[] array = new XContourPoint[this.contourPoint_.size()];
        return this.contourPoint_.toArray(array);
    }

    public void setContourPoint(XContourPoint[] contourPoint) {
        int i;
        this.contourPoint_.clear();
        for (i = 0; i < contourPoint.length; ++i) {
            this.addContourPoint(contourPoint[i]);
        }
        for (i = 0; i < contourPoint.length; ++i) {
            contourPoint[i].rSetParentRNode(this);
        }
    }

    public void setContourPoint(XContourPoint contourPoint) {
        this.contourPoint_.clear();
        this.addContourPoint(contourPoint);
        if (contourPoint != null) {
            contourPoint.rSetParentRNode(this);
        }
    }

    public void addContourPoint(XContourPoint contourPoint) {
        this.contourPoint_.add(contourPoint);
        if (contourPoint != null) {
            contourPoint.rSetParentRNode(this);
        }
    }

    public void addContourPoint(XContourPoint[] contourPoint) {
        int i;
        for (i = 0; i < contourPoint.length; ++i) {
            this.addContourPoint(contourPoint[i]);
        }
        for (i = 0; i < contourPoint.length; ++i) {
            contourPoint[i].rSetParentRNode(this);
        }
    }

    public int sizeContourPoint() {
        return this.contourPoint_.size();
    }

    public XContourPoint getContourPoint(int index) {
        return this.contourPoint_.get(index);
    }

    public void setContourPoint(int index, XContourPoint contourPoint) {
        this.contourPoint_.set(index, contourPoint);
        if (contourPoint != null) {
            contourPoint.rSetParentRNode(this);
        }
    }

    public void addContourPoint(int index, XContourPoint contourPoint) {
        this.contourPoint_.add(index, contourPoint);
        if (contourPoint != null) {
            contourPoint.rSetParentRNode(this);
        }
    }

    public void removeContourPoint(int index) {
        this.contourPoint_.remove(index);
    }

    public void removeContourPoint(XContourPoint contourPoint) {
        this.contourPoint_.remove(contourPoint);
    }

    public void clearContourPoint() {
        this.contourPoint_.clear();
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<module");
        if (this.name_ != null) {
            buffer.append(" name=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getName())));
            buffer.append("\"");
        }
        buffer.append(">");
        this.invoke_.makeTextElement(buffer);
        int size = this.contourPoint_.size();
        for (int i = 0; i < size; ++i) {
            XContourPoint value = this.contourPoint_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</module>");
    }

    public void makeTextElement(Writer buffer) throws IOException {
        buffer.write("<module");
        if (this.name_ != null) {
            buffer.write(" name=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getName())));
            buffer.write("\"");
        }
        buffer.write(">");
        this.invoke_.makeTextElement(buffer);
        int size = this.contourPoint_.size();
        for (int i = 0; i < size; ++i) {
            XContourPoint value = this.contourPoint_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.write("</module>");
    }

    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<module");
        if (this.name_ != null) {
            buffer.print(" name=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getName())));
            buffer.print("\"");
        }
        buffer.print(">");
        this.invoke_.makeTextElement(buffer);
        int size = this.contourPoint_.size();
        for (int i = 0; i < size; ++i) {
            XContourPoint value = this.contourPoint_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</module>");
    }

    public void makeTextAttribute(StringBuffer buffer) {
    }

    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    public void makeTextAttribute(PrintWriter buffer) {
    }

    public String getNameAsString() {
        return URelaxer.getString(this.getName());
    }

    public void setNameByString(String string) {
        this.setName(string);
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    @Override
    public IRNode rGetParentRNode() {
        return this.parentRNode_;
    }

    @Override
    public void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    @Override
    public IRNode[] rGetRNodes() {
        ArrayList<IRNode> classNodes = new ArrayList<IRNode>();
        if (this.invoke_ != null) {
            classNodes.add(this.invoke_);
        }
        classNodes.addAll(this.contourPoint_);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return classNodes.toArray(nodes);
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "module")) {
            return false;
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        IGlyphFactory factory = GlyphFactory.getFactory();
        if (!URelaxer.hasAttributeHungry(target, "name")) {
            return false;
        }
        $match$ = true;
        if (!XInvoke.isMatchHungry(target)) {
            return false;
        }
        $match$ = true;
        if (!XContourPoint.isMatchHungry(target)) {
            return false;
        }
        $match$ = true;
        while (XContourPoint.isMatchHungry(target)) {
            $match$ = true;
        }
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return XModule.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (XModule.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

