/*
 * Decompiled with CFR 0.152.
 */
package org.doubletype.ossa.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import org.doubletype.ossa.xml.GlyphFactory;
import org.doubletype.ossa.xml.IGlyphFactory;
import org.doubletype.ossa.xml.IRNode;
import org.doubletype.ossa.xml.RStack;
import org.doubletype.ossa.xml.UJAXP;
import org.doubletype.ossa.xml.URelaxer;
import org.doubletype.ossa.xml.XPoint2d;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XInvokePos
implements Serializable,
Cloneable,
IRNode {
    private XPoint2d point2d_;
    private IRNode parentRNode_;

    public XInvokePos() {
    }

    public XInvokePos(XInvokePos source) {
        this.setup(source);
    }

    public XInvokePos(RStack stack) {
        this.setup(stack);
    }

    public XInvokePos(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public XInvokePos(Element element) {
        this.setup(element);
    }

    public XInvokePos(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public XInvokePos(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public XInvokePos(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public XInvokePos(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public XInvokePos(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public XInvokePos(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(XInvokePos source) {
        if (source.point2d_ != null) {
            this.setPoint2d((XPoint2d)source.getPoint2d().clone());
        }
    }

    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        IGlyphFactory factory = GlyphFactory.getFactory();
        RStack stack = new RStack(element);
        this.setPoint2d(factory.createXPoint2d(stack));
    }

    public Object clone() {
        IGlyphFactory factory = GlyphFactory.getFactory();
        return factory.createXInvokePos(this);
    }

    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("pos");
        this.point2d_.makeElement(element);
        parent.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURI().toURL());
    }

    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public XPoint2d getPoint2d() {
        return this.point2d_;
    }

    public void setPoint2d(XPoint2d point2d) {
        this.point2d_ = point2d;
        if (point2d != null) {
            point2d.rSetParentRNode(this);
        }
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<pos");
        buffer.append(">");
        this.point2d_.makeTextElement(buffer);
        buffer.append("</pos>");
    }

    public void makeTextElement(Writer buffer) throws IOException {
        buffer.write("<pos");
        buffer.write(">");
        this.point2d_.makeTextElement(buffer);
        buffer.write("</pos>");
    }

    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<pos");
        buffer.print(">");
        this.point2d_.makeTextElement(buffer);
        buffer.print("</pos>");
    }

    public void makeTextAttribute(StringBuffer buffer) {
    }

    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    public void makeTextAttribute(PrintWriter buffer) {
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    @Override
    public IRNode rGetParentRNode() {
        return this.parentRNode_;
    }

    @Override
    public void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    @Override
    public IRNode[] rGetRNodes() {
        ArrayList<XPoint2d> classNodes = new ArrayList<XPoint2d>();
        if (this.point2d_ != null) {
            classNodes.add(this.point2d_);
        }
        IRNode[] nodes = new IRNode[classNodes.size()];
        return classNodes.toArray(nodes);
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "pos")) {
            return false;
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        IGlyphFactory factory = GlyphFactory.getFactory();
        if (!XPoint2d.isMatchHungry(target)) {
            return false;
        }
        $match$ = true;
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return XInvokePos.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (XInvokePos.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

