/*
 * Decompiled with CFR 0.152.
 */
package org.doubletype.ossa.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.doubletype.ossa.xml.GlyphFactory;
import org.doubletype.ossa.xml.IGlyphFactory;
import org.doubletype.ossa.xml.IRNode;
import org.doubletype.ossa.xml.RStack;
import org.doubletype.ossa.xml.UJAXP;
import org.doubletype.ossa.xml.URelaxer;
import org.doubletype.ossa.xml.XInvokeArg;
import org.doubletype.ossa.xml.XInvokePos;
import org.doubletype.ossa.xml.XInvokeVarg;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XInvoke
implements Serializable,
Cloneable,
IRNode {
    private XInvokePos invokePos_;
    private List<XInvokeArg> invokeArg_ = new ArrayList<XInvokeArg>();
    private List<XInvokeVarg> invokeVarg_ = new ArrayList<XInvokeVarg>();
    private IRNode parentRNode_;

    public XInvoke() {
    }

    public XInvoke(XInvoke source) {
        this.setup(source);
    }

    public XInvoke(RStack stack) {
        this.setup(stack);
    }

    public XInvoke(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public XInvoke(Element element) {
        this.setup(element);
    }

    public XInvoke(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public XInvoke(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public XInvoke(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public XInvoke(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public XInvoke(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public XInvoke(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(XInvoke source) {
        int i;
        if (source.invokePos_ != null) {
            this.setInvokePos((XInvokePos)source.getInvokePos().clone());
        }
        this.invokeArg_.clear();
        int size = source.invokeArg_.size();
        for (i = 0; i < size; ++i) {
            this.addInvokeArg((XInvokeArg)source.getInvokeArg(i).clone());
        }
        this.invokeVarg_.clear();
        size = source.invokeVarg_.size();
        for (i = 0; i < size; ++i) {
            this.addInvokeVarg((XInvokeVarg)source.getInvokeVarg(i).clone());
        }
    }

    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        IGlyphFactory factory = GlyphFactory.getFactory();
        RStack stack = new RStack(element);
        this.setInvokePos(factory.createXInvokePos(stack));
        this.invokeArg_.clear();
        while (XInvokeArg.isMatch(stack)) {
            this.addInvokeArg(factory.createXInvokeArg(stack));
        }
        this.invokeVarg_.clear();
        while (XInvokeVarg.isMatch(stack)) {
            this.addInvokeVarg(factory.createXInvokeVarg(stack));
        }
    }

    public Object clone() {
        IGlyphFactory factory = GlyphFactory.getFactory();
        return factory.createXInvoke(this);
    }

    public void makeElement(Node parent) {
        IRNode value;
        int i;
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("invoke");
        this.invokePos_.makeElement(element);
        int size = this.invokeArg_.size();
        for (i = 0; i < size; ++i) {
            value = this.invokeArg_.get(i);
            ((XInvokeArg)value).makeElement(element);
        }
        size = this.invokeVarg_.size();
        for (i = 0; i < size; ++i) {
            value = this.invokeVarg_.get(i);
            ((XInvokeVarg)value).makeElement(element);
        }
        parent.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURI().toURL());
    }

    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public XInvokePos getInvokePos() {
        return this.invokePos_;
    }

    public void setInvokePos(XInvokePos invokePos) {
        this.invokePos_ = invokePos;
        if (invokePos != null) {
            invokePos.rSetParentRNode(this);
        }
    }

    public XInvokeArg[] getInvokeArg() {
        XInvokeArg[] array = new XInvokeArg[this.invokeArg_.size()];
        return this.invokeArg_.toArray(array);
    }

    public void setInvokeArg(XInvokeArg[] invokeArg) {
        int i;
        this.invokeArg_.clear();
        for (i = 0; i < invokeArg.length; ++i) {
            this.addInvokeArg(invokeArg[i]);
        }
        for (i = 0; i < invokeArg.length; ++i) {
            invokeArg[i].rSetParentRNode(this);
        }
    }

    public void setInvokeArg(XInvokeArg invokeArg) {
        this.invokeArg_.clear();
        this.addInvokeArg(invokeArg);
        if (invokeArg != null) {
            invokeArg.rSetParentRNode(this);
        }
    }

    public void addInvokeArg(XInvokeArg invokeArg) {
        this.invokeArg_.add(invokeArg);
        if (invokeArg != null) {
            invokeArg.rSetParentRNode(this);
        }
    }

    public void addInvokeArg(XInvokeArg[] invokeArg) {
        int i;
        for (i = 0; i < invokeArg.length; ++i) {
            this.addInvokeArg(invokeArg[i]);
        }
        for (i = 0; i < invokeArg.length; ++i) {
            invokeArg[i].rSetParentRNode(this);
        }
    }

    public int sizeInvokeArg() {
        return this.invokeArg_.size();
    }

    public XInvokeArg getInvokeArg(int index) {
        return this.invokeArg_.get(index);
    }

    public void setInvokeArg(int index, XInvokeArg invokeArg) {
        this.invokeArg_.set(index, invokeArg);
        if (invokeArg != null) {
            invokeArg.rSetParentRNode(this);
        }
    }

    public void addInvokeArg(int index, XInvokeArg invokeArg) {
        this.invokeArg_.add(index, invokeArg);
        if (invokeArg != null) {
            invokeArg.rSetParentRNode(this);
        }
    }

    public void removeInvokeArg(int index) {
        this.invokeArg_.remove(index);
    }

    public void removeInvokeArg(XInvokeArg invokeArg) {
        this.invokeArg_.remove(invokeArg);
    }

    public void clearInvokeArg() {
        this.invokeArg_.clear();
    }

    public XInvokeVarg[] getInvokeVarg() {
        XInvokeVarg[] array = new XInvokeVarg[this.invokeVarg_.size()];
        return this.invokeVarg_.toArray(array);
    }

    public void setInvokeVarg(XInvokeVarg[] invokeVarg) {
        int i;
        this.invokeVarg_.clear();
        for (i = 0; i < invokeVarg.length; ++i) {
            this.addInvokeVarg(invokeVarg[i]);
        }
        for (i = 0; i < invokeVarg.length; ++i) {
            invokeVarg[i].rSetParentRNode(this);
        }
    }

    public void setInvokeVarg(XInvokeVarg invokeVarg) {
        this.invokeVarg_.clear();
        this.addInvokeVarg(invokeVarg);
        if (invokeVarg != null) {
            invokeVarg.rSetParentRNode(this);
        }
    }

    public void addInvokeVarg(XInvokeVarg invokeVarg) {
        this.invokeVarg_.add(invokeVarg);
        if (invokeVarg != null) {
            invokeVarg.rSetParentRNode(this);
        }
    }

    public void addInvokeVarg(XInvokeVarg[] invokeVarg) {
        int i;
        for (i = 0; i < invokeVarg.length; ++i) {
            this.addInvokeVarg(invokeVarg[i]);
        }
        for (i = 0; i < invokeVarg.length; ++i) {
            invokeVarg[i].rSetParentRNode(this);
        }
    }

    public int sizeInvokeVarg() {
        return this.invokeVarg_.size();
    }

    public XInvokeVarg getInvokeVarg(int index) {
        return this.invokeVarg_.get(index);
    }

    public void setInvokeVarg(int index, XInvokeVarg invokeVarg) {
        this.invokeVarg_.set(index, invokeVarg);
        if (invokeVarg != null) {
            invokeVarg.rSetParentRNode(this);
        }
    }

    public void addInvokeVarg(int index, XInvokeVarg invokeVarg) {
        this.invokeVarg_.add(index, invokeVarg);
        if (invokeVarg != null) {
            invokeVarg.rSetParentRNode(this);
        }
    }

    public void removeInvokeVarg(int index) {
        this.invokeVarg_.remove(index);
    }

    public void removeInvokeVarg(XInvokeVarg invokeVarg) {
        this.invokeVarg_.remove(invokeVarg);
    }

    public void clearInvokeVarg() {
        this.invokeVarg_.clear();
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        IRNode value;
        int i;
        buffer.append("<invoke");
        buffer.append(">");
        this.invokePos_.makeTextElement(buffer);
        int size = this.invokeArg_.size();
        for (i = 0; i < size; ++i) {
            value = this.invokeArg_.get(i);
            ((XInvokeArg)value).makeTextElement(buffer);
        }
        size = this.invokeVarg_.size();
        for (i = 0; i < size; ++i) {
            value = this.invokeVarg_.get(i);
            ((XInvokeVarg)value).makeTextElement(buffer);
        }
        buffer.append("</invoke>");
    }

    public void makeTextElement(Writer buffer) throws IOException {
        IRNode value;
        int i;
        buffer.write("<invoke");
        buffer.write(">");
        this.invokePos_.makeTextElement(buffer);
        int size = this.invokeArg_.size();
        for (i = 0; i < size; ++i) {
            value = this.invokeArg_.get(i);
            ((XInvokeArg)value).makeTextElement(buffer);
        }
        size = this.invokeVarg_.size();
        for (i = 0; i < size; ++i) {
            value = this.invokeVarg_.get(i);
            ((XInvokeVarg)value).makeTextElement(buffer);
        }
        buffer.write("</invoke>");
    }

    public void makeTextElement(PrintWriter buffer) {
        IRNode value;
        int i;
        buffer.print("<invoke");
        buffer.print(">");
        this.invokePos_.makeTextElement(buffer);
        int size = this.invokeArg_.size();
        for (i = 0; i < size; ++i) {
            value = this.invokeArg_.get(i);
            ((XInvokeArg)value).makeTextElement(buffer);
        }
        size = this.invokeVarg_.size();
        for (i = 0; i < size; ++i) {
            value = this.invokeVarg_.get(i);
            ((XInvokeVarg)value).makeTextElement(buffer);
        }
        buffer.print("</invoke>");
    }

    public void makeTextAttribute(StringBuffer buffer) {
    }

    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    public void makeTextAttribute(PrintWriter buffer) {
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    @Override
    public IRNode rGetParentRNode() {
        return this.parentRNode_;
    }

    @Override
    public void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    @Override
    public IRNode[] rGetRNodes() {
        ArrayList<IRNode> classNodes = new ArrayList<IRNode>();
        if (this.invokePos_ != null) {
            classNodes.add(this.invokePos_);
        }
        classNodes.addAll(this.invokeArg_);
        classNodes.addAll(this.invokeVarg_);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return classNodes.toArray(nodes);
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "invoke")) {
            return false;
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        IGlyphFactory factory = GlyphFactory.getFactory();
        if (!XInvokePos.isMatchHungry(target)) {
            return false;
        }
        $match$ = true;
        while (XInvokeArg.isMatchHungry(target)) {
            $match$ = true;
        }
        while (XInvokeVarg.isMatchHungry(target)) {
            $match$ = true;
        }
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return XInvoke.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (XInvoke.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

