/*
 * Decompiled with CFR 0.152.
 */
package org.doubletype.ossa.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import org.doubletype.ossa.xml.GlyphFactory;
import org.doubletype.ossa.xml.IGlyphFactory;
import org.doubletype.ossa.xml.IRNode;
import org.doubletype.ossa.xml.RStack;
import org.doubletype.ossa.xml.UJAXP;
import org.doubletype.ossa.xml.URelaxer;
import org.doubletype.ossa.xml.XPoint2d;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XHint
implements Serializable,
Cloneable,
IRNode {
    private long ppem_;
    private XPoint2d point2d_;
    private IRNode parentRNode_;

    public XHint() {
    }

    public XHint(XHint source) {
        this.setup(source);
    }

    public XHint(RStack stack) {
        this.setup(stack);
    }

    public XHint(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public XHint(Element element) {
        this.setup(element);
    }

    public XHint(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public XHint(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public XHint(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public XHint(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public XHint(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public XHint(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(XHint source) {
        this.ppem_ = source.ppem_;
        if (source.point2d_ != null) {
            this.setPoint2d((XPoint2d)source.getPoint2d().clone());
        }
    }

    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        IGlyphFactory factory = GlyphFactory.getFactory();
        RStack stack = new RStack(element);
        this.ppem_ = URelaxer.getAttributePropertyAsLong(element, "ppem");
        this.setPoint2d(factory.createXPoint2d(stack));
    }

    public Object clone() {
        IGlyphFactory factory = GlyphFactory.getFactory();
        return factory.createXHint(this);
    }

    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("hint");
        URelaxer.setAttributePropertyByLong(element, "ppem", this.ppem_);
        this.point2d_.makeElement(element);
        parent.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURI().toURL());
    }

    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public long getPpem() {
        return this.ppem_;
    }

    public void setPpem(long ppem) {
        this.ppem_ = ppem;
    }

    public XPoint2d getPoint2d() {
        return this.point2d_;
    }

    public void setPoint2d(XPoint2d point2d) {
        this.point2d_ = point2d;
        if (point2d != null) {
            point2d.rSetParentRNode(this);
        }
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<hint");
        buffer.append(" ppem=\"");
        buffer.append(URelaxer.getString(this.getPpem()));
        buffer.append("\"");
        buffer.append(">");
        this.point2d_.makeTextElement(buffer);
        buffer.append("</hint>");
    }

    public void makeTextElement(Writer buffer) throws IOException {
        buffer.write("<hint");
        buffer.write(" ppem=\"");
        buffer.write(URelaxer.getString(this.getPpem()));
        buffer.write("\"");
        buffer.write(">");
        this.point2d_.makeTextElement(buffer);
        buffer.write("</hint>");
    }

    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<hint");
        buffer.print(" ppem=\"");
        buffer.print(URelaxer.getString(this.getPpem()));
        buffer.print("\"");
        buffer.print(">");
        this.point2d_.makeTextElement(buffer);
        buffer.print("</hint>");
    }

    public void makeTextAttribute(StringBuffer buffer) {
    }

    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    public void makeTextAttribute(PrintWriter buffer) {
    }

    public String getPpemAsString() {
        return URelaxer.getString(this.getPpem());
    }

    public void setPpemByString(String string) {
        this.setPpem(Long.parseLong(string));
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    @Override
    public IRNode rGetParentRNode() {
        return this.parentRNode_;
    }

    @Override
    public void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    @Override
    public IRNode[] rGetRNodes() {
        ArrayList<XPoint2d> classNodes = new ArrayList<XPoint2d>();
        if (this.point2d_ != null) {
            classNodes.add(this.point2d_);
        }
        IRNode[] nodes = new IRNode[classNodes.size()];
        return classNodes.toArray(nodes);
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "hint")) {
            return false;
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        IGlyphFactory factory = GlyphFactory.getFactory();
        if (!URelaxer.hasAttributeHungry(target, "ppem")) {
            return false;
        }
        $match$ = true;
        if (!XPoint2d.isMatchHungry(target)) {
            return false;
        }
        $match$ = true;
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return XHint.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (XHint.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

