/*
 * Decompiled with CFR 0.152.
 */
package org.doubletype.ossa.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.doubletype.ossa.xml.GlyphFactory;
import org.doubletype.ossa.xml.IGlyphFactory;
import org.doubletype.ossa.xml.IRNode;
import org.doubletype.ossa.xml.RStack;
import org.doubletype.ossa.xml.UJAXP;
import org.doubletype.ossa.xml.URelaxer;
import org.doubletype.ossa.xml.XHeadGlobal;
import org.doubletype.ossa.xml.XHeadLocal;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XHead
implements Serializable,
Cloneable,
IRNode {
    private String title_;
    private String unicode_;
    private List<String> unicodeRange_ = new ArrayList<String>();
    private List<String> codePage_ = new ArrayList<String>();
    private Double ascender_;
    private Double descender_;
    private Double xHeight_;
    private Double advanceWidth_;
    private Double advanceHeight_;
    private Double leftSideBearing_;
    private Double topSideBearing_;
    private Double bottomSideBearing_;
    private Double lineGap_;
    private String author_;
    private String copyright_;
    private String version_;
    private String fontFamily_;
    private String fontSubFamily_;
    private String license_;
    private XHeadGlobal headGlobal_;
    private XHeadLocal headLocal_;
    private IRNode parentRNode_;

    public XHead() {
        this.title_ = "";
        this.unicode_ = "";
        this.author_ = "";
        this.copyright_ = "";
        this.fontFamily_ = "";
        this.fontSubFamily_ = "";
        this.license_ = "";
    }

    public XHead(XHead source) {
        this.setup(source);
    }

    public XHead(RStack stack) {
        this.setup(stack);
    }

    public XHead(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public XHead(Element element) {
        this.setup(element);
    }

    public XHead(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public XHead(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public XHead(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public XHead(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public XHead(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public XHead(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(XHead source) {
        this.title_ = source.title_;
        this.unicode_ = source.unicode_;
        this.setUnicodeRange(source.getUnicodeRange());
        this.setCodePage(source.getCodePage());
        this.ascender_ = source.ascender_;
        this.descender_ = source.descender_;
        this.xHeight_ = source.xHeight_;
        this.advanceWidth_ = source.advanceWidth_;
        this.advanceHeight_ = source.advanceHeight_;
        this.leftSideBearing_ = source.leftSideBearing_;
        this.topSideBearing_ = source.topSideBearing_;
        this.bottomSideBearing_ = source.bottomSideBearing_;
        this.lineGap_ = source.lineGap_;
        this.author_ = source.author_;
        this.copyright_ = source.copyright_;
        this.version_ = source.version_;
        this.fontFamily_ = source.fontFamily_;
        this.fontSubFamily_ = source.fontSubFamily_;
        this.license_ = source.license_;
        if (source.headGlobal_ != null) {
            this.setHeadGlobal((XHeadGlobal)source.getHeadGlobal().clone());
        }
        if (source.headLocal_ != null) {
            this.setHeadLocal((XHeadLocal)source.getHeadLocal().clone());
        }
    }

    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        IGlyphFactory factory = GlyphFactory.getFactory();
        RStack stack = new RStack(element);
        this.title_ = URelaxer.getElementPropertyAsString(stack.popElement());
        this.unicode_ = URelaxer.getElementPropertyAsString(stack.popElement());
        this.unicodeRange_ = URelaxer.getElementPropertyAsStringListByStack(stack, "unicodeRange");
        this.codePage_ = URelaxer.getElementPropertyAsStringListByStack(stack, "codePage");
        this.ascender_ = URelaxer.getElementPropertyAsDoubleByStack(stack, "ascender");
        this.descender_ = URelaxer.getElementPropertyAsDoubleByStack(stack, "descender");
        this.xHeight_ = URelaxer.getElementPropertyAsDoubleByStack(stack, "xHeight");
        this.advanceWidth_ = URelaxer.getElementPropertyAsDoubleByStack(stack, "advanceWidth");
        this.advanceHeight_ = URelaxer.getElementPropertyAsDoubleByStack(stack, "advanceHeight");
        this.leftSideBearing_ = URelaxer.getElementPropertyAsDoubleByStack(stack, "leftSideBearing");
        this.topSideBearing_ = URelaxer.getElementPropertyAsDoubleByStack(stack, "topSideBearing");
        this.bottomSideBearing_ = URelaxer.getElementPropertyAsDoubleByStack(stack, "bottomSideBearing");
        this.lineGap_ = URelaxer.getElementPropertyAsDoubleByStack(stack, "lineGap");
        this.author_ = URelaxer.getElementPropertyAsString(stack.popElement());
        this.copyright_ = URelaxer.getElementPropertyAsString(stack.popElement());
        this.version_ = URelaxer.getElementPropertyAsStringByStack(stack, "version");
        this.fontFamily_ = URelaxer.getElementPropertyAsString(stack.popElement());
        this.fontSubFamily_ = URelaxer.getElementPropertyAsString(stack.popElement());
        this.license_ = URelaxer.getElementPropertyAsString(stack.popElement());
        this.setHeadGlobal(factory.createXHeadGlobal(stack));
        this.setHeadLocal(factory.createXHeadLocal(stack));
    }

    public Object clone() {
        IGlyphFactory factory = GlyphFactory.getFactory();
        return factory.createXHead(this);
    }

    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("head");
        URelaxer.setElementPropertyByString(element, "title", this.title_);
        URelaxer.setElementPropertyByString(element, "unicode", this.unicode_);
        URelaxer.setElementPropertyByStringList(element, "unicodeRange", this.unicodeRange_);
        URelaxer.setElementPropertyByStringList(element, "codePage", this.codePage_);
        if (this.ascender_ != null) {
            URelaxer.setElementPropertyByDouble(element, "ascender", this.ascender_);
        }
        if (this.descender_ != null) {
            URelaxer.setElementPropertyByDouble(element, "descender", this.descender_);
        }
        if (this.xHeight_ != null) {
            URelaxer.setElementPropertyByDouble(element, "xHeight", this.xHeight_);
        }
        if (this.advanceWidth_ != null) {
            URelaxer.setElementPropertyByDouble(element, "advanceWidth", this.advanceWidth_);
        }
        if (this.advanceHeight_ != null) {
            URelaxer.setElementPropertyByDouble(element, "advanceHeight", this.advanceHeight_);
        }
        if (this.leftSideBearing_ != null) {
            URelaxer.setElementPropertyByDouble(element, "leftSideBearing", this.leftSideBearing_);
        }
        if (this.topSideBearing_ != null) {
            URelaxer.setElementPropertyByDouble(element, "topSideBearing", this.topSideBearing_);
        }
        if (this.bottomSideBearing_ != null) {
            URelaxer.setElementPropertyByDouble(element, "bottomSideBearing", this.bottomSideBearing_);
        }
        if (this.lineGap_ != null) {
            URelaxer.setElementPropertyByDouble(element, "lineGap", this.lineGap_);
        }
        URelaxer.setElementPropertyByString(element, "author", this.author_);
        URelaxer.setElementPropertyByString(element, "copyright", this.copyright_);
        if (this.version_ != null) {
            URelaxer.setElementPropertyByString(element, "version", this.version_);
        }
        URelaxer.setElementPropertyByString(element, "fontFamily", this.fontFamily_);
        URelaxer.setElementPropertyByString(element, "fontSubFamily", this.fontSubFamily_);
        URelaxer.setElementPropertyByString(element, "license", this.license_);
        this.headGlobal_.makeElement(element);
        this.headLocal_.makeElement(element);
        parent.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURI().toURL());
    }

    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public String getTitle() {
        return this.title_;
    }

    public void setTitle(String title) {
        this.title_ = title;
    }

    public String getUnicode() {
        return this.unicode_;
    }

    public void setUnicode(String unicode) {
        this.unicode_ = unicode;
    }

    public String[] getUnicodeRange() {
        String[] array = new String[this.unicodeRange_.size()];
        return this.unicodeRange_.toArray(array);
    }

    public void setUnicodeRange(String[] unicodeRange) {
        this.unicodeRange_.clear();
        for (int i = 0; i < unicodeRange.length; ++i) {
            this.addUnicodeRange(unicodeRange[i]);
        }
    }

    public void setUnicodeRange(String unicodeRange) {
        this.unicodeRange_.clear();
        this.addUnicodeRange(unicodeRange);
    }

    public void addUnicodeRange(String unicodeRange) {
        this.unicodeRange_.add(unicodeRange);
    }

    public void addUnicodeRange(String[] unicodeRange) {
        for (int i = 0; i < unicodeRange.length; ++i) {
            this.addUnicodeRange(unicodeRange[i]);
        }
    }

    public int sizeUnicodeRange() {
        return this.unicodeRange_.size();
    }

    public String getUnicodeRange(int index) {
        return this.unicodeRange_.get(index);
    }

    public void setUnicodeRange(int index, String unicodeRange) {
        this.unicodeRange_.set(index, unicodeRange);
    }

    public void addUnicodeRange(int index, String unicodeRange) {
        this.unicodeRange_.add(index, unicodeRange);
    }

    public void removeUnicodeRange(int index) {
        this.unicodeRange_.remove(index);
    }

    public void removeUnicodeRange(String unicodeRange) {
        this.unicodeRange_.remove(unicodeRange);
    }

    public void clearUnicodeRange() {
        this.unicodeRange_.clear();
    }

    public String[] getCodePage() {
        String[] array = new String[this.codePage_.size()];
        return this.codePage_.toArray(array);
    }

    public void setCodePage(String[] codePage) {
        this.codePage_.clear();
        for (int i = 0; i < codePage.length; ++i) {
            this.addCodePage(codePage[i]);
        }
    }

    public void setCodePage(String codePage) {
        this.codePage_.clear();
        this.addCodePage(codePage);
    }

    public void addCodePage(String codePage) {
        this.codePage_.add(codePage);
    }

    public void addCodePage(String[] codePage) {
        for (int i = 0; i < codePage.length; ++i) {
            this.addCodePage(codePage[i]);
        }
    }

    public int sizeCodePage() {
        return this.codePage_.size();
    }

    public String getCodePage(int index) {
        return this.codePage_.get(index);
    }

    public void setCodePage(int index, String codePage) {
        this.codePage_.set(index, codePage);
    }

    public void addCodePage(int index, String codePage) {
        this.codePage_.add(index, codePage);
    }

    public void removeCodePage(int index) {
        this.codePage_.remove(index);
    }

    public void removeCodePage(String codePage) {
        this.codePage_.remove(codePage);
    }

    public void clearCodePage() {
        this.codePage_.clear();
    }

    public double getAscender() {
        if (this.ascender_ == null) {
            return Double.NaN;
        }
        return this.ascender_;
    }

    public double getAscender(double ascender) {
        if (this.ascender_ == null) {
            return ascender;
        }
        return this.ascender_;
    }

    public Double getAscenderAsDouble() {
        return this.ascender_;
    }

    public boolean checkAscender() {
        return this.ascender_ != null;
    }

    public void setAscender(double ascender) {
        this.ascender_ = new Double(ascender);
    }

    public void setAscender(Double ascender) {
        this.ascender_ = ascender;
    }

    public double getDescender() {
        if (this.descender_ == null) {
            return Double.NaN;
        }
        return this.descender_;
    }

    public double getDescender(double descender) {
        if (this.descender_ == null) {
            return descender;
        }
        return this.descender_;
    }

    public Double getDescenderAsDouble() {
        return this.descender_;
    }

    public boolean checkDescender() {
        return this.descender_ != null;
    }

    public void setDescender(double descender) {
        this.descender_ = new Double(descender);
    }

    public void setDescender(Double descender) {
        this.descender_ = descender;
    }

    public double getXHeight() {
        if (this.xHeight_ == null) {
            return Double.NaN;
        }
        return this.xHeight_;
    }

    public double getXHeight(double xHeight) {
        if (this.xHeight_ == null) {
            return xHeight;
        }
        return this.xHeight_;
    }

    public Double getXHeightAsDouble() {
        return this.xHeight_;
    }

    public boolean checkXHeight() {
        return this.xHeight_ != null;
    }

    public void setXHeight(double xHeight) {
        this.xHeight_ = new Double(xHeight);
    }

    public void setXHeight(Double xHeight) {
        this.xHeight_ = xHeight;
    }

    public double getAdvanceWidth() {
        if (this.advanceWidth_ == null) {
            return Double.NaN;
        }
        return this.advanceWidth_;
    }

    public double getAdvanceWidth(double advanceWidth) {
        if (this.advanceWidth_ == null) {
            return advanceWidth;
        }
        return this.advanceWidth_;
    }

    public Double getAdvanceWidthAsDouble() {
        return this.advanceWidth_;
    }

    public boolean checkAdvanceWidth() {
        return this.advanceWidth_ != null;
    }

    public void setAdvanceWidth(double advanceWidth) {
        this.advanceWidth_ = new Double(advanceWidth);
    }

    public void setAdvanceWidth(Double advanceWidth) {
        this.advanceWidth_ = advanceWidth;
    }

    public double getAdvanceHeight() {
        if (this.advanceHeight_ == null) {
            return Double.NaN;
        }
        return this.advanceHeight_;
    }

    public double getAdvanceHeight(double advanceHeight) {
        if (this.advanceHeight_ == null) {
            return advanceHeight;
        }
        return this.advanceHeight_;
    }

    public Double getAdvanceHeightAsDouble() {
        return this.advanceHeight_;
    }

    public boolean checkAdvanceHeight() {
        return this.advanceHeight_ != null;
    }

    public void setAdvanceHeight(double advanceHeight) {
        this.advanceHeight_ = new Double(advanceHeight);
    }

    public void setAdvanceHeight(Double advanceHeight) {
        this.advanceHeight_ = advanceHeight;
    }

    public double getLeftSideBearing() {
        if (this.leftSideBearing_ == null) {
            return Double.NaN;
        }
        return this.leftSideBearing_;
    }

    public double getLeftSideBearing(double leftSideBearing) {
        if (this.leftSideBearing_ == null) {
            return leftSideBearing;
        }
        return this.leftSideBearing_;
    }

    public Double getLeftSideBearingAsDouble() {
        return this.leftSideBearing_;
    }

    public boolean checkLeftSideBearing() {
        return this.leftSideBearing_ != null;
    }

    public void setLeftSideBearing(double leftSideBearing) {
        this.leftSideBearing_ = new Double(leftSideBearing);
    }

    public void setLeftSideBearing(Double leftSideBearing) {
        this.leftSideBearing_ = leftSideBearing;
    }

    public double getTopSideBearing() {
        if (this.topSideBearing_ == null) {
            return Double.NaN;
        }
        return this.topSideBearing_;
    }

    public double getTopSideBearing(double topSideBearing) {
        if (this.topSideBearing_ == null) {
            return topSideBearing;
        }
        return this.topSideBearing_;
    }

    public Double getTopSideBearingAsDouble() {
        return this.topSideBearing_;
    }

    public boolean checkTopSideBearing() {
        return this.topSideBearing_ != null;
    }

    public void setTopSideBearing(double topSideBearing) {
        this.topSideBearing_ = new Double(topSideBearing);
    }

    public void setTopSideBearing(Double topSideBearing) {
        this.topSideBearing_ = topSideBearing;
    }

    public double getBottomSideBearing() {
        if (this.bottomSideBearing_ == null) {
            return Double.NaN;
        }
        return this.bottomSideBearing_;
    }

    public double getBottomSideBearing(double bottomSideBearing) {
        if (this.bottomSideBearing_ == null) {
            return bottomSideBearing;
        }
        return this.bottomSideBearing_;
    }

    public Double getBottomSideBearingAsDouble() {
        return this.bottomSideBearing_;
    }

    public boolean checkBottomSideBearing() {
        return this.bottomSideBearing_ != null;
    }

    public void setBottomSideBearing(double bottomSideBearing) {
        this.bottomSideBearing_ = new Double(bottomSideBearing);
    }

    public void setBottomSideBearing(Double bottomSideBearing) {
        this.bottomSideBearing_ = bottomSideBearing;
    }

    public double getLineGap() {
        if (this.lineGap_ == null) {
            return Double.NaN;
        }
        return this.lineGap_;
    }

    public double getLineGap(double lineGap) {
        if (this.lineGap_ == null) {
            return lineGap;
        }
        return this.lineGap_;
    }

    public Double getLineGapAsDouble() {
        return this.lineGap_;
    }

    public boolean checkLineGap() {
        return this.lineGap_ != null;
    }

    public void setLineGap(double lineGap) {
        this.lineGap_ = new Double(lineGap);
    }

    public void setLineGap(Double lineGap) {
        this.lineGap_ = lineGap;
    }

    public String getAuthor() {
        return this.author_;
    }

    public void setAuthor(String author) {
        this.author_ = author;
    }

    public String getCopyright() {
        return this.copyright_;
    }

    public void setCopyright(String copyright) {
        this.copyright_ = copyright;
    }

    public String getVersion() {
        return this.version_;
    }

    public void setVersion(String version) {
        this.version_ = version;
    }

    public String getFontFamily() {
        return this.fontFamily_;
    }

    public void setFontFamily(String fontFamily) {
        this.fontFamily_ = fontFamily;
    }

    public String getFontSubFamily() {
        return this.fontSubFamily_;
    }

    public void setFontSubFamily(String fontSubFamily) {
        this.fontSubFamily_ = fontSubFamily;
    }

    public String getLicense() {
        return this.license_;
    }

    public void setLicense(String license) {
        this.license_ = license;
    }

    public XHeadGlobal getHeadGlobal() {
        return this.headGlobal_;
    }

    public void setHeadGlobal(XHeadGlobal headGlobal) {
        this.headGlobal_ = headGlobal;
        if (headGlobal != null) {
            headGlobal.rSetParentRNode(this);
        }
    }

    public XHeadLocal getHeadLocal() {
        return this.headLocal_;
    }

    public void setHeadLocal(XHeadLocal headLocal) {
        this.headLocal_ = headLocal;
        if (headLocal != null) {
            headLocal.rSetParentRNode(this);
        }
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        int i;
        buffer.append("<head");
        buffer.append(">");
        buffer.append("<title>");
        buffer.append(URelaxer.escapeCharData(URelaxer.getString(this.getTitle())));
        buffer.append("</title>");
        buffer.append("<unicode>");
        buffer.append(URelaxer.escapeCharData(URelaxer.getString(this.getUnicode())));
        buffer.append("</unicode>");
        int size = this.sizeUnicodeRange();
        for (i = 0; i < size; ++i) {
            buffer.append("<unicodeRange>");
            buffer.append(URelaxer.escapeCharData(URelaxer.getString(this.getUnicodeRange(i))));
            buffer.append("</unicodeRange>");
        }
        size = this.sizeCodePage();
        for (i = 0; i < size; ++i) {
            buffer.append("<codePage>");
            buffer.append(URelaxer.escapeCharData(URelaxer.getString(this.getCodePage(i))));
            buffer.append("</codePage>");
        }
        if (this.ascender_ != null) {
            buffer.append("<ascender>");
            buffer.append(URelaxer.getString(this.getAscender()));
            buffer.append("</ascender>");
        }
        if (this.descender_ != null) {
            buffer.append("<descender>");
            buffer.append(URelaxer.getString(this.getDescender()));
            buffer.append("</descender>");
        }
        if (this.xHeight_ != null) {
            buffer.append("<xHeight>");
            buffer.append(URelaxer.getString(this.getXHeight()));
            buffer.append("</xHeight>");
        }
        if (this.advanceWidth_ != null) {
            buffer.append("<advanceWidth>");
            buffer.append(URelaxer.getString(this.getAdvanceWidth()));
            buffer.append("</advanceWidth>");
        }
        if (this.advanceHeight_ != null) {
            buffer.append("<advanceHeight>");
            buffer.append(URelaxer.getString(this.getAdvanceHeight()));
            buffer.append("</advanceHeight>");
        }
        if (this.leftSideBearing_ != null) {
            buffer.append("<leftSideBearing>");
            buffer.append(URelaxer.getString(this.getLeftSideBearing()));
            buffer.append("</leftSideBearing>");
        }
        if (this.topSideBearing_ != null) {
            buffer.append("<topSideBearing>");
            buffer.append(URelaxer.getString(this.getTopSideBearing()));
            buffer.append("</topSideBearing>");
        }
        if (this.bottomSideBearing_ != null) {
            buffer.append("<bottomSideBearing>");
            buffer.append(URelaxer.getString(this.getBottomSideBearing()));
            buffer.append("</bottomSideBearing>");
        }
        if (this.lineGap_ != null) {
            buffer.append("<lineGap>");
            buffer.append(URelaxer.getString(this.getLineGap()));
            buffer.append("</lineGap>");
        }
        buffer.append("<author>");
        buffer.append(URelaxer.escapeCharData(URelaxer.getString(this.getAuthor())));
        buffer.append("</author>");
        buffer.append("<copyright>");
        buffer.append(URelaxer.escapeCharData(URelaxer.getString(this.getCopyright())));
        buffer.append("</copyright>");
        if (this.version_ != null) {
            buffer.append("<version>");
            buffer.append(URelaxer.escapeCharData(URelaxer.getString(this.getVersion())));
            buffer.append("</version>");
        }
        buffer.append("<fontFamily>");
        buffer.append(URelaxer.escapeCharData(URelaxer.getString(this.getFontFamily())));
        buffer.append("</fontFamily>");
        buffer.append("<fontSubFamily>");
        buffer.append(URelaxer.escapeCharData(URelaxer.getString(this.getFontSubFamily())));
        buffer.append("</fontSubFamily>");
        buffer.append("<license>");
        buffer.append(URelaxer.escapeCharData(URelaxer.getString(this.getLicense())));
        buffer.append("</license>");
        this.headGlobal_.makeTextElement(buffer);
        this.headLocal_.makeTextElement(buffer);
        buffer.append("</head>");
    }

    public void makeTextElement(Writer buffer) throws IOException {
        int i;
        buffer.write("<head");
        buffer.write(">");
        buffer.write("<title>");
        buffer.write(URelaxer.escapeCharData(URelaxer.getString(this.getTitle())));
        buffer.write("</title>");
        buffer.write("<unicode>");
        buffer.write(URelaxer.escapeCharData(URelaxer.getString(this.getUnicode())));
        buffer.write("</unicode>");
        int size = this.sizeUnicodeRange();
        for (i = 0; i < size; ++i) {
            buffer.write("<unicodeRange>");
            buffer.write(URelaxer.escapeCharData(URelaxer.getString(this.getUnicodeRange(i))));
            buffer.write("</unicodeRange>");
        }
        size = this.sizeCodePage();
        for (i = 0; i < size; ++i) {
            buffer.write("<codePage>");
            buffer.write(URelaxer.escapeCharData(URelaxer.getString(this.getCodePage(i))));
            buffer.write("</codePage>");
        }
        if (this.ascender_ != null) {
            buffer.write("<ascender>");
            buffer.write(URelaxer.getString(this.getAscender()));
            buffer.write("</ascender>");
        }
        if (this.descender_ != null) {
            buffer.write("<descender>");
            buffer.write(URelaxer.getString(this.getDescender()));
            buffer.write("</descender>");
        }
        if (this.xHeight_ != null) {
            buffer.write("<xHeight>");
            buffer.write(URelaxer.getString(this.getXHeight()));
            buffer.write("</xHeight>");
        }
        if (this.advanceWidth_ != null) {
            buffer.write("<advanceWidth>");
            buffer.write(URelaxer.getString(this.getAdvanceWidth()));
            buffer.write("</advanceWidth>");
        }
        if (this.advanceHeight_ != null) {
            buffer.write("<advanceHeight>");
            buffer.write(URelaxer.getString(this.getAdvanceHeight()));
            buffer.write("</advanceHeight>");
        }
        if (this.leftSideBearing_ != null) {
            buffer.write("<leftSideBearing>");
            buffer.write(URelaxer.getString(this.getLeftSideBearing()));
            buffer.write("</leftSideBearing>");
        }
        if (this.topSideBearing_ != null) {
            buffer.write("<topSideBearing>");
            buffer.write(URelaxer.getString(this.getTopSideBearing()));
            buffer.write("</topSideBearing>");
        }
        if (this.bottomSideBearing_ != null) {
            buffer.write("<bottomSideBearing>");
            buffer.write(URelaxer.getString(this.getBottomSideBearing()));
            buffer.write("</bottomSideBearing>");
        }
        if (this.lineGap_ != null) {
            buffer.write("<lineGap>");
            buffer.write(URelaxer.getString(this.getLineGap()));
            buffer.write("</lineGap>");
        }
        buffer.write("<author>");
        buffer.write(URelaxer.escapeCharData(URelaxer.getString(this.getAuthor())));
        buffer.write("</author>");
        buffer.write("<copyright>");
        buffer.write(URelaxer.escapeCharData(URelaxer.getString(this.getCopyright())));
        buffer.write("</copyright>");
        if (this.version_ != null) {
            buffer.write("<version>");
            buffer.write(URelaxer.escapeCharData(URelaxer.getString(this.getVersion())));
            buffer.write("</version>");
        }
        buffer.write("<fontFamily>");
        buffer.write(URelaxer.escapeCharData(URelaxer.getString(this.getFontFamily())));
        buffer.write("</fontFamily>");
        buffer.write("<fontSubFamily>");
        buffer.write(URelaxer.escapeCharData(URelaxer.getString(this.getFontSubFamily())));
        buffer.write("</fontSubFamily>");
        buffer.write("<license>");
        buffer.write(URelaxer.escapeCharData(URelaxer.getString(this.getLicense())));
        buffer.write("</license>");
        this.headGlobal_.makeTextElement(buffer);
        this.headLocal_.makeTextElement(buffer);
        buffer.write("</head>");
    }

    public void makeTextElement(PrintWriter buffer) {
        int i;
        buffer.print("<head");
        buffer.print(">");
        buffer.print("<title>");
        buffer.print(URelaxer.escapeCharData(URelaxer.getString(this.getTitle())));
        buffer.print("</title>");
        buffer.print("<unicode>");
        buffer.print(URelaxer.escapeCharData(URelaxer.getString(this.getUnicode())));
        buffer.print("</unicode>");
        int size = this.sizeUnicodeRange();
        for (i = 0; i < size; ++i) {
            buffer.print("<unicodeRange>");
            buffer.print(URelaxer.escapeCharData(URelaxer.getString(this.getUnicodeRange(i))));
            buffer.print("</unicodeRange>");
        }
        size = this.sizeCodePage();
        for (i = 0; i < size; ++i) {
            buffer.print("<codePage>");
            buffer.print(URelaxer.escapeCharData(URelaxer.getString(this.getCodePage(i))));
            buffer.print("</codePage>");
        }
        if (this.ascender_ != null) {
            buffer.print("<ascender>");
            buffer.print(URelaxer.getString(this.getAscender()));
            buffer.print("</ascender>");
        }
        if (this.descender_ != null) {
            buffer.print("<descender>");
            buffer.print(URelaxer.getString(this.getDescender()));
            buffer.print("</descender>");
        }
        if (this.xHeight_ != null) {
            buffer.print("<xHeight>");
            buffer.print(URelaxer.getString(this.getXHeight()));
            buffer.print("</xHeight>");
        }
        if (this.advanceWidth_ != null) {
            buffer.print("<advanceWidth>");
            buffer.print(URelaxer.getString(this.getAdvanceWidth()));
            buffer.print("</advanceWidth>");
        }
        if (this.advanceHeight_ != null) {
            buffer.print("<advanceHeight>");
            buffer.print(URelaxer.getString(this.getAdvanceHeight()));
            buffer.print("</advanceHeight>");
        }
        if (this.leftSideBearing_ != null) {
            buffer.print("<leftSideBearing>");
            buffer.print(URelaxer.getString(this.getLeftSideBearing()));
            buffer.print("</leftSideBearing>");
        }
        if (this.topSideBearing_ != null) {
            buffer.print("<topSideBearing>");
            buffer.print(URelaxer.getString(this.getTopSideBearing()));
            buffer.print("</topSideBearing>");
        }
        if (this.bottomSideBearing_ != null) {
            buffer.print("<bottomSideBearing>");
            buffer.print(URelaxer.getString(this.getBottomSideBearing()));
            buffer.print("</bottomSideBearing>");
        }
        if (this.lineGap_ != null) {
            buffer.print("<lineGap>");
            buffer.print(URelaxer.getString(this.getLineGap()));
            buffer.print("</lineGap>");
        }
        buffer.print("<author>");
        buffer.print(URelaxer.escapeCharData(URelaxer.getString(this.getAuthor())));
        buffer.print("</author>");
        buffer.print("<copyright>");
        buffer.print(URelaxer.escapeCharData(URelaxer.getString(this.getCopyright())));
        buffer.print("</copyright>");
        if (this.version_ != null) {
            buffer.print("<version>");
            buffer.print(URelaxer.escapeCharData(URelaxer.getString(this.getVersion())));
            buffer.print("</version>");
        }
        buffer.print("<fontFamily>");
        buffer.print(URelaxer.escapeCharData(URelaxer.getString(this.getFontFamily())));
        buffer.print("</fontFamily>");
        buffer.print("<fontSubFamily>");
        buffer.print(URelaxer.escapeCharData(URelaxer.getString(this.getFontSubFamily())));
        buffer.print("</fontSubFamily>");
        buffer.print("<license>");
        buffer.print(URelaxer.escapeCharData(URelaxer.getString(this.getLicense())));
        buffer.print("</license>");
        this.headGlobal_.makeTextElement(buffer);
        this.headLocal_.makeTextElement(buffer);
        buffer.print("</head>");
    }

    public void makeTextAttribute(StringBuffer buffer) {
    }

    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    public void makeTextAttribute(PrintWriter buffer) {
    }

    public String getTitleAsString() {
        return URelaxer.getString(this.getTitle());
    }

    public String getUnicodeAsString() {
        return URelaxer.getString(this.getUnicode());
    }

    public String[] getUnicodeRangeAsString() {
        int size = this.sizeUnicodeRange();
        String[] array = new String[size];
        for (int i = 0; i < size; ++i) {
            array[i] = URelaxer.getString(this.getUnicodeRange(i));
        }
        return array;
    }

    public String getUnicodeRangeAsString(int index) {
        return URelaxer.getString(this.getUnicodeRange(index));
    }

    public String[] getCodePageAsString() {
        int size = this.sizeCodePage();
        String[] array = new String[size];
        for (int i = 0; i < size; ++i) {
            array[i] = URelaxer.getString(this.getCodePage(i));
        }
        return array;
    }

    public String getCodePageAsString(int index) {
        return URelaxer.getString(this.getCodePage(index));
    }

    public String getAscenderAsString() {
        return URelaxer.getString(this.getAscender());
    }

    public String getDescenderAsString() {
        return URelaxer.getString(this.getDescender());
    }

    public String getXHeightAsString() {
        return URelaxer.getString(this.getXHeight());
    }

    public String getAdvanceWidthAsString() {
        return URelaxer.getString(this.getAdvanceWidth());
    }

    public String getAdvanceHeightAsString() {
        return URelaxer.getString(this.getAdvanceHeight());
    }

    public String getLeftSideBearingAsString() {
        return URelaxer.getString(this.getLeftSideBearing());
    }

    public String getTopSideBearingAsString() {
        return URelaxer.getString(this.getTopSideBearing());
    }

    public String getBottomSideBearingAsString() {
        return URelaxer.getString(this.getBottomSideBearing());
    }

    public String getLineGapAsString() {
        return URelaxer.getString(this.getLineGap());
    }

    public String getAuthorAsString() {
        return URelaxer.getString(this.getAuthor());
    }

    public String getCopyrightAsString() {
        return URelaxer.getString(this.getCopyright());
    }

    public String getVersionAsString() {
        return URelaxer.getString(this.getVersion());
    }

    public String getFontFamilyAsString() {
        return URelaxer.getString(this.getFontFamily());
    }

    public String getFontSubFamilyAsString() {
        return URelaxer.getString(this.getFontSubFamily());
    }

    public String getLicenseAsString() {
        return URelaxer.getString(this.getLicense());
    }

    public void setTitleByString(String string) {
        this.setTitle(string);
    }

    public void setUnicodeByString(String string) {
        this.setUnicode(string);
    }

    public void setUnicodeRangeByString(String[] strings) {
        if (strings.length > 0) {
            String string = strings[0];
            this.setUnicodeRange(string);
            for (int i = 1; i < strings.length; ++i) {
                string = strings[i];
                this.addUnicodeRange(string);
            }
        }
    }

    public void setUnicodeRangeByString(int index, String value) {
        this.setUnicodeRange(index, value);
    }

    public void setCodePageByString(String[] strings) {
        if (strings.length > 0) {
            String string = strings[0];
            this.setCodePage(string);
            for (int i = 1; i < strings.length; ++i) {
                string = strings[i];
                this.addCodePage(string);
            }
        }
    }

    public void setCodePageByString(int index, String value) {
        this.setCodePage(index, value);
    }

    public void setAscenderByString(String string) {
        this.setAscender(Double.parseDouble(string));
    }

    public void setDescenderByString(String string) {
        this.setDescender(Double.parseDouble(string));
    }

    public void setXHeightByString(String string) {
        this.setXHeight(Double.parseDouble(string));
    }

    public void setAdvanceWidthByString(String string) {
        this.setAdvanceWidth(Double.parseDouble(string));
    }

    public void setAdvanceHeightByString(String string) {
        this.setAdvanceHeight(Double.parseDouble(string));
    }

    public void setLeftSideBearingByString(String string) {
        this.setLeftSideBearing(Double.parseDouble(string));
    }

    public void setTopSideBearingByString(String string) {
        this.setTopSideBearing(Double.parseDouble(string));
    }

    public void setBottomSideBearingByString(String string) {
        this.setBottomSideBearing(Double.parseDouble(string));
    }

    public void setLineGapByString(String string) {
        this.setLineGap(Double.parseDouble(string));
    }

    public void setAuthorByString(String string) {
        this.setAuthor(string);
    }

    public void setCopyrightByString(String string) {
        this.setCopyright(string);
    }

    public void setVersionByString(String string) {
        this.setVersion(string);
    }

    public void setFontFamilyByString(String string) {
        this.setFontFamily(string);
    }

    public void setFontSubFamilyByString(String string) {
        this.setFontSubFamily(string);
    }

    public void setLicenseByString(String string) {
        this.setLicense(string);
    }

    public void addUnicodeRangeByString(String string) {
        this.addUnicodeRange(string);
    }

    public void addCodePageByString(String string) {
        this.addCodePage(string);
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    @Override
    public IRNode rGetParentRNode() {
        return this.parentRNode_;
    }

    @Override
    public void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    @Override
    public IRNode[] rGetRNodes() {
        ArrayList<IRNode> classNodes = new ArrayList<IRNode>();
        if (this.headGlobal_ != null) {
            classNodes.add(this.headGlobal_);
        }
        if (this.headLocal_ != null) {
            classNodes.add(this.headLocal_);
        }
        IRNode[] nodes = new IRNode[classNodes.size()];
        return classNodes.toArray(nodes);
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "head")) {
            return false;
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        IGlyphFactory factory = GlyphFactory.getFactory();
        Element child = target.popElement();
        if (child == null) {
            return false;
        }
        if (!URelaxer.isTargetElement(child, "title")) {
            return false;
        }
        $match$ = true;
        child = target.popElement();
        if (child == null) {
            return false;
        }
        if (!URelaxer.isTargetElement(child, "unicode")) {
            return false;
        }
        $match$ = true;
        while ((child = target.peekElement()) != null && URelaxer.isTargetElement(child, "unicodeRange")) {
            target.popElement();
            $match$ = true;
        }
        while ((child = target.peekElement()) != null && URelaxer.isTargetElement(child, "codePage")) {
            target.popElement();
            $match$ = true;
        }
        child = target.peekElement();
        if (child != null && URelaxer.isTargetElement(child, "ascender")) {
            target.popElement();
        }
        $match$ = true;
        child = target.peekElement();
        if (child != null && URelaxer.isTargetElement(child, "descender")) {
            target.popElement();
        }
        $match$ = true;
        child = target.peekElement();
        if (child != null && URelaxer.isTargetElement(child, "xHeight")) {
            target.popElement();
        }
        $match$ = true;
        child = target.peekElement();
        if (child != null && URelaxer.isTargetElement(child, "advanceWidth")) {
            target.popElement();
        }
        $match$ = true;
        child = target.peekElement();
        if (child != null && URelaxer.isTargetElement(child, "advanceHeight")) {
            target.popElement();
        }
        $match$ = true;
        child = target.peekElement();
        if (child != null && URelaxer.isTargetElement(child, "leftSideBearing")) {
            target.popElement();
        }
        $match$ = true;
        child = target.peekElement();
        if (child != null && URelaxer.isTargetElement(child, "topSideBearing")) {
            target.popElement();
        }
        $match$ = true;
        child = target.peekElement();
        if (child != null && URelaxer.isTargetElement(child, "bottomSideBearing")) {
            target.popElement();
        }
        $match$ = true;
        child = target.peekElement();
        if (child != null && URelaxer.isTargetElement(child, "lineGap")) {
            target.popElement();
        }
        $match$ = true;
        child = target.popElement();
        if (child == null) {
            return false;
        }
        if (!URelaxer.isTargetElement(child, "author")) {
            return false;
        }
        $match$ = true;
        child = target.popElement();
        if (child == null) {
            return false;
        }
        if (!URelaxer.isTargetElement(child, "copyright")) {
            return false;
        }
        $match$ = true;
        child = target.peekElement();
        if (child != null && URelaxer.isTargetElement(child, "version")) {
            target.popElement();
        }
        $match$ = true;
        child = target.popElement();
        if (child == null) {
            return false;
        }
        if (!URelaxer.isTargetElement(child, "fontFamily")) {
            return false;
        }
        $match$ = true;
        child = target.popElement();
        if (child == null) {
            return false;
        }
        if (!URelaxer.isTargetElement(child, "fontSubFamily")) {
            return false;
        }
        $match$ = true;
        child = target.popElement();
        if (child == null) {
            return false;
        }
        if (!URelaxer.isTargetElement(child, "license")) {
            return false;
        }
        $match$ = true;
        if (!XHeadGlobal.isMatchHungry(target)) {
            return false;
        }
        $match$ = true;
        if (!XHeadLocal.isMatchHungry(target)) {
            return false;
        }
        $match$ = true;
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return XHead.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (XHead.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

