/*
 * Decompiled with CFR 0.152.
 */
package org.doubletype.ossa.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import org.doubletype.ossa.xml.GlyphFactory;
import org.doubletype.ossa.xml.IGlyphFactory;
import org.doubletype.ossa.xml.IRNode;
import org.doubletype.ossa.xml.RStack;
import org.doubletype.ossa.xml.UJAXP;
import org.doubletype.ossa.xml.URelaxer;
import org.doubletype.ossa.xml.XContourPoint;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XControlPoint
implements Serializable,
Cloneable,
IRNode {
    private boolean first_;
    private boolean smooth_;
    private XContourPoint contourPoint_;
    private IRNode parentRNode_;

    public XControlPoint() {
    }

    public XControlPoint(XControlPoint source) {
        this.setup(source);
    }

    public XControlPoint(RStack stack) {
        this.setup(stack);
    }

    public XControlPoint(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public XControlPoint(Element element) {
        this.setup(element);
    }

    public XControlPoint(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public XControlPoint(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public XControlPoint(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public XControlPoint(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public XControlPoint(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public XControlPoint(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(XControlPoint source) {
        this.first_ = source.first_;
        this.smooth_ = source.smooth_;
        if (source.contourPoint_ != null) {
            this.setContourPoint((XContourPoint)source.getContourPoint().clone());
        }
    }

    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        IGlyphFactory factory = GlyphFactory.getFactory();
        RStack stack = new RStack(element);
        this.first_ = URelaxer.getAttributePropertyAsBoolean(element, "first");
        this.smooth_ = URelaxer.getAttributePropertyAsBoolean(element, "smooth");
        this.setContourPoint(factory.createXContourPoint(stack));
    }

    public Object clone() {
        IGlyphFactory factory = GlyphFactory.getFactory();
        return factory.createXControlPoint(this);
    }

    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("controlPoint");
        URelaxer.setAttributePropertyByBoolean(element, "first", this.first_);
        URelaxer.setAttributePropertyByBoolean(element, "smooth", this.smooth_);
        this.contourPoint_.makeElement(element);
        parent.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURI().toURL());
    }

    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public boolean getFirst() {
        return this.first_;
    }

    public void setFirst(boolean first) {
        this.first_ = first;
    }

    public boolean getSmooth() {
        return this.smooth_;
    }

    public void setSmooth(boolean smooth) {
        this.smooth_ = smooth;
    }

    public XContourPoint getContourPoint() {
        return this.contourPoint_;
    }

    public void setContourPoint(XContourPoint contourPoint) {
        this.contourPoint_ = contourPoint;
        if (contourPoint != null) {
            contourPoint.rSetParentRNode(this);
        }
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<controlPoint");
        buffer.append(" first=\"");
        buffer.append(URelaxer.getString(this.getFirst()));
        buffer.append("\"");
        buffer.append(" smooth=\"");
        buffer.append(URelaxer.getString(this.getSmooth()));
        buffer.append("\"");
        buffer.append(">");
        this.contourPoint_.makeTextElement(buffer);
        buffer.append("</controlPoint>");
    }

    public void makeTextElement(Writer buffer) throws IOException {
        buffer.write("<controlPoint");
        buffer.write(" first=\"");
        buffer.write(URelaxer.getString(this.getFirst()));
        buffer.write("\"");
        buffer.write(" smooth=\"");
        buffer.write(URelaxer.getString(this.getSmooth()));
        buffer.write("\"");
        buffer.write(">");
        this.contourPoint_.makeTextElement(buffer);
        buffer.write("</controlPoint>");
    }

    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<controlPoint");
        buffer.print(" first=\"");
        buffer.print(URelaxer.getString(this.getFirst()));
        buffer.print("\"");
        buffer.print(" smooth=\"");
        buffer.print(URelaxer.getString(this.getSmooth()));
        buffer.print("\"");
        buffer.print(">");
        this.contourPoint_.makeTextElement(buffer);
        buffer.print("</controlPoint>");
    }

    public void makeTextAttribute(StringBuffer buffer) {
    }

    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    public void makeTextAttribute(PrintWriter buffer) {
    }

    public String getFirstAsString() {
        return URelaxer.getString(this.getFirst());
    }

    public String getSmoothAsString() {
        return URelaxer.getString(this.getSmooth());
    }

    public void setFirstByString(String string) {
        this.setFirst(new Boolean(string));
    }

    public void setSmoothByString(String string) {
        this.setSmooth(new Boolean(string));
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    @Override
    public IRNode rGetParentRNode() {
        return this.parentRNode_;
    }

    @Override
    public void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    @Override
    public IRNode[] rGetRNodes() {
        ArrayList<XContourPoint> classNodes = new ArrayList<XContourPoint>();
        if (this.contourPoint_ != null) {
            classNodes.add(this.contourPoint_);
        }
        IRNode[] nodes = new IRNode[classNodes.size()];
        return classNodes.toArray(nodes);
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "controlPoint")) {
            return false;
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        IGlyphFactory factory = GlyphFactory.getFactory();
        if (!URelaxer.hasAttributeHungry(target, "first")) {
            return false;
        }
        $match$ = true;
        if (!URelaxer.hasAttributeHungry(target, "smooth")) {
            return false;
        }
        $match$ = true;
        if (!XContourPoint.isMatchHungry(target)) {
            return false;
        }
        $match$ = true;
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return XControlPoint.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (XControlPoint.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

