/*
 * Decompiled with CFR 0.152.
 */
package org.doubletype.ossa.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.doubletype.ossa.xml.GlyphFactory;
import org.doubletype.ossa.xml.IGlyphFactory;
import org.doubletype.ossa.xml.IRNode;
import org.doubletype.ossa.xml.RStack;
import org.doubletype.ossa.xml.UJAXP;
import org.doubletype.ossa.xml.URelaxer;
import org.doubletype.ossa.xml.XControlPoint;
import org.doubletype.ossa.xml.XHint;
import org.doubletype.ossa.xml.XPoint2d;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XContourPoint
implements Serializable,
Cloneable,
IRNode {
    public static final String TYPE_ON = "on";
    public static final String TYPE_OFF = "off";
    private String type_;
    private Boolean rounded_;
    private XPoint2d point2d_;
    private XControlPoint controlPoint1_;
    private XControlPoint controlPoint2_;
    private List<XHint> hint_ = new ArrayList<XHint>();
    private IRNode parentRNode_;

    public XContourPoint() {
        this.type_ = "";
    }

    public XContourPoint(XContourPoint source) {
        this.setup(source);
    }

    public XContourPoint(RStack stack) {
        this.setup(stack);
    }

    public XContourPoint(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public XContourPoint(Element element) {
        this.setup(element);
    }

    public XContourPoint(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public XContourPoint(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public XContourPoint(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public XContourPoint(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public XContourPoint(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public XContourPoint(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(XContourPoint source) {
        this.type_ = source.type_;
        this.rounded_ = source.rounded_;
        if (source.point2d_ != null) {
            this.setPoint2d((XPoint2d)source.getPoint2d().clone());
        }
        if (source.controlPoint1_ != null) {
            this.setControlPoint1((XControlPoint)source.getControlPoint1().clone());
        }
        if (source.controlPoint2_ != null) {
            this.setControlPoint2((XControlPoint)source.getControlPoint2().clone());
        }
        this.hint_.clear();
        int size = source.hint_.size();
        for (int i = 0; i < size; ++i) {
            this.addHint((XHint)source.getHint(i).clone());
        }
    }

    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        IGlyphFactory factory = GlyphFactory.getFactory();
        RStack stack = new RStack(element);
        this.type_ = URelaxer.getAttributePropertyAsString(element, "type");
        this.rounded_ = URelaxer.getAttributePropertyAsBooleanObject(element, "rounded");
        this.setPoint2d(factory.createXPoint2d(stack));
        if (XControlPoint.isMatch(stack)) {
            this.setControlPoint1(factory.createXControlPoint(stack));
        }
        if (XControlPoint.isMatch(stack)) {
            this.setControlPoint2(factory.createXControlPoint(stack));
        }
        this.hint_.clear();
        while (XHint.isMatch(stack)) {
            this.addHint(factory.createXHint(stack));
        }
    }

    public Object clone() {
        IGlyphFactory factory = GlyphFactory.getFactory();
        return factory.createXContourPoint(this);
    }

    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("contourPoint");
        if (this.type_ != null) {
            URelaxer.setAttributePropertyByString(element, "type", this.type_);
        }
        if (this.rounded_ != null) {
            URelaxer.setAttributePropertyByBoolean(element, "rounded", this.rounded_);
        }
        this.point2d_.makeElement(element);
        if (this.controlPoint1_ != null) {
            this.controlPoint1_.makeElement(element);
        }
        if (this.controlPoint2_ != null) {
            this.controlPoint2_.makeElement(element);
        }
        int size = this.hint_.size();
        for (int i = 0; i < size; ++i) {
            XHint value = this.hint_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURI().toURL());
    }

    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public String getType() {
        return this.type_;
    }

    public void setType(String type) {
        this.type_ = type;
    }

    public boolean getRounded() {
        if (this.rounded_ == null) {
            return false;
        }
        return this.rounded_;
    }

    public boolean getRounded(boolean rounded) {
        if (this.rounded_ == null) {
            return rounded;
        }
        return this.rounded_;
    }

    public Boolean getRoundedAsBoolean() {
        return this.rounded_;
    }

    public boolean checkRounded() {
        return this.rounded_ != null;
    }

    public void setRounded(boolean rounded) {
        this.rounded_ = new Boolean(rounded);
    }

    public void setRounded(Boolean rounded) {
        this.rounded_ = rounded;
    }

    public XPoint2d getPoint2d() {
        return this.point2d_;
    }

    public void setPoint2d(XPoint2d point2d) {
        this.point2d_ = point2d;
        if (point2d != null) {
            point2d.rSetParentRNode(this);
        }
    }

    public XControlPoint getControlPoint1() {
        return this.controlPoint1_;
    }

    public void setControlPoint1(XControlPoint controlPoint1) {
        this.controlPoint1_ = controlPoint1;
        if (controlPoint1 != null) {
            controlPoint1.rSetParentRNode(this);
        }
    }

    public XControlPoint getControlPoint2() {
        return this.controlPoint2_;
    }

    public void setControlPoint2(XControlPoint controlPoint2) {
        this.controlPoint2_ = controlPoint2;
        if (controlPoint2 != null) {
            controlPoint2.rSetParentRNode(this);
        }
    }

    public XHint[] getHint() {
        XHint[] array = new XHint[this.hint_.size()];
        return this.hint_.toArray(array);
    }

    public void setHint(XHint[] hint) {
        int i;
        this.hint_.clear();
        for (i = 0; i < hint.length; ++i) {
            this.addHint(hint[i]);
        }
        for (i = 0; i < hint.length; ++i) {
            hint[i].rSetParentRNode(this);
        }
    }

    public void setHint(XHint hint) {
        this.hint_.clear();
        this.addHint(hint);
        if (hint != null) {
            hint.rSetParentRNode(this);
        }
    }

    public void addHint(XHint hint) {
        this.hint_.add(hint);
        if (hint != null) {
            hint.rSetParentRNode(this);
        }
    }

    public void addHint(XHint[] hint) {
        int i;
        for (i = 0; i < hint.length; ++i) {
            this.addHint(hint[i]);
        }
        for (i = 0; i < hint.length; ++i) {
            hint[i].rSetParentRNode(this);
        }
    }

    public int sizeHint() {
        return this.hint_.size();
    }

    public XHint getHint(int index) {
        return this.hint_.get(index);
    }

    public void setHint(int index, XHint hint) {
        this.hint_.set(index, hint);
        if (hint != null) {
            hint.rSetParentRNode(this);
        }
    }

    public void addHint(int index, XHint hint) {
        this.hint_.add(index, hint);
        if (hint != null) {
            hint.rSetParentRNode(this);
        }
    }

    public void removeHint(int index) {
        this.hint_.remove(index);
    }

    public void removeHint(XHint hint) {
        this.hint_.remove(hint);
    }

    public void clearHint() {
        this.hint_.clear();
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<contourPoint");
        if (this.type_ != null) {
            buffer.append(" type=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getType())));
            buffer.append("\"");
        }
        if (this.rounded_ != null) {
            buffer.append(" rounded=\"");
            buffer.append(URelaxer.getString(this.getRounded()));
            buffer.append("\"");
        }
        buffer.append(">");
        this.point2d_.makeTextElement(buffer);
        if (this.controlPoint1_ != null) {
            this.controlPoint1_.makeTextElement(buffer);
        }
        if (this.controlPoint2_ != null) {
            this.controlPoint2_.makeTextElement(buffer);
        }
        int size = this.hint_.size();
        for (int i = 0; i < size; ++i) {
            XHint value = this.hint_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</contourPoint>");
    }

    public void makeTextElement(Writer buffer) throws IOException {
        buffer.write("<contourPoint");
        if (this.type_ != null) {
            buffer.write(" type=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getType())));
            buffer.write("\"");
        }
        if (this.rounded_ != null) {
            buffer.write(" rounded=\"");
            buffer.write(URelaxer.getString(this.getRounded()));
            buffer.write("\"");
        }
        buffer.write(">");
        this.point2d_.makeTextElement(buffer);
        if (this.controlPoint1_ != null) {
            this.controlPoint1_.makeTextElement(buffer);
        }
        if (this.controlPoint2_ != null) {
            this.controlPoint2_.makeTextElement(buffer);
        }
        int size = this.hint_.size();
        for (int i = 0; i < size; ++i) {
            XHint value = this.hint_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.write("</contourPoint>");
    }

    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<contourPoint");
        if (this.type_ != null) {
            buffer.print(" type=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getType())));
            buffer.print("\"");
        }
        if (this.rounded_ != null) {
            buffer.print(" rounded=\"");
            buffer.print(URelaxer.getString(this.getRounded()));
            buffer.print("\"");
        }
        buffer.print(">");
        this.point2d_.makeTextElement(buffer);
        if (this.controlPoint1_ != null) {
            this.controlPoint1_.makeTextElement(buffer);
        }
        if (this.controlPoint2_ != null) {
            this.controlPoint2_.makeTextElement(buffer);
        }
        int size = this.hint_.size();
        for (int i = 0; i < size; ++i) {
            XHint value = this.hint_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</contourPoint>");
    }

    public void makeTextAttribute(StringBuffer buffer) {
    }

    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    public void makeTextAttribute(PrintWriter buffer) {
    }

    public String getTypeAsString() {
        return URelaxer.getString(this.getType());
    }

    public String getRoundedAsString() {
        return URelaxer.getString(this.getRounded());
    }

    public void setTypeByString(String string) {
        this.setType(string);
    }

    public void setRoundedByString(String string) {
        this.setRounded((boolean)new Boolean(string));
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    @Override
    public IRNode rGetParentRNode() {
        return this.parentRNode_;
    }

    @Override
    public void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    @Override
    public IRNode[] rGetRNodes() {
        ArrayList<IRNode> classNodes = new ArrayList<IRNode>();
        if (this.point2d_ != null) {
            classNodes.add(this.point2d_);
        }
        if (this.controlPoint1_ != null) {
            classNodes.add(this.controlPoint1_);
        }
        if (this.controlPoint2_ != null) {
            classNodes.add(this.controlPoint2_);
        }
        classNodes.addAll(this.hint_);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return classNodes.toArray(nodes);
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "contourPoint")) {
            return false;
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        IGlyphFactory factory = GlyphFactory.getFactory();
        if (!URelaxer.hasAttributeHungry(target, "type")) {
            return false;
        }
        $match$ = true;
        if (!URelaxer.isMatchDataValuesAttr(element, "type", "token", TYPE_ON, TYPE_OFF)) {
            return false;
        }
        if (!XPoint2d.isMatchHungry(target)) {
            return false;
        }
        $match$ = true;
        if (XControlPoint.isMatchHungry(target)) {
            // empty if block
        }
        if (XControlPoint.isMatchHungry(target)) {
            // empty if block
        }
        while (XHint.isMatchHungry(target)) {
            $match$ = true;
        }
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return XContourPoint.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (XContourPoint.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

