/*
 * Decompiled with CFR 0.152.
 */
package org.doubletype.ossa.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.doubletype.ossa.xml.GlyphFactory;
import org.doubletype.ossa.xml.IGlyphFactory;
import org.doubletype.ossa.xml.IRNode;
import org.doubletype.ossa.xml.RInterleave;
import org.doubletype.ossa.xml.RStack;
import org.doubletype.ossa.xml.UJAXP;
import org.doubletype.ossa.xml.URelaxer;
import org.doubletype.ossa.xml.XContour;
import org.doubletype.ossa.xml.XGlyphFile;
import org.doubletype.ossa.xml.XInclude;
import org.doubletype.ossa.xml.XModule;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XBody
implements Serializable,
Cloneable,
IRNode {
    private List<IRNode> glyphFile_ = new ArrayList<IRNode>();
    private List<IRNode> contour_ = new ArrayList<IRNode>();
    private List<IRNode> include_ = new ArrayList<IRNode>();
    private List<IRNode> module_ = new ArrayList<IRNode>();
    private IRNode parentRNode_;

    public XBody() {
    }

    public XBody(XBody source) {
        this.setup(source);
    }

    public XBody(RStack stack) {
        this.setup(stack);
    }

    public XBody(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public XBody(Element element) {
        this.setup(element);
    }

    public XBody(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public XBody(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public XBody(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public XBody(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public XBody(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public XBody(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(XBody source) {
        int i;
        this.glyphFile_.clear();
        int size = source.glyphFile_.size();
        for (i = 0; i < size; ++i) {
            this.addGlyphFile((XGlyphFile)source.getGlyphFile(i).clone());
        }
        this.contour_.clear();
        size = source.contour_.size();
        for (i = 0; i < size; ++i) {
            this.addContour((XContour)source.getContour(i).clone());
        }
        this.include_.clear();
        size = source.include_.size();
        for (i = 0; i < size; ++i) {
            this.addInclude((XInclude)source.getInclude(i).clone());
        }
        this.module_.clear();
        size = source.module_.size();
        for (i = 0; i < size; ++i) {
            this.addModule((XModule)source.getModule(i).clone());
        }
    }

    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        IGlyphFactory factory = GlyphFactory.getFactory();
        RStack stack = new RStack(element);
        RInterleave interleave = new RInterleave(stack);
        interleave.addElementSlot(factory.getXGlyphFileClass(), "*");
        interleave.addElementSlot(factory.getXContourClass(), "*");
        interleave.addElementSlot(factory.getXIncludeClass(), "*");
        interleave.addElementSlot(factory.getXModuleClass(), "*");
        if (interleave.isMatch()) {
            this.setGlyphFile((XGlyphFile[])interleave.getPropertyList(factory.getXGlyphFileClass()));
            this.setContour((XContour[])interleave.getPropertyList(factory.getXContourClass()));
            this.setInclude((XInclude[])interleave.getPropertyList(factory.getXIncludeClass()));
            this.setModule((XModule[])interleave.getPropertyList(factory.getXModuleClass()));
        }
    }

    public Object clone() {
        IGlyphFactory factory = GlyphFactory.getFactory();
        return factory.createXBody(this);
    }

    public void makeElement(Node parent) {
        IRNode value;
        int i;
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("body");
        int size = this.glyphFile_.size();
        for (i = 0; i < size; ++i) {
            value = (XGlyphFile)this.glyphFile_.get(i);
            ((XGlyphFile)value).makeElement(element);
        }
        size = this.contour_.size();
        for (i = 0; i < size; ++i) {
            value = (XContour)this.contour_.get(i);
            ((XContour)value).makeElement(element);
        }
        size = this.include_.size();
        for (i = 0; i < size; ++i) {
            value = (XInclude)this.include_.get(i);
            ((XInclude)value).makeElement(element);
        }
        size = this.module_.size();
        for (i = 0; i < size; ++i) {
            value = (XModule)this.module_.get(i);
            ((XModule)value).makeElement(element);
        }
        parent.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURI().toURL());
    }

    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public XGlyphFile[] getGlyphFile() {
        XGlyphFile[] array = new XGlyphFile[this.glyphFile_.size()];
        return this.glyphFile_.toArray(array);
    }

    public void setGlyphFile(XGlyphFile[] glyphFile) {
        int i;
        this.glyphFile_.clear();
        for (i = 0; i < glyphFile.length; ++i) {
            this.addGlyphFile(glyphFile[i]);
        }
        for (i = 0; i < glyphFile.length; ++i) {
            glyphFile[i].rSetParentRNode(this);
        }
    }

    public void setGlyphFile(XGlyphFile glyphFile) {
        this.glyphFile_.clear();
        this.addGlyphFile(glyphFile);
        if (glyphFile != null) {
            glyphFile.rSetParentRNode(this);
        }
    }

    public void addGlyphFile(XGlyphFile glyphFile) {
        this.glyphFile_.add(glyphFile);
        if (glyphFile != null) {
            glyphFile.rSetParentRNode(this);
        }
    }

    public void addGlyphFile(XGlyphFile[] glyphFile) {
        int i;
        for (i = 0; i < glyphFile.length; ++i) {
            this.addGlyphFile(glyphFile[i]);
        }
        for (i = 0; i < glyphFile.length; ++i) {
            glyphFile[i].rSetParentRNode(this);
        }
    }

    public int sizeGlyphFile() {
        return this.glyphFile_.size();
    }

    public XGlyphFile getGlyphFile(int index) {
        return (XGlyphFile)this.glyphFile_.get(index);
    }

    public void setGlyphFile(int index, XGlyphFile glyphFile) {
        this.glyphFile_.set(index, glyphFile);
        if (glyphFile != null) {
            glyphFile.rSetParentRNode(this);
        }
    }

    public void addGlyphFile(int index, XGlyphFile glyphFile) {
        this.glyphFile_.add(index, glyphFile);
        if (glyphFile != null) {
            glyphFile.rSetParentRNode(this);
        }
    }

    public void removeGlyphFile(int index) {
        this.glyphFile_.remove(index);
    }

    public void removeGlyphFile(XGlyphFile glyphFile) {
        this.glyphFile_.remove(glyphFile);
    }

    public void clearGlyphFile() {
        this.glyphFile_.clear();
    }

    public XContour[] getContour() {
        XContour[] array = new XContour[this.contour_.size()];
        return this.contour_.toArray(array);
    }

    public void setContour(XContour[] contour) {
        int i;
        this.contour_.clear();
        for (i = 0; i < contour.length; ++i) {
            this.addContour(contour[i]);
        }
        for (i = 0; i < contour.length; ++i) {
            contour[i].rSetParentRNode(this);
        }
    }

    public void setContour(XContour contour) {
        this.contour_.clear();
        this.addContour(contour);
        if (contour != null) {
            contour.rSetParentRNode(this);
        }
    }

    public void addContour(XContour contour) {
        this.contour_.add(contour);
        if (contour != null) {
            contour.rSetParentRNode(this);
        }
    }

    public void addContour(XContour[] contour) {
        int i;
        for (i = 0; i < contour.length; ++i) {
            this.addContour(contour[i]);
        }
        for (i = 0; i < contour.length; ++i) {
            contour[i].rSetParentRNode(this);
        }
    }

    public int sizeContour() {
        return this.contour_.size();
    }

    public XContour getContour(int index) {
        return (XContour)this.contour_.get(index);
    }

    public void setContour(int index, XContour contour) {
        this.contour_.set(index, contour);
        if (contour != null) {
            contour.rSetParentRNode(this);
        }
    }

    public void addContour(int index, XContour contour) {
        this.contour_.add(index, contour);
        if (contour != null) {
            contour.rSetParentRNode(this);
        }
    }

    public void removeContour(int index) {
        this.contour_.remove(index);
    }

    public void removeContour(XContour contour) {
        this.contour_.remove(contour);
    }

    public void clearContour() {
        this.contour_.clear();
    }

    public XInclude[] getInclude() {
        XInclude[] array = new XInclude[this.include_.size()];
        return this.include_.toArray(array);
    }

    public void setInclude(XInclude[] include) {
        int i;
        this.include_.clear();
        for (i = 0; i < include.length; ++i) {
            this.addInclude(include[i]);
        }
        for (i = 0; i < include.length; ++i) {
            include[i].rSetParentRNode(this);
        }
    }

    public void setInclude(XInclude include) {
        this.include_.clear();
        this.addInclude(include);
        if (include != null) {
            include.rSetParentRNode(this);
        }
    }

    public void addInclude(XInclude include) {
        this.include_.add(include);
        if (include != null) {
            include.rSetParentRNode(this);
        }
    }

    public void addInclude(XInclude[] include) {
        int i;
        for (i = 0; i < include.length; ++i) {
            this.addInclude(include[i]);
        }
        for (i = 0; i < include.length; ++i) {
            include[i].rSetParentRNode(this);
        }
    }

    public int sizeInclude() {
        return this.include_.size();
    }

    public XInclude getInclude(int index) {
        return (XInclude)this.include_.get(index);
    }

    public void setInclude(int index, XInclude include) {
        this.include_.set(index, include);
        if (include != null) {
            include.rSetParentRNode(this);
        }
    }

    public void addInclude(int index, XInclude include) {
        this.include_.add(index, include);
        if (include != null) {
            include.rSetParentRNode(this);
        }
    }

    public void removeInclude(int index) {
        this.include_.remove(index);
    }

    public void removeInclude(XInclude include) {
        this.include_.remove(include);
    }

    public void clearInclude() {
        this.include_.clear();
    }

    public XModule[] getModule() {
        XModule[] array = new XModule[this.module_.size()];
        return this.module_.toArray(array);
    }

    public void setModule(XModule[] module) {
        int i;
        this.module_.clear();
        for (i = 0; i < module.length; ++i) {
            this.addModule(module[i]);
        }
        for (i = 0; i < module.length; ++i) {
            module[i].rSetParentRNode(this);
        }
    }

    public void setModule(XModule module) {
        this.module_.clear();
        this.addModule(module);
        if (module != null) {
            module.rSetParentRNode(this);
        }
    }

    public void addModule(XModule module) {
        this.module_.add(module);
        if (module != null) {
            module.rSetParentRNode(this);
        }
    }

    public void addModule(XModule[] module) {
        int i;
        for (i = 0; i < module.length; ++i) {
            this.addModule(module[i]);
        }
        for (i = 0; i < module.length; ++i) {
            module[i].rSetParentRNode(this);
        }
    }

    public int sizeModule() {
        return this.module_.size();
    }

    public XModule getModule(int index) {
        return (XModule)this.module_.get(index);
    }

    public void setModule(int index, XModule module) {
        this.module_.set(index, module);
        if (module != null) {
            module.rSetParentRNode(this);
        }
    }

    public void addModule(int index, XModule module) {
        this.module_.add(index, module);
        if (module != null) {
            module.rSetParentRNode(this);
        }
    }

    public void removeModule(int index) {
        this.module_.remove(index);
    }

    public void removeModule(XModule module) {
        this.module_.remove(module);
    }

    public void clearModule() {
        this.module_.clear();
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        IRNode value;
        int i;
        buffer.append("<body");
        buffer.append(">");
        int size = this.glyphFile_.size();
        for (i = 0; i < size; ++i) {
            value = (XGlyphFile)this.glyphFile_.get(i);
            ((XGlyphFile)value).makeTextElement(buffer);
        }
        size = this.contour_.size();
        for (i = 0; i < size; ++i) {
            value = (XContour)this.contour_.get(i);
            ((XContour)value).makeTextElement(buffer);
        }
        size = this.include_.size();
        for (i = 0; i < size; ++i) {
            value = (XInclude)this.include_.get(i);
            ((XInclude)value).makeTextElement(buffer);
        }
        size = this.module_.size();
        for (i = 0; i < size; ++i) {
            value = (XModule)this.module_.get(i);
            ((XModule)value).makeTextElement(buffer);
        }
        buffer.append("</body>");
    }

    public void makeTextElement(Writer buffer) throws IOException {
        IRNode value;
        int i;
        buffer.write("<body");
        buffer.write(">");
        int size = this.glyphFile_.size();
        for (i = 0; i < size; ++i) {
            value = (XGlyphFile)this.glyphFile_.get(i);
            ((XGlyphFile)value).makeTextElement(buffer);
        }
        size = this.contour_.size();
        for (i = 0; i < size; ++i) {
            value = (XContour)this.contour_.get(i);
            ((XContour)value).makeTextElement(buffer);
        }
        size = this.include_.size();
        for (i = 0; i < size; ++i) {
            value = (XInclude)this.include_.get(i);
            ((XInclude)value).makeTextElement(buffer);
        }
        size = this.module_.size();
        for (i = 0; i < size; ++i) {
            value = (XModule)this.module_.get(i);
            ((XModule)value).makeTextElement(buffer);
        }
        buffer.write("</body>");
    }

    public void makeTextElement(PrintWriter buffer) {
        IRNode value;
        int i;
        buffer.print("<body");
        buffer.print(">");
        int size = this.glyphFile_.size();
        for (i = 0; i < size; ++i) {
            value = (XGlyphFile)this.glyphFile_.get(i);
            ((XGlyphFile)value).makeTextElement(buffer);
        }
        size = this.contour_.size();
        for (i = 0; i < size; ++i) {
            value = (XContour)this.contour_.get(i);
            ((XContour)value).makeTextElement(buffer);
        }
        size = this.include_.size();
        for (i = 0; i < size; ++i) {
            value = (XInclude)this.include_.get(i);
            ((XInclude)value).makeTextElement(buffer);
        }
        size = this.module_.size();
        for (i = 0; i < size; ++i) {
            value = (XModule)this.module_.get(i);
            ((XModule)value).makeTextElement(buffer);
        }
        buffer.print("</body>");
    }

    public void makeTextAttribute(StringBuffer buffer) {
    }

    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    public void makeTextAttribute(PrintWriter buffer) {
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    @Override
    public IRNode rGetParentRNode() {
        return this.parentRNode_;
    }

    @Override
    public void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    @Override
    public IRNode[] rGetRNodes() {
        ArrayList<IRNode> classNodes = new ArrayList<IRNode>();
        classNodes.addAll(this.glyphFile_);
        classNodes.addAll(this.contour_);
        classNodes.addAll(this.include_);
        classNodes.addAll(this.module_);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return classNodes.toArray(nodes);
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "body")) {
            return false;
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        IGlyphFactory factory = GlyphFactory.getFactory();
        RInterleave interleave = new RInterleave(target);
        interleave.addElementSlot(factory.getXGlyphFileClass(), "*");
        interleave.addElementSlot(factory.getXContourClass(), "*");
        interleave.addElementSlot(factory.getXIncludeClass(), "*");
        interleave.addElementSlot(factory.getXModuleClass(), "*");
        if (interleave.isMatch()) {
            $match$ = true;
        }
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return XBody.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (XBody.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

