/*
 * Decompiled with CFR 0.152.
 */
package org.doubletype.ossa.truetype;

import java.io.IOException;
import java.util.ArrayList;
import org.doubletype.ossa.truetype.FontFormatWriter;
import org.doubletype.ossa.truetype.TTGlyph;
import org.doubletype.ossa.truetype.TTPixelSize;

public class HdmxWriter
extends FontFormatWriter {
    private int m_numGlyphs = 98;

    public static int getNumOfPixelSizes() {
        return TTPixelSize.getList().size();
    }

    public static ArrayList<TTPixelSize> getPixelSizes() {
        return TTPixelSize.getList();
    }

    public void setNumGlyphs(int a_value) {
        this.m_numGlyphs = a_value;
        for (TTPixelSize pixelSize : HdmxWriter.getPixelSizes()) {
            pixelSize.setPixelWidthsSize(a_value);
        }
    }

    public void updatePixelWidth(int a_glyphIndex, TTGlyph a_glyph) {
        double advanceWidth = a_glyph.getAdvanceWidth();
        double em = TTPixelSize.getEm();
        for (TTPixelSize pixelSize : TTPixelSize.getList()) {
            int width = (int)Math.round((double)pixelSize.getPixel() * advanceWidth / em);
            pixelSize.setPixelWidth(a_glyphIndex, width);
        }
    }

    @Override
    public void write() throws IOException {
        int numOfPads = 4 - (this.m_numGlyphs + 2) % 4;
        if (numOfPads == 4) {
            numOfPads = 0;
        }
        int size = this.m_numGlyphs + 2 + numOfPads;
        this.writeInt16(0);
        this.writeInt16(HdmxWriter.getNumOfPixelSizes());
        this.writeInt32(size);
        for (TTPixelSize pixelSize : HdmxWriter.getPixelSizes()) {
            this.writeUInt8(pixelSize.getPixel());
            this.writeUInt8(pixelSize.getMaxPixelWidth());
            for (int pixelWidth : pixelSize.getPixelWidths()) {
                this.writeUInt8(pixelWidth);
            }
            for (int j = 0; j < numOfPads; ++j) {
                this.writeUInt8(0);
            }
        }
        this.pad();
    }

    @Override
    protected String getTag() {
        return "hdmx";
    }
}

