/*
 * Decompiled with CFR 0.152.
 */
package org.doubletype.ossa.module;

import java.util.ArrayList;
import org.doubletype.ossa.module.VarStackFrame;

public class VarStack {
    private static VarStack s_varstack = null;
    private ArrayList<VarStackFrame> m_stack = new ArrayList();

    public static VarStack getSingletonInstance() {
        if (s_varstack == null) {
            s_varstack = new VarStack();
        }
        return s_varstack;
    }

    public void push(VarStackFrame a_frame) {
        a_frame.beforePush();
        this.m_stack.add(a_frame);
    }

    public VarStackFrame pop() {
        VarStackFrame retval = this.peek();
        if (retval == null) {
            return retval;
        }
        this.m_stack.remove(retval);
        return retval;
    }

    public VarStackFrame peek() {
        if (this.m_stack.size() <= 0) {
            return null;
        }
        return this.m_stack.get(this.m_stack.size() - 1);
    }

    public void clear() {
        this.m_stack.clear();
    }

    public int size() {
        return this.m_stack.size();
    }

    public double get(String a_name) {
        double retval = 0.0;
        for (int i = 0; i < this.m_stack.size(); ++i) {
            VarStackFrame frame = this.m_stack.get(this.m_stack.size() - i - 1);
            if (!frame.hasVariable(a_name)) continue;
            return frame.getValue(a_name);
        }
        return retval;
    }
}

