/*
 * Decompiled with CFR 0.152.
 */
package org.doubletype.ossa.module;

import java.awt.geom.Point2D;
import org.doubletype.ossa.adapter.EContour;
import org.doubletype.ossa.adapter.EContourPoint;
import org.doubletype.ossa.adapter.EModuleInvoke;
import org.doubletype.ossa.module.GlyphModule;
import org.doubletype.ossa.xml.XContourPoint;

public class Rectangle
extends GlyphModule {
    public static final double k_defaultPen = 68.0;
    public static final double k_defaultWeight = 1.0;
    public static final String k_weight = "weight";

    public Rectangle() {
        this.addVar(k_weight, 1.0);
    }

    @Override
    public EContour toContour(EModuleInvoke a_moduleInvoke) {
        EContourPoint point;
        int i;
        EContour retval = new EContour();
        XContourPoint[] points = a_moduleInvoke.getContourPoint();
        if (points.length < 2) {
            retval.addContourPoint((XContourPoint)((Object)new EContourPoint(0.0, 0.0, true)));
            return retval;
        }
        double pen = this.m_stack.get(k_weight) * 68.0;
        boolean[] steeps = new boolean[points.length - 1];
        double[] thetas = new double[points.length - 1];
        Point2D[] outStartPoints = new Point2D[points.length - 1];
        Point2D[] inStartPoints = new Point2D[points.length - 1];
        Point2D[] outPoints = new Point2D[points.length];
        Point2D[] inPoints = new Point2D[points.length];
        for (i = 0; i < points.length - 1; ++i) {
            EContourPoint start = (EContourPoint)((Object)points[i]);
            EContourPoint end = (EContourPoint)((Object)points[i + 1]);
            double theta = start.toPoint2D().distance(end.toPoint2D()) > 0.0 ? Math.atan2(end.getY() - start.getY(), end.getX() - start.getX()) : 0.0;
            thetas[i] = theta;
            outStartPoints[i] = start.toPoint2D();
            inStartPoints[i] = new Point2D.Double(start.getX() + pen * Math.cos(theta - 1.5707963267948966), start.getY() + pen * Math.sin(theta - 1.5707963267948966));
        }
        for (i = 0; i < points.length; ++i) {
            double cuttingTheta;
            point = (EContourPoint)((Object)points[i]);
            if (i == 0) {
                cuttingTheta = this.isSteep(thetas[i]) ? 0.0 : 1.5707963267948966;
                outPoints[i] = this.getIntersection(point.toPoint2D(), cuttingTheta, outStartPoints[i], thetas[i]);
                inPoints[i] = this.getIntersection(point.toPoint2D(), cuttingTheta, inStartPoints[i], thetas[i]);
                continue;
            }
            if (i == points.length - 1) {
                cuttingTheta = this.isSteep(thetas[i - 1]) ? 0.0 : 1.5707963267948966;
                outPoints[i] = this.getIntersection(point.toPoint2D(), cuttingTheta, outStartPoints[i - 1], thetas[i - 1]);
                inPoints[i] = this.getIntersection(point.toPoint2D(), cuttingTheta, inStartPoints[i - 1], thetas[i - 1]);
                continue;
            }
            if (thetas[i - 1] != thetas[i]) {
                outPoints[i] = this.getIntersection(outStartPoints[i - 1], thetas[i - 1], outStartPoints[i], thetas[i]);
                inPoints[i] = this.getIntersection(inStartPoints[i - 1], thetas[i - 1], inStartPoints[i], thetas[i]);
                continue;
            }
            outPoints[i] = outStartPoints[i];
            inPoints[i] = inStartPoints[i];
        }
        for (i = 0; i < points.length; ++i) {
            point = (EContourPoint)((Object)points[i]);
            retval.addContourPoint(i, point.cloneAt(outPoints[i]));
            retval.addContourPoint(i + 1, point.cloneAt(inPoints[i]));
        }
        return retval;
    }

    private boolean isSteep(double a_theta) {
        return a_theta > 0.7853981633974483 && a_theta < 2.356194490192345 || a_theta < -0.7853981633974483 && a_theta > -2.356194490192345;
    }

    private Point2D getIntersection(Point2D a_p0, double a_theta0, Point2D a_p1, double a_theta1) {
        Point2D.Double retval = new Point2D.Double();
        retval.setLocation(a_p1);
        if (a_theta0 == a_theta1) {
            return retval;
        }
        double cos0 = Math.cos(a_theta0);
        double sin0 = Math.sin(a_theta0);
        double cos1 = Math.cos(a_theta1);
        double sin1 = Math.sin(a_theta1);
        double deltaX = a_p1.getX() - a_p0.getX();
        double deltaY = a_p1.getY() - a_p0.getY();
        double r1 = (cos0 * deltaY - sin0 * deltaX) / (sin0 * cos1 - cos0 * sin1);
        double x = a_p1.getX() + cos1 * r1;
        double y = a_p1.getY() + sin1 * r1;
        ((Point2D)retval).setLocation(x, y);
        return retval;
    }
}

