/*
 * Decompiled with CFR 0.152.
 */
package org.doubletype.ossa.module;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.doubletype.ossa.adapter.EContour;
import org.doubletype.ossa.adapter.EContourPoint;
import org.doubletype.ossa.adapter.EControlPoint;
import org.doubletype.ossa.adapter.EHint;
import org.doubletype.ossa.adapter.EModuleInvoke;
import org.doubletype.ossa.adapter.PointAggregate;
import org.doubletype.ossa.module.GlyphFile;
import org.doubletype.ossa.xml.IRNode;
import org.doubletype.ossa.xml.XContour;
import org.doubletype.ossa.xml.XContourPoint;
import org.doubletype.ossa.xml.XInclude;
import org.doubletype.ossa.xml.XModule;

public class GlyphIterator
implements Iterator {
    protected GlyphFile m_file;
    private int m_index = 0;
    protected List<IRNode> m_list = new ArrayList<IRNode>();

    public GlyphIterator(GlyphFile a_file) {
        this.m_file = a_file;
        this.buildList();
    }

    protected void buildList() {
        this.addIncludes();
        this.addContours();
        this.addModules();
    }

    protected void addContours() {
        XContour[] contours = this.m_file.getGlyph().getBody().getContour();
        for (int i = 0; i < contours.length; ++i) {
            this.m_list.add(contours[i]);
        }
    }

    protected void addControlPoints() {
        XContour[] contours = this.m_file.getGlyph().getBody().getContour();
        for (int i = 0; i < contours.length; ++i) {
            EContour contour = (EContour)((Object)contours[i]);
            if (!contour.isCubic()) continue;
            this.addControlPoints((PointAggregate)((Object)contour), 0.0, 0.0);
        }
    }

    private void addControlPoints(PointAggregate a_object, double a_x, double a_y) {
        XContourPoint[] points = a_object.getContourPoint();
        for (int i = 0; i < points.length; ++i) {
            EControlPoint controlPoint;
            EContourPoint point = (EContourPoint)((Object)points[i]);
            if (!this.isPointVisible(point)) continue;
            if (point.hasControlPoint1()) {
                controlPoint = (EControlPoint)((Object)point.getControlPoint1());
                controlPoint.setOffset(a_x, a_y);
                this.m_list.add((IRNode)((Object)controlPoint));
            }
            if (!point.hasControlPoint2()) continue;
            controlPoint = (EControlPoint)((Object)point.getControlPoint2());
            controlPoint.setOffset(a_x, a_y);
            this.m_list.add((IRNode)((Object)controlPoint));
        }
    }

    protected void addHints() {
        XContour[] contours = this.m_file.getGlyph().getBody().getContour();
        for (int i = 0; i < contours.length; ++i) {
            this.addHints((PointAggregate)((Object)((EContour)((Object)contours[i]))), 0.0, 0.0);
        }
        XModule[] modules = this.m_file.getGlyph().getBody().getModule();
        for (int i = 0; i < modules.length; ++i) {
            EModuleInvoke module = (EModuleInvoke)modules[i];
            double x = module.getInvoke().getInvokePos().getPoint2d().getX();
            double y = module.getInvoke().getInvokePos().getPoint2d().getY();
            this.addHints(module, x, y);
        }
    }

    private void addHints(PointAggregate a_object, double a_x, double a_y) {
        XContourPoint[] points = a_object.getContourPoint();
        for (int i = 0; i < points.length; ++i) {
            EHint hint;
            EContourPoint p;
            EContourPoint point = (EContourPoint)((Object)points[i]);
            if (!this.isPointVisible(point)) continue;
            if (point.hasHintForCurrentPpem()) {
                EHint hint2 = point.getCurrentHint();
                hint2.setOffset(a_x, a_y);
                this.m_list.add(hint2);
            }
            if (point.hasControlPoint1() && (p = (EContourPoint)((Object)point.getControlPoint1().getContourPoint())).hasHintForCurrentPpem()) {
                hint = p.getCurrentHint();
                hint.setOffset(a_x, a_y);
                this.m_list.add(hint);
            }
            if (!point.hasControlPoint2() || !(p = (EContourPoint)((Object)point.getControlPoint2().getContourPoint())).hasHintForCurrentPpem()) continue;
            hint = p.getCurrentHint();
            hint.setOffset(a_x, a_y);
            this.m_list.add(hint);
        }
    }

    private boolean isPointVisible(EContourPoint a_point) {
        if (this.m_file.getPointHost() == null) {
            return true;
        }
        return this.m_file.getPointHost() == a_point.getParent();
    }

    protected void addPoints() {
        XContour[] contours = this.m_file.getGlyph().getBody().getContour();
        for (int i = 0; i < contours.length; ++i) {
            this.addPoints((PointAggregate)((Object)((EContour)((Object)contours[i]))), 0.0, 0.0);
        }
        XModule[] modules = this.m_file.getGlyph().getBody().getModule();
        for (int i = 0; i < modules.length; ++i) {
            EModuleInvoke module = (EModuleInvoke)modules[i];
            double x = module.getInvoke().getInvokePos().getPoint2d().getX();
            double y = module.getInvoke().getInvokePos().getPoint2d().getY();
            this.addPoints(module, x, y);
        }
    }

    private void addPoints(PointAggregate a_object, double a_x, double a_y) {
        XContourPoint[] points = a_object.getContourPoint();
        for (int i = 0; i < points.length; ++i) {
            EContourPoint point = (EContourPoint)((Object)points[i]);
            if (!this.isPointVisible(point)) continue;
            point.setNumber(i);
            point.setOffset(a_x, a_y);
            this.m_list.add((IRNode)((Object)point));
        }
    }

    protected void addModules() {
        XModule[] modules = this.m_file.getGlyph().getBody().getModule();
        for (int i = 0; i < modules.length; ++i) {
            this.m_list.add(modules[i]);
        }
    }

    protected void addIncludes() {
        XInclude[] includes = this.m_file.getGlyph().getBody().getInclude();
        for (int i = 0; i < includes.length; ++i) {
            this.m_list.add(includes[i]);
        }
    }

    @Override
    public void remove() {
    }

    @Override
    public boolean hasNext() {
        return this.m_index < this.m_list.size();
    }

    public Object next() {
        return this.m_list.get(this.m_index++);
    }
}

