/*
 * Decompiled with CFR 0.152.
 */
package org.doubletype.ossa.adapter;

import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import org.doubletype.ossa.adapter.EContour;
import org.doubletype.ossa.adapter.EContourPoint;
import org.doubletype.ossa.adapter.EControlPoint;
import org.doubletype.ossa.xml.XContourPoint;

public class Emulator {
    private static Emulator s_instance = null;

    public static Emulator getInstance() {
        if (s_instance == null) {
            s_instance = new Emulator();
        }
        return s_instance;
    }

    private Emulator() {
    }

    public Shape createShape(EContour a_contour, int a_ppem) {
        if (a_contour.isCubic()) {
            EContour contour = a_contour.toQuadratic();
            return this.createShape(contour, a_ppem);
        }
        return this.concretePointsToShape(this.createConcretePoints(this.createAdjustedPoints(a_contour, a_ppem)));
    }

    private Shape createBezierCurve(EContour a_contour) {
        GeneralPath retval = new GeneralPath();
        XContourPoint[] points = a_contour.getContourPoint();
        if (points.length < 2) {
            return retval;
        }
        EContourPoint startPoint = (EContourPoint)((Object)points[points.length - 1]);
        retval.moveTo((float)startPoint.getX(), (float)startPoint.getY());
        for (int i = 0; i < points.length; ++i) {
            EContourPoint toPoint = (EContourPoint)((Object)points[i]);
            EControlPoint controlPoint1 = (EControlPoint)((Object)startPoint.getControlPoint2());
            EControlPoint controlPoint2 = (EControlPoint)((Object)toPoint.getControlPoint1());
            if (controlPoint1 == null && controlPoint2 == null) {
                retval.lineTo((float)toPoint.getX(), (float)toPoint.getY());
            }
            if (controlPoint1 != null && controlPoint2 == null) {
                retval.curveTo((float)controlPoint1.getX(), (float)controlPoint1.getY(), (float)toPoint.getX(), (float)toPoint.getY(), (float)toPoint.getX(), (float)toPoint.getY());
            }
            if (controlPoint1 == null && controlPoint2 != null) {
                retval.curveTo((float)startPoint.getX(), (float)startPoint.getY(), (float)controlPoint2.getX(), (float)controlPoint2.getY(), (float)toPoint.getX(), (float)toPoint.getY());
            }
            if (controlPoint1 != null && controlPoint2 != null) {
                retval.curveTo((float)controlPoint1.getX(), (float)controlPoint1.getY(), (float)controlPoint2.getX(), (float)controlPoint2.getY(), (float)toPoint.getX(), (float)toPoint.getY());
            }
            startPoint = toPoint;
        }
        return retval;
    }

    private Shape concretePointsToShape(List a_listOfPoints) {
        GeneralPath retval = new GeneralPath();
        if (a_listOfPoints.size() < 3) {
            return retval;
        }
        EContourPoint p = (EContourPoint)a_listOfPoints.get(0);
        retval.moveTo((float)p.getX(), (float)p.getY());
        int i = 0;
        while (i < a_listOfPoints.size() - 1) {
            EContourPoint nextPoint;
            if ((nextPoint = (EContourPoint)a_listOfPoints.get(++i)).isOn()) {
                retval.lineTo((float)nextPoint.getX(), (float)nextPoint.getY());
                continue;
            }
            EContourPoint controlPoint = nextPoint;
            EContourPoint toPoint = (EContourPoint)a_listOfPoints.get(++i);
            retval.quadTo((float)controlPoint.getX(), (float)controlPoint.getY(), (float)toPoint.getX(), (float)toPoint.getY());
        }
        return retval;
    }

    private List<EContourPoint> createConcretePoints(List a_points) {
        ArrayList<EContourPoint> retval = new ArrayList<EContourPoint>();
        if (a_points.size() < 3) {
            return retval;
        }
        EContourPoint lastPoint = (EContourPoint)a_points.get(a_points.size() - 1);
        for (int i = 0; i < a_points.size(); ++i) {
            EContourPoint point = (EContourPoint)a_points.get(i);
            if (!point.isOn() && !lastPoint.isOn()) {
                double xMidpoint = (point.getX() + lastPoint.getX()) / 2.0;
                double yMidpoint = (point.getY() + lastPoint.getY()) / 2.0;
                retval.add(new EContourPoint(xMidpoint, yMidpoint, true));
            }
            retval.add(new EContourPoint(point.getX(), point.getY(), point.isOn()));
            lastPoint = point;
        }
        EContourPoint point = (EContourPoint)retval.get(0);
        if (!point.isOn()) {
            retval.remove(0);
            retval.add(point);
        }
        point = (EContourPoint)retval.get(0);
        retval.add(point);
        return retval;
    }

    private List<EContourPoint> createAdjustedPoints(EContour a_contour, int a_ppem) {
        EContourPoint point;
        int i;
        ArrayList<EContourPoint> retval = new ArrayList<EContourPoint>();
        XContourPoint[] points = a_contour.getContourPoint();
        if (points.length < 3) {
            return retval;
        }
        boolean isRounded = false;
        for (i = 0; i < points.length; ++i) {
            point = (EContourPoint)((Object)points[i]);
            point.resetAdjusted();
            if (point.isRounded()) {
                isRounded = true;
                point.roundAdjusted(a_ppem);
            }
            retval.add(point);
        }
        if (isRounded) {
            this.interpolate(retval, true);
            this.interpolate(retval, false);
        }
        for (i = 0; i < retval.size(); ++i) {
            point = (EContourPoint)retval.get(i);
            if (!point.hasHintForPpem(a_ppem)) continue;
            point.hintAdjusted(a_ppem);
        }
        return this.promoteAdjustedToMain(retval);
    }

    private List<EContourPoint> promoteAdjustedToMain(List<EContourPoint> a_points) {
        ArrayList<EContourPoint> retval = new ArrayList<EContourPoint>();
        for (int i = 0; i < a_points.size(); ++i) {
            EContourPoint original = a_points.get(i);
            EContourPoint adjusted = new EContourPoint(original.getAdjusted().getX(), original.getAdjusted().getY(), original.isOn());
            retval.add(adjusted);
        }
        return retval;
    }

    private void interpolate(List<EContourPoint> a_points, boolean a_isX) {
        Collection<EContourPoint> sorted = this.sortPoints(a_points, a_isX);
        Iterator<EContourPoint> itr = sorted.iterator();
        EContourPoint first = itr.next();
        if (!first.isRounded()) {
            this.shiftPoint(first, a_points, a_isX);
        }
        EContourPoint second = itr.next();
        EContourPoint third = null;
        while (itr.hasNext()) {
            third = itr.next();
            if (!second.isRounded()) {
                if (first.isRounded() && third.isRounded()) {
                    this.interpolate(first, second, third, a_isX);
                } else {
                    this.shiftPoint(second, a_points, a_isX);
                }
            }
            first = second;
            second = third;
        }
        EContourPoint last = third;
        if (!last.isRounded()) {
            this.shiftPoint(last, a_points, a_isX);
        }
    }

    private Collection<EContourPoint> sortPoints(List<EContourPoint> a_points, boolean a_isX) {
        TreeMap<Double, EContourPoint> sorted = new TreeMap<Double, EContourPoint>();
        for (int i = 0; i < a_points.size(); ++i) {
            EContourPoint original = a_points.get(i);
            Double value = new Double(this.getPointValue(original, a_isX));
            while (sorted.containsKey(value)) {
                value = new Double(value + 0.01);
            }
            sorted.put(value, original);
        }
        return sorted.values();
    }

    private void interpolate(EContourPoint a_first, EContourPoint a_second, EContourPoint a_third, boolean a_isX) {
        double firstValue = this.getPointValue(a_first, a_isX);
        double secondValue = this.getPointValue(a_second, a_isX);
        double thirdValue = this.getPointValue(a_third, a_isX);
        double adjustedFirst = this.getAdjustedValue(a_first, a_isX);
        double adjustedThird = this.getAdjustedValue(a_third, a_isX);
        double ratio = (secondValue - firstValue) / (thirdValue - firstValue);
        secondValue = adjustedFirst + ratio * (adjustedThird - adjustedFirst);
        this.setAdjusted(a_second, secondValue, a_isX);
    }

    private void shiftPoint(EContourPoint a_point, List<EContourPoint> a_points, boolean a_isX) {
        EContourPoint closest = this.closestTouchedPoint(a_point, a_points);
        if (closest == null) {
            return;
        }
        double delta = this.getAdjustedValue(closest, a_isX) - this.getPointValue(closest, a_isX);
        double value = this.getPointValue(a_point, a_isX) + delta;
        this.setAdjusted(a_point, value, a_isX);
    }

    private void setAdjusted(EContourPoint a_point, double a_value, boolean a_isX) {
        double x = a_point.getX();
        double y = a_point.getY();
        if (a_isX) {
            x = a_value;
        } else {
            y = a_value;
        }
        a_point.setAdjusted(x, y);
    }

    private double getPointValue(EContourPoint a_point, boolean a_isX) {
        if (a_isX) {
            return a_point.getX();
        }
        return a_point.getY();
    }

    private double getAdjustedValue(EContourPoint a_point, boolean a_isX) {
        if (a_isX) {
            return a_point.getAdjusted().getX();
        }
        return a_point.getAdjusted().getY();
    }

    private EContourPoint closestTouchedPoint(EContourPoint a_point, List<EContourPoint> a_points) {
        EContourPoint retval = null;
        double min = Double.MAX_VALUE;
        for (int i = 0; i < a_points.size(); ++i) {
            double d;
            EContourPoint target = a_points.get(i);
            if (target == a_point || !target.isRounded() || !((d = a_point.toPoint2D().distance(target.toPoint2D())) < min)) continue;
            min = d;
            retval = target;
        }
        return retval;
    }
}

