/*
 * Decompiled with CFR 0.152.
 */
package org.doubletype.ossa.adapter;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.doubletype.ossa.ActiveList;
import org.doubletype.ossa.adapter.EContourPoint;
import org.doubletype.ossa.adapter.GlyphObject;
import org.doubletype.ossa.truetype.TTPixelSize;
import org.doubletype.ossa.xml.XHint;
import org.doubletype.ossa.xml.XInvoke;
import org.doubletype.ossa.xml.XInvokePos;
import org.doubletype.ossa.xml.XPoint2d;

public abstract class EObject {
    public static final String k_on = "on";
    public static final String k_off = "off";
    private static ActiveList s_actives = null;

    static ActiveList getActives() {
        if (s_actives == null) {
            s_actives = ActiveList.getSingletonInstance();
        }
        return s_actives;
    }

    static Shape toShape(XPoint2d a_point, AffineTransform a_trans) {
        double ratio = 16 / TTPixelSize.getEm();
        double x = a_point.getX();
        double y = a_point.getY();
        double e = 3.0 / ratio;
        Point2D.Double source = new Point2D.Double(x, y);
        Point2D dest = new Point2D.Double();
        dest = a_trans.transform(source, dest);
        x = dest.getX();
        y = dest.getY();
        return new Rectangle2D.Double(x - e, y - e, 2.0 * e + 1.0, 2.0 * e + 1.0);
    }

    static void movePoint(XPoint2d a_point, Point2D a_delta) {
        double x = a_point.getX() + a_delta.getX();
        double y = a_point.getY() + a_delta.getY();
        a_point.setX(x);
        a_point.setY(y);
    }

    public static void movePoint(EContourPoint a_point, Point2D a_delta) {
        EObject.movePoint(a_point.getPoint2d(), a_delta);
        XHint[] hints = a_point.getHint();
        for (int i = 0; i < hints.length; ++i) {
            XHint hint = hints[i];
            EObject.movePoint(hint.getPoint2d(), a_delta);
        }
        if (a_point.hasControlPoint1()) {
            EContourPoint point = (EContourPoint)((Object)a_point.getControlPoint1().getContourPoint());
            EObject.movePoint(point, a_delta);
        }
        if (a_point.hasControlPoint2()) {
            EContourPoint point = (EContourPoint)((Object)a_point.getControlPoint2().getContourPoint());
            EObject.movePoint(point, a_delta);
        }
    }

    public static boolean hit(GlyphObject a_object, Rectangle2D a_rect, AffineTransform a_trans) {
        int ppem = 16;
        Shape hitArea = a_object.toShape(a_trans, ppem);
        if (!hitArea.intersects(a_rect)) {
            return false;
        }
        EObject.getActives().addActive(a_object);
        return true;
    }

    public static XInvoke createInvoke(Point2D a_point) {
        XInvoke retval = new XInvoke();
        retval.setInvokePos(EObject.createInvokePos(a_point.getX(), a_point.getY()));
        return retval;
    }

    public static XPoint2d createTransform(XPoint2d a_point, AffineTransform a_trans) {
        XPoint2d retval = new XPoint2d();
        double x = a_point.getX();
        double y = a_point.getY();
        Point2D.Double source = new Point2D.Double(x, y);
        Point2D.Double dest = new Point2D.Double();
        a_trans.transform(source, dest);
        retval.setX(((Point2D)dest).getX());
        retval.setY(((Point2D)dest).getY());
        return retval;
    }

    private static XInvokePos createInvokePos(double a_x, double a_y) {
        XInvokePos retval = new XInvokePos();
        retval.setPoint2d(EObject.createPoint2d(a_x, a_y));
        return retval;
    }

    private static XPoint2d createPoint2d(double a_x, double a_y) {
        XPoint2d retval = new XPoint2d();
        retval.setX(a_x);
        retval.setY(a_y);
        return retval;
    }
}

