/*
 * Decompiled with CFR 0.152.
 */
package org.doubletype.ossa.adapter;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Hashtable;
import org.doubletype.ossa.GlyphColor;
import org.doubletype.ossa.ModuleManager;
import org.doubletype.ossa.adapter.EContour;
import org.doubletype.ossa.adapter.EContourPoint;
import org.doubletype.ossa.adapter.EObject;
import org.doubletype.ossa.adapter.GlyphObject;
import org.doubletype.ossa.adapter.PointAggregate;
import org.doubletype.ossa.module.GlyphModule;
import org.doubletype.ossa.module.Rectangle;
import org.doubletype.ossa.module.VarStack;
import org.doubletype.ossa.module.VarStackFrame;
import org.doubletype.ossa.xml.RStack;
import org.doubletype.ossa.xml.XBody;
import org.doubletype.ossa.xml.XContourPoint;
import org.doubletype.ossa.xml.XInvoke;
import org.doubletype.ossa.xml.XInvokeVarg;
import org.doubletype.ossa.xml.XModule;
import org.doubletype.ossa.xml.XPoint2d;

public class EModuleInvoke
extends XModule
implements VarStackFrame,
GlyphObject,
PointAggregate {
    private Hashtable<String, Double> m_augmented = new Hashtable();
    private VarStack m_stack = VarStack.getSingletonInstance();

    public static EModuleInvoke create() {
        return EModuleInvoke.createAt(new Point2D.Double(0.0, 254.0));
    }

    public static EModuleInvoke createAt(Point2D a_point) {
        EModuleInvoke retval = new EModuleInvoke();
        retval.setName(Rectangle.class.getName());
        retval.setInvoke(EObject.createInvoke(a_point));
        double x = 0.0;
        double y = 0.0;
        EContourPoint point = new EContourPoint(x, y, true);
        retval.addContourPoint((XContourPoint)((Object)point));
        point = new EContourPoint(x += 426.0, y, true);
        retval.addContourPoint((XContourPoint)((Object)point));
        point = new EContourPoint(x, y -= 254.0, true);
        retval.addContourPoint((XContourPoint)((Object)point));
        point = new EContourPoint(x -= 426.0, y, true);
        retval.addContourPoint((XContourPoint)((Object)point));
        return retval;
    }

    public EModuleInvoke() {
    }

    public EModuleInvoke(RStack a_stack) {
        this.setup(a_stack);
    }

    @Override
    public void display(Graphics2D g, AffineTransform a_trans) {
        if (this.isSelected()) {
            g.setColor(GlyphColor.SELECTED);
        } else {
            g.setColor(GlyphColor.MODULE);
        }
        g.draw(this.toShape(a_trans, 16));
    }

    @Override
    public boolean isSelected() {
        return EObject.getActives().isSelected(this);
    }

    @Override
    public Shape toShape(AffineTransform a_trans, int a_ppem) {
        EContour contour = this.toContour(a_trans);
        return contour.toShape(new AffineTransform(), a_ppem);
    }

    public EContour toContour(AffineTransform a_trans) {
        GlyphModule module = this.getModule();
        this.m_stack.push(this);
        EContour untransContour = module.toContour(this);
        this.m_stack.pop();
        XPoint2d pos = this.getInvoke().getInvokePos().getPoint2d();
        AffineTransform trans = (AffineTransform)a_trans.clone();
        trans.translate(pos.getX(), pos.getY());
        EContour retval = untransContour.transpose(trans);
        return retval;
    }

    public GlyphModule getModule() {
        return this.getModuleForName(this.getName());
    }

    private GlyphModule getModuleForName(String a_name) {
        GlyphModule retval = null;
        try {
            ModuleManager manager = ModuleManager.getSingletonInstance();
            retval = manager.getModule(a_name);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retval;
    }

    @Override
    public void remove() {
        XBody parent = (XBody)this.rGetParentRNode();
        parent.removeModule(this);
    }

    @Override
    public void move(Point2D a_delta) {
        XPoint2d point = this.getInvoke().getInvokePos().getPoint2d();
        EObject.movePoint(point, a_delta);
    }

    @Override
    public void removePoint(EContourPoint a_point) {
        boolean isFirst = a_point == this.getContourPoint(0);
        this.removeContourPoint((XContourPoint)((Object)a_point));
        GlyphModule module = this.getModuleForName(this.getName());
        if (this.getContourPoint().length < module.getMinimumPointCount()) {
            this.remove();
            return;
        }
        if (!isFirst) {
            return;
        }
        EContourPoint newFirst = (EContourPoint)((Object)this.getContourPoint(0));
        Point2D pos = newFirst.toPoint2D();
        Point2D.Double delta = new Point2D.Double(-pos.getX(), -pos.getY());
        this.moveModulePoints(delta);
        this.move(pos);
    }

    public void moveModulePoints(Point2D a_delta) {
        XContourPoint[] points = this.getContourPoint();
        for (int i = 0; i < points.length; ++i) {
            EContourPoint point = (EContourPoint)((Object)points[i]);
            EObject.movePoint(point, a_delta);
        }
    }

    @Override
    public boolean hasVariable(String a_name) {
        return this.m_augmented.containsKey(a_name);
    }

    @Override
    public double getValue(String a_name) {
        Double d = this.m_augmented.get(a_name);
        return d;
    }

    @Override
    public void beforePush() {
        this.loadInvoke(this.getInvoke());
    }

    private void loadInvoke(XInvoke a_invoke) {
        this.copyVarsToAug();
        XInvokeVarg[] vargs = a_invoke.getInvokeVarg();
        for (int i = 0; i < vargs.length; ++i) {
            this.loadVarg(vargs[i]);
        }
    }

    private void loadVarg(XInvokeVarg a_varg) {
        String name = a_varg.getName();
        String src = a_varg.getSrc();
        GlyphModule module = this.getModule();
        if (!module.hasVariable(name)) {
            System.out.println(name + " does not exist in " + module.toString());
            return;
        }
        double value = this.m_stack.get(src);
        this.m_augmented.put(name, new Double(value));
    }

    private void copyVarsToAug() {
        this.m_augmented.clear();
        this.m_augmented.putAll(this.getModule().getVars());
    }

    @Override
    public void movePoint(EContourPoint a_point, Point2D a_delta) {
        EObject.movePoint(a_point, a_delta);
        if (a_point != this.getContourPoint(0)) {
            return;
        }
        Point2D.Double negative = new Point2D.Double(-a_delta.getX(), -a_delta.getY());
        this.moveModulePoints(negative);
        this.move(a_delta);
    }

    @Override
    public GlyphObject insertPoint(EContourPoint a_point) {
        int i;
        int len = this.getContourPoint().length;
        for (i = 0; i < len && this.getContourPoint(i) != a_point; ++i) {
        }
        EContourPoint nextPoint = (EContourPoint)((Object)this.getContourPoint((i + 1) % len));
        double x = (a_point.getX() + nextPoint.getX()) / 2.0;
        double y = (a_point.getY() + nextPoint.getY()) / 2.0;
        EContourPoint retval = new EContourPoint(x, y, true);
        this.addContourPoint(i + 1, (XContourPoint)((Object)retval));
        return retval;
    }

    @Override
    public boolean hit(Rectangle2D a_rect, AffineTransform a_trans) {
        return EObject.hit(this, a_rect, a_trans);
    }
}

