/*
 * Decompiled with CFR 0.152.
 */
package org.doubletype.ossa.adapter;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Hashtable;
import org.doubletype.ossa.GlyphColor;
import org.doubletype.ossa.ModuleManager;
import org.doubletype.ossa.adapter.EObject;
import org.doubletype.ossa.adapter.GlyphObject;
import org.doubletype.ossa.module.GlyphFile;
import org.doubletype.ossa.module.GlyphModule;
import org.doubletype.ossa.module.VarStack;
import org.doubletype.ossa.module.VarStackFrame;
import org.doubletype.ossa.xml.RStack;
import org.doubletype.ossa.xml.XBody;
import org.doubletype.ossa.xml.XInclude;
import org.doubletype.ossa.xml.XInvoke;
import org.doubletype.ossa.xml.XInvokeVarg;
import org.doubletype.ossa.xml.XPoint2d;

public class EIncludeInvoke
extends XInclude
implements VarStackFrame,
GlyphObject {
    private Hashtable<String, Double> m_augmented = new Hashtable();
    private VarStack m_stack = VarStack.getSingletonInstance();

    public static EIncludeInvoke create(String a_fileName) {
        EIncludeInvoke retval = new EIncludeInvoke();
        retval.setHref(a_fileName);
        retval.setInvoke(EObject.createInvoke(new Point2D.Double()));
        return retval;
    }

    public EIncludeInvoke() {
    }

    public EIncludeInvoke(RStack a_stack) {
        this.setup(a_stack);
    }

    @Override
    public void display(Graphics2D g, AffineTransform a_trans) {
        g.setColor(GlyphColor.INCLUDE);
        if (this.isSelected()) {
            g.setColor(GlyphColor.SELECTED);
        }
        g.draw(this.toShape(a_trans, 16));
    }

    @Override
    public boolean isSelected() {
        return EObject.getActives().isSelected(this);
    }

    @Override
    public Shape toShape(AffineTransform a_trans, int a_ppem) {
        ModuleManager manager = ModuleManager.getSingletonInstance();
        GlyphFile file = manager.getGlyphFile(this.getHref());
        XPoint2d pos = this.getInvoke().getInvokePos().getPoint2d();
        AffineTransform trans = new AffineTransform();
        trans.setTransform(a_trans);
        trans.translate(pos.getX(), pos.getY());
        this.m_stack.push(this);
        Shape retval = file.toShape(trans);
        this.m_stack.pop();
        return retval;
    }

    public GlyphModule getModule() {
        ModuleManager manager = ModuleManager.getSingletonInstance();
        return manager.getGlyphFile(this.getHref());
    }

    @Override
    public boolean hasVariable(String a_name) {
        return this.m_augmented.containsKey(a_name);
    }

    @Override
    public double getValue(String a_name) {
        Double d = this.m_augmented.get(a_name);
        return d;
    }

    @Override
    public void beforePush() {
        this.getModule().beforePush();
        this.loadInvoke(this.getInvoke());
    }

    @Override
    public void remove() {
        XBody parent = (XBody)this.rGetParentRNode();
        parent.removeInclude(this);
    }

    @Override
    public void move(Point2D a_delta) {
        XPoint2d point = this.getInvoke().getInvokePos().getPoint2d();
        EObject.movePoint(point, a_delta);
    }

    private void loadInvoke(XInvoke a_invoke) {
        this.copyVarsToAug();
        XInvokeVarg[] vargs = a_invoke.getInvokeVarg();
        for (int i = 0; i < vargs.length; ++i) {
            this.loadVarg(vargs[i]);
        }
    }

    private void loadVarg(XInvokeVarg a_varg) {
        String name = a_varg.getName();
        String src = a_varg.getSrc();
        GlyphModule module = this.getModule();
        if (!module.hasVariable(name)) {
            return;
        }
        double value = this.m_stack.get(src);
        this.m_augmented.put(name, new Double(value));
    }

    private void copyVarsToAug() {
        this.m_augmented.clear();
        this.m_augmented.putAll(this.getModule().getVars());
    }

    @Override
    public boolean hit(Rectangle2D a_rect, AffineTransform a_trans) {
        return EObject.hit(this, a_rect, a_trans);
    }
}

