/*
 * Decompiled with CFR 0.152.
 */
package org.doubletype.ossa.adapter;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.doubletype.ossa.Engine;
import org.doubletype.ossa.GlyphColor;
import org.doubletype.ossa.adapter.EContourPoint;
import org.doubletype.ossa.adapter.EObject;
import org.doubletype.ossa.adapter.EPoint;
import org.doubletype.ossa.adapter.GlyphObject;
import org.doubletype.ossa.adapter.PointAggregate;
import org.doubletype.ossa.xml.XHint;
import org.doubletype.ossa.xml.XPoint2d;

public class EHint
extends XHint
implements GlyphObject,
EPoint {
    private double m_xOffset = 0.0;
    private double m_yOffset = 0.0;

    public EHint() {
    }

    public EHint(double a_x, double a_y, long a_ppem) {
        XPoint2d point = new XPoint2d();
        point.setX(a_x);
        point.setY(a_y);
        this.setPoint2d(point);
        this.setPpem(a_ppem);
    }

    public void setOffset(double a_x, double a_y) {
        this.m_xOffset = a_x;
        this.m_yOffset = a_y;
    }

    private AffineTransform buildOffsetTrans(AffineTransform a_trans) {
        if (this.m_xOffset == 0.0 && this.m_yOffset == 0.0) {
            return a_trans;
        }
        AffineTransform retval = (AffineTransform)a_trans.clone();
        retval.translate(this.m_xOffset, this.m_yOffset);
        return retval;
    }

    @Override
    public void display(Graphics2D g, AffineTransform a_trans) {
        AffineTransform trans = this.buildOffsetTrans(a_trans);
        EContourPoint point = (EContourPoint)((Object)this.rGetParentRNode());
        Shape rect = this.toShape(trans, 16);
        Line2D.Double line = new Line2D.Double(point.getX(), point.getY(), this.getX(), this.getY());
        AffineTransform oldTrans = g.getTransform();
        g.transform(trans);
        g.setColor(Color.BLACK);
        g.draw(line);
        g.setTransform(oldTrans);
        g.setColor(GlyphColor.HINT);
        if (this.isSelected()) {
            g.setColor(GlyphColor.SELECTED);
        }
        if (point.isOn()) {
            g.fill(rect);
        } else {
            g.draw(rect);
        }
    }

    @Override
    public boolean isSelected() {
        return EObject.getActives().isSelected(this);
    }

    @Override
    public Shape toShape(AffineTransform a_trans, int a_ppem) {
        return EObject.toShape(this.getPoint2d(), a_trans);
    }

    @Override
    public double getX() {
        return this.getPoint2d().getX();
    }

    @Override
    public double getY() {
        return this.getPoint2d().getY();
    }

    public Point2D toPoint2D() {
        return new Point2D.Double(this.getX(), this.getY());
    }

    @Override
    public void move(Point2D a_delta) {
        EObject.movePoint(this.getPoint2d(), a_delta);
        double gridWidth = (double)Engine.getEm() / (double)this.getPpem();
        EContourPoint point = (EContourPoint)((Object)this.rGetParentRNode());
        XPoint2d posHint = this.getPoint2d();
        XPoint2d posPoint = point.getPoint2d();
        double xDelta = posHint.getX() - posPoint.getX();
        double yDelta = posHint.getY() - posPoint.getY();
        xDelta = this.correctDelta(xDelta, gridWidth);
        yDelta = this.correctDelta(yDelta, gridWidth);
        posHint.setX(posPoint.getX() + xDelta);
        posHint.setY(posPoint.getY() + yDelta);
    }

    private double correctDelta(double a_delta, double a_width) {
        double retval = a_delta;
        if (retval > a_width) {
            retval = a_width;
        }
        if (retval < -a_width) {
            retval = -a_width;
        }
        return retval;
    }

    @Override
    public void remove() {
        this.getParent().removeHint(this);
    }

    public EContourPoint getParent() {
        return (EContourPoint)((Object)this.rGetParentRNode());
    }

    public PointAggregate getPointHost() {
        return this.getParent().getParent();
    }

    @Override
    public boolean hit(Rectangle2D a_rect, AffineTransform a_trans) {
        return EObject.hit(this, a_rect, this.buildOffsetTrans(a_trans));
    }

    public EHint createTransform(AffineTransform a_trans) {
        EHint retval = new EHint();
        retval.setPpem(this.getPpem());
        retval.setPoint2d(EObject.createTransform(this.getPoint2d(), a_trans));
        return retval;
    }
}

