/*
 * Decompiled with CFR 0.152.
 */
package org.doubletype.ossa;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.doubletype.ossa.Engine;

public class UnicodeBuilder {
    public static final String k_jisCharset = "ISO-2022-JP";

    public static Long askUnicode() {
        Engine engine = Engine.getSingletonInstance();
        throw new UnsupportedOperationException();
    }

    public static Long build(String a_value, int a_option) {
        if (a_value == null || a_value.length() == 0) {
            return null;
        }
        switch (a_option) {
            case 0: {
                return UnicodeBuilder.buildByExample(a_value);
            }
            case 1: {
                return UnicodeBuilder.buildByUnicode(a_value);
            }
            case 2: {
                return UnicodeBuilder.buildByJisCode(a_value);
            }
        }
        return null;
    }

    private static Long buildByExample(String a_value) {
        if (a_value.length() > 1) {
            return null;
        }
        return new Long(a_value.charAt(0));
    }

    private static Long buildByUnicode(String a_value) {
        if (a_value.length() == 1) {
            return UnicodeBuilder.buildByExample(a_value);
        }
        try {
            return new Long(Long.parseLong(a_value, 16));
        }
        catch (NumberFormatException e) {
            Logger.getLogger(Engine.class.getName()).log(Level.SEVERE, null, e);
            return null;
        }
    }

    private static Long buildByJisCode(String a_value) {
        if (a_value.length() == 1) {
            return UnicodeBuilder.buildByExample(a_value);
        }
        try {
            Long retval = UnicodeBuilder.jisX0208ToUnicode(Long.parseLong(a_value, 16));
            if (retval == null) {
                Logger.getLogger(Engine.class.getName()).log(Level.SEVERE, "Bad JIS Code.");
            }
            return retval;
        }
        catch (NumberFormatException e) {
            Logger.getLogger(Engine.class.getName()).log(Level.SEVERE, null, e);
            return null;
        }
    }

    public static Long jisX0208ToUnicode(long a_value) {
        if (!UnicodeBuilder.isJisSupported()) {
            return null;
        }
        Charset jis = Charset.forName(k_jisCharset);
        ByteBuffer in = ByteBuffer.allocate(5);
        CharsetDecoder jisDecoder = jis.newDecoder();
        long high = (0xFF00L & a_value) >> 8;
        long low = 0xFFL & a_value;
        if (high < 33L || high > 126L || low < 33L || high > 126L) {
            return null;
        }
        char c = (char)a_value;
        in.rewind();
        in.put((byte)27);
        in.put((byte)36);
        in.put((byte)64);
        in.putChar(c);
        in.position(0);
        try {
            CharBuffer out = jisDecoder.decode(in);
            if (out.length() > 0) {
                return new Long(out.get(0));
            }
        }
        catch (CharacterCodingException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static boolean isJisSupported() {
        return Charset.isSupported(k_jisCharset);
    }
}

