/*
 * Decompiled with CFR 0.152.
 */
package org.doubletype.ossa;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import org.doubletype.ossa.Tabbable;

public class TabbedPaneCloseButtonUI
extends BasicTabbedPaneUI {
    private final int k_xButtonOffset = 19;
    private final int k_yButtonOffset = 4;
    private final int k_wButton = 14;
    private final int k_hButton = 13;
    private int m_lastKnownSelected = -1;
    private Color m_red = new Color(217, 76, 74);
    private Color m_selectedColor = Color.white;
    private Color m_unselectedColor = new Color(160, 197, 241);

    @Override
    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        if (isSelected) {
            g.setColor(this.m_selectedColor);
        } else {
            g.setColor(this.m_unselectedColor);
        }
        g.fillRect(x, y, w, h);
    }

    @Override
    protected int calculateTabHeight(int tabPlacement, int tabIndex, int fontHeight) {
        return fontHeight + 4;
    }

    @Override
    protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        g.setColor(this.darkShadow);
        g.drawLine(x, y + h - 2, x, y);
        g.drawLine(x, y, x + w, y);
        g.drawLine(x + w, y + h - 2, x + w, y);
    }

    @Override
    protected void paintTab(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect) {
        super.paintTab(g, tabPlacement, rects, tabIndex, iconRect, textRect);
    }

    @Override
    protected void paintFocusIndicator(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
    }

    @Override
    protected void paintContentBorderTopEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        if (selectedIndex < 0) {
            return;
        }
        Rectangle rect = this.getTabBounds(selectedIndex, this.calcRect);
        g.setColor(this.darkShadow);
        g.drawLine(x, y, rect.x, y);
        g.drawLine(rect.x + rect.width, y, x + w, y);
        g.setColor(this.m_selectedColor);
        g.drawLine(rect.x + 1, y, rect.x + rect.width - 1, y);
    }

    @Override
    protected void paintContentBorderBottomEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
    }

    @Override
    protected void paintContentBorderRightEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
    }

    @Override
    protected void paintContentBorderLeftEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
    }

    @Override
    protected void paintText(Graphics g, int tabPlacement, Font font, FontMetrics metrics, int tabIndex, String title, Rectangle textRect, boolean isSelected) {
        Tabbable tabbable;
        if (this.tabPane.getComponentAt(tabIndex) instanceof Tabbable && !(tabbable = (Tabbable)((Object)this.tabPane.getComponentAt(tabIndex))).isClosable()) {
            super.paintText(g, tabPlacement, font, metrics, tabIndex, title, textRect, isSelected);
            return;
        }
        if (isSelected) {
            super.paintText(g, tabPlacement, font, metrics, tabIndex, title, textRect, isSelected);
            Rectangle rect = this.rects[tabIndex];
            g.setColor(this.m_red);
            int xButton = rect.x + rect.width - 19;
            int yButton = rect.y + 4;
            g.fillRect(xButton, yButton, 14, 13);
            g.setColor(Color.white);
            g.drawLine(xButton + 3, rect.y + 7, xButton + 9, rect.y + 13);
            g.drawLine(xButton + 9, rect.y + 7, xButton + 3, rect.y + 13);
            g.drawLine(xButton + 4, rect.y + 7, xButton + 10, rect.y + 13);
            g.drawLine(xButton + 10, rect.y + 7, xButton + 4, rect.y + 13);
            this.m_lastKnownSelected = tabIndex;
        } else {
            super.paintText(g, tabPlacement, font, metrics, tabIndex, title, textRect, isSelected);
        }
    }

    @Override
    protected int calculateTabWidth(int tabPlacement, int tabIndex, FontMetrics metrics) {
        Tabbable tabbable;
        if (this.tabPane.getComponentAt(tabIndex) instanceof Tabbable && !(tabbable = (Tabbable)((Object)this.tabPane.getComponentAt(tabIndex))).isClosable()) {
            return super.calculateTabWidth(tabPlacement, tabIndex, metrics);
        }
        return super.calculateTabWidth(tabPlacement, tabIndex, metrics) + 34;
    }

    @Override
    protected MouseListener createMouseListener() {
        return new MyMouseHandler();
    }

    class MyMouseHandler
    extends BasicTabbedPaneUI.MouseHandler {
        private int m_selectedOnPressed;

        public MyMouseHandler() {
            super(TabbedPaneCloseButtonUI.this);
            this.m_selectedOnPressed = -1;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.m_selectedOnPressed = TabbedPaneCloseButtonUI.this.m_lastKnownSelected;
            super.mousePressed(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            int tabIndex = -1;
            int tabCount = TabbedPaneCloseButtonUI.this.tabPane.getTabCount();
            for (int i = 0; i < tabCount; ++i) {
                if (!TabbedPaneCloseButtonUI.this.rects[i].contains(x, y)) continue;
                tabIndex = i;
                break;
            }
            if (TabbedPaneCloseButtonUI.this.tabPane.getSelectedIndex() != tabIndex) {
                return;
            }
            if (this.m_selectedOnPressed != tabIndex) {
                return;
            }
            if (tabIndex >= 0 && !e.isPopupTrigger()) {
                Rectangle tabRect = TabbedPaneCloseButtonUI.this.rects[tabIndex];
                int xButton = tabRect.x + tabRect.width - 19;
                if (x >= xButton + 1 && x <= xButton + 14 - 2 && (y -= tabRect.y) >= 5 && y <= 15) {
                    TabbedPaneCloseButtonUI.this.tabPane.remove(tabIndex);
                }
            }
        }
    }
}

