/*
 * Decompiled with CFR 0.152.
 */
package org.doubletype.ossa;

import java.io.File;
import java.util.Hashtable;
import org.doubletype.ossa.Engine;
import org.doubletype.ossa.module.GlyphFile;
import org.doubletype.ossa.module.GlyphModule;

public class ModuleManager {
    private static ModuleManager s_singleton = null;
    private Hashtable<String, GlyphModule> m_modules = new Hashtable();
    private Hashtable<String, GlyphFile> m_files = new Hashtable();

    public static ModuleManager getSingletonInstance() {
        if (s_singleton == null) {
            s_singleton = new ModuleManager();
        }
        return s_singleton;
    }

    private ModuleManager() {
    }

    public void clear() {
        this.m_modules.clear();
        this.m_files.clear();
    }

    public GlyphModule getModule(String a_name) throws Exception {
        if (this.m_modules.containsKey(a_name)) {
            return this.m_modules.get(a_name);
        }
        GlyphModule retval = (GlyphModule)Class.forName(a_name).newInstance();
        this.m_modules.put(a_name, retval);
        return retval;
    }

    public GlyphFile getGlyphFile(String a_name) {
        if (this.m_files.containsKey(a_name)) {
            return this.m_files.get(a_name);
        }
        return this.getReloadedGlyphFile(a_name);
    }

    public GlyphFile getReloadedGlyphFile(String a_name) {
        Engine engine = Engine.getSingletonInstance();
        GlyphFile retval = new GlyphFile(new File(engine.getGlyphPath(), a_name));
        this.m_files.put(a_name, retval);
        return retval;
    }
}

