/*
 * Decompiled with CFR 0.152.
 */
package org.doubletype.ossa;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class Memento {
    private String m_description;
    private byte[] m_compressed;
    private int m_originalSize;
    private long m_entryTime;

    public Memento(String a_description, byte[] a_data) {
        this.m_description = a_description;
        this.m_originalSize = a_data.length;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ZipOutputStream zip = new ZipOutputStream(out);
        try {
            zip.putNextEntry(new ZipEntry(a_description));
            zip.write(a_data);
            zip.closeEntry();
            zip.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        this.m_compressed = out.toByteArray();
        this.m_entryTime = System.currentTimeMillis();
    }

    public InputStream getData() {
        ZipInputStream zip = null;
        try {
            zip = new ZipInputStream(new ByteArrayInputStream(this.m_compressed));
            ZipEntry entry = zip.getNextEntry();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return zip;
    }

    public String toString() {
        return this.m_description;
    }
}

