/*
 * Decompiled with CFR 0.152.
 */
package org.doubletype.ossa;

import java.util.ArrayList;
import org.doubletype.ossa.Memento;
import org.doubletype.ossa.module.GlyphFile;

public class HistoryList {
    private GlyphFile m_file;
    private ArrayList<Memento> m_list = new ArrayList();
    private int m_index = -1;

    public HistoryList(GlyphFile a_file) {
        this.m_file = a_file;
    }

    private void printHistoryArray() {
        for (int i = 0; i <= this.m_index; ++i) {
            Memento memento = this.m_list.get(i);
            System.out.println(memento.toString());
        }
    }

    public void record(String a_description) {
        this.add(this.m_file.createMemento(a_description));
    }

    private void add(Memento a_memento) {
        while (this.m_list.size() - 1 > this.m_index) {
            this.m_list.remove(this.m_list.size() - 1);
        }
        this.m_list.add(a_memento);
        this.m_index = this.m_list.size() - 1;
    }

    public void undo() {
        if (this.m_list.size() == 0 || this.m_index <= 0) {
            return;
        }
        --this.m_index;
        this.m_file.restore(this.get(this.m_index));
    }

    public void redo() {
        if (this.m_list.size() == 0 || this.m_index >= this.m_list.size() - 1) {
            return;
        }
        ++this.m_index;
        this.m_file.restore(this.get(this.m_index));
    }

    private Memento get(int a_index) {
        return this.m_list.get(a_index);
    }
}

