/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.tools.sfnttool;

import com.google.typography.font.sfntly.Font;
import com.google.typography.font.sfntly.Tag;
import com.google.typography.font.sfntly.table.core.CMap;
import com.google.typography.font.sfntly.table.core.CMapTable;
import com.google.typography.font.sfntly.table.truetype.CompositeGlyph;
import com.google.typography.font.sfntly.table.truetype.Glyph;
import com.google.typography.font.sfntly.table.truetype.GlyphTable;
import com.google.typography.font.sfntly.table.truetype.LocaTable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class GlyphCoverage {
    public static List<Integer> getGlyphCoverage(Font font, String string) {
        CMapTable cMapTable = (CMapTable)font.getTable(Tag.cmap);
        CMap cMap = GlyphCoverage.getBestCMap(cMapTable);
        HashSet<Integer> hashSet = new HashSet<Integer>();
        hashSet.add(0);
        for (int i = 0; i < string.length(); ++i) {
            int n = string.charAt(i) & 0xFFFF;
            int n2 = cMap.glyphId(n);
            GlyphCoverage.touchGlyph(font, hashSet, n2);
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>(hashSet);
        Collections.sort(arrayList);
        return arrayList;
    }

    private static void touchGlyph(Font font, Set<Integer> set, int n) {
        if (!set.contains(n)) {
            set.add(n);
            Glyph glyph = GlyphCoverage.getGlyph(font, n);
            if (glyph != null && glyph.glyphType() == Glyph.GlyphType.Composite) {
                CompositeGlyph compositeGlyph = (CompositeGlyph)glyph;
                for (int i = 0; i < compositeGlyph.numGlyphs(); ++i) {
                    GlyphCoverage.touchGlyph(font, set, compositeGlyph.glyphIndex(i));
                }
            }
        }
    }

    private static CMap getBestCMap(CMapTable cMapTable) {
        for (CMap cMap : cMapTable) {
            if (cMap.format() != CMap.CMapFormat.Format12.value()) continue;
            return cMap;
        }
        for (CMap cMap : cMapTable) {
            if (cMap.format() != CMap.CMapFormat.Format4.value()) continue;
            return cMap;
        }
        return null;
    }

    private static Glyph getGlyph(Font font, int n) {
        LocaTable locaTable = (LocaTable)font.getTable(Tag.loca);
        GlyphTable glyphTable = (GlyphTable)font.getTable(Tag.glyf);
        int n2 = locaTable.glyphOffset(n);
        int n3 = locaTable.glyphLength(n);
        return glyphTable.glyph(n2, n3);
    }
}

