/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.tools.conversion.eot;

import java.io.ByteArrayOutputStream;

public class MagnitudeDependentWriter {
    private final ByteArrayOutputStream buf = new ByteArrayOutputStream();
    private byte byteBuf = 0;
    private int bitCount = 0;

    private void writeBit(int n) {
        this.byteBuf = (byte)(this.byteBuf | n << this.bitCount);
        ++this.bitCount;
        if (this.bitCount == 8) {
            this.buf.write(this.byteBuf);
            this.byteBuf = 0;
            this.bitCount = 0;
        }
    }

    public void writeValue(int n) {
        if (n == 0) {
            this.writeBit(0);
        } else {
            int n2 = Math.abs(n);
            for (int i = 0; i < n2; ++i) {
                this.writeBit(1);
            }
            this.writeBit(0);
            this.writeBit(n > 0 ? 0 : 1);
        }
    }

    public void flush() {
        if (this.bitCount > 0) {
            this.buf.write(this.byteBuf);
            this.byteBuf = 0;
            this.bitCount = 0;
        }
    }

    public byte[] toByteArray() {
        return this.buf.toByteArray();
    }
}

