/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.tools.conversion.eot;

import com.google.typography.font.tools.conversion.eot.BitIOWriter;

public class HuffmanEncoder {
    private static final int ROOT = 1;
    private TreeNode[] tree;
    private short[] symbolIndex;
    private int bitCount2;
    private int range;
    private BitIOWriter bits;

    public HuffmanEncoder(BitIOWriter bitIOWriter, int n) {
        int n2;
        this.bits = bitIOWriter;
        this.range = n;
        HuffmanEncoder.bitsUsed(n - 1);
        this.bitCount2 = n > 256 && n < 512 ? HuffmanEncoder.bitsUsed(n - 257) : 0;
        this.symbolIndex = new short[n];
        int n3 = 2 * n;
        this.tree = new TreeNode[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            this.tree[n2] = new TreeNode();
        }
        for (n2 = 2; n2 < n3; ++n2) {
            this.tree[n2].up = (short)(n2 / 2);
            this.tree[n2].weight = 1;
        }
        for (n2 = 1; n2 < n; ++n2) {
            this.tree[n2].left = (short)(2 * n2);
            this.tree[n2].right = (short)(2 * n2 + 1);
        }
        for (n2 = 0; n2 < n; ++n2) {
            this.tree[n2].code = (short)-1;
            this.tree[n + n2].code = (short)n2;
            this.tree[n + n2].left = (short)-1;
            this.tree[n + n2].right = (short)-1;
            this.symbolIndex[n2] = (short)(n + n2);
        }
        this.initWeight(1);
        if (this.bitCount2 != 0) {
            this.updateWeight(this.symbolIndex[256]);
            this.updateWeight(this.symbolIndex[257]);
            for (n2 = 0; n2 < 12; ++n2) {
                this.updateWeight(this.symbolIndex[n - 3]);
            }
            for (n2 = 0; n2 < 6; ++n2) {
                this.updateWeight(this.symbolIndex[n - 2]);
            }
        } else {
            for (n2 = 0; n2 < 2; ++n2) {
                for (int i = 0; i < n; ++i) {
                    this.updateWeight(this.symbolIndex[i]);
                }
            }
        }
    }

    String checkTree() {
        short s;
        int n;
        int n2;
        for (n2 = 1; n2 < this.range; ++n2) {
            if (this.tree[n2].code >= 0) continue;
            if (this.tree[this.tree[n2].left].up != n2) {
                return "tree[tree[" + n2 + "].left].up == " + this.tree[this.tree[n2].left].up + ", expected " + n2;
            }
            if (this.tree[this.tree[n2].right].up == n2) continue;
            return "tree[tree[" + n2 + "].right].up == " + this.tree[this.tree[n2].right].up + ", expected " + n2;
        }
        for (n2 = 1; n2 < this.range; ++n2) {
            if (this.tree[n2].code >= 0 || this.tree[n2].weight == this.tree[this.tree[n2].left].weight + this.tree[this.tree[n2].right].weight) continue;
            return "tree[" + n2 + "].weight == " + this.tree[n2].weight + ", expected " + this.tree[this.tree[n2].left].weight + " + " + this.tree[this.tree[n2].right].weight;
        }
        n2 = this.range * 2 - 1;
        for (n = 1; n < n2; ++n) {
            if (this.tree[n].weight >= this.tree[n + 1].weight) continue;
            return "tree[" + n + "].weight == " + this.tree[n].weight + ", tree[" + (n + 1) + ".weight == " + this.tree[n + 1].weight + ", not >=";
        }
        for (n = 2; n < n2; ++n) {
            short s2;
            if (this.tree[n].code >= 0 || (s = this.tree[n].left) - (s2 = this.tree[n].right) == 1 || s - s2 == -1) continue;
            return "tree[" + n + "].left == " + this.tree[n].left + ", tree[" + n + "].right] == " + this.tree[n].right + ", siblings not adjacent";
        }
        for (n = 2; n < this.range * 2; ++n) {
            s = this.tree[n].up;
            if (this.tree[s].left == n || this.tree[s].right == n) continue;
            return "tree[" + s + "].left != " + n + " && tree[" + s + "].right != " + n;
        }
        return null;
    }

    private int initWeight(int n) {
        if (this.tree[n].code < 0) {
            this.tree[n].weight = this.initWeight(this.tree[n].left) + this.initWeight(this.tree[n].right);
        }
        return this.tree[n].weight;
    }

    private void updateWeight(int n) {
        while (n != 1) {
            int n2 = this.tree[n].weight;
            int n3 = n - 1;
            if (this.tree[n3].weight == n2) {
                while (this.tree[--n3].weight == n2) {
                }
                if (++n3 > 1) {
                    this.swapNodes(n, n3);
                    n = n3;
                }
            }
            this.tree[n].weight = ++n2;
            n = this.tree[n].up;
        }
        ++this.tree[n].weight;
    }

    private void swapNodes(int n, int n2) {
        short s = this.tree[n].up;
        short s2 = this.tree[n2].up;
        TreeNode treeNode = this.tree[n];
        this.tree[n] = this.tree[n2];
        this.tree[n2] = treeNode;
        this.tree[n].up = s;
        this.tree[n2].up = s2;
        short s3 = this.tree[n].code;
        if (s3 < 0) {
            this.tree[this.tree[n].left].up = (short)n;
            this.tree[this.tree[n].right].up = (short)n;
        } else {
            this.symbolIndex[s3] = (short)n;
        }
        s3 = this.tree[n2].code;
        if (s3 < 0) {
            this.tree[this.tree[n2].left].up = (short)n2;
            this.tree[this.tree[n2].right].up = (short)n2;
        } else {
            this.symbolIndex[s3] = (short)n2;
        }
    }

    public int writeSymbolCost(int n) {
        short s = this.symbolIndex[n];
        int n2 = 0;
        do {
            ++n2;
        } while ((s = this.tree[s].up) != 1);
        return n2 << 16;
    }

    public void writeSymbol(int n) {
        short s;
        short s2;
        short s3 = s2 = this.symbolIndex[n];
        boolean[] blArray = new boolean[50];
        int n2 = 0;
        do {
            s = this.tree[s2].up;
            boolean bl = blArray[n2++] = this.tree[s].right == s2;
        } while ((s2 = s) != 1);
        do {
            this.bits.writeBit(blArray[--n2]);
        } while (n2 > 0);
        this.updateWeight(s3);
    }

    public static int bitsUsed(int n) {
        int n2;
        for (n2 = 32; n2 > 1 && (n & 1 << n2 - 1) == 0; --n2) {
        }
        return n2;
    }

    private static class TreeNode {
        short up;
        short left;
        short right;
        short code;
        int weight;

        private TreeNode() {
        }
    }
}

